#include <DOC.H>

$DOC_INTERFACE(__BSCAN,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BT.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) int
__BSCAN(unsigned long $ARG(val));)

$DESCRIPTION(
This function uses the same bitmap format as $LINK(__BT,__BT) and similar
$CODE(__B*) functions, but it operates only on one long int. It doesn't operate
in memory.
$NP
This function scans for a non-zero bit in an unsigned long int and returns its
index. The index may be passed to $LINK(__BVS,__BVS), $LINK(__BVR,__BVR) or
$LINK(__BVC,__BVC) functions.
$NP
The order in which bits are scanned is unspecified.
)

$ARGUMENTS(
$ARGUMENT(val, A value in which the bit will be searched. It must not be zero.)
)

$RETURNS(
An index of a bit. The mapping of bits to unsigned long int is
architecture-specific.
)

$IMPLEMENTATION(
On IA-32 this function is equivalent to $LINK(__BSF,__BSF). On other
architectures, it may be implemented differently.
)

$SEE_ALSO(
$LINK(__BVS,__BVS),
$LINK(__BVR,__BVR),
$LINK(__BVC,__BVC),
$LINK(__BT,__BT),
$LINK(__BTS,__BTS),
$LINK(__BTR,__BTR),
$LINK(__BTC,__BTC),
$LINK(__BS,__BS),
$LINK(__BR,__BR),
$LINK(__BC,__BC)
)

)

$IGNORE(
vim: textwidth=80
)
