#include <DOC.H>

$DOC_INTERFACE(__CMPXCHG64_AVAILABLE,

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$TYPE_MACRO_EXPRESSION

$INCLUDES(
$INCLUDE(ARCH/BITOPS.H)
)

$FORMAT(if (__CMPXCHG64_AVAILABLE) ...)

$DESCRIPTION(
This macro returns non-zero if inline functions $LINK(__CMPXCHG,__CMPXCHG64) and
$LINK(__CMPXCHG,__LOCK_CMPXCHG64) are available on a current CPU. If they are
not available, they must not be called because that would cause an
invalid instruction exception.
)

$RETURNS(
Zero, if 64-bit CMPXCHG is not available, otherwise non-zero.
)

$SEE_ALSO($LINK(__CMPXCHG,__PrefixCMPXCHGSuffix))
)

$IGNORE(
vim: textwidth=80
)
