#include <DOC.H>

$DOC_INTERFACE(__SizeFrom2ToConst,

$TYPE_MACRO_EXPRESSION

$INCLUDES(
$INCLUDE(ENDIAN.H)
)

$FORMAT(x = __SizeFrom2ToConst($ARG(val)))

$DESCRIPTION(
This is a family of preprocessor macros that convert to or from different
endianity. The function of the macro is encoded in parts of its name:
$ARG(Size), $ARG(From), $ARG(To), $ARG(Const).
)

$ARGUMENTS(
$ARGUMENT(Size, This may be one of the following:
$CONSTANTS(
$CONSTANT(16, Convert 16-bit unsigned value.)
$CONSTANT(32, Convert 32-bit unsigned value.)
$CONSTANT(64, Convert 64-bit unsigned value.)
)
)
$ARGUMENT(From, This is the format from which the conversion should be made:
$CONSTANTS(
$CONSTANT(CPU, Convert from CPU-native format.)
$CONSTANT(LE, Convert from little endian.)
$CONSTANT(BE, Convert from big endian.)
)
)
$ARGUMENT(To, This is the format to which the conversion should be made:
$CONSTANTS(
$CONSTANT(CPU, Convert to CPU-native format.)
$CONSTANT(LE, Convert to little endian.)
$CONSTANT(BE, Convert to big endian.)
)
Note: exactly one of $ARG(From) and $ARG(To) must be $CODE(CPU).
)
$ARGUMENT(Const, This specifies if the macro should perform conversion of a
constant and generate a C constant expression.
$CONSTANTS(
$CONSTANT(empty, Convert any expression into a non-constant result.)
$CONSTANT(_CONST, Convert a constant expression into a constant result.)
)
)
$ARGUMENT(val, This is the number to convert. It must be 16-bit, 32-bit or
64-bit unsigned integer (according to $ARG(Size)).)
)

$RETURNS(The if the CPU endianity differs from the requested endianity, the
macro will return an argument with swapped bytes. Otherwise the macro will
return $ARG(val) unchanged.)

$SEE_ALSO(
$LINK(NTOHS,ntohs),
$LINK(HTONS,htons),
$LINK(NTOHL,ntohl),
$LINK(HTONL,htonl)
)

)

$IGNORE(
vim: textwidth=80
)
