#include <DOC.H>

$DOC_INTERFACE(__finline__,

$TYPE_MACRO_TYPE_ATTRIBUTE

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(static __finline__ type function(args...))

$DESCRIPTION(
This macro expands to a compiler-specific attribute telling that the function
is forced inline. When using the $CODE(inline) keyword, the compiler may decide
if it wants to inline the function or not (it decides according to function
complexity or other function calls made from this functions).
$CODE(__finline__) will expand to a
compiler-specific attribute forcing the compiler to inline the function.
)

$IMPLEMENTATION(On gcc compiler, this macro expands to $CODE(__inline__) on
older versions and to $CODE(__attribute((__always_inline__))) on newer versions
of gcc.
)

$SEE_ALSO($LINK(__IS_CONSTANT,__is_constant))

)

$IGNORE(
vim: textwidth=80
)
