#include <DOC.H>

$DOC_INTERFACE(__make64,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) $LINK(__U64,__u64)
__make64($LINK(__U32,__u32) $ARG(__lo), $LINK(__U32,__u32) $ARG(__hi));)

$DESCRIPTION(
This function converts two 32-bit values to a 64-bit value. It is equivalent to
$CODE((__u64)$ARG(__hi) << 32 | $ARG(__lo)), but architecture-specific
optimizations may be used.
)

$ARGUMENTS(
$ARGUMENT(__lo, The lower half of the result.)
$ARGUMENT(__hi, The higher half of the result.)
)

$RETURNS(64-bit number composed of $ARG(__hi) and $ARG(__lo).)

$SEE_ALSO($LINK(__MAKE64HI, __make64hi))

)

$IGNORE(
vim: textwidth=80
)
