#include <DOC.H>

$DOC_INTERFACE(__OFF_T_ALIGN,

$TYPE_MACRO_EXPRESSION

$INCLUDES(
$INCLUDE(SYS/TYPES.H)
)

$FORMAT(__OFF_T_ALIGN)

$DESCRIPTION(
This macro expands to an integer value representing required alignment of the
$LINK(OFF_T, off_t) and $LINK(_U_OFF_T, _u_off_t) types. If the value is not
aligned to this value, it is considered an error.
$NP
This value is used in kernel to check arguments passed from userspace. If the
$CODE(off_t) argument is not aligned to this boundary, the kernel must not touch
the argument (as it may generate unaligned access exceptions on some
architectures) and must return an error to userspace program.
)

$SEE_ALSO($LINK(OFF_T, off_t), $LINK(_U_OFF_T, _u_off_t))

)

$IGNORE(
vim: textwidth=80
)
