#ifndef __ATA_ACTRL_H
#define __ATA_ACTRL_H

#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>
#include <SPAD/TIMER.H>
#include <SPAD/AC.H>
#include <ARCH/IRQ.H>
#include <SPAD/PCI.H>
#include <SPAD/RANDOM.H>
#include <ARCH/IO.H>

#include <SPAD/ATA.H>
#include <SPAD/SCSI.H>

#include "ACTRLREG.H"

typedef struct __actrl ACTRL;
/*typedef struct __aport APORT;*/
typedef struct __adevice ADEVICE;

struct __adevice {
	ATA_ATTACH_PARAM *attached;
	unsigned dev_flags;
};

/* 0x1 - 0x00020000  --- IDE_XFER_* */
#define DEV_F_MASKIRQ		0x01000000U
#define DEV_F_IO32		0x02000000U
#define DEV_F_ATAPI		0x04000000U
#define DEV_F_ATAPI_DMADIR	0x08000000U
#define DEV_F_ATAPI_DRQ_INT	0x10000000U
#define DEV_F_ATAPI_LONG_DRQ	0x20000000U
#define DEV_F_ATAPI_CMD_16	0x40000000U
#define DEV_F_ATAPI_DMA		0x80000000U

struct __aport {
	ACTRL *ctrl;
	io_t io;
	io_t alt_io;
	io_t dma_io;
	unsigned char aport_flags;
	ATARQ *current_rq;
	ASGLIST *sglist;
	__u32 sglist_dev;
	ADEVICE device[2];
	AST irq_ast;
	IRQ_CONTROL irq_ctrl;
	TIMER timeout;
	RANDOM_CTX random_ctx;

	void (*setup_dma)(APORT *p, ATARQ *rq);	/* if APORT_SPECIAL_DMA */
	unsigned max_len;			/* if APORT_SIZE_LIMIT */
	void (*setup_pio)(APORT *p, int drive);

	unsigned long port_chipset_flags;	/* usable for chipset */
	unsigned long port_chipset_flags_2;	/* usable for chipset */

	/* ATAPI */
	SCSIRQ *scsirq;
	ATARQ atapi_placeholder;
	__u8 error_register;
	SCSIRQ *orig_scsirq;
	DECL_SCSIRQ(6) sense_rq;
	BIODESC sense_desc;

	unsigned n;

	int irq;

	unsigned pio_n_sect;
	unsigned pio_sg_pos;
	u_jiffies_lo_t pio_timeout;

	IO_RANGE io_range;
	IO_RANGE alt_io_range;
	IO_RANGE dma_io_range;
};

/* APORT->aport_flags */
#define APORT_DISABLED			0x01
#define APORT_SATA			0x02
#define APORT_IMPLICIT_DMA		0x04
#define APORT_SPECIAL_DMA		0x08
#define APORT_SIZE_LIMIT		0x10
#define APORT_LOCK			0x80


struct __actrl {
	__u8 n_ports;

	char pci_dll;
	char on_pci;
	__u8 dev_rev;
	__u32 dev_id;
	pci_id_t pci_id;
	char *chipset_name;
	unsigned long chipset_flags;
	unsigned long chipset_flags_2;
	unsigned actrl_flags;
	unsigned bus_clock;

	int dcall_users;

	void (*get_avail_xfer)(APORT *p, int drive, unsigned *avail, unsigned *avail_unsupported);
	int (*set_xfer)(APORT *p, int drive, unsigned dma);
	int (*fixup_ident)(APORT *p, int drive, __u16 *ident);

	void *lnte, *dlrq;
	char dev_name[__MAX_STR_LEN];

	APORT port[1];
};

/* ACTRL->actrl_flags */
#define ACTRL_ALWAYS_NATIVE	0x1
#define ACTRL_SATA		0x2
#define ACTRL_FORCE_MASKIRQ	0x4

#define ATA_DI(p, d)							\
do {									\
	if (__unlikely((p)->device[d].dev_flags & DEV_F_MASKIRQ)) KERNEL$DI(); \
} while (0)

#define ATA_EI(p, d)							\
do {									\
	if (__unlikely((p)->device[d].dev_flags & DEV_F_MASKIRQ)) KERNEL$EI(); \
} while (0)

int ATA_FIND_DEV(ACTRL *a, __u32 dev_id, __u8 rev_min, __u8 rev_max);

static __finline__ void setup_dma_generic(APORT *p, ATARQ *rq)
{
	io_outl(p->dma_io + DMAPORT_DTP, p->sglist_dev);
	io_outb(p->dma_io + DMAPORT_CMD, ~rq->atarq_flags & DMACMD_READ);
}

#define IS_ATAPI(p, rq)		((rq) == &(p)->atapi_placeholder)

/* Controller drivers */

int DETECT_CMD640(ACTRL *a);
int DETECT_RZ1000(ACTRL *a);
int DETECT_VIA(ACTRL *a);
int DETECT_IT821(ACTRL *a);
int DETECT_TRIFLEX(ACTRL *a);

#endif
