#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SPAD/PCI.H>
#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/ALLOC.H>
#include <SPAD/SYSLOG.H>

#include "PDCREG.H"

#define BOARD_2037x		0
#define BOARD_2037x_PATA	1
#define BOARD_20319		2
#define BOARD_20619		3
#define BOARD_2057x		4
#define BOARD_2057x_PATA	5
#define BOARD_40518		6

static __const__ struct pci_id_s pci_cards[] = {
{ 0x105a, 0x3371, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20371", BOARD_2037x },
{ 0x105a, 0x3373, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20378", BOARD_2037x },
{ 0x105a, 0x3375, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20375", BOARD_2037x },
{ 0x105a, 0x3376, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20376", BOARD_2037x },

{ 0x105a, 0x3570, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20771", BOARD_2057x },
{ 0x105a, 0x3571, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20571", BOARD_2057x },
{ 0x105a, 0x3574, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20579", BOARD_2057x },
{ 0x105a, 0x3577, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC40779", BOARD_2057x },
{ 0x105a, 0x3d73, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC40775", BOARD_2057x },
{ 0x105a, 0x3d75, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20575", BOARD_2057x },

{ 0x105a, 0x3318, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20318", BOARD_20319 },
{ 0x105a, 0x3319, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20319", BOARD_20319 },
{ 0x105a, 0x3515, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC40719", BOARD_20319 },
{ 0x105a, 0x3519, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC40519", BOARD_20319 },

{ 0x105a, 0x3d17, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC40718", BOARD_40518 },
{ 0x105a, 0x3d18, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20518/PDC40518", BOARD_40518 },

{ 0x105a, 0x6629, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "PDC20619", BOARD_20619 },
{ 0, }
};

typedef struct {
	char *bar3;
	char dev_name[__MAX_STR_LEN];
	pci_id_t id;
} PDC;

int main(int argc, char *argv[])
{
	union {
		MALLOC_REQUEST mrq;
	} u;
	int r;
	char *chip_name;
	unsigned long flags;
	PDC *pdc;
	pci_id_t id = 0, id_mask = 0;
	int order = 0;
	char *opt, *optend, *str;
	struct __param_table params[] = {
		NULL, 0, 0, 0, NULL,
	};
	char **arg = argv;
	int state = 0;

	while (__parse_params(&arg, &state, params, &opt, &optend, &str)) {
		if (PCI$PARSE_PARAMS(opt, optend, str, &id, &id_mask, &order)) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "PDC: SYNTAX ERROR");
			r = -EBADSYN;
			goto ret0;
		}
	}

	if (PCI$FIND_DEVICE(pci_cards, id, id_mask, order, PCI$TEST_LIST, &id, &chip_name, &flags, 0)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "PDC: NO PCI DEVICE FOUND");
		r = -ENODEV;
		goto ret0;
	}

	u.mrq.size = sizeof(PDC);
	SYNC_IO_CANCELABLE(&u.mrq, KERNEL$UNIVERSAL_MALLOC);
	if (u.mrq.status < 0) {
		if (u.mrq.status != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "PDC: CAN'T ALLOCATE MEMORY");
		r = u.mrq.status;
		goto ret1;
	}
	pdc = u.mrq.ptr;
	pdc->id = id;
	_snprintf(pdc->dev_name, sizeof pdc->dev_name, "ATA$PDC@" PCI_ID_FORMAT, id);

	PCI$ENABLE_DEVICE(id, PCI_COMMAND_MEMORY | PCI_COMMAND_MASTER);
	pdc->bar3 = PCI$MAP_MEM_RESOURCE(id, 3, PDC_REGSPACE);
	if (!pdc->bar3) {
		KERNEL$SYSLOG(__SYSLOG_HW_BUG, pdc->dev_name, "NO MEM RESOURCE");
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: NO MEM RESOURCE", pdc->dev_name);
		r = -ENXIO;
		goto ret2;
	}
	if (__IS_ERR(pdc->bar3)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: COULD NOT MAP MEM RESOURCE: %s", pdc->dev_name, strerror(-__PTR_ERR(pdc->bar3)));
		r = __PTR_ERR(pdc->bar3);
		goto ret2;
	}

	r = 0;

	PCI$UNMAP_MEM_RESOURCE(id, pdc->bar3, PDC_REGSPACE);
	ret2:
	KERNEL$UNIVERSAL_FREE(pdc);
	ret1:
	PCI$FREE_DEVICE(id);
	ret0:
	return r;
}
