#include <SPAD/LIBC.H>
#include <SPAD/AC.H>
#include <SPAD/WQ.H>
#include <SPAD/SYNC.H>
#include <SPAD/BIO_KRNL.H>

#include <SPAD/ATA.H>

static WQ_DECL(ATA_SYNC_WQ, "ATA$SYNC_WQ");
static DECL_XLIST(ATA_SYNC_LIST);

typedef struct {
	LIST_ENTRY list;
	ATARQ *rq;
	ATA_ATTACH_PARAM *ap;
	int (*deq)(ATA_ATTACH_PARAM *);
	BIORQ *(*pro)(ATA_ATTACH_PARAM *);
} ATA_SYNC_STRUCT;

static int ATA_SYNC_DEQUEUE(ATA_ATTACH_PARAM *ap);
static BIORQ *ATA_SYNC_PROBE_QUEUE(ATA_ATTACH_PARAM *ap);
static void ATA_SYNC_DONE(ATARQ *rq);

void ATA$SYNC_RQ(ATARQ *rq, ATA_ATTACH_PARAM *ap, void *ptr, unsigned long len, u_jiffies_lo_t timeout, int retries)
{
	BIODESC desc;
	ATA_SYNC_STRUCT st;
	int spl;
	rq->port = ap->port;
	rq->device = ap->device;
	rq->done = ATA_SYNC_DONE;
	rq->timeout = timeout;
	rq->retries = retries;
	rq->len = len;
	if (((rq->atarq_flags) & ATARQ_PROTOCOL) != ATA_PROTOCOL_NODATA) {
		rq->desc = &desc;
		desc.v.ptr = (unsigned long)ptr;
		desc.v.len = len;
		desc.v.vspace = &KERNEL$VIRTUAL;
		desc.next = NULL;
	} else {
		rq->desc = NULL;
#if __DEBUG >= 1
		if (__unlikely(len != 0))
			KERNEL$SUICIDE("ATA$SYNC_RQ: REQUEST HAS NODATA PROTOCOL AND NON-ZERO DATA LENGTH");
#endif
	}
	st.rq = rq;
	st.ap = ap;
	spl = KERNEL$SPL;
#if __DEBUG >= 1
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ATA_SCSI), spl)))
		KERNEL$SUICIDE("ATA$SYNC_RQ AT SPL %08X", spl);
#endif
	RAISE_SPL(SPL_ATA_SCSI);
	ADD_TO_XLIST(&ATA_SYNC_LIST, &st.list);
	st.deq = ap->dequeue;
	st.pro = ap->probe_queue;
	ap->dequeue = ATA_SYNC_DEQUEUE;
	ap->probe_queue = ATA_SYNC_PROBE_QUEUE;
	ATA_SYNC_DEQUEUE(ap);
	while (rq->done != NULL) {
		WQ_WAIT_SYNC(&ATA_SYNC_WQ);
	}
	DEL_FROM_LIST(&st.list);
	LOWER_SPLX(spl);
}

static int ATA_SYNC_DEQUEUE(ATA_ATTACH_PARAM *ap)
{
	int r;
	ATA_SYNC_STRUCT *st;
	XLIST_FOR_EACH(st, &ATA_SYNC_LIST, ATA_SYNC_STRUCT, list) if (__likely(st->ap == ap)) goto found;
	KERNEL$SUICIDE("SCSI_SYNC_DEQUEUE: REQUEST NOT FOUND");
	found:
	r = ap->post(st->rq);
	if (__unlikely(r)) {
		if (__unlikely(r == -EAGAIN)) return 0;
		st->rq->status = 0;
		st->rq->done(st->rq);
	}
	ap->dequeue = st->deq;
	ap->probe_queue = st->pro;
	return 1;
}

static BIORQ *ATA_SYNC_PROBE_QUEUE(ATA_ATTACH_PARAM *ap)
{
	return BIO_COMPARE_UNSPECIFIED;
}

static void ATA_SYNC_DONE(ATARQ *rq)
{
	rq->done = NULL;
	WQ_WAKE_ALL_PL(&ATA_SYNC_WQ);
}

