#if !RW
#if !AS
#define FN	BIO$READ
#define WFN	KERNEL$WAKE_READ
#define fnn	read
#define XIORQ	SIORQ
#define DRF	DIRECT_READ_FINISHED
#define IRF	INDIRECT_READ_FINISHED
#else
#define FN	BIO$AREAD
#define WFN	KERNEL$WAKE_AREAD
#define fnn	aread
#define XIORQ	AIORQ
#define DRF	DIRECT_AREAD_FINISHED
#define IRF	INDIRECT_AREAD_FINISHED
#endif
#define BFLAGS	BIO_READ
#define PFFLAG	PF_WRITE
#define IRWF
#define IWF
#else
#if !AS
#define FN	BIO$WRITE
#define WFN	KERNEL$WAKE_WRITE
#define fnn	write
#define XIORQ	SIORQ
#define DRF	DIRECT_WRITE_FINISHED
#define IRWF	INDIRECT_READ_WRITE_FINISHED
#define IWF	INDIRECT_WRITE_FINISHED
#else
#define FN	BIO$AWRITE
#define WFN	KERNEL$WAKE_AWRITE
#define fnn	awrite
#define XIORQ	AIORQ
#define DRF	DIRECT_AWRITE_FINISHED
#define IRWF	INDIRECT_AREAD_AWRITE_FINISHED
#define IWF	INDIRECT_AWRITE_FINISHED
#endif
#define BFLAGS	BIO_WRITE
#define PFFLAG	PF_READ
#define IRF
#endif

extern AST_STUB DRF;
#if !RW
extern AST_STUB IRF;
#else
extern AST_STUB IRWF;
extern AST_STUB IWF;
#endif

#if !RW
#if !AS
DECL_IOCALL(BIO$READ, SPL_DEV, SIORQ)
#else
DECL_IOCALL(BIO$AREAD, SPL_DEV, AIORQ)
#endif
#else
#if !AS
DECL_IOCALL(BIO$WRITE, SPL_DEV, SIORQ)
#else
DECL_IOCALL(BIO$AWRITE, SPL_DEV, AIORQ)
#endif
#endif
{
	HANDLE *h = RQ->handle;
	PARTITION *pa;
	PARTITIONS *p;
	SBIORQ *sb;
	WQ *wq;
	unsigned long len;
#if !AS
	FFILE *file;
	vspace_unmap_t *funmap;
#endif
	_u_off_t pos;
	if (__unlikely(h->op->fnn != FN)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_DEV));
	if (__unlikely(!RQ->v.len)) {
		if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
		else RQ->status = -EOVERFLOW;
		RETURN_AST(RQ);
	}
	pa = h->fnode;
	p = pa->p;
#if !AS
	RAISE_SPL(SPL_VSPACE);
	file = KERNEL$MAP_FILE_STRUCT(h, (IORQ *)RQ, &funmap);
	LOWER_SPL(SPL_DEV);
	if (__unlikely(!file)) RETURN;
	pos = file->pos;
	RAISE_SPL(SPL_VSPACE);
	funmap(file);
	LOWER_SPL(SPL_DEV);
#else
	pos = RQ->pos;
#endif
	if (__unlikely((pos >> BIO_SECTOR_SIZE_BITS) >= (__usec_t)pa->len)) {
		if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
		else RQ->status = -EOVERFLOW;
		RETURN_AST(RQ);
	}
	if (__unlikely(!(sb = __slalloc(&p->iorqs)))) {
		WQ_WAIT(&p->iorqs_wait, RQ, WFN);
		RETURN;
	}
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely((wq = KERNEL$ACQUIRE_IO_TAG(&sb->tag, h->name_addrspace)) != NULL)) {
		WQ_WAIT(wq, RQ, WFN);
		LOWER_SPL(SPL_DEV);
		__slow_slfree(sb);
		RETURN;
	}
	LOWER_SPL(SPL_DEV);
#if RW
	if (__unlikely(p->lock)) {
		if (__unlikely(p->lock < 0) || __unlikely(!WQ_EMPTY(&p->iorqs_wait))) goto wait_on;
	}
	p->lock++;
#endif
	sb->flags = 0;
	sb->sio = RQ;
	sb->p = p;
	sb->off = pos;
	sb->b.h = h->handle_num & HANDLE_NUM_MASK;
	sb->b.handle = h;
	sb->b.flags = BFLAGS;
	sb->b.desc = &sb->desc;
	sb->b.proc = sb->tag.proc;
	sb->b.fault_sec = -1;
	sb->desc.next = NULL;
	if (__likely(!((unsigned)pos & (BIO_SECTOR_SIZE - 1))) && __likely(RQ->v.len >= BIO_SECTOR_SIZE) && __likely(!((unsigned)RQ->v.ptr & (BIO_SECTOR_SIZE - 1)))) {
		sb->b.fn = &DRF;
		sb->b.sec = pos >> BIO_SECTOR_SIZE_BITS;
		len = RQ->v.len;
			/* +1 is to avoid warning */
		if (sizeof(long) > sizeof(int) && __unlikely((__u64)len + 1 > (__u64)(MAXINT - 2) << BIO_SECTOR_SIZE_BITS)) len = (unsigned long)(MAXINT - 2) << BIO_SECTOR_SIZE_BITS;
		sb->b.nsec = len >> BIO_SECTOR_SIZE_BITS;
		if (__unlikely((__usec_t)sb->b.sec + sb->b.nsec > (__usec_t)pa->len)) sb->b.nsec = (__usec_t)pa->len - sb->b.sec;
		sb->desc.v.ptr = RQ->v.ptr;
		sb->desc.v.len = (unsigned long)sb->b.nsec << BIO_SECTOR_SIZE_BITS;
		sb->desc.v.vspace = RQ->v.vspace;
		sb->sec = sb->b.sec;
		sb->nsec = sb->b.nsec;
		RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, RQ);
	}
#if !RW
	sb->b.fn = IRF;
	sb->b.sec = pos >> BIO_SECTOR_SIZE_BITS;
	len = RQ->v.len;
		/* +1 is to avoid warning */
	if (sizeof(long) > sizeof(int) && __unlikely((__u64)len + 1 > (__u64)(MAXINT - 2) << BIO_SECTOR_SIZE_BITS)) len = (unsigned long)(MAXINT - 2) << BIO_SECTOR_SIZE_BITS;
	sb->b.nsec = (((unsigned)pos & (BIO_SECTOR_SIZE - 1)) + len + BIO_SECTOR_SIZE - 1) >> BIO_SECTOR_SIZE_BITS;
	if (__unlikely(sb->b.sec + sb->b.nsec > (__usec_t)pa->len)) sb->b.nsec = (__usec_t)pa->len - sb->b.sec;
	if (sb->b.nsec > BUFFER_SECTORS) {
		if (((unsigned)pos & (BIO_SECTOR_SIZE - 1)) == ((unsigned)RQ->v.ptr & (BIO_SECTOR_SIZE - 1))) sb->b.nsec = 1;
		else sb->b.nsec = BUFFER_SECTORS;
	}
	sb->desc.v.ptr = (unsigned long)sb->buffer;
	sb->desc.v.len = sb->b.nsec << BIO_SECTOR_SIZE_BITS;
	sb->desc.v.vspace = &KERNEL$VIRTUAL;
	sb->sec = sb->b.sec;
	sb->nsec = sb->b.nsec;
	RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, RQ);
#else
	sb->b.flags = BIO_READ;
	sb->b.fn = IRWF;
	sb->b.sec = pos >> BIO_SECTOR_SIZE_BITS;
	sb->b.nsec = 1;
	sb->desc.v.ptr = (unsigned long)sb->buffer;
	sb->desc.v.len = BIO_SECTOR_SIZE;
	sb->desc.v.vspace = &KERNEL$VIRTUAL;
	sb->sec = sb->b.sec;
	sb->nsec = 1;
	if (!((unsigned)pos & (BIO_SECTOR_SIZE - 1)) && RQ->v.len >= BIO_SECTOR_SIZE) {
		sb->b.status = 0;
		RETURN_AST(&sb->b);
	}
	if (__unlikely(p->lock != 1)) {
		wait_on:
		WQ_WAIT(&p->iorqs_wait, RQ, WFN);
		RAISE_SPL(SPL_VSPACE);
		KERNEL$RELEASE_IO_TAG(&sb->tag);
		LOWER_SPL(SPL_DEV);
		__slow_slfree(sb);
		RETURN;
	}
	p->lock = -1;
	sb->flags |= SBIORQ_LOCK;
	RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, RQ);
#endif
}

#if !RW
#define W_UNLOCK(sb, p) do { } while (0)
#define S_UNLOCK(sb, p) do { } while (0)
#elif __DEBUG < 1
#define W_UNLOCK(sb, p)							\
do {									\
	if (__unlikely(sb->flags & SBIORQ_LOCK)) p->lock = 0;		\
	else p->lock--;							\
} while (0)
#define S_UNLOCK(sb, p)							\
do {									\
	p->lock--;							\
} while (0)
#else
#define W_UNLOCK(sb, p)							\
do {									\
	if (__unlikely(sb->flags & SBIORQ_LOCK)) {			\
		if (__unlikely(p->lock != -1)) KERNEL$SUICIDE("W_UNLOCK: UNLOCKING EXCLUSIVE LOCK: %d", p->lock);					\
		p->lock = 0;						\
	} else {							\
		if (__unlikely(p->lock <= 0)) KERNEL$SUICIDE("W_UNLOCK: UNLOCKING SHARED LOCK: %d", p->lock);						\
		p->lock--;						\
	}								\
} while (0)
#define S_UNLOCK(sb, p)							\
do {									\
	if (__unlikely(sb->flags & SBIORQ_LOCK)) KERNEL$SUICIDE("S_UNLOCK: FLAGS %X", sb->flags);							\
	if (__unlikely(p->lock <= 0)) KERNEL$SUICIDE("S_UNLOCK: UNLOCKING SHARED LOCK: %d", p->lock);							\
	p->lock--;							\
} while (0)
#endif

#if !AS
#define INC_FPOS(rev)							\
do {									\
	if (__unlikely(sio->tmp1 != (unsigned long)WFN))		\
		KERNEL$SUICIDE("INC_FPOS: TMP1 == %p, SHOULD BE %p", (void *)sio->tmp1, WFN);								\
	RAISE_SPL(SPL_VSPACE);						\
	file = KERNEL$MAP_FILE_STRUCT(sio->handle, (IORQ *)sio, &funmap);\
	LOWER_SPL(SPL_DEV);						\
	if (__unlikely(!file)) {					\
		if (rev) {						\
			sio->v.ptr -= s;				\
			sio->v.len += s;				\
			sio->progress -= s;				\
		}							\
		p = sb->p;						\
		W_UNLOCK(sb, p);					\
		FREE_SB(sb, p);						\
		RETURN;							\
	}								\
	file->pos += s;							\
	RAISE_SPL(SPL_VSPACE);						\
	funmap(file);							\
	LOWER_SPL(SPL_DEV);						\
} while (0)
#else
#define INC_FPOS(rev)							\
do {									\
	sio->pos += s;							\
} while (0)
#endif

#if !RW
#if !AS
DECL_AST(DIRECT_READ_FINISHED, SPL_DEV, BIORQ)
#else
DECL_AST(DIRECT_AREAD_FINISHED, SPL_DEV, BIORQ)
#endif
#else
#if !AS
DECL_AST(DIRECT_WRITE_FINISHED, SPL_DEV, BIORQ)
#else
DECL_AST(DIRECT_AWRITE_FINISHED, SPL_DEV, BIORQ)
#endif
#endif
{
	SBIORQ *sb = LIST_STRUCT(RQ, SBIORQ, b);
	XIORQ *sio = sb->sio;
	PARTITIONS *p;
	unsigned long s;
#if !AS
	FFILE *file;
	vspace_unmap_t *funmap;
#endif
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, sio);
	SWITCH_PROC_ACCOUNT(sio->handle->name_addrspace, SPL_X(SPL_DEV));
	if (__unlikely(sb->b.status != 0)) {
		if (sb->b.status == -EVSPACEFAULT) {
			s = 0;
			if (sb->b.fault_sec != (__sec_t)-1) {
				if (__unlikely((__usec_t)(sb->b.fault_sec - sb->sec) >= sb->nsec))
					KERNEL$SUICIDE("DIRECT_*_FINISHED: BIO FAULT_SEC OUT OF REQUEST. FAULT_SEC %"__sec_t_format"X, RQ SEC %"__sec_t_format"X, RQ LEN %X", sb->b.fault_sec, sb->sec, sb->nsec);
				s = (__v_off)(sb->b.fault_sec - sb->sec) << BIO_SECTOR_SIZE_BITS;
				INC_FPOS(0);
				sio->v.ptr += s;
				sio->v.len -= s;
				sio->progress += s;
			}
			if (!s && sb->nsec != 1) goto sec1;
			p = sb->p;
			S_UNLOCK(sb, p);
			FREE_SB(sb, p);
			DO_PAGEIN(sio, &sio->v, PFFLAG);
		}
		if (sb->b.status == -ERANGE) {
			if (sb->nsec == 1) goto end;
			sec1:
			sb->nsec >>= 1;
			sb->b.flags = BFLAGS;
			sb->b.desc = &sb->desc;
			sb->b.proc = sb->tag.proc;
			sb->b.fault_sec = -1;
			sb->desc.next = NULL;
			sb->b.sec = sb->sec;
			sb->b.nsec = sb->nsec;
			sb->desc.v.ptr = sio->v.ptr;
			sb->desc.v.len = (unsigned long)sb->nsec << BIO_SECTOR_SIZE_BITS;
			sb->desc.v.vspace = sio->v.vspace;
			RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, sio);
		}
		if (sb->nsec != 1) goto sec1;
		sio->status = sb->b.status;
		reta:
		p = sb->p;
		S_UNLOCK(sb, p);
		WQ_WAKE_ALL(&p->iorqs_wait);
		RAISE_SPL(SPL_VSPACE);
		KERNEL$RELEASE_IO_TAG(&sb->tag);
		LOWER_SPL(SPL_DEV);
		__slfree(sb);
		RETURN_AST(sio);
	}
	s = (__v_off)sb->nsec << BIO_SECTOR_SIZE_BITS;
	INC_FPOS(0);
	sio->v.ptr += s;
	sio->v.len -= s;
	sio->progress += s;
	if (__likely(!sio->v.len)) {
		end:
		if (__likely(sio->progress >= 0)) sio->status = sio->progress;
		else sio->status = -EOVERFLOW;
		goto reta;
	}
	p = sb->p;
	S_UNLOCK(sb, p);
	FREE_SB(sb, p);
	TEST_LOCKUP_LOOP(sio, RETURN);
	RETURN_IORQ_LSTAT(sio, FN);
}

#if !RW

#if !AS
DECL_AST(INDIRECT_READ_FINISHED, SPL_DEV, BIORQ)
#else
DECL_AST(INDIRECT_AREAD_FINISHED, SPL_DEV, BIORQ)
#endif
{
	SBIORQ *sb = LIST_STRUCT(RQ, SBIORQ, b);
	XIORQ *sio = sb->sio;
	PARTITIONS *p;
	VBUF vbuf;
	unsigned long s;
#if !AS
	FFILE *file;
	vspace_unmap_t *funmap;
#endif
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, sio);
	SWITCH_PROC_ACCOUNT(sio->handle->name_addrspace, SPL_X(SPL_DEV));
	if (__unlikely(sb->b.status != 0)) {
		if (sb->b.status == -ERANGE) {
			if (sb->nsec == 1) goto end;
			sec1:
			sb->b.flags = BFLAGS;
			sb->b.desc = &sb->desc;
			sb->b.proc = sb->tag.proc;
			sb->b.fault_sec = -1;
			sb->desc.next = NULL;
			sb->b.sec = sb->sec;
			sb->b.nsec = 1;
			sb->desc.v.ptr = (unsigned long)sb->buffer;
			sb->desc.v.len = sb->b.nsec << BIO_SECTOR_SIZE_BITS;
			sb->desc.v.vspace = &KERNEL$VIRTUAL;
			sb->nsec = 1;
			RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, sio);
		}
		if (sb->nsec != 1) goto sec1;
		sio->status = sb->b.status;
		reta:
		p = sb->p;
		FREE_SB(sb, p);
		RETURN_AST(sio);
	}
	vbuf.ptr = sb->buffer + ((unsigned)sb->off & (BIO_SECTOR_SIZE - 1));
	vbuf.len = (sb->nsec << BIO_SECTOR_SIZE_BITS) - ((unsigned)sb->off & (BIO_SECTOR_SIZE - 1));
	vbuf.spl = SPL_X(SPL_DEV);
	next_vsp:
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely(!(s = sio->v.vspace->op->vspace_put(&sio->v, &vbuf)))) {
		p = sb->p;
		FREE_SB(sb, p);
		DO_PAGEIN(sio, &sio->v, PFFLAG);
	}
	sio->progress += s;
	INC_FPOS(1);
	vbuf.ptr = (char *)vbuf.ptr + s;
	vbuf.len -= s;
	if (sio->v.len) {
		if (vbuf.len) goto next_vsp;
		p = sb->p;
		FREE_SB(sb, p);
		TEST_LOCKUP_LOOP(sio, RETURN);
		RETURN_IORQ_LSTAT(sio, FN);
	}
	end:
	if (__likely(sio->progress >= 0)) sio->status = sio->progress;
	else sio->status = -EOVERFLOW;
	goto reta;
}

#else

#if !AS
DECL_AST(INDIRECT_READ_WRITE_FINISHED, SPL_DEV, BIORQ)
#else
DECL_AST(INDIRECT_AREAD_AWRITE_FINISHED, SPL_DEV, BIORQ)
#endif
{
	SBIORQ *sb = LIST_STRUCT(RQ, SBIORQ, b);
	XIORQ *sio = sb->sio;
	PARTITIONS *p;
	VBUF vbuf;
	unsigned long s, l;
	unsigned of;
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, sio);
	SWITCH_PROC_ACCOUNT(sio->handle->name_addrspace, SPL_X(SPL_DEV));
	if (__unlikely(sb->b.status != 0)) {
		if (sb->b.status == -ERANGE) {
			if (__likely(sio->progress >= 0)) sio->status = sio->progress;
			else sio->status = -EOVERFLOW;
			goto reta;
		}
		sio->status = sb->b.status;
		reta:
		p = sb->p;
		W_UNLOCK(sb, p);
		FREE_SB(sb, p);
		RETURN_AST(sio);
	}
	of = sb->off & (BIO_SECTOR_SIZE - 1);
	vbuf.ptr = sb->buffer + of;
	vbuf.len = sio->v.len;
	if (of + vbuf.len > BIO_SECTOR_SIZE * BUFFER_SECTORS) {
		vbuf.len = BIO_SECTOR_SIZE * BUFFER_SECTORS - of;
	} else if (of + vbuf.len > BIO_SECTOR_SIZE && __unlikely((int)(of + vbuf.len) & (BIO_SECTOR_SIZE - 1))) {
		vbuf.len = ((of + vbuf.len) & ~(BIO_SECTOR_SIZE - 1)) - of;
	}
	vbuf.spl = SPL_X(SPL_DEV);
	l = 0;
	nextpg:
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely(!(s = sio->v.vspace->op->vspace_get(&sio->v, &vbuf)))) {
		sio->v.ptr -= l;
		sio->v.len += l;
		p = sb->p;
		W_UNLOCK(sb, p);
		FREE_SB(sb, p);
		DO_PAGEIN(sio, &sio->v, PFFLAG);
	}
	l += s;
	vbuf.ptr = (char *)vbuf.ptr + s;
	vbuf.len -= s;
	if (vbuf.len) goto nextpg;
	sio->v.ptr -= l;
	sio->v.len += l;
	sb->written = l;
	sb->b.flags = BIO_WRITE;
	sb->b.desc = &sb->desc;
	sb->b.proc = sb->tag.proc;
	sb->b.fault_sec = -1;
	sb->desc.next = NULL;
	sb->b.fn = IWF;
	sb->b.sec = sb->sec;
	sb->b.nsec = (of + l + BIO_SECTOR_SIZE - 1) >> BIO_SECTOR_SIZE_BITS;
	sb->desc.v.ptr = (unsigned long)sb->buffer;
	sb->desc.v.len = sb->b.nsec << BIO_SECTOR_SIZE_BITS;
	sb->desc.v.vspace = &KERNEL$VIRTUAL;
	sb->nsec = sb->b.nsec;
	RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, sio);
}

#if !AS
DECL_AST(INDIRECT_WRITE_FINISHED, SPL_DEV, BIORQ)
#else
DECL_AST(INDIRECT_AWRITE_FINISHED, SPL_DEV, BIORQ)
#endif
{
	SBIORQ *sb = LIST_STRUCT(RQ, SBIORQ, b);
	XIORQ *sio = sb->sio;
	PARTITIONS *p;
	unsigned long s;
#if !AS
	FFILE *file;
	vspace_unmap_t *funmap;
#endif
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, sio);
	SWITCH_PROC_ACCOUNT(sio->handle->name_addrspace, SPL_X(SPL_DEV));
	if (__unlikely(sb->b.status != 0)) {
		if (sb->b.status == -ERANGE) {
			if (sb->nsec == 1) goto end;
			sb->b.flags = BFLAGS;
			sb->b.desc = &sb->desc;
			sb->b.proc = sb->tag.proc;
			sb->b.fault_sec = -1;
			sb->desc.next = NULL;
			sb->b.sec = sb->sec;
			sb->b.nsec = 1;
			sb->desc.v.ptr = (unsigned long)sb->buffer;
			sb->desc.v.len = sb->b.nsec << BIO_SECTOR_SIZE_BITS;
			sb->desc.v.vspace = &KERNEL$VIRTUAL;
			sb->nsec = 1;
			sb->written = BIO_SECTOR_SIZE - ((unsigned)sb->off & (BIO_SECTOR_SIZE - 1));
			RETURN_IORQ_CANCELABLE(&sb->b, KERNEL$WAKE_BIO, sio);
		}
		sio->status = sb->b.status;
		reta:
		p = sb->p;
		W_UNLOCK(sb, p);
		FREE_SB(sb, p);
		RETURN_AST(sio);
	}
	s = sb->written;
	INC_FPOS(0);
	sio->v.ptr += s;
	sio->v.len -= s;
	sio->progress += s;
	if (sio->v.len) {
		p = sb->p;
		W_UNLOCK(sb, p);
		FREE_SB(sb, p);
		TEST_LOCKUP_LOOP(sio, RETURN);
		RETURN_IORQ_LSTAT(sio, FN);
	}
	end:
	if (__likely(sio->progress >= 0)) sio->status = sio->progress;
	else sio->status = -EOVERFLOW;
	goto reta;
}

#endif

#undef W_UNLOCK
#undef S_UNLOCK
#undef INC_FPOS

#undef FN
#undef WFN
#undef fnn
#undef XIORQ
#undef BFLAGS
#undef PFFLAG
#undef DRF
#undef IRF
#undef IRWF
#undef IWF
