#ifndef __HOST_USBMSD_H
#define __HOST_USBMSD_H

#include <SYS/TYPES.H>
#include <ENDIAN.H>

#define MSD_SUBCLASS_RBC		0x01
#define MSD_SUBCLASS_SFF_8020_I_MMC_2	0x02
#define MSD_SUBCLASS_QIC_157		0x03
#define MSD_SUBCLASS_UFI		0x04
#define MSD_SUBCLASS_SFF_8070I		0x05
#define MSD_SUBCLASS_SCSI		0x06

#define MSD_PROTOCOL_CBI		0x00
#define MSD_PROTOCOL_CB			0x01
#define MSD_PROTOCOL_BULK		0x50

#define MSD_CMD_RESET			(0xff00 | USB_CTRL_RECIP_INTERFACE | USB_CTRL_TYPE_CLASS | USB_CTRL_DIR_OUT)
#define MSD_CMD_GET_MAX_LUN		(0xfe00 | USB_CTRL_RECIP_INTERFACE | USB_CTRL_TYPE_CLASS | USB_CTRL_DIR_IN)

#define MSD_MAX_LUNS			0x10

#define MSD_CMD_LENGTH			16

typedef struct {
	__u32 dCBWSignature;
	__u32 dCBWTag;
	__u32 dCBWDataTransferLength;
	__u8 bmCBWFlags;
	__u8 bCBWLUN;
	__u8 bCBWLength;
	__u8 bCBWCB[MSD_CMD_LENGTH];
} MSD_CBW;

#define CBW_SIZE			31

#define CBW_SIGNATURE			__32CPU2LE(0x43425355)
#define CBW_FLAGS_DATA_OUT		0x00
#define CBW_FLAGS_DATA_IN		0x80

typedef struct {
	__u32 dCSWSignature;
	__u32 dCSWTag;
	__u32 dCSWDataResidue;
	__u8 bCSWStatus;
} MSD_CSW;

#define CSW_SIZE			13

#define CSW_SIGNATURE			__32CPU2LE(0x53425355)
#define CSW_STATUS_GOOD			0x00
#define CSW_STATUS_FAILED		0x01
#define CSW_STATUS_PHASE_ERROR		0x02

#endif

