#include <SPAD/AC.H>
#include <SPAD/LIBC.H>
#include <SPAD/TIMER.H>
#include <SPAD/SYSLOG.H>
#include <ARCH/BSF.H>
#include <SPAD/SYNC.H>
#include <SYS/PARAM.H>
#include <SPAD/SCSI.H>
#include <STDLIB.H>
#include <STRING.H>

#include "SD.H"

static int TEST_UNIT_READY_ACTION(SCSIRQ *cmd);
static int START_STOP_UNIT_ACTION(SCSIRQ *cmd);

long SD_MEDIA_THREAD(void *sd_)
{
	SD *sd = sd_;
	DECL_SCSIRQ(16) cmd;
	SCSI_SENSE_DATA sense;
	union {
		SCSI_CAPACITY_10 capa10;
		SCSI_CAPACITY_16 capa16;
	} u;
	__u64 capa;
	__u32 secsize;
	unsigned max_secsize;
	unsigned secsize_bits;
	char *cmdstring;
	int r;
	SCSI_MODE_SENSE_HEADER *mode;

	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ZERO)))
		KERNEL$SUICIDE("SD_MEDIA_THREAD AT SPL %08X", KERNEL$SPL);
	RAISE_SPL(SPL_ATA_SCSI);

	while (__unlikely(!XLIST_EMPTY(&sd->in_progress)) && __unlikely(!LIST_EMPTY(&sd->waiting_list))) KERNEL$SLEEP(1);

	cmd.sense = (__u8 *)&sense;
	cmd.sense_size = SCSI_SIZEOF_SENSE_DATA;

	cmd.direction = 0;
	cmd.cmdlen = 6;
	cmd.cmd[0] = SCMD_TEST_UNIT_READY;
	cmd.cmd[1] = sd->lun_byte;
	cmd.cmd[2] = 0;
	cmd.cmd[3] = 0;
	cmd.cmd[4] = 0;
	cmd.cmd[5] = 0;
	SCSI$SYNC_RQ(sd->dev_name, sd->errorlevel, cmdstring = "TEST UNIT READY", (SCSIRQ *)&cmd, &sd->ap, NULL, 0, sd->timeout, SD_RETRIES, TEST_UNIT_READY_ACTION);
	if (__unlikely(TEST_UNIT_READY_ACTION((SCSIRQ *)&cmd) != SCSI_ACTION_OK)) {
		u_jiffies_lo_t spin_start_time;
		__u32 key = SCSI$GET_CMD_SENSE((SCSIRQ *)&cmd);
		if (__unlikely(SCSI_SENSE_UNKNOWN(key))) goto cmd_err;
		if (SCSI_SENSE_KEY(key == SCSI_KEY_NOT_READY)) {
			__u8 asc = SCSI_SENSE_ASC(key);
			__u8 ascq = SCSI_SENSE_ASCQ(key);
			if (asc == 0x04 && ascq >= 0x03 && ascq <= 0x09) goto cmd_err;
		} else goto cmd_err;
		cmd.direction = 0;
		cmd.cmdlen = 6;
		cmd.cmd[0] = SCMD_START_STOP_UNIT;
		cmd.cmd[1] = sd->lun_byte | 1;
		cmd.cmd[2] = 0;
		cmd.cmd[3] = 0;
		cmd.cmd[4] = 1;
		cmd.cmd[5] = 0;
		SCSI$SYNC_RQ(sd->dev_name, sd->errorlevel, cmdstring = "START STOP UNIT", (SCSIRQ *)&cmd, &sd->ap, NULL, 0, MAX(sd->timeout, SD_SPINUP_TIMEOUT), SD_RETRIES, START_STOP_UNIT_ACTION);
		if (__unlikely(START_STOP_UNIT_ACTION((SCSIRQ *)&cmd) != SCSI_ACTION_OK)) goto cmd_err;
		spin_start_time = KERNEL$GET_JIFFIES_LO();
		do {
			KERNEL$SLEEP(JIFFIES_PER_SECOND);
			cmd.direction = 0;
			cmd.cmdlen = 6;
			cmd.cmd[0] = SCMD_TEST_UNIT_READY;
			cmd.cmd[1] = sd->lun_byte;
			cmd.cmd[2] = 0;
			cmd.cmd[3] = 0;
			cmd.cmd[4] = 0;
			cmd.cmd[5] = 0;
			SCSI$SYNC_RQ(sd->dev_name, sd->errorlevel, cmdstring = "TEST UNIT READY", (SCSIRQ *)&cmd, &sd->ap, NULL, 0, sd->timeout, 0, NULL);
			if (__unlikely(cmd.status == -EINTR)) goto cmd_err;
			if (__unlikely(TEST_UNIT_READY_ACTION((SCSIRQ *)&cmd) == SCSI_ACTION_OK)) goto spun_up;
		} while (KERNEL$GET_JIFFIES_LO() - spin_start_time <= TIMEOUT_JIFFIES(MAX(sd->timeout, SD_SPINUP_TIMEOUT)));
		/* failed to spin up */
		if (sd->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "SPIN UP FAILED");
		LOWER_SPL(SPL_ZERO);
		return -EIO;
	}
	spun_up:;

	sd->flags &= ~FLAGS_WP;
	
	if (__likely(STD_IS_DISK(sd->std))) {
		mode = SCSI$MODE_SENSE(sd->dev_name, sd->errorlevel, &sd->inq, sd->scsi_version, &sd->ap, sd->lun_byte, 0x3f, 0, sd->timeout, SD_RETRIES);
		if (__unlikely(__IS_ERR(mode))) mode = SCSI$MODE_SENSE(sd->dev_name, sd->errorlevel, &sd->inq, sd->scsi_version, &sd->ap, sd->lun_byte, 0x00, 0, sd->timeout, SD_RETRIES);
		if (__unlikely(__IS_ERR(mode))) mode = SCSI$MODE_SENSE(sd->dev_name, sd->errorlevel, &sd->inq, sd->scsi_version, &sd->ap, sd->lun_byte, 0x3f, 255 - 8, sd->timeout, SD_RETRIES);
		if (__likely(!__IS_ERR(mode))) {
			/*__debug_printf("mode sense: %x, %x, %x, %x\n", __16BE2CPU(mode->data_length), mode->medium_type, mode->device_specific, __16BE2CPU(mode->block_descriptor_length));*/
			if (mode->device_specific & 0x80) sd->flags |= FLAGS_WP;
			free(mode);
		}
	} else {
			/* CD-ROM */
		sd->flags |= FLAGS_WP;
	}

	cmd.direction = PF_WRITE;
	cmd.cmdlen = 10;
	cmd.cmd[0] = SCMD_READ_CAPACITY_10;
	cmd.cmd[1] = sd->lun_byte;
	cmd.cmd[2] = 0;
	cmd.cmd[3] = 0;
	cmd.cmd[4] = 0;
	cmd.cmd[5] = 0;
	cmd.cmd[6] = 0;
	cmd.cmd[7] = 0;
	cmd.cmd[8] = 0;
	cmd.cmd[9] = 0;
	sd->flags &= ~(FLAGS_COMMAND_SIZE_10 | FLAGS_COMMAND_SIZE_16 | FLAGS_NO_SYNCHRONIZE_CACHE);
	if (__unlikely(sd->std == STD_SCSI_1)) sd->flags |= FLAGS_NO_SYNCHRONIZE_CACHE;
	SCSI$SYNC_RQ(sd->dev_name, sd->errorlevel, cmdstring = "READ CAPACITY(10)", (SCSIRQ *)&cmd, &sd->ap, &u.capa10, sizeof u.capa10, sd->timeout, SD_RETRIES, SCSI$RECOMMENDED_ACTION);
	/*__debug_printf("%X,%X\n", __32BE2CPU(u.capa10.lba), __32BE2CPU(u.capa10.sector_size));*/
	if (__unlikely(SCSI$RECOMMENDED_ACTION((SCSIRQ *)&cmd) != SCSI_ACTION_OK)) goto cmd_err;
	if (__unlikely(cmd.status < SCSI_MIN_CAPACITY_10_SIZE)) {
		if (sd->errorlevel >= 1)
			KERNEL$SYSLOG(__SYSLOG_HW_BUG, sd->dev_name, "READ CAPACITY(10) RETURNED TOO LITTLE DATA (%d)", cmd.status);
		LOWER_SPL(SPL_ZERO);
		return -EPROTO;
	}
	if (u.capa10.lba != __32CPU2BE(0xffffffff)) {
		capa = __32BE2CPU(u.capa10.lba) + 1;
		secsize = __32BE2CPU(u.capa10.sector_size);
		if (__likely(sd->std != STD_SCSI_1) || capa > 0x200000 || __unlikely(secsize < BIO_SECTOR_SIZE / 0x100)) {
			sd->flags |= FLAGS_COMMAND_SIZE_10;
			sd->max_sectors = 0xFFFF;
					/* will be modified later ... */
		} else {
			sd->max_sectors = 0x100;
		}
	} else {
		cmd.direction = PF_WRITE;
		cmd.cmdlen = 16;
		cmd.cmd[0] = SCMD_READ_CAPACITY_16;
		cmd.cmd[1] = SCMDSA_READ_CAPACITY_16 | sd->lun_byte;
		cmd.cmd[2] = 0;
		cmd.cmd[3] = 0;
		cmd.cmd[4] = 0;
		cmd.cmd[5] = 0;
		cmd.cmd[6] = 0;
		cmd.cmd[7] = 0;
		cmd.cmd[8] = 0;
		cmd.cmd[9] = 0;
		cmd.cmd[10] = sizeof u.capa16 >> 24;
		cmd.cmd[11] = sizeof u.capa16 >> 16;
		cmd.cmd[12] = sizeof u.capa16 >> 8;
		cmd.cmd[13] = sizeof u.capa16;
		cmd.cmd[14] = 0;
		cmd.cmd[15] = 0;
		SCSI$SYNC_RQ(sd->dev_name, sd->errorlevel, cmdstring = "READ CAPACITY(16)", (SCSIRQ *)&cmd, &sd->ap, &u.capa16, sizeof u.capa16, sd->timeout, SD_RETRIES, SCSI$RECOMMENDED_ACTION);
		if (__unlikely(SCSI$RECOMMENDED_ACTION((SCSIRQ *)&cmd) != SCSI_ACTION_OK)) goto cmd_err;
		if (__unlikely(cmd.status < SCSI_MIN_CAPACITY_16_SIZE)) {
			if (sd->errorlevel >= 1)
				KERNEL$SYSLOG(__SYSLOG_HW_BUG, sd->dev_name, "READ CAPACITY(16) RETURNED TOO LITTLE DATA (%d)", cmd.status);
			LOWER_SPL(SPL_ZERO);
			return -EPROTO;
		}
		sd->flags |= FLAGS_COMMAND_SIZE_16;
		capa = __64BE2CPU(u.capa16.lba) + 1;
		secsize = __32BE2CPU(u.capa16.sector_size);
		if (__unlikely(!capa)) {
			if (sd->errorlevel >= 2)
				KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "INVALID CAPACITY");
			LOWER_SPL(SPL_ZERO);
			return -EINVAL;
		}
		sd->max_sectors = 0;
	}
	if (__unlikely(secsize & (secsize - 1)) || __unlikely(!secsize)) {
		if (sd->std < 0) {
	/* some CD-ROMS report hardware sector size instead of 2048.
	   some CD-ROMS report 2048 for some CDs and 2352 for others (TEAC) */
			secsize = 2048;
		} else {
			if (sd->errorlevel >= 2)
				KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "INVALID SECTOR SIZE %u", (unsigned)secsize);
			LOWER_SPL(SPL_ZERO);
			return -EINVAL;
		}
	}
	max_secsize = SD_MAX_SECSIZE;
	if (sd->ap.max_fragments && sd->ap.max_fragments < max_secsize >> BIO_SECTOR_SIZE_BITS) max_secsize = sd->ap.max_fragments << BIO_SECTOR_SIZE_BITS;
	if (sd->ap.max_sectors < max_secsize >> BIO_SECTOR_SIZE_BITS) max_secsize = sd->ap.max_sectors << BIO_SECTOR_SIZE_BITS;
	if (__unlikely(secsize > max_secsize)) {
		if (sd->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "TOO BIG SECTOR SIZE %u (MAXIMUM %u)", (unsigned)secsize, max_secsize);
		LOWER_SPL(SPL_ZERO);
		return -EINVAL;
	}
	secsize_bits = __BSR(secsize);
	
	sd->flags &= ~(FLAGS_LARGER_SECSIZE | FLAGS_SMALLER_SECSIZE);
	if (__unlikely(secsize_bits < BIO_SECTOR_SIZE_BITS)) {
		sd->secsize_shift = BIO_SECTOR_SIZE - secsize_bits;
		sd->max_sectors >>= sd->secsize_shift;
		capa >>= BIO_SECTOR_SIZE - secsize_bits;
		if (__unlikely(!capa)) {
			if (sd->errorlevel >= 2)
				KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "MEDIA SIZE SMALLER THAN %d BYTES", BIO_SECTOR_SIZE);
			LOWER_SPL(SPL_ZERO);
			return -EINVAL;
		}
		sd->flags |= FLAGS_SMALLER_SECSIZE;
	} else
#ifndef SD_TEST_RMW
		if (__unlikely(secsize_bits > BIO_SECTOR_SIZE_BITS))
#endif
	{
		sd->secsize_shift = secsize_bits - BIO_SECTOR_SIZE_BITS;
		sd->max_sectors <<= sd->secsize_shift;
		if ((capa << (secsize_bits - BIO_SECTOR_SIZE_BITS) >> (secsize_bits - BIO_SECTOR_SIZE_BITS)) != capa) {
			if (sd->errorlevel >= 2)
				KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "MEDIA SIZE LARGER THAN 2^73 BYTES");
			LOWER_SPL(SPL_ZERO);
			return -EINVAL;
		}
		capa <<= secsize_bits - BIO_SECTOR_SIZE_BITS;
		sd->flags |= FLAGS_LARGER_SECSIZE;
	}
	if (__unlikely(sd->flags & FLAGS_COMMAND_SIZE_16) || __likely(sd->max_sectors > sd->ap.max_sectors)) {
		sd->max_sectors = sd->ap.max_sectors;
		if (__unlikely(sd->flags & FLAGS_LARGER_SECSIZE))
			sd->max_sectors &= ~(unsigned)((1 << sd->secsize_shift) - 1);
		/* max_secsize before guarantees that this won't be 0 */
		if (__unlikely(!sd->max_sectors))
			KERNEL$SUICIDE("SD_MEDIA_THREAD: MAX_SECTORS IS ZERO");
	}
	if (__unlikely(capa >= (__u64)1 << (64 - BIO_SECTOR_SIZE_BITS))) {
		if (sd->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "MEDIA IS TOO BIG CAPACITY %016"__64_format"X >= MAXIMUM %016"__64_format"X", capa, (__u64)1 << (64 - BIO_SECTOR_SIZE_BITS));
		LOWER_SPL(SPL_ZERO);
		return -EFBIG;
	}
	if (__unlikely(capa != (__sec_t)capa) || __unlikely((__sec_t)capa < 0)) {
		if (sd->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "MEDIA WITH CAPACITY %016"__64_format"X SECTORS INACCESSIBLE BECAUSE SYSTEM WAS COMPILED WITH 31-BIT SECTOR NUMBERS", capa);
		LOWER_SPL(SPL_ZERO);
		return -EFBIG;
	}
	if (__unlikely(sd->flags & FLAGS_SMALLER_SECSIZE)) if (__unlikely((capa << (BIO_SECTOR_SIZE - secsize_bits)) != (__sec_t)(capa << (BIO_SECTOR_SIZE - secsize_bits))) || __unlikely((__sec_t)(capa << (BIO_SECTOR_SIZE - secsize_bits)) < 0)) {
		if (sd->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sd->dev_name, "MEDIA WITH CAPACITY %016"__64_format"X RAW SECTORS INACCESSIBLE BECAUSE SYSTEM WAS COMPILED WITH 31-BIT SECTOR NUMBERS", capa);
		LOWER_SPL(SPL_ZERO);
		return -EFBIG;
	}
	sd->capacity = capa;
	if (sd->p) BIO$SET_PARTITIONS_SIZE(sd->p, sd->capacity);
	/*__debug_printf("capacity %Lx, secsize %x\n", capa, secsize);*/
	LOWER_SPL(SPL_ZERO);
	return 0;

	cmd_err:
	/*{
		int i;
		__debug_printf("status: %d, scsi_status: %d\n", cmd.status, cmd.scsi_status);
		__debug_printf("sense:");
		for (i = 0; i < 18; i++) __debug_printf(" %02X", ((__u8 *)&sense)[i]);
		__debug_printf("\n");
	}*/
	r = SCSI$CMD_ERROR_CODE(sd->scsi_version, (SCSIRQ *)&cmd);
	SCSI$LOG_ERROR(sd->dev_name, sd->errorlevel, &sd->inq, sd->scsi_version, cmdstring, (SCSIRQ *)&cmd, r);
	LOWER_SPL(SPL_ZERO);
	return r;
}

static int TEST_UNIT_READY_ACTION(SCSIRQ *cmd)
{
	if (__likely(cmd->status >= 0) && cmd->scsi_status == SCSI_CHECK_CONDITION) {
		__u32 key = SCSI$GET_SENSE((SCSI_SENSE_DATA *)cmd->sense, cmd->sense_size);
		if (__unlikely(SCSI_SENSE_UNKNOWN(key))) return SCSI_ACTION_FAIL;
		if (__unlikely(SCSI_SENSE_DEFERRED(key))) goto deflt;
		if (SCSI_SENSE_KEY(key) == SCSI_KEY_NOT_READY && SCSI_SENSE_ASC(key) == 0x04) {
			__u8 ascq = SCSI_SENSE_ASCQ(key);
			if (ascq != 0x01 && !(ascq >= 0x04 && ascq <= 0x09)) return SCSI_ACTION_FAIL;
			goto deflt;
		}
	}
	deflt:
	return SCSI$RECOMMENDED_ACTION(cmd);
}

static int START_STOP_UNIT_ACTION(SCSIRQ *cmd)
{
	if (__likely(cmd->status >= 0) && __unlikely(cmd->scsi_status == SCSI_CHECK_CONDITION)) {
		__u32 key = SCSI$GET_SENSE((SCSI_SENSE_DATA *)cmd->sense, cmd->sense_size);
		if (__likely(!SCSI_SENSE_UNKNOWN(key)) && __likely(!SCSI_SENSE_DEFERRED(key)) && SCSI_SENSE_ASC(key) == 0x04 && SCSI_SENSE_ASCQ(key) == 0x01) return SCSI_ACTION_OK;
	}
	return SCSI$RECOMMENDED_ACTION(cmd);
}

extern AST_STUB SD_MEDIA_PROBED;

void SD_MEDIA_PROBE(SD *sd)
{
	if (__unlikely(sd->flags & FLAGS_MEDIA_PROBING)) return;
	SD_RESET_FSTAT(sd);
	sd->flags |= FLAGS_NO_MEDIA | FLAGS_MEDIA_PROBING;
	sd->media_thread.fn = SD_MEDIA_PROBED;
	sd->media_thread.thread_main = SD_MEDIA_THREAD;
	sd->media_thread.p = sd;
	sd->media_thread.error = NULL;
	sd->media_thread.cwd = NULL;
	sd->media_thread.std_in = -1;
	sd->media_thread.std_out = -1;
	sd->media_thread.std_err = -1;
	sd->media_thread.dlrq = NULL;
	sd->media_thread.spawned = 0;
	/* sd->media_thread.thread already set */
	CALL_IORQ(&sd->media_thread, KERNEL$THREAD);
}

DECL_AST(SD_MEDIA_PROBED, SPL_ATA_SCSI, THREAD_RQ)
{
	IORQ *io;
	SD *sd = GET_STRUCT(RQ, SD, media_thread);
	sd->flags &= ~(FLAGS_NO_MEDIA | FLAGS_MEDIA_PROBING);
	if (__likely(!sd->media_thread.status) || __unlikely(sd->media_thread.status == -EINTR)) {
		WQ_WAKE_ALL(&sd->media_wq);
		SD_DEQUEUE(&sd->ap);
		RETURN;
	}
	SD_RESET_FSTAT(sd);
	sd->flags |= FLAGS_NO_MEDIA;
	while (__unlikely((io = WQ_GET_ONE(&sd->media_wq)) != NULL)) {
		io->status = sd->media_thread.status;
		CALL_AST(io);
	}
	SD_DEQUEUE_ERROR(sd, sd->media_thread.status);
	RETURN;
}

void SD_RESET_FSTAT(SD *sd)
{
	if (sd->p) BIO$SET_PARTITIONS_SIZE(sd->p, (__sec_t)-1);
}
