unsigned mclk;

#define BASE_FREQ	14318180

static int s3dacsfindclock(unsigned freq_in, unsigned min_n2, unsigned freq_min, unsigned freq_max, unsigned *best_m_out, unsigned *best_n1_out, unsigned *best_n2_out)
{
	int diff, best_diff;
	int m;
	__u8 n1, n2;
	__u8 best_n1 = 16 + 2, best_n2 = 2, best_m = 125 + 2;
	unsigned ffreq_in = (__u64)freq_in * 1000000 / BASE_FREQ;
	unsigned ffreq_min = (__u64)freq_min * 1000000 / BASE_FREQ;
	unsigned ffreq_max = (__u64)freq_max * 1000000 / BASE_FREQ;
	unsigned ffreq_out;
	if (__unlikely(freq_in < freq_min / 8)) {
		/*__debug_printf("too low freq\n");*/
		return -1;
	}
	if (__unlikely(freq_in > freq_max >> min_n2)) {
		/*__debug_printf("too high freq\n");*/
		return -1;
	}
	best_diff = ffreq_in;
	for (n2 = min_n2; n2 <= 3; n2++) {
		for (n1 = 1 + 2; n1 <= 31 + 2; n1++) {
			m = (__u64)(((ffreq_in * n1) << n2) + 500000) / 1000000;
			if (m < 1 + 2 || m > 127 + 2) continue;
			ffreq_out = (__u64)m * 1000000 / n1;
			if (ffreq_out >= ffreq_min && ffreq_out <= ffreq_max) {
				diff = ffreq_in - (ffreq_out >> n2);
				if (diff < 0) diff = -diff;
				if (diff < best_diff) {
					best_diff = diff;
					best_m = m;
					best_n1 = n1;
					best_n2 = n2;
				}
			}
		}
	}
	/*__debug_printf("m: %d, n1: %d, n2: %d\n", best_m, best_n1, best_n2);
	__debug_printf("%d -> %d\n", freq_in, (int)(((__u64)best_m * BASE_FREQ / best_n1) >> best_n2));*/
	*best_m_out = best_m;
	*best_n1_out = best_n1;
	*best_n2_out = best_n2;
	return 0;
}

static int gendac_sdac_probe(void)
{
	__u8 cr_55;
	__u32 clock01, clock23;
	int i;
	__u8 savelut[6];
	cr_55 = in_cr(0x55);
	out_cr(0x55, cr_55 & ~1);
	io_outb(VGA_DAC_READ_IDX, 0);
	for (i = 0; i < 6; i++) savelut[i] = io_inb(VGA_DAC_REG);
	io_outb(VGA_DAC_WRITE_IDX, 0);
	for (i = 0; i < 6; i++) io_outb(VGA_DAC_REG, 0);
	out_cr(0x55, cr_55 | 1);
	io_outb(VGA_DAC_READ_IDX, 0);
	clock01 = 0;
	for (i = 0; i < 4; i++) clock01 = (clock01 << 8) | io_inb(VGA_DAC_REG);
	clock23 = 0;
	for (i = 0; i < 4; i++) clock23 = (clock23 << 8) | io_inb(VGA_DAC_REG);
	out_cr(0x55, cr_55 & ~1);
	io_outb(VGA_DAC_WRITE_IDX, 0);
	for (i = 0; i < 6; i++) io_outb(VGA_DAC_REG, savelut[i]);
	out_cr(0x55, cr_55);
	if ((clock01 == 0x28613d62 || clock01 == 0x524a5d4a) || (clock01 == 0x7f7f7f7f && clock23 != 0x7f7f7f7f)) {
		io_inb(VGA_DAC_WRITE_IDX);
		io_inb(VGA_DAC_MASK);
		io_inb(VGA_DAC_MASK);
		io_inb(VGA_DAC_MASK);
		if ((io_inb(VGA_DAC_MASK) & 0xf0) == 0x70) return 2;
		else return 1;
	}
	return 0;
}

static int sdac_probe(void)
{
	return gendac_sdac_probe() == 2 ? 0 : -ENODEV;
}

static int gendac_probe(void)
{
	return gendac_sdac_probe() == 1 ? 0 : -ENODEV;
}

static unsigned gendac_sdac_calc_clock(unsigned pixel_clock, unsigned bpp, int gendac, int wr)
{
	unsigned min_m, min_n1, n2;
	if (!gendac) {
		if (bpp == 24) pixel_clock = pixel_clock * 3 / 2;
		if (bpp == 32) pixel_clock = pixel_clock * 2;
	} else {
		pixel_clock *= (bpp + 7) >> 3;
	}
	if (__unlikely(s3dacsfindclock(pixel_clock, 0, 100000000, 250000000, &min_m, &min_n1, &n2))) return 0;
	if (wr) {
		io_outb(VGA_DAC_WRITE_IDX, 2);
		io_outb(VGA_DAC_REG, min_m - 2);
		io_outb(VGA_DAC_REG, (min_n1 - 2) | (n2 << 5));
	}
	pixel_clock = ((__u64)min_m * BASE_FREQ / min_n1) >> n2;
	if (!gendac) {
		if (bpp == 24) pixel_clock = pixel_clock * 2 / 3;
		if (bpp == 32) pixel_clock = pixel_clock / 2;
	} else {
		pixel_clock /= (bpp + 7) >> 3;
	}
	return pixel_clock;
}

static unsigned sdac_get_pixel_clock(unsigned bpp, unsigned pixel_clock)
{
	return gendac_sdac_calc_clock(pixel_clock, bpp, 0, 0);
}

static unsigned gendac_get_pixel_clock(unsigned bpp, unsigned pixel_clock)
{
	return gendac_sdac_calc_clock(pixel_clock, bpp, 1, 0);
}

static unsigned gendac_sdac_set_clock(unsigned bpp, unsigned pixel_clock, int gendac)
{
	__u8 cr_55;
	__u8 pixmux;
	switch (bpp) {
		case 8:
			pixmux = 0x00;
			break;
		case 15:
			if (!gendac) pixmux = 0x30;
			else pixmux = 0x20;
			break;
		case 16:
			if (!gendac) pixmux = 0x50;
			else pixmux = 0x60;
			break;
		case 24:
			if (!gendac) pixmux = 0x90;
			else pixmux = 0x40;
			break;
		case 32:
			if (!gendac) pixmux = 0x70;
			else return 0;
			break;
		default:
			return 0;
	}
	cr_55 = in_cr(0x55) & 0xfc;
	out_cr(0x55, cr_55 | 0x01);
	io_outb(VGA_DAC_MASK, pixmux);
	pixel_clock = gendac_sdac_calc_clock(pixel_clock, bpp, gendac, 1);
	out_cr(0x55, cr_55);
	return pixel_clock;
}

static unsigned sdac_set_pixel_clock(unsigned bpp, unsigned pixel_clock)
{
	return gendac_sdac_set_clock(bpp, pixel_clock, 0);
}

static unsigned gendac_set_pixel_clock(unsigned bpp, unsigned pixel_clock)
{
	return gendac_sdac_set_clock(bpp, pixel_clock, 1);
}

static unsigned gendac_sdac_map_horizontal_crtc(unsigned bpp, unsigned pixelclock, unsigned htiming)
{
	return htiming * ((bpp + 7) >> 3);
}

static int trio64_probe(void)
{
	__u8 sr_8 = in_sr(0x08);
	__u8 m, n, n1, n2;
	out_sr(0x08, 0x06);
	m = in_sr(0x11);
	n = in_sr(0x10);
	out_sr(0x08, sr_8);
	m &= 0x7f;
	n1 = n & 0x1f;
	n2 = (n >> 5) & 0x03;
	mclk = ((1431818 * (m + 2)) / (n1 + 2) / (1 << n2) + 50) / 100;
	return 0;
}

static unsigned trio64_map_horizontal_crtc(unsigned bpp, unsigned pixelclock, unsigned htiming)
{
	if (bpp == 15 || bpp == 16) return htiming * 2;
	return htiming;
}

static unsigned trio64_get_pixel_clock(unsigned bpp, unsigned pixel_clock)
{
	/*int apx = 0;*/
	unsigned min_m, min_n1, n2;
	/*if (0 && bpp == 8 && pixel_clock >= 67500000) pixel_clock /= 2, apx = 1;*/
	if (__unlikely(s3dacsfindclock(pixel_clock, 0, 130000000, 270000000, &min_m, &min_n1, &n2))) return 0;
	return ((__u64)min_m * BASE_FREQ / min_n1) >> n2 /*<< apx*/;
}

static unsigned trio64_set_pixel_clock(unsigned bpp, unsigned pixel_clock)
{
	unsigned r;
	__u8 sr_8, sr_15, sr_18, cr_67;
	/*int apx = 0;*/
	unsigned min_m, min_n1, n2;
	/*if (0 && bpp == 8 && pixel_clock >= 67500000) pixel_clock /= 2, apx = 1;*/
	if (__unlikely(s3dacsfindclock(pixel_clock, 0, 130000000, 270000000, &min_m, &min_n1, &n2))) return 0;
	r = 0;
	sr_8 = in_sr(0x08);
	out_sr(0x08, 0x06);
	sr_15 = in_sr(0x15) & ~0x50;
	sr_18 = in_sr(0x18) & ~0x80;
	cr_67 = 0;
	/*if (bpp == 8 && apx) {
		cr_67 = 0x12;
		sr_15 |= 0x50;
		sr_18 |= 0x80;
	} else*/ if (bpp == 8) {
	} else if (bpp == 15) {
		cr_67 = 0x32;
	} else if (bpp == 16) {
		cr_67 = 0x52;
	} else if (bpp == 32) {
		cr_67 = 0xd1;
	} else {
		goto fail_unlock;
	}
	out_cr(0x67, cr_67);
	out_sr(0x15, sr_15);
	out_sr(0x18, sr_18);
	out_sr(0x12, (min_n1 - 2) | (n2 << 5));
	out_sr(0x13, min_m - 2);
	sr_15 = in_sr(0x15);
	out_sr(0x15, sr_15 & ~0x20);
	out_sr(0x15, sr_15 | 0x20);
	out_sr(0x15, sr_15 & ~0x20);
	r = ((__u64)min_m * BASE_FREQ / min_n1) >> n2 /*<< apx*/;
	fail_unlock:
	out_sr(0x08, sr_8);
	return r;
}

struct dac {
	int (*probe)(void);
	unsigned (*get_pixel_clock)(unsigned bpp, unsigned pixel_clock);
	unsigned (*set_pixel_clock)(unsigned bpp, unsigned pixel_clock);
	unsigned (*map_horizontal_crtc)(unsigned bpp, unsigned pixelclock, unsigned htiming);
};

struct dac s3_sdac = {
	sdac_probe,
	sdac_get_pixel_clock,
	sdac_set_pixel_clock,
	gendac_sdac_map_horizontal_crtc,
};

struct dac s3_gendac = {
	gendac_probe,
	gendac_get_pixel_clock,
	gendac_set_pixel_clock,
	gendac_sdac_map_horizontal_crtc,
};

struct dac s3_trio64_dac = {
	trio64_probe,
	trio64_get_pixel_clock,
	trio64_set_pixel_clock,
	trio64_map_horizontal_crtc,
};

