#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#ifdef __EMX__
#include <io.h>
#endif

#ifdef __SPAD__
#include <ENDIAN.H>
#else
static __u16 __16CPU2LE(__u16 v)
{
	union {
		__u16 u;
		__u8 a[2];
	} u;
	u.a[0] = v;
	u.a[1] = v >> 8;
	return u.u;
}
static __u32 __32CPU2LE(__u32 v)
{
	union {
		__u32 u;
		__u8 a[4];
	} u;
	u.a[0] = v;
	u.a[1] = v >> 8;
	u.a[2] = v >> 16;
	u.a[3] = v >> 24;
	return u.u;
}
#endif

#include "KBDFMT.H"

int main(int argc, char *argv[])
{
	int h, i;
	struct keymap_header hd;
	if (argc != 2) {
		fprintf(stderr, "SYNTAX ERROR");
		exit(2);
	}
	h = creat(argv[1], 0666);
	if (h < 0) {
		perror(argv[1]);
		exit(1);
	}
#ifdef __EMX__
	setmode(h, O_BINARY);
#endif
	for (i = 0; i < sizeof(keymap) / sizeof(*keymap); i++) {
		keymap[i].if_mod_set = __32CPU2LE(keymap[i].if_mod_set);
		keymap[i].if_mod_reset = __32CPU2LE(keymap[i].if_mod_reset);
		keymap[i].if_key = __16CPU2LE(keymap[i].if_key);
		keymap[i].do_mod_set = __32CPU2LE(keymap[i].do_mod_set);
		keymap[i].do_mod_reset = __32CPU2LE(keymap[i].do_mod_reset);
	}
#ifdef EEOF
	errno = EEOF;
#else
	errno = EINVAL;
#endif
	memset(&hd, 0, sizeof hd);
	memcpy(&hd.signature, KEYMAP_SIGNATURE, sizeof hd.signature);
	hd.n_entries_le = __32CPU2LE(sizeof(keymap) / sizeof(*keymap));
#ifdef PARENT_KEYMAP
	strncpy(hd.parent_keymap, PARENT_KEYMAP, sizeof hd.parent_keymap);
#endif
	hd.reserved_bytes = 0;
	if (write(h, &hd, sizeof hd) != sizeof hd || write(h, keymap, sizeof keymap) != sizeof keymap) {
		perror("WRITE");
		exit(1);
	}
	if (close(h)) {
		perror("CLOSE");
		exit(1);
	}
	return 0;
}
