#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#ifdef __EMX__
#include <io.h>
#endif

#ifdef __SPAD__
#include <ENDIAN.H>
#else
typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned __u32;
static __u32 __32CPU2LE(__u32 v)
{
	union {
		__u32 u;
		__u8 a[4];
	} u;
	u.a[0] = v;
	u.a[1] = v >> 8;
	u.a[2] = v >> 16;
	u.a[3] = v >> 24;
	return u.u;
}
#endif

#include "FONTFMT.H"

extern struct font_entry {
	unsigned unicode;
	char *string;
} font[];

static int h;

static void do_write(unsigned char c)
{
#ifdef EEOF
	errno = EEOF;
#else
	errno = EINVAL;
#endif
	if (write(h, &c, 1) != 1) {
		perror("WRITE");
		exit(1);
	}
}

static void do_write_str(char *c, int l)
{
	while (l--) do_write(*c++);
}

int main(int argc, char *argv[])
{
	int i;
	struct font_header fh;
	if (argc != 2) {
		fprintf(stderr, "SYNTAX ERROR");
		exit(2);
	}
	for (i = 0; font[i].string; i++) {
		if (strlen(font[i].string) != HEIGHT * WIDTH) {
			fprintf(stderr, "INVALID SIZE OF CHARACTER %u: %lu\n", font[i].unicode, (unsigned long)strlen(font[i].string));
			abort();
		}
		if (strspn(font[i].string, ".X") != HEIGHT * WIDTH) {
			fprintf(stderr, "INVALID BIT IN CHARACTER %u\n", font[i].unicode);
			abort();
		}
		if (i > 0 && font[i - 1].unicode >= font[i].unicode) {
			fprintf(stderr, "SEQUENCE NOT MONOTONIC: %u > %u\n", font[i - 1].unicode, font[i].unicode);
			abort();
		}
	}
	h = creat(argv[1], 0666);
	if (h < 0) {
		perror(argv[1]);
		exit(1);
	}
#ifdef __EMX__
	setmode(h, O_BINARY);
#endif
	memset(&fh, 0, sizeof fh);
	memcpy(fh.signature, FONT_SIGNATURE, sizeof fh.signature);
	fh.n_entries_le = __32CPU2LE(i);
	fh.width = WIDTH;
	fh.height = HEIGHT;
	fh.letter_size = sizeof(struct letter_header) + (WIDTH * HEIGHT + 7) / 8;
	fh.reserved_bytes = 0;
	do_write_str((char *)&fh, sizeof fh);
	for (i = 0; font[i].string; i++) {
		struct letter_header lh;
		int j;
		unsigned char out;
		memset(&lh, 0, sizeof lh);
		lh.uni_le = __32CPU2LE(font[i].unicode);
		do_write_str((char *)&lh, sizeof lh);
		out = 0;
		for (j = 0; j < WIDTH * HEIGHT; j++) {
			if (j && !(j & 7)) do_write(out), out = 0;
			if (font[i].string[j] == 'X') out |= 1 << ((7 - j) & 7);
		}
		do_write(out);
	}
	if (close(h)) {
		perror("CLOSE");
		exit(1);
	}
	return 0;
}
