#ifndef _CDFS_CDFS_H
#define _CDFS_CDFS_H

#include <SPAD/VFS.H>

#include "STRUCT.H"

#define CDFS_SECTOR_SHIFT	(CDFS_SECTOR_SIZE_BITS - BIO_SECTOR_SIZE_BITS)
#define CDFS_SECTOR_N		(1 << CDFS_SECTOR_SHIFT)
#define CDFS_GET_SECTOR(sec)	((__d_off)(sec) << CDFS_SECTOR_SHIFT)

typedef struct {
	__u8 buffer[CDFS_SECTOR_SIZE];
	unsigned pos;
	unsigned len;
	__u32 cont_sector;
	__u32 cont_offset;
	__u32 cont_len;
	__u32 current_sector;
	unsigned current_offset;
	unsigned n_cont;
} SUSP_STATE;

#define CDFS_HIGH_SIERRA	1
#define CDFS_JOLIET		2
#define CDFS_ROCK_RIDGE		4
#define CDFS_DISABLE_JOLIET	8
#define CDFS_DISABLE_ROCK_RIDGE	16
#define CDFS_PREFER_JOLIET	32

typedef struct {
	FS_HEAD;
	__u8 susp_offset;
} CDFS;

typedef struct {
	FNODE_HEAD;
	unsigned sector;
	unsigned offset;
	unsigned file_desc_length;
} CDFNODE;

#define PG_LOOKUP	0
#define PG_READDIR	1
#define PG_BMAP		2

typedef struct {
	PAGEINRQ_HEAD;
	char type;
	char susp_active;
	char reading_dir;
	unsigned sector;
	unsigned offset;
	unsigned remaining;
	unsigned dirent_residue_length;

	char multi_extent;
	unsigned first_extent_sector;
	unsigned first_extent_offset;
	unsigned accumulated_size;

	time_t ctime;
	time_t mtime;

	SUSP_STATE st;
	__u8 dirent_residue[255];
	char name[255];

	__u8 rock_used_flags;
	unsigned namelen;
	unsigned child_link;
} CDPAGEINRQ;

#define ROCK_USED_NAME		0x01
#define ROCK_USED_CHILD_LINK	0x02
#define ROCK_USED_HIDE		0x04

#define DIRENT_SECTOR(dirent)		(GET_LE_32_16((dirent)->extent_le) + (dirent)->ea_sectors)

#define DIRENT_FLAGS(fs, dirent)	(__likely(!((fs)->flags & CDFS_HIGH_SIERRA)) ? (dirent)->flags : (dirent)->date[6])

#define IS_FORBIDDEN_CHAR(c)		(__unlikely(!(c)) || __unlikely(c == ':') || __unlikely(c == '/'))

int CDFS_PROCESS_OPTION(FS *fs_, char *opt, char *optend, char *str);
int CDFS_MOUNT(FS *fs_);
void CDFS_UMOUNT(FS *fs_, int nosync);
void CDFS_LOOKUP(PAGEINRQ *p_);
void CDFS_INIT_READDIR_COOKIE(struct readdir_buffer *rb, FNODE *f_);
void CDFS_READDIR(PAGEINRQ *p_, struct readdir_buffer *rb);
void CDFS_BMAP(PAGEINRQ *p_);
int CDFS_SYNC_BMAP(FNODE *f_, __d_off off, int try);
void CDFS_STAT(FNODE *f_, struct stat *stat);
WQ *CDFS_STATFS(FS *fs_, struct statfs *stat);

void INIT_SUSP_STATE(CDFS *fs, SUSP_STATE *st, DIRECTORY_RECORD *dir, unsigned current_sector, unsigned current_offset);
SUSP *GET_SUSP_ENTRY(CDFS *fs, SUSP_STATE *st);
void SUSP_CONTINUE(CDFS *fs, SUSP_STATE *st, __u8 *new_sector);

#define CDFS_TIME_HIGH_SIERRA	0
#define CDFS_TIME_SHORT		1
#define CDFS_TIME_LONG		2

time_t CDFS_TIME(__u8 *value, int format);
int ROCK_TIME(SUSP *susp, time_t *ctime, time_t *mtime);

#endif
