#ifndef _CDFS_STRUCT_H
#define _CDFS_STRUCT_H

#include <SYS/TYPES.H>

#define CDFS_SECTOR_SIZE_BITS	11
#define CDFS_SECTOR_SIZE	(1 << CDFS_SECTOR_SIZE_BITS)
#define CDFS_VOLUME_START	16
#define CDFS_VOLUME_MAX		128

#define ISO_ID			"CD001"
#define ISO_TYPE_PRIMARY	1
#define ISO_TYPE_SUPPLEMENTARY	2
#define ISO_TYPE_END		255

#define GET_LE_32_8(a)	((a)[0] + ((a)[1] << 8) + ((a)[2] << 16) + ((a)[3] << 24))
#define GET_LE_32_16(a)	(__16LE2CPU((a)[0]) + (__16LE2CPU((a)[1]) << 16))

typedef struct {
	__u8 type;
	__u8 id[5];
	__u8 version;
	__u8 supplementary_flags;
	__u8 system_id[32];
	__u8 volume_id[32];
	__u8 unused_2[8];
	__u32 volume_space_size_le;
	__u32 volume_space_size_be;
	__u8 supplementary_escape_sequences[32];
	__u16 volume_set_size_le;
	__u16 volume_set_size_be;
	__u16 volume_sequence_number_le;
	__u16 volume_sequence_number_be;
	__u16 logical_block_size_le;
	__u16 logical_block_size_be;
	__u32 path_table_size_le;
	__u32 path_table_size_be;
	__u32 type_l_path_table_le;
	__u32 opt_type_l_path_table_le;
	__u32 type_m_path_table_be;
	__u32 opt_type_m_path_table_be;
	__u8 root_directory[34];
	__u8 volume_set_id[128];
	__u8 publisher_id[128];
	__u8 preparer_id[128];
	__u8 application_id[128];
	__u8 copyright_file_id[37];
	__u8 abstract_file_id[37];
	__u8 bibliographic_file_id[37];
	__u8 creation_date[17];
	__u8 modification_date[17];
	__u8 expiration_date[17];
	__u8 effective_date[17];
	__u8 file_structure_version;
	__u8 unused_4;
	__u8 application_data[512];
	__u8 unused_5[653];
} ISO_DESCRIPTOR;

#define HS_ID			"CDROM"
#define HS_TYPE_PRIMARY		1

typedef struct {
	__u8 foo[8];
	__u8 type;
	__u8 id[5];
	__u8 version;
	__u8 unused_1;
	__u8 system_id[32];
	__u8 volume_id[32];
	__u8 unused_2[8];
	__u32 volume_space_size_le;
	__u32 volume_space_size_be;
	__u8 unused_3[32];
	__u16 volume_set_size_le;
	__u16 volume_set_size_be;
	__u16 volume_sequence_number_le;
	__u16 volume_sequence_number_be;
	__u16 logical_block_size_le;
	__u16 logical_block_size_be;
	__u32 path_table_size_le;
	__u32 path_table_size_be;
	__u32 type_l_path_table_le;
	__u8 unused_4[28];
	__u8 root_directory[34];
	__u8 unused_5[1834];
} HS_DESCRIPTOR;

typedef struct {
	__u8 length;
	__u8 ea_sectors;
	__u16 extent_le[2];
	__u16 extent_be[2];
	__u16 size_le[2];
	__u16 size_be[2];
	__u8 date[7];
	__u8 flags;
	__u8 file_unit_size;
	__u8 interleave_gap;
	__u16 volume_sequence_number_le;
	__u16 volume_sequence_number_be;
	__u8 name_len;
	__u8 name[1];
} DIRECTORY_RECORD;

#define DIR_FLAG_HIDDEN		0x01
#define DIR_FLAG_DIRECTORY	0x02
#define DIR_FLAG_ASSOCIATED	0x04
#define DIR_FLAG_RECORD		0x08
#define DIR_FLAG_PROTECTION	0x10
#define DIR_FLAG_MULTI_EXTENT	0x80

#define SUSP_MAX_CONT			256

#define SUSP_HEAD			\
	__u8 signature[2];		\
	__u8 len;			\
	__u8 version;

typedef struct {
	SUSP_HEAD
} SUSP;

#define TEST_SUSP(susp, s0, s1, v)		(\
	(susp)->signature[0] == (s0) &&		\
	(susp)->signature[1] == (s1) &&		\
	(susp)->version == (v)			)\

typedef struct {
	SUSP_HEAD
	__u8 sector_le[4];
	__u8 sector_be[4];
	__u8 offset_le[4];
	__u8 offset_be[4];
	__u8 length_le[4];
	__u8 length_be[4];
} SUSP_CE;

typedef struct {
	SUSP_HEAD
} SUSP_ST;

typedef struct {
	SUSP_HEAD
	__u8 check_1;
	__u8 check_2;
	__u8 susp_offset;
} SUSP_SP;

#define SUSP_SP_CHECK_1		0xbe
#define SUSP_SP_CHECK_2		0xef

typedef struct {
	SUSP_HEAD
	__u8 flags;
	__u8 name[1];
} SUSP_NM;

#define SUSP_NM_OFFSET		5

#define SUSP_NM_CONTINUE	0x01
#define SUSP_NM_CURRENT		0x02
#define SUSP_NM_PARENT		0x04

typedef struct {
	SUSP_HEAD
	__u8 sector_le[4];
	__u8 sector_be[4];
} SUSP_CL;

typedef struct {
	SUSP_HEAD
	__u8 sector_le[4];
	__u8 sector_be[4];
} SUSP_PL;

typedef struct {
	SUSP_HEAD
} SUSP_RE;

typedef struct {
	SUSP_HEAD
	__u8 flags;
	__u8 data[1];
} SUSP_TF;

#define SUSP_TF_OFFSET		5

#define SUSP_TF_CREATE		0x01
#define SUSP_TF_MODIFY		0x02
#define SUSP_TF_ACCESS		0x04
#define SUSP_TF_CHANGE		0x08
#define SUSP_TF_BACKUP		0x10
#define SUSP_TF_EXPIRE		0x20
#define SUSP_TF_EFFECTIVE	0x40
#define SUSP_TF_LONG		0x80

#define SUSP_TF_SHORT_TIME_LENGTH	7
#define SUSP_TF_LONG_TIME_LENGTH	17

#endif
