#ifndef _EXT2_EXT2_H
#define _EXT2_EXT2_H

#include <SPAD/VFS.H>

#include "MSTRUCT.H"
#include "STRUCT.H"

#define PG_LOOKUP	1
#define PG_READDIR	2
#define PG_BMAP		3

typedef struct {
	PAGEINRQ_HEAD;
	int type;
	int depth;
	ext2_blk_t blk;
	ext2_blk_t indir;
} EXT2PAGEINRQ;

typedef struct {
	__d_off block;
	unsigned offs;
} EXT2_READDIR_COOKIE;

int EXT2_FIND_INODE(EXT2FS *sb, ext2_ino_t ino, ext2_blk_t *block, int *offset);
int EXT2_GET_INODE(EXT2FNODE *inode, struct ext2_inode *raw_inode, ext2_ino_t ino);
void EXT2_FREE_FNODE(FNODE *f_);

ext2_blk_t EXT2_ALLOC(EXT2FS *sb, ext2_blk_t goal, unsigned n, int in);
void EXT2_FREE(EXT2FS *fs, ext2_blk_t goal, unsigned n, int in);

ext2_blk_t EXT2_ALLOC_BLOCK(EXT2FNODE *fn, ext2_blk_t goal);
ext2_ino_t EXT2_ALLOC_INODE(EXT2FNODE *fn, ext2_ino_t goal);
void EXT2_FREE_BLOCKS(EXT2FNODE *fn, ext2_blk_t blk, unsigned n);
void EXT2_FREE_INODE(EXT2FNODE *fn, ext2_ino_t blk);
void EXT2_DISCARD_PREALLOC(EXT2FS *fs);
void EXT2_DO_PREALLOC(EXT2FNODE *f);

void *EXT2_READ_BUFFER_SYNC(EXT2FS *fs, ext2_blk_t block, int dirty);
void *EXT2_ALLOC_BUFFER_SYNC(EXT2FS *fs, ext2_blk_t block);
void ext2_write_super (struct super_block * sb);
void ext2_write_group(struct super_block *sb, int grpno);
void ext2_update_dynamic_rev(struct super_block *sb);
void ext2_error(struct super_block *sb, int sync);
int ext2_bg_has_super(struct super_block *sb, int group);
struct ext2_group_desc * ext2_get_group_desc(struct super_block * sb, unsigned int block_group);

int EXT2_PROCESS_OPTION(FS *fs_, char *opt, char *optend, char *str);
int EXT2_MOUNT(FS *fs_);
void EXT2_SET_DIRTY(FS *fs_, int dirty);
void EXT2_COMMIT(FS *fs);
void EXT2_UMOUNT(FS *fs_, int nosync);
int EXT2_VALIDATE_FILENAME(FS *fs, __const__ char *filename);
void EXT2_LOOKUP(PAGEINRQ *p);
void EXT2_INIT_READDIR_COOKIE(struct readdir_buffer *rb, FNODE *f);
void EXT2_READDIR(PAGEINRQ *pgin, struct readdir_buffer *rb);
void EXT2_INIT_FNODE(FNODE *f);
int EXT2_CREATE_FNODE(FNODE *f_);
int EXT2_WRITE_FNODE_DATA(FNODE *f_);
int EXT2_ADD_FNODE_TO_DIRECTORY(FNODE *f_);
int EXT2_DELETE_FNODE(FNODE *f_);
int EXT2_REMOVE_FNODE_FROM_DIRECTORY(FNODE *f_);
void EXT2_BMAP(PAGEINRQ *pgin);
int EXT2_SYNC_BMAP(FNODE *f, __d_off off, int try);
void *EXT2_ACCOUNT(FNODE *f, int dir, PAGE *p);
void EXT2_UNACCOUNT(FNODE *f, int dir, PAGE *p);
ext2_blk_t EXT2_BLOCKS(EXT2FS *fs, __u64 size);
void EXT2_STAT(FNODE *f_, struct stat *stat);
WQ *EXT2_STATFS(FS *fs_, struct statfs *stat);

#define is_bmap_invalid(f)	\
	(__unlikely((f)->disk_blk + (f)->run_length > ((EXT2FS *)(f)->fs)->size) || __unlikely((f)->disk_blk >= ((EXT2FS *)(f)->fs)->size))

ext2_blk_t INODE_2_BLOCK(EXT2FS *fs, ext2_ino_t ino);
void EXT2_INVALID_BMAP_MSG(EXT2FNODE *f);

#endif
