#include "EXT2.H"

#include <SPAD/SYSLOG.H>

static void EXT2_DISCARD_INODE_PREALLOC(EXT2FS *fs);

ext2_blk_t EXT2_ALLOC_BLOCK(EXT2FNODE *fn, ext2_blk_t goal)
{
	ext2_blk_t blks;
	ext2_blk_t ret;
	EXT2FS *fs = (EXT2FS *)fn->fs;
	if (__likely(!(fn->flags & FNODE_DIRECTORY))) {
		if (__likely(fs->prealloc_blk_len != 0)) {
			take_prealloc:
			fs->prealloc_blk_len--;
			return fs->prealloc_blk++;
		}
		ret = EXT2_ALLOC(fs, goal, 0, 0);
		if (__likely(ret != 0)) return ret;
		/*__debug_printf("new prea @ %x\n", goal);*/
		blks = EXT2_BLOCKS(fs, fn->disk_size);
		if (__likely(blks > fn->i_blocks >> fs->sectors_per_block_bits)) {
			fs->new_prealloc_blk_len = blks - (fn->i_blocks >> fs->sectors_per_block_bits);
			fs->new_prealloc_ino_len = 0;
			EXT2_DO_PREALLOC(fn);
			if (__likely(fs->prealloc_blk_len != 0)) {
		/*__debug_printf("allocated: %x\n", fs->prealloc_blk);*/
				goto take_prealloc;
			}
		}
	}
	ret = EXT2_ALLOC(fs, goal, 1, 0);
	if (__unlikely(!ret)) {
		if (__likely(fs->prealloc_blk_len != 0)) goto take_prealloc;
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "COULD NOT ALLOC BLOCK");
		ext2_error(fs, 1);
		return 0;
	}
	return ret;
}

ext2_ino_t EXT2_ALLOC_INODE(EXT2FNODE *fn, ext2_ino_t goal)
{
	ext2_ino_t ret;
	EXT2FS *fs = (EXT2FS *)fn->fs;
	if (__likely((fn->flags & (FNODE_DIRECTORY | FNODE_UNCOMMITTED_PREALLOC_HINT)) == FNODE_UNCOMMITTED_PREALLOC_HINT)) {
		if (__likely(fs->prealloc_ino_len != 0)) {
			fs->prealloc_ino_len--;
			return fs->prealloc_ino++;
		}
	}
	ret = EXT2_ALLOC(fs, goal, 1, fn->flags & FNODE_DIRECTORY ? 2 : 1);
	if (__unlikely(!ret)) {
		EXT2_DISCARD_INODE_PREALLOC(fs);
		ret = EXT2_ALLOC(fs, goal, 1, fn->flags & FNODE_DIRECTORY ? 2 : 1);
		if (__unlikely(!ret)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "COULD NOT ALLOC INODE");
			ext2_error(fs, 1);
			return 0;
		}
	}
	return ret;
}

void EXT2_FREE_BLOCKS(EXT2FNODE *fn, ext2_blk_t blk, unsigned n)
{
	EXT2_FREE((EXT2FS *)fn->fs, blk, n, 0);
}

void EXT2_FREE_INODE(EXT2FNODE *fn, ext2_ino_t blk)
{
	EXT2_FREE((EXT2FS *)fn->fs, blk, 1, __unlikely(fn->flags & FNODE_DIRECTORY) ? 2 : 1);
}

void EXT2_DISCARD_PREALLOC(EXT2FS *fs)
{
	/*if (fs->prealloc_blk_len | fs->prealloc_ino_len) __debug_printf("discard: %d blocks, %d inodes\n", fs->prealloc_blk_len, fs->prealloc_ino_len);*/
	if (__unlikely(fs->prealloc_blk_len)) {
		EXT2_FREE(fs, fs->prealloc_blk, fs->prealloc_blk_len, 0);
		fs->prealloc_blk_len = 0;
	}
	EXT2_DISCARD_INODE_PREALLOC(fs);
}

static void EXT2_DISCARD_INODE_PREALLOC(EXT2FS *fs)
{
	if (__unlikely(fs->prealloc_ino_len)) {
		EXT2_FREE(fs, fs->prealloc_ino, fs->prealloc_ino_len, 1);
		fs->prealloc_ino_len = 0;
	}
}

void EXT2_DO_PREALLOC(EXT2FNODE *f)
{
	EXT2FS *fs = (EXT2FS *)f->fs;
	ext2_blk_t blkhint;
	ext2_ino_t inohint;
	blkhint = INODE_2_BLOCK(fs, inohint = ((EXT2FNODE *)f->parent)->i_ino);
	fs->flags |= FS_COMMIT_FREES_DATA;
	while (fs->new_prealloc_blk_len) {
		if (__unlikely(fs->prealloc_blk_len))
			KERNEL$SUICIDE("EXT2_DO_PREALLOC: %s: PREALLOC ALREADY EXISTING: %u BLOCKS", fs->filesystem_name, fs->prealloc_blk_len);
		if (__likely(fs->new_prealloc_blk_len <= EXT2_BLOCKS_PER_GROUP(fs) * 3 / 4) && __likely((fs->prealloc_blk = EXT2_ALLOC(fs, blkhint, fs->new_prealloc_blk_len, 0)) != 0)) {
			fs->prealloc_blk_len = fs->new_prealloc_blk_len;
			inohint = (fs->prealloc_blk - le32_to_cpu(fs->sblk.s_first_data_block)) / EXT2_BLOCKS_PER_GROUP(fs) * EXT2_INODES_PER_GROUP(fs) + 1;
			break;
		}
		fs->new_prealloc_blk_len >>= 1;
	}
	while (fs->new_prealloc_ino_len) {
		if (__unlikely(fs->prealloc_ino_len))
			KERNEL$SUICIDE("EXT2_DO_PREALLOC: %s: PREALLOC ALREADY EXISTING: %u INODES", fs->filesystem_name, fs->prealloc_ino_len);
		if (__likely(fs->new_prealloc_ino_len <= EXT2_INODES_PER_GROUP(fs)) && __likely((fs->prealloc_ino = EXT2_ALLOC(fs, inohint, fs->new_prealloc_ino_len, 1)) != 0)) {
			fs->prealloc_ino_len = fs->new_prealloc_ino_len;
			break;
		}
		fs->new_prealloc_ino_len >>= 1;
	}
}

