#ifndef _FAT_FAT_H
#define _FAT_FAT_H

#include <SPAD/VFS.H>

#include "STRUCT.H"

#define FAT_VFAT	0x00000001

#define MAX_FAT_ERRORS		32
#define FAT_ERROR_TIMEOUT	JIFFIES_PER_SECOND

typedef struct {
	FS_HEAD;
	int sectors_per_sector;
	int sector_size;
	int sectors_per_cluster;	/* 512 bytes per cluster */
	int sectors_per_cluster_bits;	/* -------- "" --------- */
	int fat_start;
	int fat_length;
	int fat_bits;
	int fats;
	int dir_start;
	int dir_sectors;
	int data_start;
	unsigned long total_sectors;
	unsigned long clusters;

	int fsinfo_sector;
	unsigned long free_clusters;
	unsigned long overallocated;
	unsigned long max_free_run;

	int n_fat_errors;
	u_jiffies_lo_t error_timeout;
	unsigned long fat_errors[MAX_FAT_ERRORS];
} FATFS;

typedef struct {
	FNODE_HEAD;
	unsigned long dirent_sec;
	unsigned dirent_pos;
	unsigned n_slots;
	unsigned long start_cluster;
} FATFNODE;

typedef struct {
	PAGEINRQ_HEAD;
	int cookie;
	unsigned long dirptr;
	unsigned dir_off;
	unsigned long c[2];
	char longname[256];
	int longnamelen;
	int n_slots;
	int shortnamesum;
	int longnameslots;
	unsigned current_fat;
} FATPAGEINRQ;

int FAT_STOP_CYCLES(unsigned long key, unsigned long (*c)[2]);

void *FAT_READ_BUFFER_SYNC(FATFS *fs, unsigned long sec, int dirty);

unsigned long FAT_READ(FATFS *fs, unsigned long cluster);
void FAT_WRITE(FATFS *fs, unsigned long cluster, unsigned long value);
void FAT_WRITE_FSINFO(FATFS *fs);

unsigned long FAT_ALLOC(FATFS *fs, unsigned long hint, unsigned long *n_clusters, int first);
void FAT_FREE(FATFS *fs, unsigned long cluster);

void fat_date_unix2dos(int unix_date,unsigned short *time, unsigned short *date);
int FAT_CREATE_SLOTS_FROM_NAME(FATFNODE *dir, __const__ char *name, struct fat_dir_entry slots[32]);

int FAT_GROW(FATFNODE *f, unsigned long n_clusters);	/* number of clusters to add */
int FAT_SHRINK(FATFNODE *f, unsigned long n_clusters);	/* number of clusters to leave */

int FAT_PROCESS_OPTION(FS *fs_, char *opt, char *optend, char *str);
int FAT_MOUNT(FS *fs_);
void FAT_UMOUNT(FS *fs_, int nosync);
void FAT_SET_DIRTY(FS *fs_, int dirty);
int FAT_VALIDATE_FILENAME(FS *fs, __const__ char *filename);
void FAT_LOOKUP(PAGEINRQ *p);
void FAT_INIT_READDIR_COOKIE(struct readdir_buffer *rb, FNODE *f);
void FAT_READDIR(PAGEINRQ *pgin, struct readdir_buffer *rb);
void FAT_INIT_FNODE(FNODE *f);
int FAT_CREATE_FNODE(FNODE *f_);
int FAT_WRITE_FNODE_DATA(FNODE *f_);
int FAT_ADD_FNODE_TO_DIRECTORY(FNODE *f_);
int FAT_DELETE_FNODE(FNODE *f_);
int FAT_REMOVE_FNODE_FROM_DIRECTORY(FNODE *f_);
void FAT_BMAP(PAGEINRQ *pgin);
int FAT_SYNC_BMAP(FNODE *f, __d_off off, int try);
void *FAT_ACCOUNT(FNODE *f, int dir, PAGE *p);
void FAT_UNACCOUNT(FNODE *f, int dir, PAGE *p);
void FAT_STAT(FNODE *f_, struct stat *stat);
WQ *FAT_STATFS(FS *fs_, struct statfs *stat);

static __finline__ unsigned long FAT_SIZE_2_CLUSTERS(FATFS *fs, unsigned long size)
{
	size += (fs->sectors_per_cluster << BIO_SECTOR_SIZE_BITS) - 1;;
	size >>= fs->sectors_per_cluster_bits + BIO_SECTOR_SIZE_BITS;
	return size;
}

static __finline__ unsigned long FAT_CLUSTER_2_SECTOR(FATFS *fs, unsigned long start_cluster)
{
	if (__unlikely(start_cluster < 2)) return fs->dir_start;
	return fs->data_start + ((start_cluster - 2) << fs->sectors_per_cluster_bits);
}

static __finline__ unsigned long FAT_SECTOR_2_CLUSTER(FATFS *fs, unsigned long sector)
{
	if (sector < fs->data_start) return 0;
	return ((sector - fs->data_start) >> fs->sectors_per_cluster_bits) + 2;
}

int _FAT_GET_NEXT_SECTOR(FATFS *fs, unsigned long *sector, unsigned long *to_read, int nfat);

static __finline__ int FAT_GET_NEXT_SECTOR(FATFS *fs, unsigned long *sector, unsigned long *to_read, int nfat)
{
	if (__unlikely(*sector < fs->data_start)) {
		(*sector)++;
		if (__unlikely(*sector == fs->dir_start + fs->dir_sectors)) *sector = 0;
		return 0;
	}
	if (__likely(((int)(*sector + 1 - fs->data_start) & (fs->sectors_per_cluster - 1)))) {
		(*sector)++;
		return 0;
	}
	return _FAT_GET_NEXT_SECTOR(fs, sector, to_read, nfat);
}

unsigned long FAT_GET_NEXT_SECTOR_SYNC(FATFS *fs, unsigned long sector);

static __finline__ int FAT_READAHEAD(FATFS *fs)
{
	return 0;
	/*return fs->fat_bits > 16; this caused performance drop :-( */
}

#define is_bmap_invalid(f)		\
	(__unlikely((f)->disk_blk + (f)->run_length > ((FATFS *)(f)->fs)->size) || __unlikely((f)->disk_blk + (f)->run_length <= (f)->disk_blk))

void FAT_INVALID_BMAP_MSG(FATFNODE *f);

#endif
