#include <SPAD/SYSLOG.H>

#include "FAT.H"
#include "STRUCT.H"

/* if exact is set, it searches from (hint + 1) */

unsigned long FAT_ALLOC(FATFS *fs, unsigned long hint, unsigned long *n_clusters, int exact)
{
	unsigned long run_start, x;
	unsigned long best_run, best_len;
	if (hint < 2 || hint >= fs->clusters) hint = 2;
	if (__unlikely(!exact) && __likely(!FAT_READ(fs, hint))) {
		unsigned long i;
		do_alloc:
		for (i = 1; i < *n_clusters; i++)
			if (hint + i < fs->clusters && !FAT_READ(fs, hint + i)) {
				FAT_WRITE(fs, hint + i - 1, hint + i);
			} else break;
		FAT_WRITE(fs, hint + i - 1, CLUSTER_EOF);
		fs->free_clusters -= i;
		*n_clusters = i;
		FAT_WRITE_FSINFO(fs);
		return hint;
	}
	x = hint + 1;
	best_run = 0;
	best_len = 0;
	c1:
	if (x >= fs->clusters) x = 2;
	if (x == hint) {
		h:
		if (__unlikely(!best_len)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CAN'T ALLOCATE %lX CLUSTERS NEAR %08lX", *n_clusters, hint);
			return 0;
		}
		hint = best_run;
		fs->max_free_run = best_len / 2 + 1;
		goto do_alloc;
	}
	if (__likely(FAT_READ(fs, x) != 0)) {
		x++;
		goto c1;
	}
	run_start = x;
	c2:
	x++;
	if (__unlikely(x == hint)) goto h;
	if (x - run_start >= *n_clusters || x - run_start >= fs->max_free_run) {
		hint = run_start;
		goto do_alloc;
	}
	if (x < fs->clusters && !FAT_READ(fs, x)) goto c2;
	if (x - run_start > best_len) best_run = run_start, best_len = x - run_start;
	goto c1;
}

void FAT_FREE(FATFS *fs, unsigned long cluster)
{
	unsigned long v;
	if (__unlikely(cluster < 2)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREEING CLUSTER %08lX", cluster);
		return;
	}
	if (fs->max_free_run < fs->clusters) fs->max_free_run <<= 1;
	again:
	v = FAT_READ(fs, cluster);
	if (IS_EOF(v)) {
		VFS$CLEAN_BUFFERS_SYNC((FS *)fs, FAT_CLUSTER_2_SECTOR(fs, cluster), fs->sectors_per_cluster);
		FAT_WRITE(fs, cluster, 0);
		fs->free_clusters++;
		FAT_WRITE_FSINFO(fs);
		return;
	}
	if (v < 2 || v >= CLUSTER_BAD) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "BAD CLUSTER %08lX IN CHAIN AT %08lX", v, cluster);
		FAT_WRITE_FSINFO(fs);
		return;
	}
	VFS$CLEAN_BUFFERS_SYNC((FS *)fs, FAT_CLUSTER_2_SECTOR(fs, cluster), fs->sectors_per_cluster);
	FAT_WRITE(fs, cluster, 0);
	fs->free_clusters++;
	cluster = v;
	goto again;
}

