#ifndef _FAT_STRUCT_H
#define _FAT_STRUCT_H

/* from linux/include/linux/msdos_fs.h, (C) someone who wrote it */

#define ATTR_RO      1  /* read-only */
#define ATTR_HIDDEN  2  /* hidden */
#define ATTR_SYS     4  /* system */
#define ATTR_VOLUME  8  /* volume label */
#define ATTR_DIR     16 /* directory */
#define ATTR_ARCH    32 /* archived */
#define ATTR_EXT     (ATTR_RO | ATTR_HIDDEN | ATTR_SYS | ATTR_VOLUME)
	/* bits that are used by the Windows 95/Windows NT extended FAT */

#define DELETED_FLAG 0xe5 /* marks file as deleted when in name[0] */
#define DELETED_REPLACE	0x05
#define DIRSLOT_SLOTS	0x1f
#define DIRSLOT_START	0x40
#define DIRSLOT_INVALID	0x80

#define FAT_BOOT_SIGNATURE	0xaa55

#define FAT_12_MAX_CLUSTER	0x00000ff7
#define FAT_16_MAX_CLUSTER	0x0000fff7
#define FAT_32_MAX_CLUSTER	0x0ffffff7

#define CLUSTER_BAD		0xfffffff7
#define CLUSTER_EOF		0xffffffff
#define IS_EOF(x)		((x) >= 0xfffffff8)

#define FAT_VALID_MEDIA(x)	((0xF8 <= (x) /*&& (x) <= 0xFF*/) || (x) == 0xF0)
#define FAT_FIRST_12		0x00000F00
#define FAT_FIRST_16		0x0000FF00
#define FAT_FIRST_32		0x0FFFFF00
#define FAT_FIRST		0xFFFFFF00


struct fat_boot_sector {
	__s8	ignored[3];	/* Boot strap short or near jump */
	__s8	system_id[8];	/* Name - can be used to special case
				   partition manager volumes */
	__u8	sector_size[2];	/* bytes per logical sector */
	__u8	cluster_size;	/* sectors/cluster */
	__u16	reserved;	/* reserved sectors */
	__u8	fats;		/* number of FATs */
	__u8	dir_entries[2];	/* root directory entries */
	__u8	sectors[2];	/* number of sectors */
	__u8	media;		/* media code */
	__u16	fat_length;	/* sectors/FAT */
	__u16	secs_track;	/* sectors per track */
	__u16	heads;		/* number of heads */
	__u32	hidden;		/* hidden sectors (unused) */
	__u32	total_sect;	/* number of sectors (if sectors == 0) */

	/* The following fields are only used by FAT32 */
	__u32	fat32_length;	/* sectors/FAT */
	__u16	flags;		/* bit 8: fat mirroring, low 4: active fat */
	__u8	version[2];	/* major, minor filesystem version */
	__u32	root_cluster;	/* first cluster in root directory */
	__u16	info_sector;	/* filesystem info sector */
	__u16	backup_boot;	/* backup boot sector */
	__u16	reserved2[6];	/* Unused */
};

#define FAT_FSINFO_SIG1		0x41615252
#define FAT_FSINFO_SIG2		0x61417272

struct fat_boot_fsinfo {
	__u32	signature1;	/* 0x41615252L */
	__u32	reserved1[120]; /* Nothing as far as I can tell */
	__u32	signature2;	/* 0x61417272L */
	__u32	free_clusters;	/* Free cluster count.	-1 if unknown */
	__u32	next_cluster;	/* Most recently allocated cluster.
				 * Unused under Linux. */
	__u32	reserved2[4];
};

#define FAT_DIRENT_SIZE		32

struct fat_dir_entry {
	__u8	name[8],ext[3];	/* name and extension */
	__u8	attr;		/* attribute bits */
	__u8    lcase;		/* Case for base and extension */
	__u8	ctime_ms;	/* Creation time, milliseconds */
	__u16	ctime;		/* Creation time */
	__u16	cdate;		/* Creation date */
	__u16	adate;		/* Last access date */
	__u16   starthi;	/* High 16 bits of cluster in FAT32 */
	__u16	time,date,start;/* time, date and first cluster */
	__u32	size;		/* file size (in bytes) */
};

/* Up to 13 characters of the name */
struct fat_dir_slot {
	__u8    id;		/* sequence number for slot */
	__u8    name0_4[10];	/* first 5 characters in name */
	__u8    attr;		/* attribute byte */
	__u8    reserved;	/* always 0 */
	__u8    alias_checksum;	/* checksum for 8.3 alias */
	__u8    name5_10[12];	/* 6 more characters in name */
	__u16   start;		/* starting cluster number, 0 in long slots */
	__u8    name11_12[4];	/* last 2 characters in name */
};

#endif
