#include "HPFS.H"

__u8 *HPFS_MAP_BITMAP(HPFSFS *fs, int bmp, BUFFER **b, int *pos)
{
	__u8 *desc;
	unsigned sec;
	if (__unlikely(bmp >= (int)fs->n_bitmaps) || __unlikely(bmp < -1)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "AN ATTEMPT TO MAP INVALID BITMAP %d, MAX BITMAPS %d", bmp, fs->n_bitmaps);
		HPFS_ERROR(fs);
		return NULL;
	}
	if (__unlikely(bmp < 0)) sec = fs->dir_band_bitmap;
	else sec = fs->bmp_desc[bmp].sector;
	if (__unlikely(!sec)) return NULL;
	if (__unlikely(__IS_ERR(desc = VFS$READ_BUFFER_SYNC((FS *)fs, sec, 4, (sec & 0x3fff) == 0x3ffc, b)))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "ERROR READING BITMAP %u AT %08X: %s", bmp, fs->bmp_desc[bmp].sector, strerror(-__PTR_ERR(desc)));
		return NULL;
	}
	*pos = sec & __SECTORS_PER_PAGE_CLUSTER_MINUS_1;
	return desc;
}

static int SCAN_BITMAP(__u8 *bmp, unsigned start, unsigned n)
{
	unsigned run = 0;
	again:
	if (start & 31) {
		bits:
		if ((bmp[start >> 3] >> (start & 7)) & 1) run++;
		else run = 0;
		start++;
	} else {
		__u32 b = *(__u32 *)&bmp[start >> 3];
		if (__likely(!b)) {
			start += 32;
			run = 0;
		} else if (__likely(b == 0xffffffffU)) {
			start += 32;
			run += 32;
		} else goto bits;
	}
	if (run >= n) return start - run;
	if (__unlikely(start == 0x4000)) return -1;
	goto again;
}

int FIND_MAX_RUN(__u8 *bmp)
{
	unsigned start = 0;
	unsigned run = 0;
	unsigned max_run = 0;
	again:
	if (start & 31) {
		bits:
		if ((bmp[start >> 3] >> (start & 7)) & 1) run++;
		else {
			if (__unlikely(run > max_run)) max_run = run;
			run = 0;
		
		}
		start++;
	} else {
		__u32 b = *(__u32 *)&bmp[start >> 3];
		if (__likely(!b)) {
			start += 32;
			if (__unlikely(run > max_run)) max_run = run;
			run = 0;
		} else if (__likely(b == 0xffffffffU)) {
			start += 32;
			run += 32;
		} else goto bits;
	}
	if (__likely(start < 0x4000)) goto again;
	if (__unlikely(run > max_run)) max_run = run;
	return max_run;
}

static int TEST_BITMAP(__u8 *bmp, unsigned start, unsigned n)
{
	unsigned run = 0;
	again:
	if (start & 31) {
		bits:
		if ((bmp[start >> 3] >> (start & 7)) & 1) run++;
		else return run;
		start++;
	} else {
		__u32 b = ((__u32 *)bmp)[start >> 5];
		if (__likely(!b)) return run;
		else if (__likely(b == 0xffffffffU)) {
			start += 32;
			run += 32;
		} else goto bits;
	}
	if (__unlikely(start == 0x4000)) return run;
	goto again;
}

static int SCAN_BITMAP_FOR_4(__u8 *bmp, unsigned start)
{
	start &= ~3;
	again:
	if (!(start & 4)) {
		if ((bmp[start >> 3] & 0x0f) == 0x0f) return start;
	} else {
		if ((bmp[start >> 3] & 0xf0) == 0xf0) return start;
	}
	start += 4;
	if (__unlikely(start == 0x4000)) return -1;
	goto again;
}

unsigned HPFS_ALLOC(HPFSFS *fs, unsigned goal, unsigned *n)
{
	__u8 *bmp;
	int g, a, i, bmpi;
	BUFFER *b;
	int pos;
	if (__unlikely(!n) && __unlikely(fs->dir_band_free)) {
		if (__unlikely(!(bmp = HPFS_MAP_BITMAP(fs, -1, &b, &pos))))
			goto skip_dir;
		if (__unlikely(goal >= fs->dir_band_start) && __unlikely(goal < fs->dir_band_start + fs->n_dir_band)) {
			g = goal - fs->dir_band_start;
			g >>= 2;
			if (__unlikely((unsigned)g >= 0x4000)) g = 0;
		} else g = 0;
		scan_dir_again:
		a = SCAN_BITMAP(bmp, g, 1);
		if (__likely(a != -1)) {
			if (__unlikely(!((bmp[a >> 3] >> (a & 7)) & 1)))
				KERNEL$SUICIDE("HPFS_ALLOC: %s: DIRBAND BIT NOT FREE, POS %d", fs->filesystem_name, a);
			bmp[a >> 3] &= ~(1 << (a & 7));
			fs->free_dnodes--;
			VFS$MARK_BUFFER_DIRTY(b, pos, 4);
			VFS$PUT_BUFFER(bmp);
			fs->dir_band_free--;
			return fs->dir_band_start + (a << 2);
		}
		if (__unlikely(g)) {
			g = 0;
			goto scan_dir_again;
		}
		VFS$PUT_BUFFER(bmp);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "DIR BAND FREE %u AND NO FREE BLOCKS THERE", fs->dir_band_free);
		fs->dir_band_free = 0;
	}
	if (n && __unlikely(*n > 0x3ffc)) *n = 0x3ffc;
	skip_dir:
	alloc_less:
	bmpi = goal >> 14;
	g = goal & 0x3fff;
	i = fs->n_bitmaps + 1;
	next_bitmap:
	if (__unlikely(bmpi >= fs->n_bitmaps)) bmpi = 0;
	if (__unlikely((__likely(n != NULL) ? *n : 4) > fs->bmp_desc[bmpi].max_alloc)) goto skip_bmp;
	if (__unlikely(!(bmp = HPFS_MAP_BITMAP(fs, bmpi, &b, &pos)))) {
		fs->bmp_desc[bmpi].max_alloc = 0;
		goto skip_bmp;
	}
	if (__unlikely(!n)) {
		a = SCAN_BITMAP_FOR_4(bmp, g);
		if (__likely(a != -1)) {
			static unsigned four = 4;
			n = &four;
			goto allocated;
		}
		if (__unlikely(!g)) fs->bmp_desc[bmpi].max_alloc = FIND_MAX_RUN(bmp);
		goto skip_bmp_d;
	}
	if (__unlikely(i == fs->n_bitmaps + 1)) {
		int nn = TEST_BITMAP(bmp, g, *n);
		if (__likely(nn)) {
			if (__unlikely(nn > *n)) nn = *n;
			else *n = nn;
			a = g;
			goto allocated;
		}
	}
	a = SCAN_BITMAP(bmp, g, *n);
	if (__likely(a != -1)) {
		unsigned x;
		allocated:
		x = *n;
		while (x) {
			if (__unlikely(a & 7) || __unlikely(x < 8)) {
				if ((a & 7) < 4) {
					if ((bmp[a >> 3] & 0x0f) == 0x0f) fs->free_dnodes--;
				} else {
					if ((bmp[a >> 3] & 0xf0) == 0xf0) fs->free_dnodes--;
				}
				if (__unlikely(!((bmp[a >> 3] >> (a & 7)) & 1)))
					KERNEL$SUICIDE("HPFS_ALLOC: %s: BIT NOT FREE, BITMAP %d, POS %d, START %d, LEN %d", fs->filesystem_name, bmpi, a, a + x - *n, *n);
				bmp[a >> 3] &= ~(1 << (a & 7));
				a++;
				x--;
			} else {
				if (__unlikely(bmp[a >> 3] != 0xff))
					KERNEL$SUICIDE("HPFS_ALLOC: %s: BYTE NOT FREE, BITMAP %d, POS %d, START %d, LEN %d", fs->filesystem_name, bmpi, a, a + x - *n, *n);
				fs->free_dnodes -= 2;
				bmp[a >> 3] = 0;
				a += 8;
				x -= 8;
			}
		}
		fs->free_space -= *n;
		VFS$MARK_BUFFER_DIRTY(b, pos, 4);
		VFS$PUT_BUFFER(bmp);
		return (bmpi << 14) + a - *n;
	}
	if (__unlikely(!g)) fs->bmp_desc[bmpi].max_alloc = FIND_MAX_RUN(bmp);
	skip_bmp_d:
	VFS$PUT_BUFFER(bmp);
	skip_bmp:
	g = 0;
	bmpi++;
	if (__likely(--i)) goto next_bitmap;
	if (__unlikely(!n)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "COULD NOT ALLOCATE DNODE BLOCK WITH GOAL %08X", goal);
		HPFS_ERROR(fs);
		return 0;
	}
	if (__unlikely(!(*n >>= 1))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "COULD NOT ALLOCATE BLOCK WITH GOAL %08X", goal);
		HPFS_ERROR(fs);
		return 0;
	}
		/* 4-sector blocks are needed for directories,
		   do not allocate them with precedence */
	if (__unlikely(*n < 8)) *n = 1;
	goto alloc_less;
}

void HPFS_FREE(HPFSFS *fs, unsigned sec, unsigned n)
{
	__u8 *bmp;
	int bmpi;
	BUFFER *b;
	int pos;
	int msg;
	if (__unlikely(n == 1) || __unlikely(n == 4))
		VFS$CLEAN_BUFFERS_SYNC((FS *)fs, sec, n);
	if (__unlikely(sec >= (unsigned)fs->size) || __unlikely(sec + n >= (unsigned)fs->size) || __unlikely(sec + n < sec)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREE DATA OUT OF FILESYSTEM (START %08X, LEN %08X, FS SIZE %08X)", sec, n, (unsigned)fs->size);
		HPFS_ERROR(fs);
		return;
	}
	if (__likely(sec >= fs->dir_band_start) && __likely(sec < fs->dir_band_start + fs->n_dir_band)) {
		unsigned bl;
		if (__unlikely(n != 4) || __unlikely(sec & 3)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREE INVALID DATA IN DIRBAND (START %08X, LEN %08X)", sec, n);
			HPFS_ERROR(fs);
			return;
		}
		if (__unlikely(sec & 3) || __unlikely((bl = (sec - fs->dir_band_start) >> 2) >= 0x4000)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREEING INVALID BLOCK IN DIRECTORY BAND: %08X", sec);
			HPFS_ERROR(fs);
			return;
		}
		bmp = HPFS_MAP_BITMAP(fs, -1, &b, &pos);
		if (__unlikely(!bmp)) return;
		VFS$MARK_BUFFER_DIRTY(b, pos, 4);
		if (__unlikely((bmp[bl >> 3] >> (bl & 7)) & 1)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREEING ALREADY FREE BLOCK IN DIRBAND AT POSITION %08X", bl);
			HPFS_ERROR(fs);
			goto skip_dir_free;
		}
		bmp[bl >> 3] |= 1 << (bl & 7);
		fs->free_dnodes++;
		fs->dir_band_free++;
		skip_dir_free:
		VFS$PUT_BUFFER(bmp);
		return;
	}
	while (__unlikely((sec & 0x3fff) + n > 0x4000)) {
		unsigned x;
		HPFS_FREE(fs, sec, x = 0x4000 - (sec & 0x3fff));
		sec += x;
		n -= x;
	}
	if (__unlikely(!n)) return;
	bmpi = sec >> 14;
	if (__unlikely(bmpi >= fs->n_bitmaps))
		KERNEL$SUICIDE("HPFS_FREE: %s: BAD BITMAP TO FREE (START %08X, LEN %08X, FS SIZE %08X, N_BITMAPS %d)", fs->filesystem_name, sec, n, (unsigned)fs->size, fs->n_bitmaps);
	if ((fs->bmp_desc[bmpi].max_alloc = fs->bmp_desc[bmpi].max_alloc * 2 + n) > 0x4000) fs->bmp_desc[bmpi].max_alloc = 0x4000;
	bmp = HPFS_MAP_BITMAP(fs, bmpi, &b, &pos);
	if (__unlikely(!bmp)) return;
	VFS$MARK_BUFFER_DIRTY(b, pos, 4);
	msg = 0;
	sec &= 0x3fff;
	free_next:
	if (__unlikely(sec & 7) || __unlikely(n < 8)) {
		no_d:
		if (__unlikely((bmp[sec >> 3] >> (sec & 7)) & 1)) {
			if (!msg) KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREEING ALREADY FREE BLOCK AT %08X (LEN %08X)", (bmpi << 14) + sec, n), msg = 1, HPFS_ERROR(fs);
			else if (msg == 1) KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREEING MORE FREE BLOCKS"), msg = 2;
			goto skip_free;
		}
		bmp[sec >> 3] |= 1 << (sec & 7);
		if ((sec & 7) < 4) {
			if ((bmp[sec >> 3] & 0x0f) == 0x0f) fs->free_dnodes++;
		} else {
			if ((bmp[sec >> 3] & 0xf0) == 0xf0) fs->free_dnodes++;
		}
		fs->free_space++;
		skip_free:
		sec++;
		n--;
	} else {
		if (__unlikely(bmp[sec >> 3])) goto no_d;
		fs->free_dnodes += 2;
		bmp[sec >> 3] = 0xff;
		fs->free_space += 8;
		sec += 8;
		n -= 8;
	}
	if (__likely(n)) goto free_next;
	VFS$PUT_BUFFER(bmp);
}
