#include "HPFS.H"

static __finline__ void HPFS_GET_FNODE(HPFSFNODE *f, struct hpfs_dirent *de)
{
	f->mtime = TIME_LOCAL_TO_GMT((HPFSFS *)f->fs, __32LE2CPU(de->write_date));
	f->ctime = TIME_LOCAL_TO_GMT((HPFSFS *)f->fs, __32LE2CPU(de->creation_date));
	f->flags1 = de->flags1;
	f->flags2 = de->flags2;
	f->fnode = __32LE2CPU(de->fnode);
	f->ea_size = __32LE2CPU(de->ea_size);
	FNODE_OUT_OF_WANTFREE((FNODE *)f);
	if (__likely(!(de->flags2 & DE_2_DIRECTORY))) {
		f->flags = FNODE_FILE;
		f->run_length = 0;
		f->size = f->disk_size = __32LE2CPU(de->file_size);
	} else {
		if (!(f->flags & FNODE_DIRECTORY)) {
			VFS_INIT_DIR((FNODE *)f);
		}
		f->flags = FNODE_DIRECTORY;
		f->size = f->disk_size = 0;
	}
}

int HPFS_VALIDATE_FILENAME(FS *fs_, __const__ char *filename)
{
	HPFSFS *fs = (HPFSFS *)fs_;
	__const__ char *f;
	unsigned char c;
	if (__unlikely(!*filename)) return -EINVAL;
	for (f = filename; (c = *f); f++) {
		if (__unlikely(c < ' ') || __unlikely(c == '"') || __unlikely(c == '*') || __unlikely(c == '/') || __unlikely(c == ':') || __unlikely(c == '<') || __unlikely(c == '>') || __unlikely(c == '?') || __unlikely(c == '\\') || __unlikely(c == '|')) return -EINVAL;
		if (__unlikely(c >= 128) && __unlikely(fs->upcase[c - 128] != c)) return -EINVAL;
	}
	if (__unlikely(f[-1] == '.') || __unlikely(f[-1] == ' ')) return -EINVAL;
	if (__unlikely(f - filename >= 256)) return -ENAMETOOLONG;
	return 0;
}

void HPFS_INIT_FNODE(FNODE *f)
{
}

extern AST_STUB HPFS_LOOKUP_AST;

void HPFS_LOOKUP(PAGEINRQ *p_)
{
	HPFSPAGEINRQ *p = (HPFSPAGEINRQ *)p_;
	p->fn = HPFS_LOOKUP_AST;
	p->state = 0;
	p->c[1] = 0;
	CALL_AST(p);
}

DECL_AST(HPFS_LOOKUP_AST, SPL_FS, HPFSPAGEINRQ)
{
	long error;
	struct dnode *dnode;
	struct hpfs_dirent *de;
	HPFSFNODE *f;
	IORQ *caller;
	IO_DISABLE_CHAIN_CANCEL(SPL_FS, RQ->caller);
	SWITCH_PROC_ACCOUNT(RQ->tag.proc, SPL_X(SPL_FS));;
	if (__unlikely(RQ->status < 0)) {
		error = RQ->status;
		goto err;
	}
	if (0) {
		subdir:
		if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
			lockup_wait:
			WQ_WAIT_PAGEINRQ(&KERNEL$LOCKUP_EVENTS, (PAGEINRQ *)RQ);
			RETURN;
		}
	}
	f = (HPFSFNODE *)RQ->fnode;
	if (__unlikely(!RQ->state)) {
		struct fnode *fnode;
		unsigned ptr;
		if (__unlikely(!(fnode = VFS$GET_BUFFER(RQ->fs, f->fnode, 1, (void *)&KERNEL$LIST_END, RQ->tag.proc)))) {
			VFS$READ_BUFFER(f->fnode, (PAGEINRQ *)RQ, 0);
			RETURN;
		}
		if (__unlikely(HPFS_CHECK_FNODE((HPFSFS *)RQ->fs, fnode, f->fnode))) {
			VFS$PUT_BUFFER(fnode);
			error = -EFSERROR;
			goto err;
		}
		ptr = __32LE2CPU(fnode->u.external[0].disk_secno);
		VFS$PUT_BUFFER(fnode);
		if (__unlikely(!ptr) || __unlikely(ptr & 3)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "INVALID POINTER TO ROOT DNODE %08X AT FNODE %08X", ptr, f->fnode);
			HPFS_ERROR((HPFSFS *)RQ->fs);
			error = -EFSERROR;
			goto err;
		}
		RQ->dirptr = ptr;
		RQ->state = 1;
	}
	if (0) {
		go_down:
		if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
			goto lockup_wait;
		}
	}
	if (__unlikely(!(dnode = VFS$GET_BUFFER(RQ->fs, RQ->dirptr, 4, (void *)&KERNEL$LIST_END, RQ->tag.proc)))) {
		VFS$READ_BUFFER(RQ->dirptr, (PAGEINRQ *)RQ, dnode_readahead((HPFSFS *)RQ->fs, RQ->dirptr));
		RETURN;
	}
	if (__unlikely(HPFS_CHECK_DNODE((HPFSFS *)RQ->fs, dnode, RQ->dirptr, 0))) {
		error = -EFSERROR;
		goto err_put;
	}
	if (__unlikely(HPFS_STOP_CYCLES(RQ->dirptr, &RQ->c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (LOOKUP)", RQ->dirptr, f->fnode);
		HPFS_ERROR((HPFSFS *)RQ->fs);
		error = -EFSERROR;
		goto err_put;
	}
	de = (struct hpfs_dirent *)dnode->dirent;
	while (!(de->flags1 & DE_1_LAST)) {
		int r;
		if (__unlikely(de->flags1 & DE_1_FIRST)) goto n;
		r = HPFS_COMPARE((HPFSFS *)RQ->fs, RQ->new_fnode->namelen, RQ->new_fnode->name, de->namelen, de->name);
		if (__unlikely(r < 0)) {
			gd:
			if (__likely(de->flags1 & DE_1_DOWN)) {
				unsigned ptr = de_down_pointer(de);
				VFS$PUT_BUFFER(dnode);
				if (__unlikely(!ptr) || __unlikely(ptr & 3)) {
					KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "INVALID POINTER TO DNODE %08X AT DNODE %08X", ptr, RQ->dirptr);
					HPFS_ERROR((HPFSFS *)RQ->fs);
					error = -EFSERROR;
					goto err;
				}
				RQ->dirptr = ptr;
				goto go_down;
			}
			error = -ENOENT;
			err_put:
			VFS$PUT_BUFFER(dnode);
			goto err;
		}
		if (__unlikely(!r)) {
			int was_dir = 0;
			HPFSFNODE *fn = (HPFSFNODE *)RQ->new_fnode;
			if (fn->flags & FNODE_DIRECTORY) {
				was_dir = 1;
				if (__unlikely(!(de->flags2 & DE_2_DIRECTORY))) {
					error = -ENOTDIR;
					goto err_put;
				}
			}
			RQ->fnode->readers--;
			WQ_WAKE_ALL(&RQ->fnode->wait);
			if (__unlikely(RQ->fnode->readers < 0))
				KERNEL$SUICIDE("HPFS_LOOKUP_AST: %s: LOCK UNDERRUN: %d", VFS$FNODE_DESCRIPTION(RQ->fnode), RQ->fnode->readers);
			HPFS_GET_FNODE(fn, de);
			WQ_WAKE_ALL(&fn->wait);
			VFS$PUT_BUFFER(dnode);
			if (was_dir) {
				RQ->new_fnode = LIST_STRUCT(fn->u.d.clean.next, FNODE, dirent_entry);
				RQ->fnode = (FNODE *)fn;
				RQ->fnode->readers++;
				RQ->state = 0;
				RQ->c[1] = 0;
				goto subdir;
			}
			if (__likely((RQ->wr & (O_CREAT | O_EXCL)) != (O_CREAT | O_EXCL))) {
				caller = VFS$FREE_EMPTY_PAGEIN((PAGEINRQ *)RQ);
				RETURN_IORQ_LSTAT(caller, (IO_STUB *)caller->tmp1);
			} else {
				caller = VFS$FREE_EMPTY_PAGEIN((PAGEINRQ *)RQ);
				caller->status = -EEXIST;
				RETURN_AST(caller);
			}
		}
		n:
		de = de_next_de(de);
	}
	goto gd;

	err:
	if (__unlikely(error != -ENOENT) || __likely(!(RQ->wr & (O_CREAT | _O_RENAME)))) {
		caller = VFS$FREE_LOOKUP_PAGEIN((PAGEINRQ *)RQ, error == -ENOENT);
		caller->status = error;
		RETURN_AST(caller);
	}
	caller = VFS$FREE_LOOKUP_PAGEIN((PAGEINRQ *)RQ, 1);
	RETURN_IORQ_LSTAT(caller, (IO_STUB *)caller->tmp1);
}

void HPFS_INIT_READDIR_COOKIE(struct readdir_buffer *rb, FNODE *f)
{
	char *c = (char *)rb->cookie;
	memset(c, 0, 256);
	rb->cookie_size = 256;
}

extern AST_STUB HPFS_READDIR_AST;

void HPFS_READDIR(PAGEINRQ *p_, struct readdir_buffer *rb)
{
	HPFSPAGEINRQ *p = (HPFSPAGEINRQ *)p_;
	p->fn = HPFS_READDIR_AST;
	if (rb) {
		memcpy(p->cookie, rb->cookie, 256);
		p->cookie[255] = 0;
	} else {
		memset(p->cookie, 0, 256);
	}
	p->state = 0;
	p->c[1] = 0;
	p->d[1] = 0;
	CALL_AST(p);
}

DECL_AST(HPFS_READDIR_AST, SPL_FS, HPFSPAGEINRQ)
{
	long error;
	struct dnode *dnode;
	struct hpfs_dirent *de;
	HPFSFNODE *f;
	IORQ *caller;
	int cl;
	unsigned ptr;
	char name[256];
	IO_DISABLE_CHAIN_CANCEL(SPL_FS, RQ->caller);
	SWITCH_PROC_ACCOUNT(RQ->tag.proc, SPL_X(SPL_FS));;
	if (__unlikely(RQ->status < 0)) {
		error = RQ->status;
		goto err;
	}
	f = (HPFSFNODE *)RQ->fnode;
	if (__unlikely(!RQ->state)) {
		struct fnode *fnode;
		unsigned ptr;
		if (__unlikely(!(fnode = VFS$GET_BUFFER(RQ->fs, f->fnode, 1, (void *)&KERNEL$LIST_END, RQ->tag.proc)))) {
			VFS$READ_BUFFER(f->fnode, (PAGEINRQ *)RQ, 0);
			RETURN;
		}
		if (__unlikely(HPFS_CHECK_FNODE((HPFSFS *)RQ->fs, fnode, f->fnode))) {
			VFS$PUT_BUFFER(fnode);
			error = -EFSERROR;
			goto err;
		}
		ptr = __32LE2CPU(fnode->u.external[0].disk_secno);
		VFS$PUT_BUFFER(fnode);
		if (__unlikely(!ptr) || __unlikely(ptr & 3)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "INVALID POINTER TO ROOT DNODE %08X AT FNODE %08X", ptr, f->fnode);
			HPFS_ERROR((HPFSFS *)RQ->fs);
			error = -EFSERROR;
			goto err;
		}
		RQ->dirptr = ptr;
		RQ->state = 1;
	}
	if (0) {
		go_down:
		if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
			WQ_WAIT_PAGEINRQ(&KERNEL$LOCKUP_EVENTS, (PAGEINRQ *)RQ);
			RETURN;
		}
	}
	if (__unlikely(!(dnode = VFS$GET_BUFFER(RQ->fs, RQ->dirptr, 4, (void *)&KERNEL$LIST_END, RQ->tag.proc)))) {
		VFS$READ_BUFFER(RQ->dirptr, (PAGEINRQ *)RQ, dnode_readahead((HPFSFS *)RQ->fs, RQ->dirptr));
		RETURN;
	}
	if (__unlikely(HPFS_CHECK_DNODE((HPFSFS *)RQ->fs, dnode, RQ->dirptr, 0))) {
		error = -EFSERROR;
		goto err_put;
	}
	cl = strlen(RQ->cookie);
	de = (struct hpfs_dirent *)dnode->dirent;
	while (!(de->flags1 & DE_1_LAST)) {
		int r;
		if (__unlikely(de->flags1 & DE_1_FIRST)) goto n;
		r = HPFS_COMPARE((HPFSFS *)RQ->fs, cl, RQ->cookie, de->namelen, de->name);
		if (__unlikely(r < 0)) {
			void *map;
			unsigned maplen;
			void (*unmap)(void *ptr);
			if (__likely(de->flags1 & DE_1_DOWN) && RQ->state == 1) {
				unsigned ptr;
				gd:
				ptr = __32LE2CPU(*(__u32 *)((char *)de + __16LE2CPU(de->length) - 4));
				VFS$PUT_BUFFER(dnode);
				if (__unlikely(!ptr) || __unlikely(ptr & 3)) {
					KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "INVALID POINTER TO DNODE %08X AT DNODE %08X", ptr, RQ->dirptr);
					HPFS_ERROR((HPFSFS *)RQ->fs);
					error = -EFSERROR;
					goto err;
				}
				RQ->dirptr = ptr;
				if (__unlikely(HPFS_STOP_CYCLES(ptr, &RQ->c))) {
					KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (READDIR - DOWN)", ptr, f->fnode);
					HPFS_ERROR((HPFSFS *)RQ->fs);
					error = -EFSERROR;
					goto err;
				}
				goto go_down;
			}
			map = VFS$MAP_READDIR((IOCTLRQ *)RQ->caller, RQ->wr, RQ->fs, &maplen, &unmap);
			if (__unlikely(!map)) {
				VFS$PUT_BUFFER(dnode);
				goto pagefault;
			}
			if (__unlikely(map == (void *)1)) {
				error = 0;
				goto err_put;
			}
			if (__unlikely(__IS_ERR(map))) {
				error = __PTR_ERR(map);
				goto err_put;
			}
			memcpy(name, de->name, de->namelen);
			HPFS_UPCASE((HPFSFS *)RQ->fs, name, de->namelen);
			error = VFS$DO_READDIR_NAME((PAGEINRQ *)RQ, map, maplen, name, de->namelen, de->flags2 & DE_2_DIRECTORY ? DT_DIR : DT_REG);
			if (__unlikely(error != 0)) {
				VFS$UNMAP_READDIR(map, unmap);
				goto err_put;
			}
			*(char *)mempcpy(RQ->cookie, de->name, de->namelen) = 0;
			strcpy(((struct readdir_buffer *)map)->cookie, RQ->cookie);
			VFS$UNMAP_READDIR(map, unmap);
			RQ->state = 1;
			if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ONE_PASS)) {
				if (__unlikely(RQ->tag.proc == &KERNEL$PROC_KERNEL) || __unlikely(RQ->wr < 0)) {
					VFS$PUT_BUFFER(dnode);
					WQ_WAIT_PAGEINRQ(&KERNEL$LOCKUP_EVENTS, (PAGEINRQ *)RQ);
					RETURN;
				} else {
					error = -EINTR;
					goto err_put;
				}
			}
		}
		n:
		de = (struct hpfs_dirent *)((char *)de + de->length);
	}
	if (__likely(de->flags1 & DE_1_DOWN) && RQ->state == 1) goto gd;
	if (__likely(dnode->flags1 & DN_1_ROOT_DNODE)) {
		void *map;
		void (*unmap)(void *ptr);
		VFS$PUT_BUFFER(dnode);
		map = VFS$MAP_READDIR((IOCTLRQ *)RQ->caller, RQ->wr, RQ->fs, (void *)&KERNEL$LIST_END, &unmap);
		if (__unlikely(!map)) {
			goto pagefault;
		}
		if (__unlikely(map == (void *)1)) {
			error = 0;
			goto err;
		}
		if (__unlikely(__IS_ERR(map))) {
			error = __PTR_ERR(map);
			goto err;
		}
		((struct readdir_buffer *)map)->end = 1;
		VFS$UNMAP_READDIR(map, unmap);
		if (VFS$DONE_READDIR((PAGEINRQ *)RQ)) goto repost;
		error = 0;
		goto err;
	}
	if (__unlikely(HPFS_STOP_CYCLES(__32LE2CPU(dnode->self), &RQ->d))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (READDIR - UP)", (unsigned)__32LE2CPU(dnode->self), f->fnode);
		HPFS_ERROR((HPFSFS *)RQ->fs);
		error = -EFSERROR;
		goto err_put;
	}
	RQ->state = 2;
	ptr = __32LE2CPU(dnode->up);
	VFS$PUT_BUFFER(dnode);
	if (__unlikely(!ptr) || __unlikely(ptr & 3)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "INVALID POINTER TO UP DNODE %08X AT DNODE %08X", ptr, RQ->dirptr);
		HPFS_ERROR((HPFSFS *)RQ->fs);
		error = -EFSERROR;
		goto err;
	}
	RQ->dirptr = ptr;
	goto go_down;

	err_put:
	VFS$PUT_BUFFER(dnode);
	err:
	caller = VFS$FREE_PAGEIN((PAGEINRQ *)RQ);
	caller->status = error;
	RETURN_AST(caller);

	repost:
	caller = VFS$FREE_PAGEIN((PAGEINRQ *)RQ);
	RETURN_IORQ_LSTAT(caller, (IO_STUB *)caller->tmp1);

	pagefault:
	caller = VFS$FREE_PAGEIN((PAGEINRQ *)RQ);
	DO_PAGEIN(caller, &((IOCTLRQ *)caller)->v, PF_RW);
}

