#include "HPFS.H"

int HPFS_CREATE_FNODE(FNODE *f_)
{
	HPFSFNODE *f = (HPFSFNODE *)f_;
	struct fnode *fnode;
	unsigned fn, rd = 0 /* warning, go away */;
	unsigned n = 1;
	fn = HPFS_ALLOC((HPFSFS *)f->fs, ((HPFSFNODE *)f->parent)->fnode, &n);
	if (__unlikely(!fn)) return -ENOSPC;
	if (__unlikely(f->flags & FNODE_DIRECTORY)) {
		rd = HPFS_ALLOC((HPFSFS *)f->fs, fn, NULL);
		if (__unlikely(!rd)) {
			HPFS_FREE((HPFSFS *)f->fs, fn, 1);
			return -ENOSPC;
		}
	}
	fnode = VFS$ALLOC_BUFFER_SYNC(f->fs, fn, 1, (void *)&KERNEL$LIST_END);
	if (__unlikely(__IS_ERR(fnode))) {
		alloc_error:
		if (f->flags & FNODE_DIRECTORY) HPFS_FREE((HPFSFS *)f->fs, rd, 4);
		HPFS_FREE((HPFSFS *)f->fs, fn, 1);
		return __PTR_ERR(fnode);
	}
	fnode->magic = __32CPU2LE(FNODE_MAGIC);
	fnode->len = f->namelen;
	strncpy(fnode->name, f->name, sizeof(fnode->name));
	fnode->up = __32CPU2LE(((HPFSFNODE *)f->parent)->fnode);
	if (__unlikely(f->flags & FNODE_DIRECTORY)) {
		fnode->flags2 = FN_2_DIRECTORY;
		fnode->u.external[0].disk_secno = __32CPU2LE(rd);
	}
	else {
		fnode->btree.n_free_nodes = 8;
		fnode->btree.n_used_nodes = 0;
		fnode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header));
	}
	fnode->ea_offs = __16CPU2LE(0xc4);
	VFS$PUT_BUFFER(fnode);
	if (__unlikely(f->flags & FNODE_DIRECTORY)) {
		struct hpfs_dirent *de;
		struct dnode *dnode = VFS$ALLOC_BUFFER_SYNC(f->fs, rd, 4, (void *)&KERNEL$LIST_END);
		if (__unlikely(__IS_ERR(dnode))) goto alloc_error;
		dnode->magic = __32CPU2LE(DNODE_MAGIC);
		dnode->flags1 = DN_1_ROOT_DNODE;
		dnode->up = __32CPU2LE(fn);
		dnode->self = __32CPU2LE(rd);
		de = (struct hpfs_dirent *)dnode->dirent;
		de->length = __16CPU2LE(0x24);
		de->flags1 = DE_1_FIRST;
		de->flags2 = DE_2_DIRECTORY;
		de->fnode = __32CPU2LE(fn);
		de->write_date = de->read_date = TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->mtime);
		de->creation_date = TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->ctime);
		de->namelen = 2;
		de->name[0] = 1;
		de->name[1] = 1;
		de = (struct hpfs_dirent *)((char *)de + 0x24);
		de->length = __16CPU2LE(0x20);
		de->flags1 = DE_1_LAST;
		de->namelen = 1;
		de->name[0] = 255;
		de = (struct hpfs_dirent *)((char *)de + 0x20);
		dnode->first_free = __32CPU2LE((char *)de - (char *)dnode);
		VFS$PUT_BUFFER(dnode);
	}
	f->flags1 = 0;
	f->flags2 = (__unlikely(f->flags & FNODE_DIRECTORY) ? DE_2_DIRECTORY : 0) | (__unlikely(f->name[0] == '.') ? DE_2_HIDDEN : 0) | DE_2_ARCHIVE;
	f->fnode = fn;
	f->ea_size = 0;
	f->run_length = 0;
	return 0;
}

static struct dnode *MAP_FILE_DE(HPFSFNODE *f, char *name, int namelen, struct hpfs_dirent **e)
{
	BUFFER *b;
	struct fnode *fnode;
	struct dnode *dnode;
	struct hpfs_dirent *de;
	unsigned dno;
	unsigned c[2];
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, (void *)&KERNEL$LIST_END))))
		return (void *)fnode;
	c[1] = 0;
	dno = __32LE2CPU(fnode->u.external[0].disk_secno);
	VFS$PUT_BUFFER(fnode);
	down:
	if (__unlikely(HPFS_STOP_CYCLES(dno, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (MAP FILE DE)", dno, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return __ERR_PTR(-EFSERROR);
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, dno, &b, 0)))) return dnode;
	de = (struct hpfs_dirent *)dnode->dirent;
	while (!(de->flags1 & DE_1_LAST)) {
		int r;
		/*if (__unlikely(de->flags1 & DE_1_FIRST)) goto n;*/
		r = HPFS_COMPARE((HPFSFS *)f->fs, namelen, name, de->namelen, de->name);
		if (__unlikely(r < 0)) {
			gd:
			if (__likely(de->flags1 & DE_1_DOWN)) {
				dno = de_down_pointer(de);
				VFS$PUT_BUFFER(dnode);
				goto down;
			}
			VFS$PUT_BUFFER(dnode);
			return __ERR_PTR(-ENOENT);
		} if (__unlikely(!r)) {
			VFS$MARK_BUFFER_DIRTY(b, dno & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
			*e = de;
			return dnode;
		}
		de = de_next_de(de);
	}
	goto gd;
}


int HPFS_WRITE_FNODE_DATA(FNODE *f_)
{
	HPFSFNODE *f = (HPFSFNODE *)f_;
	int r;
	struct dnode *dnode;
	struct hpfs_dirent *de;
	struct fnode *fnode;
	BUFFER *b;
	if (__likely(f->flags & FNODE_FILE)) {
		unsigned disk_sec = (f->disk_size + 511) >> 9;
		unsigned size = f->size;
		unsigned mem_sec = (size + 511) >> 9;
		if (mem_sec > disk_sec) {
			if (__unlikely(r = HPFS_EXTEND_FILE(f, disk_sec, mem_sec - disk_sec))) return r;
		} else {
			if (mem_sec < disk_sec) if (__unlikely(r = HPFS_TRUNCATE_FILE(f, mem_sec))) return r;
		}
		f->disk_size = size;
	}
	VFS$WRITEPAGES((FNODE *)f);
	if (__unlikely(!f->parent)) goto skip_dn;
	if (__unlikely(__IS_ERR(dnode = MAP_FILE_DE((HPFSFNODE *)f->parent, f->name, f->namelen, &de)))) {
		if (__likely(__PTR_ERR(dnode) == -ENOENT)) goto skip_dn;
		return __PTR_ERR(dnode);
	}
	de->fnode = __32CPU2LE(f->fnode);
	de->write_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->mtime));
	de->read_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->mtime));
	de->creation_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->ctime));
	de->file_size = __32CPU2LE(f->disk_size);
	de->ea_size = __32CPU2LE(f->ea_size);
	VFS$PUT_BUFFER(dnode);
	skip_dn:
	if (__likely(f->flags & FNODE_FILE)) {
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) return __PTR_ERR(fnode);
		fnode->file_size = __32CPU2LE(f->disk_size);
		VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		VFS$PUT_BUFFER(fnode);
	}
	return 0;
}

static void FIX_UP_POINTERS(HPFSFS *fs, struct dnode *dnode)
{
	unsigned dno = __32LE2CPU(dnode->self);
	struct hpfs_dirent *de = (struct hpfs_dirent *)dnode->dirent;
	again:
	if (de->flags1 & DE_1_DOWN) {
		BUFFER *b;
		struct dnode *new_dnode;
		unsigned new_dno = de_down_pointer(de);
		if (__unlikely(__IS_ERR(new_dnode = HPFS_MAP_DNODE(fs, new_dno, &b, 1)))) goto skip;
		new_dnode->up = __32CPU2LE(dno);
		new_dnode->flags1 &= DN_1_ROOT_DNODE;
		VFS$MARK_BUFFER_DIRTY(b, new_dno & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
		VFS$PUT_BUFFER(new_dnode);
	}
	skip:
	if (de->flags1 & DE_1_LAST) return;
	de = de_next_de(de);
	goto again;
}

static void FIX_UP_POINTERS_DNO(HPFSFS *fs, unsigned dno)
{
	struct dnode *dnode;
#define scratch_dnode ((struct dnode *)fs->scratch)
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE(fs, dno, (void *)&KERNEL$LIST_END, 1)))) return;
	memcpy(scratch_dnode, dnode, 2048);
	VFS$PUT_BUFFER(dnode);
	FIX_UP_POINTERS(fs, scratch_dnode);
#undef scratch_dnode
}

static int ADD_DE_TO_DNODE(HPFSFNODE *f, unsigned dno, struct hpfs_dirent *de, char *name, unsigned down)
{
	struct fnode *fnode;
	struct dnode *dnode;
	BUFFER *b;
	struct hpfs_dirent new_de, *pde;
	char new_name[256];
	unsigned new_down, new_down_2;
	int l;
	unsigned c[2];
	HPFSFS *fs = (HPFSFS *)f->fs;
#define scratch_dnode ((struct dnode *)fs->scratch)
	memcpy(&new_de, de, sizeof(struct hpfs_dirent));
	memcpy(new_name, name, new_de.namelen);
	new_down = down;
	c[1] = 0;
	go_up:
	if (__unlikely(HPFS_STOP_CYCLES(dno, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (ADD DE TO DNODE)", dno, f->fnode);
		HPFS_ERROR(fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE(fs, dno, &b, 1))))
		return __PTR_ERR(dnode);
	VFS$MARK_BUFFER_DIRTY(b, dno & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
	de = (struct hpfs_dirent *)dnode->dirent;
	while (HPFS_COMPARE(fs, de->namelen, de->name, new_de.namelen, new_name) < 0) de = de_next_de(de);
	if (__likely(__32LE2CPU(dnode->first_free) + (l = de_length(new_de.namelen, new_down)) <= 2048)) {
		memmove((char *)de + l, de, __32LE2CPU(dnode->first_free) - ((char *)de - (char *)dnode));
		memcpy(de, &new_de, sizeof(struct hpfs_dirent));
		dnode->first_free = __32CPU2LE(__32LE2CPU(dnode->first_free) + l);
		de->length = __16CPU2LE(l);
		memcpy(de->name, new_name, new_de.namelen);
		if (__unlikely(new_down)) {
			de->flags1 |= DE_1_DOWN;
			*(__u32 *)((char *)de + l - 4) = __32CPU2LE(new_down);
		} else de->flags1 &= ~DE_1_DOWN;
		VFS$PUT_BUFFER(dnode);
		return 0;
	}
	memcpy(scratch_dnode, dnode, 2048);
	de = (struct hpfs_dirent *)((char *)scratch_dnode + ((char *)de - (char *)dnode));
	memmove((char *)de + l, de, __32LE2CPU(scratch_dnode->first_free) - ((char *)de - (char *)scratch_dnode));
	memcpy(de, &new_de, sizeof(struct hpfs_dirent));
	scratch_dnode->first_free = __32CPU2LE(__32LE2CPU(scratch_dnode->first_free) + l);
	de->length = __16CPU2LE(l);
	memcpy(de->name, new_name, new_de.namelen);
	if (__unlikely(new_down)) {
		de->flags1 |= DE_1_DOWN;
		*(__u32 *)((char *)de + l - 4) = __32CPU2LE(new_down);
	} else de->flags1 &= ~DE_1_DOWN;
	de = (struct hpfs_dirent *)scratch_dnode->dirent;
	pde = de;
	while ((char *)de - (char *)scratch_dnode <= __32LE2CPU(scratch_dnode->first_free) >> 1) {
		if (__unlikely(de->flags1 & DE_1_LAST))
			KERNEL$SUICIDE("HPFS_ADD_FNODE_TO_DIRECTORY: %s: RUN OUT OF DNODE WHEN SPLITTING", VFS$FNODE_DESCRIPTION((FNODE *)f));
		pde = de;
		de = de_next_de(de);
	}
	if (__32LE2CPU(scratch_dnode->first_free) - ((char *)pde - (char *)scratch_dnode) < ((char *)de - (char *)scratch_dnode) - __32LE2CPU(scratch_dnode->first_free)) de = pde;
	pde = de_next_de(de);
	memcpy(dnode->dirent, pde, l = __32LE2CPU(scratch_dnode->first_free) - ((char *)pde - (char *)scratch_dnode));
	dnode->first_free = __32CPU2LE(l = (unsigned long)&((struct dnode *)NULL)->dirent + __32LE2CPU(scratch_dnode->first_free) - ((char *)pde - (char *)scratch_dnode));
	memset((char *)dnode + l, 0, 2048 - l);
	dnode->flags1 &= ~DN_1_ROOT_DNODE;
	VFS$PUT_BUFFER(dnode);
	if (de->flags1 & DE_1_DOWN) new_down = de_down_pointer(de);
	else new_down = 0;
	memcpy(&new_de, de, sizeof(struct hpfs_dirent));
	/*if (HPFS_IS_NAME_LONG(de->name, de->namelen)) new_de.flags2 |= DE_2_NOT_8x3;*/
	memcpy(new_name, de->name, de->namelen);
	memset(de, 0, 2048 - ((char *)de - (char *)scratch_dnode));
	de->length = __16CPU2LE(new_down ? 0x24 : 0x20);
	de->flags1 = DE_1_LAST | (new_down ? DE_1_DOWN : 0);
	de->namelen = 1;
	de->name[0] = 0xff;
	if (new_down) *(__u32 *)((char *)de + 0x20) = __32CPU2LE(new_down);
	new_down = HPFS_ALLOC(fs, dno, NULL);
	if (__unlikely(!new_down)) return -ENOSPC;
	dnode = VFS$ALLOC_BUFFER_SYNC((FS *)fs, new_down, 4, (void *)&KERNEL$LIST_END);
	if (__unlikely(__IS_ERR(dnode))) {
		HPFS_FREE(fs, new_down, 4);
		return __PTR_ERR(dnode);
	}
	memcpy(dnode, scratch_dnode, /*(char *)de_next_de(de) - (char *)scratch_dnode*/2048);
	dnode->first_free = __32CPU2LE((char *)de_next_de(de) - (char *)scratch_dnode);
	dnode->self = __32CPU2LE(new_down);
	memcpy(scratch_dnode, dnode, __32LE2CPU(dnode->first_free));
	dnode->flags1 &= ~DN_1_ROOT_DNODE;
	VFS$PUT_BUFFER(dnode);
	FIX_UP_POINTERS(fs, scratch_dnode);
	if (!(scratch_dnode->flags1 & DN_1_ROOT_DNODE)) {
		dno = __32CPU2LE(scratch_dnode->up);
		goto go_up;
	}
	dno = HPFS_ALLOC(fs, new_down, NULL);
	if (__unlikely(!dno)) return -ENOSPC;
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE((HPFSFNODE *)f->parent, &b)))) {
		HPFS_FREE(fs, new_down, 4);
		return __PTR_ERR(fnode);
	}
	new_down_2 = __32LE2CPU(fnode->u.external[0].disk_secno);
	fnode->u.external[0].disk_secno = __32CPU2LE(dno);
	VFS$MARK_BUFFER_DIRTY(b, ((HPFSFNODE *)f->parent)->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
	VFS$PUT_BUFFER(fnode);
	dnode = VFS$ALLOC_BUFFER_SYNC((FS *)fs, dno, 4, (void *)&KERNEL$LIST_END);
	if (__unlikely(__IS_ERR(dnode))) {
		return __PTR_ERR(dnode);
	}
	dnode->magic = __32CPU2LE(DNODE_MAGIC);
	dnode->flags1 = DN_1_ROOT_DNODE;
	dnode->up = __32CPU2LE(((HPFSFNODE *)f->parent)->fnode);
	dnode->self = __32CPU2LE(dno);
	de = (struct hpfs_dirent *)dnode->dirent;
	memcpy(de, &new_de, sizeof(struct hpfs_dirent));
	de->length = __16CPU2LE(l = de_length(new_de.namelen, 1));
	memcpy(de->name, new_name, new_de.namelen);
	de->flags1 |= DE_1_DOWN;
	*(__u32 *)((char *)de + l - 4) = __32CPU2LE(new_down);
	de = de_next_de(de);
	de->length = __16CPU2LE(0x24);
	de->flags1 = DE_1_LAST | DE_1_DOWN;
	de->namelen = 1;
	de->name[0] = 0xff;
	*(__u32 *)((char *)de + 0x20) = __32CPU2LE(new_down_2);
	de = de_next_de(de);
	dnode->first_free = __32CPU2LE((char *)de - (char *)dnode);
	memcpy(scratch_dnode, dnode, (char *)de - (char *)dnode);
	VFS$PUT_BUFFER(dnode);
	FIX_UP_POINTERS(fs, scratch_dnode);
	return 0;
#undef scratch_dnode
}

static int ADD_DE_DOWN_TO_DNODE(HPFSFNODE *f, unsigned dno, struct hpfs_dirent *new_de, char *name)
{
	struct dnode *dnode;
	struct hpfs_dirent *de;
	unsigned c[2];
	c[1] = 0;
	go_down:
	if (__unlikely(HPFS_STOP_CYCLES(dno, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (ADD DE DOWN TO DNODE)", dno, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, dno, (void *)&KERNEL$LIST_END, 0)))) return __PTR_ERR(dnode);
	de = (struct hpfs_dirent *)dnode->dirent;
	while (!(de->flags1 & DE_1_LAST)) {
		int r;
		if (__unlikely(de->flags1 & DE_1_FIRST)) goto n;
		r = HPFS_COMPARE((HPFSFS *)f->fs, new_de->namelen, name, de->namelen, de->name);
		if (__unlikely(r < 0)) {
			if (__unlikely(de->flags1 & DE_1_DOWN)) {
				dn:
				dno = de_down_pointer(de);
				VFS$PUT_BUFFER(dnode);
				goto go_down;
			}
			goto add_at_de;
		} else if (__unlikely(!r)) {
			VFS$PUT_BUFFER(dnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "ADDING ALREADY PRESENT ENTRY FOR FNODE %08X", ((HPFSFNODE *)f->parent)->fnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR | __SYSLOG_SECRET, f->fs->filesystem_name, "ADDING ALREADY PRESENT ENTRY %s TO FNODE %s", f->name, f->parent->name);
			return -EFSERROR;
		}
		n:
		de = de_next_de(de);
	}
	if (__unlikely(de->flags1 & DE_1_DOWN)) goto dn;
	add_at_de:
	VFS$PUT_BUFFER(dnode);
	return ADD_DE_TO_DNODE(f, dno, new_de, name, 0);
}

int HPFS_ADD_FNODE_TO_DIRECTORY(FNODE *f_)
{
	HPFSFNODE *f = (HPFSFNODE *)f_;
	struct fnode *fnode;
	BUFFER *b;
	unsigned dno;
	struct hpfs_dirent new_de;
	struct hpfs_dirent *de;
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) return __PTR_ERR(fnode);
	fnode->len = f->namelen;
	strncpy(fnode->name, f->name, sizeof(fnode->name));
	fnode->up = __32CPU2LE(((HPFSFNODE *)f->parent)->fnode);
	VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
	VFS$PUT_BUFFER(fnode);
	if (__unlikely(f->flags & FNODE_DIRECTORY)) {
		struct dnode *dnode;
		if (__unlikely(__IS_ERR(dnode = MAP_FILE_DE(f, "\001\001", 2, &de)))) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "DIRECTORY DOES NOT CONTAIN .. ENTRY: %s", strerror(-__PTR_ERR(dnode)));
			return -EFSERROR;
		}
		de->fnode = __32CPU2LE(((HPFSFNODE *)f->parent)->fnode);
		de->write_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, ((HPFSFNODE *)f->parent)->mtime));
		de->read_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, ((HPFSFNODE *)f->parent)->mtime));
		de->creation_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, ((HPFSFNODE *)f->parent)->ctime));
		VFS$PUT_BUFFER(dnode);
	}
	new_de.flags1 = f->flags1;
	new_de.flags2 = f->flags2 & ~DE_2_NOT_8x3;
	if (HPFS_IS_NAME_LONG(f->name, f->namelen)) new_de.flags2 |= DE_2_NOT_8x3;
	new_de.fnode = __32CPU2LE(f->fnode);
	new_de.write_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->mtime));
	new_de.read_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->mtime));
	new_de.creation_date = __32CPU2LE(TIME_GMT_TO_LOCAL((HPFSFS *)f->fs, f->ctime));
	new_de.file_size = __32CPU2LE(f->disk_size);
	new_de.ea_size = __32CPU2LE(f->ea_size);
	new_de.no_of_acls = 0;
	new_de.ix = 0;
	new_de.namelen = f->namelen;
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE((HPFSFNODE *)f->parent, (void *)&KERNEL$LIST_END)))) return __PTR_ERR(fnode);
	dno = __32LE2CPU(fnode->u.external[0].disk_secno);
	VFS$PUT_BUFFER(fnode);
	return ADD_DE_DOWN_TO_DNODE(f, dno, &new_de, f->name);
}

int HPFS_DELETE_FNODE(FNODE *f_)
{
	HPFSFNODE *f = (HPFSFNODE *)f_;
	HPFSFS *fs = (HPFSFS *)f->fs;
	struct fnode *fnode;
	struct extended_attribute *ea, *ea_end;
#define scratch_fnode	((struct fnode *)fs->scratch)
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, (void *)&KERNEL$LIST_END))))
		return __PTR_ERR(fnode);
	memcpy(scratch_fnode, fnode, 512);
	VFS$PUT_BUFFER(fnode);
	if (__unlikely(f->flags & FNODE_DIRECTORY)) HPFS_FREE(fs, __32LE2CPU(scratch_fnode->u.external[0].disk_secno), 4);
	else HPFS_TRUNCATE_FILE(f, 0);
	if (__unlikely(scratch_fnode->flags1 & FN_1_EA_ANODE))
		HPFS_ZAP_ANODE(fs, __32LE2CPU(scratch_fnode->ea_secno));
	else if (__unlikely(__32LE2CPU(scratch_fnode->ea_size_l) != 0))
		HPFS_FREE(fs, __32LE2CPU(scratch_fnode->ea_secno), (__32LE2CPU(scratch_fnode->ea_size_l) + 511) >> 9);
	ea_end = fnode_end_ea(scratch_fnode);
	for (ea = fnode_ea(scratch_fnode); (char *)ea >= (char *)scratch_fnode && ea < ea_end && (char *)ea <= (char *)scratch_fnode + 512 - sizeof(struct extended_attribute); ea = ea_next_ea(ea)) {
		if ((char *)ea_next_ea(ea) > (char *)scratch_fnode + 512) break;
		if (__unlikely(ea->flags1 & EA_1_INDIRECT)) {
			unsigned sec;
			if (__unlikely(ea_valuelen(ea) < 8)) break;
			sec = ea_sec(ea);
			if (__unlikely(ea->flags1 & EA_1_ANODE)) HPFS_ZAP_ANODE(fs, sec);
			else HPFS_FREE(fs, sec, (ea_len(ea) + 511) >> 9);
		}
	}
	HPFS_FREE(fs, f->fnode, 1);
	f->fnode = 0;
	return 0;
#undef scratch_fnode
}

static int REMOVE_DE(struct dnode *dnode, struct hpfs_dirent *de)
{
	struct hpfs_dirent *dee = de_next_de(de);
	memmove(de, dee, (char *)dnode + __32LE2CPU(dnode->first_free) - (char *)dee);
	dnode->first_free = __32CPU2LE(__32LE2CPU(dnode->first_free) - ((char *)dee - (char *)de));
	memset((char *)dnode + __32LE2CPU(dnode->first_free), 0, (char *)dee - (char *)de);
	dee = (struct hpfs_dirent *)dnode->dirent;
	return dee->flags1 & DE_1_LAST;
}

static int REMOVE_EMPTY_DNODE(HPFSFNODE *f, unsigned dno)
{
	int r;
	unsigned up, down, ndown, nd2;
	BUFFER *b;
	struct dnode *dnode;
	struct hpfs_dirent *de, *pde;
	struct hpfs_dirent new_de;
	char new_name[256];
	unsigned c[2];
	c[1] = 0;
	check_this:
	if (__unlikely(HPFS_STOP_CYCLES(dno, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (REMOVE EMPTY DNODE)", dno, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, dno, (void *)&KERNEL$LIST_END, 1))))
		return __PTR_ERR(dnode);
	de = (struct hpfs_dirent *)dnode->dirent;
	if (__unlikely(!(de->flags1 & DE_1_LAST))) {
		VFS$PUT_BUFFER(dnode);
		return 0;
	}
	if (__unlikely(de->flags1 & DE_1_DOWN)) down = de_down_pointer(de);
	else down = 0;
	up = __unlikely(dnode->flags1 & DN_1_ROOT_DNODE) ? 0 : __32LE2CPU(dnode->up);
	VFS$PUT_BUFFER(dnode);
	if (__unlikely(!up) && __unlikely(!down)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "THE ONLY DNODE %08X IN DIRECTORY %08X IS EMPTY", dno, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	HPFS_FREE((HPFSFS *)f->fs, dno, 4);
	if (__unlikely(!up)) {
		struct fnode *fnode;
		if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, down, &b, 0))))
			return __PTR_ERR(dnode);
		VFS$MARK_BUFFER_DIRTY(b, down & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
		dnode->up = __32CPU2LE(f->fnode);
		dnode->flags1 |= DN_1_ROOT_DNODE;
		VFS$PUT_BUFFER(dnode);
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b))))
			return __PTR_ERR(fnode);
		VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		fnode->u.external[0].disk_secno = __32CPU2LE(down);
		VFS$PUT_BUFFER(fnode);
		return 0;
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, up, &b, 0))))
		return __PTR_ERR(dnode);
	VFS$MARK_BUFFER_DIRTY(b, up & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
	pde = de = (struct hpfs_dirent *)dnode->dirent;
	while (1) {
		if (__likely(de->flags1 & DE_1_DOWN) && de_down_pointer(de) == dno) break;
		if (__unlikely(de->flags1 & DE_1_LAST)) {
			VFS$PUT_BUFFER(dnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "POINTER TO DNODE %08X NOT FOUND IN PARENT DNODE %08X", dno, up);
			HPFS_ERROR((HPFSFS *)f->fs);
			return -EFSERROR;
		}
		pde = de;
		de = de_next_de(de);
	}

	if (__likely(!(de->flags1 & DE_1_LAST))) {
		memcpy(&new_de, de, sizeof(struct hpfs_dirent));
		memcpy(new_name, de->name, new_de.namelen);
		REMOVE_DE(dnode, de);
		if (__likely(de->flags1 & DE_1_DOWN)) ndown = de_down_pointer(de);
		else ndown = up;
		VFS$PUT_BUFFER(dnode);
		if (__unlikely((r = ADD_DE_TO_DNODE(f, ndown, &new_de, new_name, down))))
			return r;
		FIX_UP_POINTERS_DNO((HPFSFS *)f->fs, ndown);
		dno = up;
		goto check_this;
	}

	if (__unlikely(!(pde->flags1 & DE_1_DOWN))) {
		if (down) *(__u32 *)((char *)de + __16LE2CPU(de->length) - 4) = __32CPU2LE(down);
		else {
			de->flags1 &= ~DE_1_DOWN;
			de->length = __16CPU2LE(__16LE2CPU(de->length) - 4);
			dnode->first_free = __32CPU2LE(__32LE2CPU(dnode->first_free) - 4);
		}
		VFS$PUT_BUFFER(dnode);
		FIX_UP_POINTERS_DNO((HPFSFS *)f->fs, up);
		return 0;
	}
	ndown = de_down_pointer(pde);
	memcpy(&new_de, pde, sizeof(struct hpfs_dirent));
	memcpy(new_name, pde->name, new_de.namelen);
	REMOVE_DE(dnode, pde);
	*(__u32 *)((char *)pde + __16LE2CPU(pde->length) - 4) = __32CPU2LE(ndown);
	VFS$PUT_BUFFER(dnode);
	if (!down) {
		if (__unlikely((r = ADD_DE_TO_DNODE(f, ndown, &new_de, new_name, 0))))
			return r;
		FIX_UP_POINTERS_DNO((HPFSFS *)f->fs, up);
		dno = up;
		goto check_this;
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, ndown, &b, 0))))
		return __PTR_ERR(dnode);
	VFS$MARK_BUFFER_DIRTY(b, ndown & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
	de = (struct hpfs_dirent *)dnode->dirent;
	while (!(de->flags1 & DE_1_LAST)) de = de_next_de(de);
	if (__unlikely(!(de->flags1 & DE_1_DOWN))) {
		VFS$PUT_BUFFER(dnode);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "UNBALANCED TREE AT FNODE %08X", f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	nd2 = de_down_pointer(de);
	*(__u32 *)((char *)de + __16LE2CPU(de->length) - 4) = __32CPU2LE(down);
	VFS$PUT_BUFFER(dnode);
	if (__unlikely((r = ADD_DE_TO_DNODE(f, ndown, &new_de, new_name, nd2))))
		return r;
	FIX_UP_POINTERS_DNO((HPFSFS *)f->fs, ndown);
	dno = up;
	goto check_this;
}

int HPFS_REMOVE_FNODE_FROM_DIRECTORY(FNODE *f_)
{
	HPFSFNODE *f = (HPFSFNODE *)f_;
	BUFFER *b;
	struct dnode *dnode;
	struct hpfs_dirent *de, *dee;
	struct hpfs_dirent new_de;
	char new_de_name[256];
	unsigned down, dno, rem_empty, odown;
	unsigned c[2];
	int r;
	if (__unlikely(__IS_ERR(dnode = MAP_FILE_DE((HPFSFNODE *)f->parent, f->name, f->namelen, &de)))) {
		if (__unlikely(__PTR_ERR(dnode) == -ENOENT)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "DIRENT FOR FNODE %08X NOT FOUND", f->fnode);
			HPFS_ERROR((HPFSFS *)f->fs);
		}
		return __PTR_ERR(dnode);
	}
	if (__likely((de->flags1 & DE_1_DOWN))) down = de_down_pointer(de);
	else down = 0;
	if (__unlikely(REMOVE_DE(dnode, de)) && __unlikely(!down)) {
		dno = __32LE2CPU(dnode->self);
		VFS$PUT_BUFFER(dnode);
		return REMOVE_EMPTY_DNODE((HPFSFNODE *)f->parent, dno);
	}
	if (__likely(!down)) {
		VFS$PUT_BUFFER(dnode);
		return 0;
	}
	dno = __32LE2CPU(dnode->self);
	VFS$PUT_BUFFER(dnode);
	odown = down;
	c[1] = 0;
	ddd:
	if (__unlikely(HPFS_STOP_CYCLES(down, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (REMOVE FNODE FROM DIRECTORY)", down, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(dnode = HPFS_MAP_DNODE((HPFSFS *)f->fs, down, &b, 0))))
		return __PTR_ERR(dnode);
	de = (struct hpfs_dirent *)dnode->dirent;
	dd:
	dee = de_next_de(de);
	if (__likely(!(dee->flags1 & DE_1_LAST))) {
		de = dee;
		goto dd;
	}
	if (__unlikely(dee->flags1 & DE_1_DOWN)) {
		down = de_down_pointer(dee);
		VFS$PUT_BUFFER(dnode);
		goto ddd;
	}
	if (__unlikely(de->flags1 & DE_1_DOWN)) {
		VFS$PUT_BUFFER(dnode);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "UNBALANCED DNODE %08X IN DIRECTORY %08X", down, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	memcpy(&new_de, de, sizeof(struct hpfs_dirent));
	memcpy(new_de_name, de->name, de->namelen);
	if (__unlikely(REMOVE_DE(dnode, de))) rem_empty = down;
	else rem_empty = 0;
	VFS$MARK_BUFFER_DIRTY(b, down & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 4);
	VFS$PUT_BUFFER(dnode);
	r = ADD_DE_TO_DNODE(f, dno, &new_de, new_de_name, odown);
	if (__unlikely(r)) return r;
	if (__unlikely(rem_empty)) return REMOVE_EMPTY_DNODE((HPFSFNODE *)f->parent, rem_empty);
	return 0;
}

