#ifndef _VFS_H
#define _VFS_H

#include <SPAD/VFS.H>
#include <ARCH/SETUP.H>
#include <SPAD/DEV_KRNL.H>

#define VFS_PAGE_READAHEAD		524288
#define VFS_MAX_PAGE_READAHEAD		4194304
#define VFS_MAX_PAGE_DIRECT_IO		16777216
#define VFS_MAX_PAGE_WRITE_CLUSTER	16777216
#define VFS_BUFFER_READAHEAD		262144
#define VFS_DEFAULT_SYNCTIME		600
#define VFS_DEFAULT_BUFFER_FLUSHTIME	10
#define VFS_MAX_DIRTY_NODES		3072
#define VFS_MAX_DIRTY_NODES_HARD	4096

#define BUFFER_OFF_MASK	(~(__d_off)__SECTORS_PER_PAGE_CLUSTER_MINUS_1)
void BUFFER_CTOR(void *fs_, void *buffer_);
void BRQ_CTOR(void *fs_, void *brq_);
void CLOSE_BUFFERS(FS *fs);
int BUFFER_INIT_GLOBAL(void);
void BUFFER_TERM_GLOBAL(void);
BUFFER *CREATE_EMPTY_BUFFER(FS *fs, __d_off off, PROC *proc);
int BUFFER_READ_PARTIAL(BUFFER *buf, int status, PROC *proc);

int FNODE_INIT_GLOBAL(void);
void FNODE_TERM_GLOBAL(void);

void FNODE_WRITE(VMENTITY *e, PROC *p, int trashing);
void *FIX_DEPTH(FNODE *f, void *param);

int PAGE_INIT_GLOBAL(void);
void PAGE_TERM_GLOBAL(void);
extern IO_STUB VFS_PROCESS_WANTFREE;

long SYNCER(void *p);
void SYNC_HALF(FS *fs);
void SYNC_TIMER(TIMER *t);

void VFS_SPAGE_CTOR(void *g, void *o);
int VFS_ALLOC_SPAGE(FNODE *f, unsigned n_pages);
void VFS_FREE_SPAGE(FNODE *f);
void VFS_UNDIRTY_PAGES(FNODE *f);

void WPAGE_CTOR(void *fs_, void *wpage_);
int VFS_WRITEPAGE(FS *fs, PAGE *p, unsigned sec, int unsigned, __d_off blk);
void VFS_DO_WRITE(FS *fs);
void VFS_DO_EXTEND_READ(FNODE *f, IOCTLRQ *rq);
extern IO_STUB VFS_FILE_READ;
extern IO_STUB VFS_FILE_AREAD;
extern IO_STUB VFS_FILE_WRITE;
extern IO_STUB VFS_FILE_AWRITE;
extern IO_STUB VFS_FILE_BIO;
unsigned long VFS_VSPACE_GET(VDESC *desc, __const__ VBUF *buf);
unsigned long VFS_VSPACE_PUT(VDESC *desc, __const__ VBUF *buf);
void *VFS_VSPACE_MAP(VDESC *desc, int rw, vspace_unmap_t **unmap);
VDMA VFS_VSPACE_DMALOCK(VDESC *desc, int rw, vspace_dmaunlock_t **unlock);
void VFS_VSPACE_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma, vspace_dma64unlock_t **unlock);
void VFS_VSPACE_PHYSLOCK(VDESC *desc, int rw, VPHYS *dma, vspace_physunlock_t **unlock);
PAGE *VFS_GET_PAGE(HANDLE *h, __v_off idx, int wr);
IORQ *VFS_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int wr);

extern __const__ HANDLE_OPERATIONS VFS_FILE_OPERATIONS;
extern __const__ HANDLE_OPERATIONS VFS_DIR_OPERATIONS;

void VFS_FREE_EMPTY_FNODE(FNODE *f);
void VFS_FREE_FNODE_DATA(FNODE *f);
WQ *VFS_FREE_FILE_PAGES(FNODE *f, _u_off_t off);
WQ *VFS_EXTEND_FILE(FNODE *f, _u_off_t off, PROC *proc);

#define FS_BUFFERS_DONE(fs)	(!(fs)->write_buf_ops)
#define FS_WPAGES_DONE(fs)	(XLIST_EMPTY(&(fs)->wpages_io))

#if __DEBUG >= 2
void CHECK_DIR_LISTS(FNODE *f);
void CHECK_PAGE(PAGE *p, int trunc);
#else
#define CHECK_DIR_LISTS(f) do { } while(0)
#define CHECK_PAGE(p, trunc) do { } while(0)
#endif

#if __DEBUG >= 3
void CHECK_FNODE_HANDLE(FNODE *f, HANDLE *h);
static __finline__ void INIT_PAGE(PAGE *p, __u8 fill)
{
	void *v = KERNEL$MAP_PHYSICAL_PAGE(p);
	memset(v, fill, __PAGE_CLUSTER_SIZE);
	KERNEL$UNMAP_PHYSICAL_BANK(v);
}
#define CHECK_DIR_LISTS_3 CHECK_DIR_LISTS
#else
#define CHECK_FNODE_HANDLE(x, y) do { } while(0)
#define INIT_PAGE(p, fill) do { } while(0)
#define CHECK_DIR_LISTS_3(f) do { } while (0)
#endif

XLIST_HEAD *VFS_ALLOC_BIGHASH(FS *fs);
void VFS_REHASH_DIRECTORY(FNODE *f);

static __finline__ void POSSIBLY_REHASH_DIRECTORY(FNODE *f)
{
	if (__unlikely(((f->u.d.n_clean + f->u.d.n_dirty) & -((unsigned)(BIG_HASH_MASK - f->u.d.hash_mask) / (BIG_HASH_SIZE / 2))) > SMALL_HASH_ITEMS)) {
		VFS_REHASH_DIRECTORY(f);
	}
}

#define IS_SMALL_HASH(p)	((unsigned long)(p) & __PAGE_CLUSTER_SIZE_MINUS_1)

static __finline__ void init_small_hash(XLIST_HEAD *h)
{
	INIT_XLIST(&h[0]);
}

static __finline__ void init_big_hash(XLIST_HEAD *h)
{
	int i;
	for (i = 0; i < BIG_HASH_SIZE; i++) INIT_XLIST(&h[i]);
}

static __finline__ void free_hash(FS *fs, XLIST_HEAD *h)
{
	if (__likely(IS_SMALL_HASH(h))) __slfree(h);
	else KERNEL$FREE_KERNEL_PAGE(h, VM_TYPE_CACHED_MAPPED), fs->n_bighash--;
}

#if __DEBUG >= 1
#define testspl(string, spl)						\
do {									\
	if (__unlikely(KERNEL$SPL != (spl)))				\
		KERNEL$SUICIDE(string " AT SPL %08X", KERNEL$SPL);	\
} while (0)
#else
#define testspl(string, spl) do { } while (0)
#endif

#define no_need_to_free_fnodes(fs)	(__unlikely((fs)->fnodes.__n_pages <= (fs)->fnodes.__n_reserved_pages) && __unlikely(!(fs)->n_bighash) && __likely((fs)->small_hash.__n_pages <= (fs)->small_hash.__n_reserved_pages) && __likely((fs)->names.__n_pages <= (fs)->names.__n_reserved_pages) && __likely((fs)->pageinrq.__n_pages <= (fs)->pageinrq.__n_reserved_pages) && __likely((fs)->brq.__n_pages <= (fs)->brq.__n_reserved_pages) && __likely((fs)->wpages.__n_pages <= (fs)->wpages.__n_reserved_pages))

#define GET_PAGEINRQ(pgin, fs, process, prefetch, splvspace, wait_for_pagein, failcode)									\
{									\
	testspl("GET_PAGEINRQ", !(splvspace) ? SPL_X(SPL_FS) : SPL_X(SPL_VSPACE));									\
	if (!(splvspace)) RAISE_SPL(SPL_VSPACE);			\
	(pgin) = __slalloc(&(fs)->pageinrq);				\
	if (__unlikely(!(pgin))) {					\
		wq = &(fs)->pageinrq_wait;				\
		wait_for_pagein:					\
		{							\
			failcode;					\
		}							\
		__unreachable_code();					\
	}								\
	if (!(splvspace)) TEST_SPL(SPL_FS, SPL_VSPACE);			\
	if (__unlikely((wq = KERNEL$ACQUIRE_IO_TAG(&(pgin)->tag, process)) != NULL)) {									\
		__slow_slfree((pgin));					\
		goto wait_for_pagein;					\
	}								\
	if (prefetch) {							\
		(pgin)->caller = (IORQ *)&(pgin)->prefetch_tag;		\
		(pgin)->prefetch_tag.fn = KERNEL$DUMMY_IORQ.fn;		\
		(pgin)->prefetch_tag.tmp1 = KERNEL$DUMMY_IORQ.tmp1;	\
		(pgin)->prefetch_tag.status = RQS_PROCESSING;		\
		KERNEL$ACQUIRE_PREFETCH_TAG(&(pgin)->prefetch_tag, (pgin)->tag.proc);									\
	}								\
	if (!(splvspace)) LOWER_SPL(SPL_FS);				\
}

static __finline__ IORQ *FREE_PAGEINRQ(PAGEINRQ *pgin, int splvspace)
{
	IORQ *caller;
	testspl("FREE_PAGEINRQ", !(splvspace) ? SPL_X(SPL_FS) : SPL_X(SPL_VSPACE));
	if (!(splvspace)) RAISE_SPL(SPL_VSPACE);
	KERNEL$RELEASE_IO_TAG(&(pgin)->tag);
	WQ_WAKE_ALL(&(pgin)->fs->pageinrq_wait);
	caller = pgin->caller;
	if (PAGEIN_IS_PREFETCH(pgin, caller)) {
		RELEASE_PREFETCH_TAG(&pgin->prefetch_tag);
		caller = &KERNEL$DUMMY_IORQ;
	}
	if (!(splvspace)) TEST_SPL(SPL_FS, SPL_VSPACE);
	__slfree(pgin);
	if (!(splvspace)) LOWER_SPL(SPL_FS);
	return caller;
}

#endif
