#include "VFS.H"

extern IO_STUB SPAGE_RELEASE;
static WQ *VFS_SPAGE_LOCKDOWN(SPAGE *sp, int lock);

void VFS_SPAGE_CTOR(void *g, void *o)
{
	SPAGES *spages = o;
	unsigned i;
	spages->s[0].size = 0;
	spages->s[__PAGES_PER_CLUSTER + 1].size = 0;
	for (i = 0; i < __PAGES_PER_CLUSTER + 2; i++) spages->s[i].spages = spages;
}

int VFS_ALLOC_SPAGE(FNODE *f, unsigned n_pages)
{
	FS *fs = f->fs;
	SPAGE_ENTRY *sp, *spp;
	SPAGES *spages;
	PAGE *page;
	unsigned i, newsize;
#if __DEBUG >= 1
	if (__unlikely(n_pages - 1 >= __PAGES_PER_CLUSTER - 1))
		KERNEL$SUICIDE("VFS_ALLOC_SPAGE: %s: %u PAGES", fs->filesystem_name, n_pages);
#endif
	if (__likely(!XLIST_EMPTY(&fs->slist[n_pages - 1]))) {
		int i;
		sp = LIST_STRUCT(fs->slist[n_pages - 1].next, SPAGE_ENTRY, freelist);
#if __DEBUG >= 1
		if (__unlikely((sp[0].size ^ n_pages) | (sp[n_pages - 1].size ^ n_pages)))
			KERNEL$SUICIDE("VFS_ALLOC_SPAGE: %s: SPAGE ENTRY AREA CORRUPTED WHEN ALLOCATING FROM EXACT LIST, SIZE %u, SIZE IN LIST %u, %u", fs->filesystem_name, n_pages, sp[0].size, sp[n_pages - 1].size);
#endif
		if (__unlikely(sp->spages->page->flags & PAGE_WANTFREE)) goto alloc_new;
		DEL_FROM_LIST(&sp->freelist);
		ret_sp:
		sp[0].size = 0;
		sp[n_pages - 1].size = 0;
		for (i = 0; i < n_pages; i++) sp[i].freelist.next = (void *)&f->u.s.s;
		f->u.s.s.lockdown = VFS_SPAGE_LOCKDOWN;
		f->u.s.s.spage_entry = sp;
		f->u.s.s.n_pages = n_pages;
		f->u.s.s.page = sp->spages->page;
		f->u.s.s.offset = ((char *)sp - (char *)&sp->spages->s[1]) * (PG_SIZE / sizeof(SPAGE_ENTRY));
		INIT_XLIST(&f->u.s.s.mapping);
		f->u.s.s.flags = PAGE_BUSY;
		WQ_INIT(&f->u.s.s.wait, "VFS$SPAGE_WAIT");
		return 0;
	}
	for (i = n_pages + 1; i < __PAGES_PER_CLUSTER; i++) {
		if (__likely(!XLIST_EMPTY(&fs->slist[i - 1]))) {
			sp = LIST_STRUCT(fs->slist[i - 1].next, SPAGE_ENTRY, freelist);
#if __DEBUG >= 1
			if (__unlikely((sp[0].size ^ i) | (sp[i - 1].size ^ i)))
				KERNEL$SUICIDE("VFS_ALLOC_SPAGE: %s: SPAGE ENTRY AREA CORRUPTED WHEN ALLOCATING FROM LARGER LIST, ALLOCATING %u, SIZE %u, SIZE IN LIST %u, %u", fs->filesystem_name, n_pages, i, sp[0].size, sp[n_pages - 1].size);
#endif
			if (__unlikely(sp->spages->page->flags & PAGE_WANTFREE)) goto alloc_new;
			DEL_FROM_LIST(&sp->freelist);
			set_sp:
			spp = sp + n_pages;
			newsize = i - n_pages;
			spp[0].size = newsize;
			spp[newsize - 1].size = newsize;
			ADD_TO_XLIST(&fs->slist[newsize - 1], &spp->freelist);
			goto ret_sp;
		}
	}
	alloc_new:
	spages = __slalloc(&fs->spages);
	if (__unlikely(!spages)) return 1;
	page = PAGEZONE_ALLOC(&fs->z, KERNEL$ALLOC_IO_PAGE, 0);
	if (__unlikely(!page)) {
		__slow_slfree(spages);
		return 1;
	}
	page->flags = 0;
	page->release = SPAGE_RELEASE;
#if __DEBUG >= 1
	page->lockdown = NULL;
#endif
	page->fnode = spages;
	spages->page = page;
	i = __PAGES_PER_CLUSTER;
	sp = &spages->s[1];
	goto set_sp;
}

void VFS_FREE_SPAGE(FNODE *f)
{
	FS *fs;
	SPAGE_ENTRY *sp;
	unsigned n_pages;
	SPAGES *spages;
	WQ_WAKE_ALL(&f->u.s.s.wait);
	fs = f->fs;
	sp = f->u.s.s.spage_entry;
	n_pages = f->u.s.s.n_pages;
#if __DEBUG >= 1
	if (__unlikely((n_pages - 1) >= __PAGES_PER_CLUSTER - 1))
		KERNEL$SUICIDE("VFS_FREE_SPAGE: %s: %u PAGES", fs->filesystem_name, n_pages);
	if (__unlikely(sp[0].size | sp[n_pages - 1].size))
		KERNEL$SUICIDE("VFS_FREE_SPAGE: %s: FREEING NON-ALLOCATED SPAGE ENTRY, SIZE %u, SIZE DESCRIPTORS %u, %u", fs->filesystem_name, n_pages, sp[0].size, sp[n_pages - 1].size);
#endif
	if (sp[-1].size) {
#if __DEBUG >= 1
		if (__unlikely(sp[-(int)sp[-1].size].size != sp[-1].size))
			KERNEL$SUICIDE("VFS_FREE_SPAGE: %s: SPAGE ENTRY AREA CORRUPTED WHEN JOINING WITH PREVIOUS, %u != %u", fs->filesystem_name, sp[-(int)sp[-1].size].size, sp[-1].size);
#endif
		n_pages += sp[-1].size;
		sp -= sp[-1].size;
		DEL_FROM_LIST(&sp->freelist);
	}
	if (__unlikely(sp[n_pages].size)) {
#if __DEBUG >= 1
		if (__unlikely(sp[n_pages].size != sp[n_pages + sp[n_pages].size - 1].size))
			KERNEL$SUICIDE("VFS_FREE_SPAGE: %s: SPAGE ENTRY AREA CORRUPTED WHEN JOINING WITH NEXT, %u != %u", fs->filesystem_name, sp[n_pages].size, sp[n_pages + sp[n_pages].size - 1].size);
#endif
		DEL_FROM_LIST(&sp[n_pages].freelist);
		n_pages += sp[n_pages].size;
	}
	if (__likely(n_pages < __PAGES_PER_CLUSTER)) {
		sp[0].size = sp[n_pages - 1].size = n_pages;
		ADD_TO_XLIST(&fs->slist[n_pages - 1], &sp->freelist);
		return;
	}
	spages = sp->spages;
#if __DEBUG >= 1
	if (__unlikely(spages->s[0].size | spages->s[__PAGES_PER_CLUSTER + 1].size))
		KERNEL$SUICIDE("VFS_FREE_SPAGE: %s: SPAGE ENTRY AREA CORRUPTED WHEN FREEING, %u != 0 || %u != 0", fs->filesystem_name, spages->s[0].size, spages->s[__PAGES_PER_CLUSTER + 1].size);
#endif
	PAGEZONE_FREE(&fs->z, spages->page, 0);
	__slfree(spages);
	WQ_WAKE_ALL(&fs->freemem);
}

static WQ *VFS_SPAGE_LOCKDOWN(SPAGE *sp, int lock)
{
#define f	GET_STRUCT(sp, FNODE, u.s.s)
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_VSPACE)))
		  KERNEL$SUICIDE("VFS_SPAGE_LOCKDOWN AT SPL %08X", KERNEL$SPL);
#endif
	if (!lock) {
		if (__unlikely(f->flags & FNODE_WANTFREE)) return &f->wait;
		if (__unlikely(sp->flags & PAGE_BUSY)) return &sp->wait;
		if (__unlikely((sp->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) return &sp->wait;
		sp->flags += PAGE_DMALOCKCOUNT_1;
		return NULL;
	} else {
#if __DEBUG >= 1
		if (__unlikely(!(sp->flags & PAGE_DMALOCKCOUNT)))
			KERNEL$SUICIDE("VFS_SPAGE_LOCKDOWN: %s: UNLOCKING UNLOCKED SPAGE", VFS$FNODE_DESCRIPTION(f));
#endif
		if (__unlikely((sp->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) WQ_WAKE_ALL(&sp->wait);
		if (__likely(!((sp->flags -= PAGE_DMALOCKCOUNT_1) & PAGE_DMALOCKCOUNT))) WQ_WAKE_ALL(&sp->wait);
		return NULL;
	}
#undef f
}

static void FREE_SPAGES(PAGE *page);

DECL_IOCALL(SPAGE_RELEASE, SPL_FS, PAGE_RELEASE_REQUEST)
{
	PAGE *page = RQ->pg, *new;
	SPAGES *spages;
	void *v1, *v2;
	unsigned i;
	if (__unlikely(page->release != &SPAGE_RELEASE)) call_again: RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_PAGE_RELEASE);
	if (!(new = KERNEL$ALLOC_USER_PAGE(VM_TYPE_WIRED_UNMAPPED))) {
		if (KERNEL$OOM(VM_TYPE_WIRED_UNMAPPED)) {
			RQ->status = -ENOMEM;
			RETURN_AST(RQ);
		}
		WQ_WAIT(&KERNEL$FREEMEM_WAIT, RQ, KERNEL$WAKE_PAGE_RELEASE);
		RETURN;
	}
	spages = page->fnode;
	for (i = 0; i < __PAGES_PER_CLUSTER; ) {
		SPAGE_ENTRY *s = &spages->s[i + 1];
		if (s->size) i += s->size;
		else {
			FNODE *f = GET_STRUCT(s->freelist.next, FNODE, u.s.s);
#if __DEBUG >= 1
			if (__unlikely(!(f->flags & (FNODE_FILE | FNODE_SPAGE))))
				KERNEL$SUICIDE("SPAGE_RELEASE: %s: INVALID FNODE ATTACHED TO SPAGES, FLAGS %08X", VFS$FNODE_DESCRIPTION(f), f->flags);
#endif
			if (__unlikely(KERNEL$VM_UNMAP_SPAGE(&f->u.s.s) != NULL)) {
				WQ *wq;
				LOWER_SPL(SPL_FS);
				KERNEL$FREE_USER_PAGE(new, VM_TYPE_WIRED_UNMAPPED);
				if ((wq = VFS$FREE_FNODE(f))) {
					WQ_WAIT(wq, RQ, KERNEL$WAKE_PAGE_RELEASE);
					LOWER_SPL(SPL_FS);
/* revert temporarily disabled FNODE_SPAGE ... this code is a mess :-/ */
					for (i = 0; i < __PAGES_PER_CLUSTER; ) {
						SPAGE_ENTRY *s = &spages->s[i + 1];
						if (s->size) i += s->size;
						else {
							FNODE *f = GET_STRUCT(s->freelist.next, FNODE, u.s.s);
							RAISE_SPL(SPL_VSPACE);
							f->flags |= FNODE_SPAGE;
							LOWER_SPL(SPL_FS);
							i += f->u.s.s.n_pages;
						}
					}
					FREE_SPAGES(page);
					RETURN;
				}
				goto call_again;
			}
			f->flags &= ~FNODE_SPAGE;
			LOWER_SPL(SPL_FS);
			i += f->u.s.s.n_pages;
		}
	}
#if __DEBUG >= 1
	if (__unlikely(i != __PAGES_PER_CLUSTER))
		KERNEL$SUICIDE("SPAGE_RELEASE: RAN OUT OF SPAGES, POSITION %u", i);
#endif
	new->fnode = spages;
	spages->page = new;
	new->flags = 0;
	new->release = SPAGE_RELEASE;
	v1 = KERNEL$MAP_PHYSICAL_PAGE(page);
	v2 = KERNEL$MAP_PHYSICAL_PAGE(new);
	memcpy(v2, v1, __PAGE_CLUSTER_SIZE);
	KERNEL$UNMAP_PHYSICAL_BANK(v1);
	KERNEL$UNMAP_PHYSICAL_BANK(v2);
	KERNEL$PAGE_RELEASE(page, VM_TYPE_WIRED_UNMAPPED);
	for (i = 0; i < __PAGES_PER_CLUSTER; ) {
		SPAGE_ENTRY *s = &spages->s[i + 1];
		if (s->size) i += s->size;
		else {
			FNODE *f = GET_STRUCT(s->freelist.next, FNODE, u.s.s);
			f->u.s.s.page = new;
			f->u.s.s.offset = i * PG_SIZE;
			RAISE_SPL(SPL_VSPACE);
			f->flags |= FNODE_SPAGE;
			LOWER_SPL(SPL_FS);
			i += f->u.s.s.n_pages;
		}
	}
#if __DEBUG >= 1
	if (__unlikely(i != __PAGES_PER_CLUSTER))
		KERNEL$SUICIDE("SPAGE_RELEASE: RAN OUT OF SPAGES AFTER MOVE, POSITION %u", i);
#endif
	RQ->status = 0;
	RETURN_AST(RQ);
}

static void FREE_SPAGES(PAGE *page)
{
	unsigned i;
	SPAGES *spages;
	scan_again:
	if (__unlikely(page->release != &SPAGE_RELEASE)) return;
	spages = page->fnode;
	page->flags |= PAGE_WANTFREE;
	for (i = 0; i < __PAGES_PER_CLUSTER; ) {
		SPAGE_ENTRY *s = &spages->s[i + 1];
		if (s->size) i += s->size;
		else {
			FNODE *f = GET_STRUCT(s->freelist.next, FNODE, u.s.s);
			i += f->u.s.s.n_pages;
			if (VFS$FREE_FNODE(f)) {
				LOWER_SPL(SPL_FS);
			} else {
				goto scan_again;
			}
		}
	}
#if __DEBUG >= 1
	if (__unlikely(i != __PAGES_PER_CLUSTER))
		KERNEL$SUICIDE("FREE_SPAGES: RAN OUT OF SPAGES, POSITION %u", i);
#endif
}
