#include <SPAD/VM.H>
#include <SPAD/ALLOC.H>
#include <SPAD/WQ.H>
#include <SPAD/LIBC.H>

#include <SPAD/PAGEZONE.H>

DECL_IOCALL(NO_PAGE_RELEASE, SPL_FS, PAGE_RELEASE_REQUEST)
{
	PAGE *pg = RQ->pg;
	if (__unlikely(pg->release != &NO_PAGE_RELEASE)) RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_PAGE_RELEASE);
	RQ->status = -EIO;
	RETURN_AST(RQ);
}

DECL_IOCALL(RSVD_PAGE_RELEASE, SPL_FS, PAGE_RELEASE_REQUEST)
{
	PAGE *new;
	PAGE *l, **ll;
	PAGEZONE *z;
	if (__unlikely(RQ->pg->release != &RSVD_PAGE_RELEASE)) RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_PAGE_RELEASE);
	if (__unlikely(!(new = KERNEL$ALLOC_USER_PAGE(VM_TYPE_WIRED_UNMAPPED)))) {
		if (KERNEL$OOM(VM_TYPE_WIRED_UNMAPPED)) {
			RQ->status = -ENOMEM;
			RETURN_AST(RQ);
		}
		WQ_WAIT(&KERNEL$FREEMEM_WAIT, RQ, KERNEL$WAKE_PAGE_RELEASE);
		RETURN;
	}
	z = (void *)RQ->pg->hash_entry.prev;
	ll = &z->next;
	for (l = z->next; l; l = (PAGE *)l->hash_entry.next) {
		if (l == RQ->pg) {
			*ll = (PAGE *)l->hash_entry.next;
			goto ok;
		}
		ll = (PAGE **)&l->hash_entry.next;
	}
	KERNEL$SUICIDE("RSVD_PAGE_RELEASE: PAGE IS NOT IN ZONE: PAGE %p, ZONE %s (%p)", RQ->pg, z->name, z);
	ok:
	z->reserved--;
	VFS$ZFREE(z, new);
	KERNEL$PAGE_RELEASE(RQ->pg, VM_TYPE_WIRED_UNMAPPED);
	RQ->status = 0;
	RETURN_AST(RQ);
}

void VFS$ZINIT(PAGEZONE *z, int type, __const__ char *name)
{
	z->type = type;
	z->next = NULL;
	z->allocated = 0;
	z->reserved = 0;
	z->name = name;
}

void VFS$ZRESERVE(PAGEZONE *z, PAGE *p)
{
	VFS$ZFREE(z, p);
}

PAGE *VFS$ZALLOC(PAGEZONE *z)
{
	PAGE *p;
	p = z->next;
	z->next = (PAGE *)p->hash_entry.next;
	p->release = &NO_PAGE_RELEASE;
	z->reserved--;
#if __DEBUG >= 1
	if (__unlikely(z->reserved < 0)) KERNEL$SUICIDE("VFS$ZALLOC: RESERVED COUNT UNDERFLOW: %d, ZONE %s", z->reserved, z->name);
	if (__unlikely(!z->reserved != !z->next)) KERNEL$SUICIDE("VFS$ZALLOC: RESERVED COUNT INCONSISTENT: %d, ZONE %s", z->reserved, z->name);
#endif
	return p;
}

void VFS$ZFREE(PAGEZONE *z, PAGE *p)
{
	p->hash_entry.next = (void *)z->next;
	p->hash_entry.prev = (void *)z;
	z->next = p;
	z->reserved++;
	p->release = &RSVD_PAGE_RELEASE;
}

void VFS$ZDONE(PAGEZONE *z)
{
	if (__unlikely(z->allocated != 0)) KERNEL$SUICIDE("VFS$ZDONE: ZONE %s IS NOT EMPTY (%ld+%d PAGES LEAKED)", z->name, z->allocated, z->reserved);
	while (z->next) {
		KERNEL$FREE_USER_PAGE(VFS$ZALLOC(z), VM_TYPE_WIRED_UNMAPPED);
	}
	if (__unlikely(z->reserved != 0)) KERNEL$SUICIDE("VFS$ZDONE: ZONE %s IS NOT EMPTY (%d PAGES LEAKED)", z->name, z->reserved);
}

void VFS$KZINIT(KPAGEZONE *z, __const__ char *name)
{
	z->next = NULL;
	z->allocated = 0;
	z->reserved = 0;
	z->name = name;
}

void VFS$KZRESERVE(KPAGEZONE *z, void *p)
{
	VFS$KZFREE(z, p);
}

void *VFS$KZALLOC(KPAGEZONE *z)
{
	void **p;
	p = z->next;
	z->next = *p;
	z->reserved--;
#if __DEBUG >= 1
	if (__unlikely(z->reserved < 0)) KERNEL$SUICIDE("VFS$KZALLOC: RESERVED COUNT UNDERFLOW: %d, ZONE %s", z->reserved, z->name);
	if (__unlikely(!z->reserved != !z->next)) KERNEL$SUICIDE("VFS$KZALLOC: RESERVED COUNT INCONSISTENT: %d, ZONE %s", z->reserved, z->name);
#endif
	return p;
}

void VFS$KZFREE(KPAGEZONE *z, void *p)
{
	*(void **)p = z->next;
	z->next = p;
	z->reserved++;
}

void VFS$KZDONE(KPAGEZONE *z)
{
	if (__unlikely(z->allocated != 0)) KERNEL$SUICIDE("VFS$KZDONE: ZONE %s IS NOT EMPTY (%ld+%d PAGES LEAKED)", z->name, z->allocated, z->reserved);
	while (z->next) {
		KERNEL$FREE_KERNEL_PAGE(VFS$KZALLOC(z), VM_TYPE_WIRED_MAPPED);
	}
	if (__unlikely(z->reserved != 0)) KERNEL$SUICIDE("VFS$KZDONE: ZONE %s IS NOT EMPTY (%d PAGES LEAKED)", z->name, z->reserved);
}


