#ifndef __SPAD_API_H
#define __SPAD_API_H

#ifdef __linux__
#ifdef __STRICT_ANSI__
#undef __STRICT_ANSI__
#endif
#include <asm/types.h>
#else
typedef signed char __s8;
typedef unsigned char __u8;
typedef short __s16;
typedef unsigned short __u16;
typedef int __s32;
typedef unsigned __u32;
typedef long long __s64;
typedef unsigned long long __u64;
#endif

#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __GNUC__
#define __PRINTF_ATTR__(c, ch) __attribute__ ((__format__ (__printf__, c, ch)))
#define __NORET_ATTR__ __attribute__((__noreturn__))
#if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1)
#define __finline__	__inline__ __attribute__((__always_inline__))
#else
#define __finline__	__inline__
#endif
#else
#define __PRINTF_ATTR__(c, ch)
#define __NORET_ATTR__
#define __finline__	inline
#endif

#if !defined(__GNUC__) || (__GNUC__ <= 2 && __GNUC_MINOR__ < 96)
#define __likely(x)	((int)(x))
#define __unlikely(x)	((int)(x))
#else
#define __likely(x)	(__builtin_expect((x),1))
#define __unlikely(x)	(__builtin_expect((x),0))
#endif

#define __MAX_STR_LEN	256

#ifndef EBADSYN
#define EBADSYN		EINVAL
#endif
#ifndef EEOF
#define EEOF		ERANGE
#endif

#define _snprintf	snprintf
#define __sync_malloc	malloc
#define _strcasecmp	strcasecmp

#ifndef MAXULONG
#define MAXULONG	((unsigned long)-1)
#endif

#if defined(__linux__) && !defined(__INTEL_COMPILER)
#define __64_format	"L"
#else
#define __64_format	"ll"
#endif

#define __make64(__lo, __hi)	(((__u64)(__hi) << 32) | (__lo))

static __finline__ int __BT(void *__ptr, int __bit)
{
	return (*((__u32 *)__ptr + (__bit >> 5)) >> (__bit & 31)) & 1;
}

static __finline__ int __BTS(void *__ptr, int __bit)
{
	int __r = __BT(__ptr, __bit);
	*((__u32 *)__ptr + (__bit >> 5)) |= 1 << (__bit & 31);
	return __r;
}

static __finline__ int __BTR(void *__ptr, int __bit)
{
	int __r = __BT(__ptr, __bit);
	*((__u32 *)__ptr + (__bit >> 5)) &= ~(1 << (__bit & 31));
	return __r;
}

static __finline__ int __BSR(unsigned long __x)
{
	int __i;
	for (__i = sizeof(unsigned long) * 8 - 1; __i > 0; __i--) if (__unlikely((__x & (1UL << __i)) != 0)) return __i;
	return 0;
}

static __finline__ int __BSF(unsigned long __x)
{
	int __i;
	for (__i = 0; __i < sizeof(unsigned long) * 8 - 1; __i++) if (__unlikely((__x & (1UL << __i)) != 0)) return __i;
	return sizeof(unsigned long) * 8 - 1;
}

int _memcasecmp(__const__ void *__s1, __const__ void *__s2, size_t __count);
size_t strlcpy(char *__dest, __const__ char *__src, size_t __count);
size_t strlcat(char *__dest, __const__ char *__src, size_t __count);

#define VM_TYPE_WIRED_MAPPED	0
__u64 KERNEL$GET_MEMORY_SIZE(int type);
char *KERNEL$ERROR_MSG(void);
int KERNEL$STDIN(void);
int KERNEL$STDOUT(void);
int KERNEL$STDERR(void);
void __PRINTF_ATTR__(1,2) __NORET_ATTR__ KERNEL$SUICIDE(__const__ char *__fmt, ...);
int __PRINTF_ATTR__(1,2) _printf(__const__ char *__fmt, ...);
int _vprintf(__const__ char *__fmt, va_list __args);
int __PRINTF_ATTR__(1,2) _eprintf(__const__ char *__fmt, ...);
int _veprintf(__const__ char *__fmt, va_list __args);
int __PRINTF_ATTR__(2,3) _fprintf(int __h, __const__ char *__fmt, ...);
int _vfprintf(int __h, __const__ char *__fmt, va_list __args);

static __finline__ void __barrier(void) { __asm__ __volatile__ ("":::"memory"); }
static __finline__ void __PREFETCHT0(void *p) {}
static __finline__ void __PREFETCHT1(void *p) {}
static __finline__ void __PREFETCHT2(void *p) {}
static __finline__ void __PREFETCHNTA(void *p) {}
static __finline__ void __PREFETCHT0_IF32(void *p) {}
static __finline__ void __PREFETCHT1_IF32(void *p) {}
static __finline__ void __PREFETCHT2_IF32(void *p) {}
static __finline__ void __PREFETCHNTA_IF32(void *p) {}
static __finline__ void __PREFETCHT0_IF64(void *p) {}
static __finline__ void __PREFETCHT1_IF64(void *p) {}
static __finline__ void __PREFETCHT2_IF64(void *p) {}
static __finline__ void __PREFETCHNTA_IF64(void *p) {}

#ifdef __NOT_FROM_SPAD_TREE
#include "LIST.H"
#else
#include <SPAD/LIST.H>
#endif

#endif
