#ifdef __SPAD__
#include <SPAD/TTY.H>
#include <SPAD/KEYBOARD.H>
#else

#include "../../../INCLUDE/SPAD/KEYBOARD.H"

typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned __u32;

/* duplicate of INCLUDE/SPAD/TTY.H */

#define MAX_KEYMAP_SEQUENCE		5

struct keymap_entry {
	__u32 if_mod_set;
	__u32 if_mod_reset;
	__u16 if_key;
	__u8 seq;
	__u8 do_sequence[MAX_KEYMAP_SEQUENCE];
	__u32 do_mod_set;
	__u32 do_mod_reset;
};

#define STRING_NOCHANGE		"\000\000\001\000\000"
#define VAL_NOCHANGE		__32CPU2BE(0x00010000)

#define MOD_CAPS_LOCK	0x00000001
#define MOD_NUM_LOCK	0x00000002
#define MOD_ADD_ESC	0x00000004
#define MOD_ALT_NUM	0x00000008
#define MOD_MOUSE_PASTE	0x00000010
#define MOD_NOREINIT	(~(MOD_CAPS_LOCK | MOD_NUM_LOCK))

#define KEY_CODE_MASK	0x03ff
#define KEY_IS_DOWN	0x0400
#define KEY_NONEMPTY_OUTPUT	(KEY_IS_DOWN | KEY_IS_UP)
#define KEY_EMPTY_OUTPUT	(KEY_IS_DOWN | KEY_IS_UP | 1)
#define KEY_IS_UP	0x0800
#define KEY_DOWN_NO_UP	0x1000
#define KEY_DOWN	0x2000
#define KEY_REPEAT	0x4000
#define KEY_UP		0x8000
#define KEY		(KEY_DOWN | KEY_DOWN_NO_UP | KEY_REPEAT)

#define SEQ_MASK	0x3f
#define SEQ_QUIT_PASS	0x40
#define SEQ_QUIT	0x80

#endif

#include "KBD_MAC.I"

static
#ifdef FROM_KBD
__const__
#endif
struct keymap_entry keymap[] = {
