#include <SPAD/KEYBOARD.H>
#include <STRING.H>
#include "KBD.I"

/*
 * Translation of scan codes to key codes. Copied from
 *
 * linux/drivers/char/pc_keyb.c
 *
 * Separation of the PC low-level part by Geert Uytterhoeven, May 1997
 * See keyboard.c for the whole history.
 *
 * Major cleanup by Martin Mares, May 1997
 *
 * Combined the keyboard and PS/2 mouse handling into one file,
 * because they share the same hardware.
 * Johan Myreen <jem@iki.fi> 1998-10-08.
 *
 * Code fixes to handle mouse ACKs properly.
 * C. Scott Ananian <cananian@alumni.princeton.edu> 1999-01-29.
 *
 */

#define SC_LIM 89

static __const__ __u8 e0_keys[128] = {
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x00-0x07 */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x08-0x0f */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x10-0x17 */
	0, 0, 0, 0, KC_NUM_ENTER, KC_RIGHT_CTRL, 0, 0,	/* 0x18-0x1f */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x20-0x27 */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x28-0x2f */
	0, 0, 0, 0, 0, KC_NUM_DIV, 0, KC_PRINT_SCREEN,	/* 0x30-0x37 */
	KC_RIGHT_ALT, 0, 0, 0, 0, 0, 0, 0,		/* 0x38-0x3f */
	0, 0, 0, 0, 0, 0, KC_BREAK, KC_HOME,		/* 0x40-0x47 */
	KC_UP, KC_PAGE_UP, 0, KC_LEFT, 0, KC_RIGHT, 0, KC_END,/* 0x48-0x4f */
	KC_DOWN, KC_PAGE_DOWN, KC_INS, KC_DEL, 0, 0, 0, 0,/* 0x50-0x57 */
	0, 0, 0, KC_MSLW, KC_MSRW, KC_MSTM, 0, 0,	/* 0x58-0x5f */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x60-0x67 */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x68-0x6f */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x70-0x77 */
	0, 0, 0, 0, 0, 0, 0, 0,				/* 0x78-0x7f */
};

static void handle_scancode(unsigned char scancode)
{
	static unsigned prev_scancode = 0;
	int down;

	put_buffer(&raw_buffer[active_vc], &scancode, 1);

	if (scancode == 0xe0 || scancode == 0xe1) {
		prev_scancode = scancode;
		return;
	}

	if (scancode == 0x00 || scancode == 0xff) {
		prev_scancode = 0;
		return;
	}
	down = !(scancode & 0x80);
	scancode &= 0x7f;

	if (prev_scancode) {
		if (prev_scancode != 0xe0) {
		  /*
		   * usually it will be 0xe0, but a Pause key generates
		   * e1 1d 45 e1 9d c5 when pressed, and nothing when released
		   */
			if (prev_scancode == 0xe1 && scancode == 0x1d) {
				prev_scancode = 0x100;
				return;
			} else if (prev_scancode == 0x100 && scancode == 0x45) {
				if (down) handle_keycode(KC_PAUSE, KBD_KEY_DOWN_NO_UP);
				prev_scancode = 0;
				return;
			} else {
				prev_scancode = 0;
				return;
			}
		  } else {
			__u8 key;
			prev_scancode = 0;
	      /*
	       *  The keyboard maintains its own internal caps lock and
	       *  num lock statuses. In caps lock mode E0 AA precedes make
	       *  code and E0 2A follows break code. In num lock mode,
	       *  E0 2A precedes make code and E0 AA follows break code.
	       *  We do our own book-keeping, so we will just ignore these.
	       */
	      /*
	       *  For my keyboard there is no caps lock mode, but there are
	       *  both Shift-L and Shift-R modes. The former mode generates
	       *  E0 2A / E0 AA pairs, the latter E0 B6 / E0 36 pairs.
	       *  So, we should also ignore the latter. - aeb@cwi.nl
	       */
			if (scancode == 0x2a || scancode == 0x36) return;

			if ((key = __secure_lookup_8(e0_keys, sizeof e0_keys, scancode))) {
				handle_keycode(key, down);
				return;
			} else {
				return;
			}
		}
	} else if (scancode >= SC_LIM) {
	    /* This happens with the FOCUS 9000 keyboard
	       Its keys PF1..PF12 are reported to generate
	       55 73 77 78 79 7a 7b 7c 74 7e 6d 6f
	       Moreover, unless repeated, they do not generate
	       key-down events, so we have to zero up_flag below */
	    /* Also, Japanese 86/106 keyboards are reported to
	       generate 0x73 and 0x7d for \ - and \ | respectively. */
	    /* Also, some Brazilian keyboard is reported to produce
	       0x73 and 0x7e for \ ? and KP-dot, respectively. */
		return;
	} else {
		handle_keycode(scancode, down);
	}
}

