#include <TIME.H>

#define PS2_RESET_TIMEOUT	(JIFFIES_PER_SECOND / 5 + 1)

static struct mouse_state ms;
static struct mouse_info mi = { 3, 0, 2 };

static int mouse_state = 0;
static __u8 packet_byte[6];
static __u8 last_byte = 0;

static int mouse_id = -1;

static DECL_TIMER(ps2_reset_timer);

static void init_ps2_mouse(void);
static void ps2_reset(TIMER *t);

static int n_errors = 0;

static int mouse_error(void)
{
	static time_t last_error = 0;
	time_t tm = time(NULL);
	if (tm - last_error > 10) n_errors = 0;
	n_errors++;
	if (__unlikely(n_errors > 10)) {
		init_ps2_mouse();
		return 1;
	}
	return 0;
}

static __finline__ void do_mouse_event(void)
{
	ms.x = mi.buttons;
	ms.y = mi.wheels;
	ms.z = mi.axes;
	kbd_mouse_event(&ms);
}

static void handle_mouse_code(int scancode)
{
	/*__debug_printf("[%02X]", scancode);*/
	/* AA 00 can be hotplug notification or part of correct stream. If we
	   don't receive anything else in PS2_RESET_TIMEOUT, assume it is
	   hotplug */
	if (__unlikely(ps2_reset_timer.fn != NULL)) KERNEL$DEL_TIMER(&ps2_reset_timer), ps2_reset_timer.fn = NULL;
	if (__unlikely(last_byte == 0xaa) && __likely(scancode == 0x00)) {
		ps2_reset_timer.fn = ps2_reset;
		KERNEL$SET_TIMER(PS2_RESET_TIMEOUT, &ps2_reset_timer);
	}
	last_byte = scancode;
	retry:
	packet_byte[mouse_state] = scancode;
	switch (mouse_state) {
		case 0:
			if (__unlikely(!(packet_byte[0] & 0x08))) {
				mouse_error();
				return;
			}
			mouse_state = 1;
			return;
		case 1:
			mouse_state = 2;
			return;
		case 2:
			memset(&ms, 0, sizeof ms);
			if (packet_byte[0] & 0x10) ms.rx = packet_byte[1] - 0x100;
			else ms.rx = packet_byte[1];
			if (packet_byte[0] & 0x20) ms.ry = 0x100 - packet_byte[2];
			else ms.ry = -packet_byte[2];
			ms.buttons = packet_byte[0] & 7;
			if (mouse_id != 3 && mouse_id != 4 && mouse_id != 8) {
				do_mouse_event();
				mouse_state = 0;
				return;
			}
			mouse_state = 3;
			return;
		case 3:
			if (mouse_id == 3) {
				int w = (packet_byte[3] & 0x07) - (packet_byte[3] & 0x08);
				if (__unlikely((packet_byte[3] & 0xf0) != (w & 0xf0))) {
					if (mouse_error()) {
						mouse_state = 0;
						return;
					}
					retry3:
					do_mouse_event();
					mouse_state = 0;
					goto retry;
				}
				ms.wy = w;
				do_mouse_event();
				mouse_state = 0;
				return;
			}
			if (mouse_id == 4) {
				if (packet_byte[3] & 0xc0) {
					if (mouse_error()) return;
					do_mouse_event();
					mouse_state = 0;
					return;
				}
				ms.wy = (packet_byte[3] & 0x07) - (packet_byte[3] & 0x08);
				ms.buttons |= (packet_byte[3] >> 1) & 0x18;
				do_mouse_event();
				mouse_state = 0;
				return;
			}
			if (mouse_id == 8) {
				if (__unlikely(packet_byte[3] != packet_byte[0])) {
					if (mouse_error()) mouse_state = 0;
					goto retry3;
				}
				mouse_state = 4;
				return;
			}
			goto retry3;
		case 4:
			mouse_state = 5;
			return;
		case 5:
			if (__unlikely(packet_byte[5] != 0)) {
				if (mouse_error()) mouse_state = 0;
				do_mouse_event();
				mouse_state = 0;
				return;
			}
			ms.wy = (__s8)packet_byte[4];
			do_mouse_event();
			mouse_state = 0;
			return;
	}
}

static void init_ps2_mouse(void)
{
	/*
	mouse_write_output(AUX_RESET);
	mouse_wait_for_input();
	mouse_wait_for_input();*/

	/* some USB-to-PS/2 converters are lame and return value as the first
	   byte after AUX_READ_ID, without returning ack 250. */

	mouse_write_output(AUX_SET_DEFAULTS);
	mouse_wait_for_input();
	mouse_write_output(AUX_READ_ID);
	mouse_id = mouse_wait_for_input();
	if (mouse_id == 250) mouse_id = mouse_wait_for_input();
	if (mouse_id < 0) goto done;

	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(200);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(100);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(80);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(60);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(40);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(20);
	mouse_wait_for_input();
	mouse_write_output(AUX_READ_ID);
	mouse_id = mouse_wait_for_input();
	if (mouse_id == 250) mouse_id = mouse_wait_for_input();
	if (mouse_id <= 0) goto done;
	if (mouse_id == 8) goto done;
	if (mouse_id != 3) goto done;
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(200);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(200);
	mouse_wait_for_input();
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(80);
	mouse_wait_for_input();
	mouse_write_output(AUX_READ_ID);
	mouse_wait_for_input();
	if (mouse_id == 250) mouse_id = mouse_wait_for_input();

	done:
	mouse_write_output(AUX_SET_SAMPLE);
	mouse_write_output(100);
	mouse_wait_for_input();
	mouse_write_output(AUX_ENABLE_DEV);
	mouse_wait_for_input();
	mouse_state = 0;
	n_errors = 0;
	switch (mouse_id) {
		case 3:
			mi.buttons = 3;
			mi.wheels = 1;
			mi.axes = 2;
			break;
		case 4:
			mi.buttons = 5;
			mi.wheels = 1;
			mi.axes = 2;
			break;
		case 8:
			mi.buttons = 3;
			mi.wheels = 1;
			mi.axes = 2;
			break;
		default:
			mi.buttons = 3;
			mi.wheels = 0;
			mi.axes = 2;
			break;
	}
}

static void ps2_reset(TIMER *t)
{
	LOWER_SPL(SPL_KEYBOARD);
	t->fn = NULL;
	init_ps2_mouse();
}
