#ifndef _USBHID_H
#define _USBHID_H

#include <SPAD/USB.H>

#define USBHID_REQ_GET_HID_DESCRIPTOR	(USB_REQ_GET_DESCRIPTOR | USB_CTRL_DIR_IN | USB_CTRL_TYPE_STANDARD | USB_CTRL_RECIP_INTERFACE)

#define USBHID_REQ_GET_REPORT		(0x0100 | USB_CTRL_DIR_IN | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_INTERFACE)
#define USBHID_REQ_GET_IDLE		(0x0200 | USB_CTRL_DIR_IN | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_INTERFACE)
#define USBHID_REQ_GET_PROTOCOL		(0x0300 | USB_CTRL_DIR_IN | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_INTERFACE)
#define USBHID_REQ_SET_REPORT		(0x0900 | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_INTERFACE)
#define USBHID_REQ_SET_IDLE		(0x0A00 | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_INTERFACE)
#define USBHID_REQ_SET_PROTOCOL		(0x0B00 | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_INTERFACE)

#define HID_DT		0x21
#define HID_DT_REPORT	0x22
#define HID_DT_PHYS	0x23

typedef struct {
	__u8 bLength;
	__u8 bDescriptorType;
	__u16 bcdHid;
	__u8 bCountryCode;
	__u8 bNumDescriptors;
	struct {
		__u8 bDescriptorType;
		__u8 wDescriptorLength_lo;
		__u8 wDescriptorLength_hi;
	} descs[1];
} USB_DESCRIPTOR_HID;

#define USB_DESCRIPTOR_HID_SIZE(n_desc)	(6 + 3 * (n_desc))
#define USB_DESCRIPTOR_HID_MIN_SIZE	USB_DESCRIPTOR_HID_SIZE(1)

#define HID_N_REPORTS				256
#define HID_N_REPORT_TYPES			3
#define  HID_REPORT_INPUT			 0
#define  HID_REPORT_OUTPUT			 1
#define  HID_REPORT_FEATURE			 2
#define HID_MAX_REPORT_SIZE			4096

#define HID_ITEM_TYPE_MAIN			0
#define HID_ITEM_TYPE_GLOBAL			1
#define HID_ITEM_TYPE_LOCAL			2
#define HID_ITEM_TYPE_RESERVED			3

#define HID_MAIN_ITEM_TAG_INPUT			8
#define HID_MAIN_ITEM_TAG_OUTPUT		9
#define HID_MAIN_ITEM_TAG_FEATURE		11
#define HID_MAIN_ITEM_TAG_BEGIN_COLLECTION	10
#define HID_MAIN_ITEM_TAG_END_COLLECTION	12

#define HID_GLOBAL_ITEM_TAG_USAGE_PAGE		0
#define HID_GLOBAL_ITEM_TAG_LOGICAL_MINIMUM	1
#define HID_GLOBAL_ITEM_TAG_LOGICAL_MAXIMUM	2
#define HID_GLOBAL_ITEM_TAG_PHYSICAL_MINIMUM	3
#define HID_GLOBAL_ITEM_TAG_PHYSICAL_MAXIMUM	4
#define HID_GLOBAL_ITEM_TAG_UNIT_EXPONENT	5
#define HID_GLOBAL_ITEM_TAG_UNIT		6
#define HID_GLOBAL_ITEM_TAG_REPORT_SIZE		7
#define HID_GLOBAL_ITEM_TAG_REPORT_ID		8
#define HID_GLOBAL_ITEM_TAG_REPORT_COUNT	9
#define HID_GLOBAL_ITEM_TAG_PUSH		10
#define HID_GLOBAL_ITEM_TAG_POP			11

#define HID_LOCAL_ITEM_TAG_USAGE		0
#define HID_LOCAL_ITEM_TAG_USAGE_MINIMUM	1
#define HID_LOCAL_ITEM_TAG_USAGE_MAXIMUM	2
#define HID_LOCAL_ITEM_TAG_DESIGNATOR_INDEX	3
#define HID_LOCAL_ITEM_TAG_DESIGNATOR_MINIMUM	4
#define HID_LOCAL_ITEM_TAG_DESIGNATOR_MAXIMUM	5
#define HID_LOCAL_ITEM_TAG_STRING_INDEX		7
#define HID_LOCAL_ITEM_TAG_STRING_MINIMUM	8
#define HID_LOCAL_ITEM_TAG_STRING_MAXIMUM	9
#define HID_LOCAL_ITEM_TAG_DELIMITER		10

#define HID_COLLECTION_PHYSICAL			0
#define HID_COLLECTION_APPLICATION		1
#define HID_COLLECTION_LOGICAL			2
#define HID_COLLECTION_REPORT			3
#define HID_COLLECTION_NAMED_ARRAY		4
#define HID_COLLECTION_USAGE_SWITCH		5
#define HID_COLLECTION_USAGE_MODIFIER		6

#define HID_REPORT_TYPE_CONSTANT		0x00000001
#define HID_REPORT_TYPE_VARIABLE		0x00000002
#define HID_REPORT_TYPE_RELATIVE		0x00000004
#define HID_REPORT_TYPE_WRAP			0x00000008
#define HID_REPORT_TYPE_NON_LINEAR		0x00000010
#define HID_REPORT_TYPE_NO_PREFERRED		0x00000020
#define HID_REPORT_TYPE_NULL_STATE		0x00000040
#define HID_REPORT_TYPE_VOLATILE		0x00000080
#define HID_REPORT_TYPE_BUFFERE_BYTES		0x00000100

#define HID_USAGE_CP_POINTER			0x00010001
#define HID_USAGE_CA_MOUSE			0x00010002
#define HID_USAGE_CA_JOYSTICK			0x00010004
#define HID_USAGE_CA_GAME_PAD			0x00010005
#define HID_USAGE_CA_KEYBOARD			0x00010006
#define HID_USAGE_CA_KEYPAD			0x00010007
#define HID_USAGE_CA_MULTI_AXIS_CONTROLLER	0x00010008
#define HID_USAGE_CA_TABLET_PC_SYSTEM_CONTROLS	0x00010009
#define HID_USAGE_DV_X				0x00010030
#define HID_USAGE_DV_Y				0x00010031
#define HID_USAGE_DV_Z				0x00010032
#define HID_USAGE_DV_RX				0x00010033
#define HID_USAGE_DV_RY				0x00010034
#define HID_USAGE_DV_RZ				0x00010035
#define HID_USAGE_DV_SLIDER			0x00010036
#define HID_USAGE_DV_DIAL			0x00010037
#define HID_USAGE_DV_WHEEL			0x00010038
#define HID_USAGE_DV_HAT_SWITCH			0x00010039
#define HID_USAGE_CL_COUNTER_BUFFER		0x0001003a
#define HID_USAGE_DV_BYTE_COUNT			0x0001003b
#define HID_USAGE_OSC_MOTION_WAKEUP		0x0001003c
#define HID_USAGE_OOC_START			0x0001003d
#define HID_USAGE_OOC_SELECT			0x0001003e
#define HID_USAGE_DV_VX				0x00010040
#define HID_USAGE_DV_VY				0x00010041
#define HID_USAGE_DV_VZ				0x00010042
#define HID_USAGE_DV_VBRX			0x00010043
#define HID_USAGE_DV_VBRY			0x00010044
#define HID_USAGE_DV_VBRZ			0x00010045
#define HID_USAGE_DV_VNO			0x00010046
#define HID_USAGE_DV_DF_FEATURE_NOTIFICATION	0x00010047
#define HID_USAGE_DV_RESOLUTION_MULTIPLIER	0x00010048
#define HID_USAGE_CA_SYSTEM_CONTROL		0x00010080
#define HID_USAGE_OSC_SYSTEM_POWER_DOWN		0x00010081
#define HID_USAGE_OSC_SYSTEM_SLEEP		0x00010082
#define HID_USAGE_OSC_SYSTEM_WAKE_UP		0x00010083
#define HID_USAGE_OSC_SYSTEM_CONTEXT_MENU	0x00010084
#define HID_USAGE_OSC_SYSTEM_MAIN_MENU		0x00010085
#define HID_USAGE_OSC_SYSTEM_APP_MENU		0x00010086
#define HID_USAGE_OSC_SYSTEM_MENU_HELP		0x00010087
#define HID_USAGE_OSC_SYSTEM_MENU_EXIT		0x00010088
#define HID_USAGE_OSC_SYSTEM_MENU_SELECT	0x00010089
#define HID_USAGE_RTC_SYSTEM_MENU_RIGHT		0x0001008a
#define HID_USAGE_RTC_SYSTEM_MENU_LEFT		0x0001008b
#define HID_USAGE_RTC_SYSTEM_MENU_UP		0x0001008c
#define HID_USAGE_RTC_SYSTEM_MENU_DOWN		0x0001008d
#define HID_USAGE_OSC_SYSTEM_COLD_RESET		0x0001008e
#define HID_USAGE_OSC_SYSTEM_WARM_RESTART	0x0001008f
#define HID_USAGE_OOC_D_PAD_UP			0x00010090
#define HID_USAGE_OOC_D_PAD_DOWN		0x00010091
#define HID_USAGE_OOC_D_PAD_RIGHT		0x00010092
#define HID_USAGE_OOC_D_PAD_LEFT		0x00010093
#define HID_USAGE_OSC_SYSTEM_DOCK		0x000100a0
#define HID_USAGE_OSC_SYSTEM_UNDOCK		0x000100a1
#define HID_USAGE_OSC_SYSTEM_SETUP		0x000100a2
#define HID_USAGE_OSC_SYSTEM_BREAK		0x000100a3
#define HID_USAGE_OSC_SYSTEM_DEBUGGER_BREAK	0x000100a4
#define HID_USAGE_OSC_APPLICATION_BREAK		0x000100a5
#define HID_USAGE_OSC_APPLICATION_DEBUGGER_BREAK 0x000100a6
#define HID_USAGE_OSC_SYSTEM_SPEAKER_MUTE	0x000100a7
#define HID_USAGE_OSC_SYSTEM_HIBERNATE		0x000100a8
#define HID_USAGE_OSC_SYSTEM_DISPLAY_INVERT	0x000100b0
#define HID_USAGE_OSC_SYSTEM_DISPLAY_INTERNAL	0x000100b1
#define HID_USAGE_OSC_SYSTEM_DISPLAY_EXTERNAL	0x000100b2
#define HID_USAGE_OSC_SYSTEM_DISPLAY_BOTH	0x000100b3
#define HID_USAGE_OSC_SYSTEM_DISPLAY_DUAL	0x000100b4
#define HID_USAGE_OSC_SYSTEM_DISPLAY_TOGGLE_INT_EXT 0x000100b5
#define HID_USAGE_OSC_SYSTEM_DISPLAY_SWAP_PRIMARY_SECONDARY 0x000100b6
#define HID_USAGE_OSC_SYSTEM_DISPLAY_LCD_AUTOSCALE 0x000100b7

#define HID_USAGE_KEYBOARD			0x00070000
#define HID_USAGE_KEYBOARD_NO_EVENT		0x00070000
#define HID_USAGE_KEYBOARD_ROLL_OVER		0x00070001
#define HID_USAGE_KEYBOARD_POST_FAIL		0x00070002
#define HID_USAGE_KEYBOARD_ERROR_UNDEFINED	0x00070003
#define HID_USAGE_KEYBOARD_MASK			0x0000ffff
#define HID_USAGE_LED				0x00080000
#define HID_USAGE_LED_MASK			0x0000ffff
#define HID_USAGE_OOC_LED_NUM_LOCK		0x00080001
#define HID_USAGE_OOC_LED_CAPS_LOCK		0x00080002
#define HID_USAGE_OOC_LED_SCROLL_LOCK		0x00080003
#define HID_USAGE_OOC_LED_COMPOSE		0x00080004
#define HID_USAGE_OOC_LED_KANA			0x00080005
#define HID_USAGE_OOC_LED_POWER			0x00080006
#define HID_USAGE_OOC_LED_SHIFT			0x00080007
#define HID_USAGE_BUTTON			0x00090000
#define HID_USAGE_BUTTON_MASK			0x0000ffff
#define HID_USAGE_BUTTON_1			0x00090001
#define HID_USAGE_UM_ORDINAL			0x000a0000
#define HID_USAGE_UM_ORDINAL_MASK		0x0000ffff
#define HID_USAGE_UM_ORDINAL_1			0x000a0001

#define HID_USAGE_CONSUMER_CONTROL_NO_EVENT	0x000c0000
#define HID_USAGE_CA_CONSUMER_CONTROL		0x000c0001
#define HID_USAGE_NAry_NUMERIC_KEY_PAD		0x000c0002
#define HID_USAGE_NAry_PROGRAMMABLE_BUTTONS	0x000c0003
#define HID_USAGE_CA_MICROPHONE			0x000c0004
#define HID_USAGE_CA_HEADPHONE			0x000c0005
#define HID_USAGE_CA_GRAPHIC_EQUALIZER		0x000c0006

#endif
