#ifndef __EAPOL_EAP_H
#define __EAPOL_EAP_H

#include <SYS/TYPES.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/AC.H>
#include <SPAD/LIBC.H>

#if 0
#define debug(x) __debug_printf x
#else
#define debug(x)
#endif

#define EAP_MAXNAMELEN	24

typedef struct {
	__u8 code;
	__u8 id;
	__u16 length;
	__u8 type;
	__u8 vendor[3];
	__u32 exp_type;
} EAP_FRAME;

#define EAP_HEADER_SIZE		4
#define EAP_REQ_HEADER_SIZE	5
#define EAP_EXP_HEADER_SIZE	8

#define EAP_CODE_REQUEST	0x01
#define EAP_CODE_RESPONSE	0x02
#define EAP_CODE_SUCCESS	0x03
#define EAP_CODE_FAILURE	0x04

#define EAP_TYPE_IDENTITY	0x01
#define EAP_TYPE_NOTIFICATION	0x02
#define EAP_TYPE_NAK		0x03
#define EAP_TYPE_MD5_CHALLENGE	0x04
#define EAP_TYPE_OTP		0x05
#define EAP_TYPE_GTC		0x06
#define EAP_TYPE_TLS		0x0d
#define EAP_TYPE_LEAP		0x11
#define EAP_TYPE_SIM		0x12
#define EAP_TYPE_TTLS		0x15
#define EAP_TYPE_AKA		0x17
#define EAP_TYPE_PEAP		0x19
#define EAP_TYPE_MSCHAPV2	0x1a
#define EAP_TYPE_TLV		0x21
#define EAP_TYPE_FAST		0x2b
#define EAP_TYPE_PAX		0x2e
#define EAP_TYPE_EXPANDED	0xfe

#define EAP_MTU			1496

#define EAP_DEFAULT_IDENTITY	"SPAD"

#define EAP_MAX_DATA_LENGTH		(EAP_MTU - EAP_EXP_HEADER_SIZE)
#define EAP_MAX_RECEIVED_DATA_LENGTH	(EAP_MTU - EAP_REQ_HEADER_SIZE)
#define EAP_MAX_OFFERS			128

typedef struct __eap EAP;

struct __eap {
	void (*send_packet)(EAP *eap);
	void (*offer_callback)(EAP *eap);
	void (*progress_callback)(EAP *eap);
	void (*end_callback)(EAP *eap, int status);
	void (*log_callback)(EAP *eap, int level, __const__ char *msg);
	int (*status_callback)(EAP *eap, char msg[__MAX_STR_LEN]);
	XLIST_HEAD offers;
	__u64 offers_seq;
	unsigned top_priority;
	__u8 last_id;
	char can_repeat_packet;
	char was_expanded;
	char waiting_for_userspace;
	char something_received;
	WQ userspace_wait;
	__u64 magic;
	__s32 method_vendor;
	__u32 method_type;
	char method_name[EAP_MAXNAMELEN + 1];
	unsigned packet_length;
	__u8 packet[EAP_MTU];
	unsigned received_data_code;
	unsigned received_data_length;
	__u8 received_data[EAP_MAX_RECEIVED_DATA_LENGTH];
	char identity[__MAX_STR_LEN];
	char failure_reason[__MAX_STR_LEN];
};

#define EAP_LOG_LOCAL_ERROR		0
#define EAP_LOG_ERROR			1
#define EAP_LOG_WARNING			2

	/* must not collide with 8-bit packet codes */
#define EAP_END_SUCCESS			0x0100
#define EAP_END_FAILURE_RETRY		0x0101
#define EAP_END_FAILURE_HOLD		0x0102
#define EAP_END_PROTOCOL_VIOLATION	0x0103
#define EAP_END_IDLE			0x0104

	/* status_callback returns */
#define STATE_IDLE		0
#define STATE_CONNECTING	1
#define STATE_AUTHENTICATING	2
#define STATE_AUTHENTICATED	3

void EAP_INIT(EAP *eap);
void EAP_DONE(EAP *eap);
void EAP_RESET(EAP *eap);
int EAP_HAVE_OFFERS(EAP *eap);
int EAP_HAVE_NONEMPTY_OFFERS(EAP *eap);
void EAP_REQUEST(EAP *eap, EAP_FRAME *ef);
void EAP_SUCCESS(EAP *eap);
void EAP_FAILURE(EAP *eap);

void EAP_IOCTL(EAP *eap, IOCTLRQ *RQ);

typedef struct offer {
	__u64 magic;
	__u64 offers_seq;
	struct {	/* must match EAP_OFFER */
		__u32 vendor;
		__u32 type;
		char name[EAP_MAXNAMELEN];
	} offers[EAP_MAX_OFFERS];
} EAP_OFFER_REQUEST;

typedef struct {
	__u64 magic;
	__u32 vendor;
	__u32 type;
	unsigned code;
	unsigned data_length;
	__u8 data[EAP_MAX_RECEIVED_DATA_LENGTH];
} EAP_PACKET_REQUEST;

#endif
