#ifndef __EAPOL_EAPOL_H
#define __EAPOL_EAPOL_H

#include <SYS/TYPES.H>
#include <SPAD/PKT.H>
#include <SPAD/TIMER.H>

#include "EAP.H"

#define EAPOL_MULTICAST_ADDRESS	{ 0x01, 0x80, 0xc2, 0x00, 0x00, 0x03 }

typedef struct {
	__u8 version;
	__u8 type;
	__u16 length;
	/* ... EAP packet */
} EAPOL_FRAME;

#define EAPOL_HEADER_SIZE	4

#define EAPOL_VERSION		0x01

#define EAPOL_TYPE_EAP		0x00
#define EAPOL_TYPE_START	0x01
#define EAPOL_TYPE_LOGOFF	0x02
#define EAPOL_TYPE_KEY		0x03
#define EAPOL_TYPE_ASF_ALERT	0x04

#define PKT2EAPOL(p)	((EAPOL_FRAME *)(&p->data[LL_HEADER]))
#define PKT2EAP(p)	((EAP_FRAME *)(&p->data[LL_HEADER + EAPOL_HEADER_SIZE]))

#define EAP_START_MIN_JIFFIES	(JIFFIES_PER_SECOND * 4)
#define EAP_START_MAX_JIFFIES	(JIFFIES_PER_SECOND * 60)

#define EAP_AUTH_JIFFIES	(JIFFIES_PER_SECOND * 30)
#define EAP_HOLD_JIFFIES	(JIFFIES_PER_SECOND * 60)
#define EAP_RETRY_JIFFIES	(JIFFIES_PER_SECOND)
#define EAP_LINKUP_JIFFIES	(JIFFIES_PER_SECOND / 20)

#endif
