#include <SPAD/LIBC.H>
#include <STDLIB.H>
#include <STRING.H>
#include <PTHREAD.H>
#include <OPENSSL/ERR.H>

#include "ROOTER.H"

void lock_ssl(void)
{
	int r = pthread_mutex_lock(&ssl_lock);
	if (__unlikely(r)) {
		KERNEL$SUICIDE("CAN'T LOCK PTHREAD MUTEX: %s\n", strerror(r));
	}
	while (__unlikely(ERR_get_error() != 0)) ;
}

void unlock_ssl(void)
{
	int r = pthread_mutex_unlock(&ssl_lock);
	if (__unlikely(r)) {
		KERNEL$SUICIDE("CAN'T UNLOCK PTHREAD MUTEX: %s\n", strerror(r));
	}
}

void assert_ssl_lock(char *name)
{
	int r = pthread_mutex_trylock(&ssl_lock);
	if (__unlikely(r != EBUSY) && __unlikely(r != EDEADLK)) {
		if (!r) KERNEL$SUICIDE("assert_ssl_lock: MUTEX NOT LOCKED AT %s", name);
		else KERNEL$SUICIDE("assert_ssl_lock: pthread_mutex_trylock RETURNED %d AT %s", r, name);
	}
}

void new_ssl_ctx(SSL_CTX **p)
{
	assert_ssl_lock("new_ssl_ctx");
	if (*p) goto ret;
	SSL_library_init();
	*p = SSL_CTX_new(TLSv1_method());
	ret:;
}

void new_x509_store(X509_STORE **p)
{
	assert_ssl_lock("new_x509_store");
	if (*p) goto ret;
	SSL_library_init();
	*p = X509_STORE_new();
	ret:;
}

void print_ssl_errors(void)
{
	assert_ssl_lock("print_ssl_errors");
	SSL_load_error_strings();
	ERR_print_errors_fp(stderr);
}

void clear_ssl_errors(void)
{
	assert_ssl_lock("clear_ssl_errors");
	ERR_clear_error();
}
