#include <SPAD/PKT.H>
#include <SPAD/LIBC.H>
#include <STRING.H>

char *NET$PRINT_STRING(char str[__MAX_STR_LEN], __u8 *string, unsigned len)
{
	unsigned i, j;
	for (i = 0, j = 0; i < __MAX_STR_LEN - 1 && j < len; j++) {
		if (__likely(string[j] >= ' ')) str[i++] = string[j];
		else if (string[j] == '\n') str[i++] = ' ';
	}
	str[i] = 0;
	return str;
}

char *NET$PRINT_HWADDR(char str[__MAX_STR_LEN], __u8 *hwaddr, int hwaddrlen)
{
	char *ostr, *e;
	if (__unlikely(!hwaddrlen)) {
		strlcpy(str, "NONE", __MAX_STR_LEN);
		return str;
	}
	ostr = str;
	e = str + __MAX_STR_LEN;
	*str = 0;
	while (hwaddrlen--) {
		_snprintf(str, e - str, "%02X%s", *hwaddr++, hwaddrlen ? ":" : "");
		str += strlen(str);
	}
	return ostr;
}

char *NET$PRINT_LINK_STATE(char str[__MAX_STR_LEN], LINK_STATE_PHYS *ls)
{
	char *ostr, *e;
	ostr = str;
	e = str + __MAX_STR_LEN;
	str[0] = 0;
	if (__unlikely(!(ls->flags & (LINK_STATE_UP | LINK_STATE_UNKNOWN)))) {
		_snprintf(str, e - str, "LINK DOWN");
		str += strlen(str);
		if (__unlikely(ls->flags & LINK_STATE_AUTO_NEGOTIATION_FAILED)) {
			_snprintf(str, e - str, " AUTO-NEGOTIATION FAILED");
			str += strlen(str);
		}
		goto failed_entries;
	} else if (__unlikely(ls->flags & LINK_STATE_UNKNOWN)) {
		_snprintf(str, e - str, "LINK STATE UNKNOWN");
		str += strlen(str);
	} else {
		_snprintf(str, e - str, "LINK UP");
		str += strlen(str);
	}
	if (__likely(ls->speed != 0)) {
		if (ls->speed >= 1000000000) {
			_snprintf(str, e - str, " %luG", (unsigned long)(ls->speed >> 9) / (1000000000 >> 9));
			str += strlen(str);
		} else if (ls->speed >= 1000000) {
			_snprintf(str, e - str, " %luM", (unsigned long)ls->speed / 1000000);
			str += strlen(str);
		} else if (ls->speed >= 1000) {
			_snprintf(str, e - str, " %luK", (unsigned long)ls->speed / 1000);
			str += strlen(str);
		} else {
			_snprintf(str, e - str, " %luB", (unsigned long)ls->speed);
			str += strlen(str);
		}
	}
	if (__likely(ls->flags & LINK_STATE_FULL_DUPLEX)) {
		_snprintf(str, e - str, " FULL-DUPLEX");
		str += strlen(str);
	} else if (__likely(ls->flags & LINK_STATE_HALF_DUPLEX)) {
		_snprintf(str, e - str, " HALF-DUPLEX");
		str += strlen(str);
	}
	if (__unlikely(ls->flags & LINK_STATE_AUTO_NEGOTIATION_FAILED)) {
		_snprintf(str, e - str, " AUTO-NEGOTIATION FAILED");
		str += strlen(str);
	} else if (__likely(ls->flags & LINK_STATE_AUTO_NEGOTIATION)) {
		_snprintf(str, e - str, " AUTO-NEGOTIATION");
		str += strlen(str);
	}
	failed_entries:
	if (__unlikely(ls->flags & LINK_STATE_REMOTE_FAULT)) {
		_snprintf(str, e - str, " REMOTE FAULT");
		str += strlen(str);
	}
	if (__unlikely(ls->flags & LINK_STATE_JABBER)) {
		_snprintf(str, e - str, " JABBER");
		str += strlen(str);
	}
	if (__likely(ls->desc[0])) {
		_snprintf(str, e - str, " %s", ls->desc);
		str += strlen(str);
	}
	if (__unlikely(ls->flags & LINK_STATE_MEDIA_AUTOSELECT)) {
		_snprintf(str, e - str, " AUTOSELECT");
		str += strlen(str);
	}
	return ostr;
}

