#define RECV_POLLING(xl)	(V2(xl))
#define XMIT_POLLING(xl)	(V2(xl))

static int XL_WAIT(XL *xl, char *msg)
{
	unsigned cnt = 0;
	while (__unlikely(XL_READ_16(xl, XL_IntStatusCmd) & XL_IntStatus_CmdInProgress)) {
		if (__unlikely(++cnt >= XL_COMMAND_TIMEOUT)) {
			if (__unlikely(XL_READ_16(xl, XL_IntStatusCmd) == 0xffff)) xl->flags |= FLAG_DEAD;
			if (msg && !(xl->flags & FLAG_DEAD)) KERNEL$SYSLOG(__SYSLOG_HW_BUG, xl->dev_name, "TIMED OUT WHEN WAITING FOR COMMAND %s", msg);
			return 1;
		}
		KERNEL$UDELAY(1);
	}
	return 0;
}

static __finline__ void XL_WINDOW(XL *xl, unsigned win)
{
	XL_WRITE_16(xl, XL_IntStatusCmd, X2_Cmd_SetRegisterWindow | win);
}

static __finline__ void THE_PCMCIA_PEOPLE_ARE_IDIOTS(XL *xl)
{
/* I don't know what this does, but linux has it too ... with the comment
   about idiocy */
	if (__unlikely(xl->flags & CARDBUS)) mmio_outl(xl->cb_mem + 4, 0x8000);
}

