#ifndef __NIC_IPGREG_H
#define __NIC_IPGREG_H

#define IPG_IO_REGSPACE		8

#define IPG_REGSPACE		0x20000

#define IPG_CTRL		0x0000
#define  IPG_CTRL_FD			0x00000001
#define  IPG_CTRL_LRST			0x00000008
#define  IPG_CTRL_ASDE			0x00000020
#define  IPG_CTRL_SLU			0x00000040
#define  IPG_CTRL_ILOS			0x00000080
#define  IPG_CTRL_SPEED			0x00000300
#define   IPG_CTRL_SPEED_10			0x00000000
#define   IPG_CTRL_SPEED_100			0x00000100
#define   IPG_CTRL_SPEED_1000			0x00000200
#define  IPG_CTRL_FRCSPD		0x00000800
#define  IPG_CTRL_FRCDPLX		0x00001000
#define  IPG_CTRL_SDP0_DATA		0x00040000
#define  IPG_CTRL_SDP1_DATA		0x00080000
#define  IPG_CTRL_SDP2_DATA		0x00100000
#define  IPG_CTRL_SDP3_DATA		0x00200000
#define  IPG_CTRL_ADVD3WUC		0x00100000
#define  IPG_CTRL_EN_PHY_PWR_MGMT	0x00200000
#define  IPG_CTRL_SDP0_IODIR		0x00400000
#define  IPG_CTRL_SDP1_IODIR		0x00800000
#define  IPG_CTRL_SDP2_IODIR		0x01000000
#define  IPG_CTRL_SDP3_IODIR		0x02000000
#define  IPG_CTRL_RST			0x04000000
#define  IPG_CTRL_RFCE			0x08000000
#define  IPG_CTRL_TFCE			0x10000000
#define  IPG_CTRL_VME			0x40000000
#define  IPG_CTRL_PHY_RST		0x80000000
#define  IPG_CTRL_BEM			0x00000002
#define  IPG_CTRL_PRIOR			0x00000004
#define  IPG_CTRL_GIO_MASTER_DISABLE	0x00000004
#define  IPG_CTRL_TME			0x00000010
#define  IPG_CTRL_SLE			0x00000020
#define  IPG_CTRL_BEM32			0x00000400
#define  IPG_CTRL_D_UD_EN		0x00002000
#define  IPG_CTRL_D_UD_POLARITY		0x00004000
#define  IPG_CTRL_FORCE_PHY_RESET	0x00008000
#define  IPG_CTRL_LINK_EXT_EN		0x00010000
#define  IPG_CTRL_RTE			0x20000000
#define  IPG_CTRL_PHY_RESET_DIR		IPG_CTRL_SDP0_IODIR
#define  IPG_CTRL_PHY_RESET		IPG_CTRL_SDP0_DATA
#define  IPG_CTRL_MDIO_DIR		IPG_CTRL_SDP2_IODIR
#define  IPG_CTRL_MDIO			IPG_CTRL_SDP2_DATA
#define  IPG_CTRL_MDC_DIR		IPG_CTRL_SDP3_IODIR
#define  IPG_CTRL_MDC			IPG_CTRL_SDP3_DATA
#define IPG_CTRL_DUP		0x0004
#define IPG_STATUS		0x0008
#define  IPG_STATUS_FD			0x00000001
#define  IPG_STATUS_LU			0x00000002
#define  IPG_STATUS_FUNCTION_1		0x00000004
#define  IPG_STATUS_FUNCTION_ID		0x0000000c
#define  IPG_STATUS_TXOFF		0x00000010
#define  IPG_STATUS_TBIMODE		0x00000020
#define  IPG_STATUS_SPEED		0x000000c0
#define  IPG_STATUS_ASDV		0x00000300
#define  IPG_STATUS_PCI66		0x00000800
#define  IPG_STATUS_BUS64		0x00001000
#define  IPG_STATUS_PCIX_MODE		0x00002000
#define  IPG_STATUS_PCIXSPD		0x0000c000
#define  IPG_STATUS_LAN_INIT_DONE	0x00000200
#define  IPG_STATUS_MTXCKOK		0x00000400
#define  IPG_STATUS_GIO_MASTER_ENABLE	0x00080000
#define  IPG_STATUS_BMC_SKU_0		0x00100000
#define  IPG_STATUS_BMC_SKU_1		0x00200000
#define  IPG_STATUS_BMC_SKU_2		0x00400000
#define  IPG_STATUS_BMC_CRYPTO		0x00800000
#define  IPG_STATUS_BMC_LITE		0x01000000
#define  IPG_STATUS_RGMII_ENABLE	0x02000000
#define  IPG_STATUS_FUSE_8		0x04000000
#define  IPG_STATUS_FUSE_9		0x08000000
#define  IPG_STATUS_SERDES0_DIS		0x10000000
#define  IPG_STATUS_SERDES1_DIS		0x20000000
#define IPG_EECD		0x0010
#define  IPG_EECD_SK			0x00000001
#define  IPG_EECD_CS			0x00000002
#define  IPG_EECD_DI			0x00000004
#define  IPG_EECD_DO			0x00000008
#define  IPG_EECD_FWE			0x00000030
#define  IPG_EECD_FWE_DIS		0x00000010
#define  IPG_EECD_FWE_EN		0x00000020
#define  IPG_EECD_EE_REQ		0x00000040
#define  IPG_EECD_EE_GNT		0x00000080
#define  IPG_EECD_EE_PRES		0x00000100
#define  IPG_EECD_EE_SIZE		0x00000200
#define  IPG_EECD_EE_SIZE_2		0x00000400
#define  IPG_EECD_EE_TYPE		0x00002000
#define  IPG_EECD_AUTO_RD		0x00000200
#define  IPG_EECD_SIZE_EX_MASK		0x00007800
#define  IPG_EECD_NVADDS		0x00018000
#define  IPG_EECD_SELSHAD		0x00020000
#define  IPG_EECD_INITSRAM		0x00040000
#define  IPG_EECD_FLUPD			0x00080000
#define  IPG_EECD_AUPDEN		0x00100000
#define  IPG_EECD_SHADV			0x00200000
#define  IPG_EECD_SEC1VAL		0x00400000
#define IPG_EERD		0x0014
#define  IPG_EERD_START			0x00000001
#define  IPG_EERD_DONE			0x00000010
#define  IPG_EERD_ADDR			0x0000ff00
#define  IPG_EERD_DONE_2		0x00000002
#define  IPG_EERD_ADDR_2		0x0000fffc
#define  IPG_EERD_DATA			0xffff0000
#define IPG_CTRL_EXT		0x0018
#define  IPG_CTRL_EXT_GPI0_EN		0x00000001
#define  IPG_CTRL_EXT_GPI1_EN		0x00000002
#define  IPG_CTRL_EXT_PHYINT_EN		IPG_CTRL_EXT_GPI1_EN
#define  IPG_CTRL_EXT_GPI2_EN		0x00000004
#define  IPG_CTRL_EXT_GPI3_EN		0x00000008
#define  IPG_CTRL_EXT_SDP4_DATA		0x00000010
#define  IPG_CTRL_EXT_SDP5_DATA		0x00000020
#define  IPG_CTRL_EXT_PHYINT		IPG_CTRL_EXT_SDP5_DATA
#define  IPG_CTRL_EXT_SDP6_DATA		0x00000040
#define  IPG_CTRL_EXT_SDP7_DATA		0x00000080
#define  IPG_CTRL_EXT_SDP4_IODIR	0x00000100
#define  IPG_CTRL_EXT_SDP5_IODIR	0x00000200
#define  IPG_CTRL_EXT_SDP6_IODIR	0x00000400
#define  IPG_CTRL_EXT_SDP7_IODIR	0x00000800
#define  IPG_CTRL_EXT_ASDCHK		0x00001000
#define  IPG_CTRL_EXT_EE_RST		0x00002000
#define  IPG_CTRL_EXT_SPD_BYPS		0x00008000
#define  IPG_CTRL_EXT_RO_DIS		0x00020000
#define  IPG_CTRL_EXT_VREG_POWER_DOWN	0x00200000
#define  IPG_CTRL_EXT_LINK_MODE		0x00c00000
#define  IPG_CTRL_EXT_SWDPINSHI		0x000000d0
#define  IPG_CTRL_EXT_SWDPIOHI		0x00000d00
#define  IPG_CTRL_EXT_ASDCHK		0x00001000
#define  IPG_CTRL_EXT_EE_RST		0x00002000
#define  IPG_CTRL_EXT_IPS		0x00004000
#define  IPG_CTRL_EXT_SPD_BYPS		0x00008000
#define  IPG_CTRL_EXT_IPS1		0x00010000
#define  IPG_CTRL_EXT_RO_DIS		0x00020000
#define  IPG_CTRL_EXT_PHY_RESET_DIR4	IPG_CTRL_EXT_SDP4_IODIR
#define  IPG_CTRL_EXT_PHY_RESET4	IPG_CTRL_EXT_SDP4_DATA
#define IPG_FLA			0x001c
#define  IPG_FLA_FL_SCK			0x00000001
#define  IPG_FLA_FL_CE			0x00000002
#define  IPG_FLA_FL_SI			0x00000004
#define  IPG_FLA_FL_SO			0x00000008
#define  IPG_FLA_FL_REQ			0x00000010
#define  IPG_FLA_FL_GNT			0x00000020
#define  IPG_FLA_FL_BUSY		0x40000000
#define  IPG_FLA_FL_ER			0x80000000
#define IPG_MDIC		0x0020
#define  IPG_MDIC_DATA			0x0000ffff
#define  IPG_MDIC_REGADD		0x001f0000
#define  IPG_MDIC_PHYADD		0x03e00000
#define  IPG_MDIC_OP			0x0c000000
#define  IPG_MDIC_OP_WRITE		0x04000000
#define  IPG_MDIC_OP_READ		0x08000000
#define  IPG_MDIC_R			0x10000000
#define  IPG_MDIC_I			0x20000000
#define  IPG_MDIC_E			0x40000000
#define IPG_SCTL		0x0024
#define  IPG_SCTL_DISABLE_LOOPBACK	0x00000400
#define IPG_FCAL		0x0028
#define IPG_FCAH		0x002c
#define IPG_FCT			0x0030
#define IPG_KUMCTRLSTA		0x0034
#define  IPG_KUMCTRLSTA_MASK		0x0000ffff
#define  IPG_KUMCTRLSTA_OFFSET		0x001f0000
#define  IPG_KUMCTRLSTA_REN		0x00200000
#define IPG_VET			0x0038
#define IPG_MDPHYA		0x003c
#define IPG_ICR			0x00c0
#define  IPG_ICR_TXDW			0x00000001
#define  IPG_ICR_TXQE			0x00000002
#define  IPG_ICR_LSC			0x00000004
#define  IPG_ICR_RXSEQ			0x00000008
#define  IPG_ICR_RXDMT0			0x00000010
#define  IPG_ICR_RXO			0x00000040
#define  IPG_ICR_RXTO			0x00000080
#define  IPG_ICR_MDAC			0x00000200
#define  IPG_ICR_RXCFG			0x00000400
#define  IPG_ICR_PHYINT			0x00001000
#define  IPG_ICR_GPI_SDP62		0x00002000
#define  IPG_ICR_GPI_SDP73		0x00004000
#define  IPG_ICR_TXD_LOW		0x00008000
#define  IPG_ICR_SRPD			0x00010000
#define IPG_ITR			0x00c4
#define IPG_ICS			0x00c8
#define IPG_IMS			0x00d0
#define IPG_IMC			0x00d8
#define IPG_RCTL		0x0100
#define  IPG_RCTL_RST			0x00000001
#define  IPG_RCTL_EN			0x00000002
#define  IPG_RCTL_SBP			0x00000004
#define  IPG_RCTL_UPE			0x00000008
#define  IPG_RCTL_MPE			0x00000010
#define  IPG_RCTL_LPE			0x00000020
#define  IPG_RCTL_LBM			0x000000c0
#define  IPG_RCTL_RDMTS			0x00000300
#define  IPG_RCTL_MO			0x00003000
#define  IPG_RCTL_MDR			0x00004000
#define  IPG_RCTL_BAM			0x00008000
#define  IPG_RCTL_BSIZE			0x00030000
#define  IPG_RCTL_VFE			0x00040000
#define  IPG_RCTL_CFIEN			0x00080000
#define  IPG_RCTL_CFI			0x00100000
#define  IPG_RCTL_DPF			0x00400000
#define  IPG_RCTL_PMCF			0x00800000
#define  IPG_RCTL_BSEX			0x02000000
#define  IPG_RCTL_SECRC			0x04000000
#define  IPG_RCTL_FLXBUF_MASK		0x78000000
#define IPG_FCTTV		0x0170
#define IPG_TXCW		0x0178
#define  IPG_TXCW_TXCONFIGWORD		0x0000ffff
#define  IPG_TXCW_FD			0x00000020
#define  IPG_TXCW_HD			0x00000040
#define  IPG_TXCW_PAUSE			0x00000080
#define  IPG_TXCW_ASM_DIR		0x00000100
#define  IPG_TXCW_PAUSE_MASK		0x00000180
#define  IPG_TXCW_RF			0x00003000
#define  IPG_TXCW_NP			0x00008000
#define  IPG_TXCW_TXCONFIG		0x40000000
#define  IPG_TXCW_ANE			0x80000000
#define IPG_RXCW		0x0180
#define  IPG_RXCW_RXCONFIGWORD		0x0000ffff
#define  IPG_RXCW_RXCONFIGNOCARRIER	0x04000000
#define  IPG_RXCW_RXCONFIGINVALID	0x08000000
#define  IPG_RXCW_RXCONFIGCHANGE	0x10000000
#define  IPG_RXCW_RXCONFIG		0x20000000
#define  IPG_RXCW_RXSYNCHRONIZE		0x40000000
#define  IPG_RXCW_ANC			0x80000000
#define IPG_TCTL		0x0400
#define  IPG_TCTL_RST			0x00000001
#define  IPG_TCTL_EN			0x00000002
#define  IPG_TCTL_BCE			0x00000004
#define  IPG_TCTL_PSP			0x00000008
#define  IPG_TCTL_CT			0x00000ff0
#define  IPG_TCTL_COLD			0x003ff000
#define  IPG_TCTL_SWXOFF		0x00400000
#define  IPG_TCTL_PBE			0x00800000
#define  IPG_TCTL_RTLC			0x01000000
#define  IPG_TCTL_NRTU			0x02000000
#define  IPG_TCTL_MULR			0x10000000
#define IPG_TCTL_EXT		0x0404
#define  IPG_TCTL_EXT_BST_MASK		0x000003ff
#define  IPG_TCTL_EXT_GCEX_MASK		0x000ffc00
#define  IPG_TCTL_EXT_GCEX_DEFAULT	0x00010000
#define IPG_TIPG		0x0410
#define  IPG_TIPG_IPGT			0x000003ff
#define  IPG_TIPG_IPGT_DEFAULT_1000	0x00000008
#define  IPG_TIPG_IPGT_DEFAULT_10_100	0x00000009
#define  IPG_TIPG_IPGR1			0x000ffc00
#define  IPG_TIPG_IPGR2			0x3ff00000
#define IPG_AIFS		0x0458
#define IPG_LEDCTL		0x0e00
#define  IPG_LEDCTL_LED0_MOD		0x0000000f
#define  IPG_LEDCTL_LED0_IVRT		0x00000040
#define  IPG_LEDCTL_LED0_BLINK		0x00000080
#define  IPG_LEDCTL_LED1_MOD		0x00000f00
#define  IPG_LEDCTL_LED1_IVRT		0x00004000
#define  IPG_LEDCTL_LED1_BLINK		0x00008000
#define  IPG_LEDCTL_LED2_MOD		0x000f0000
#define  IPG_LEDCTL_LED2_IVRT		0x00400000
#define  IPG_LEDCTL_LED2_BLINK		0x00800000
#define  IPG_LEDCTL_LED3_MOD		0x0f000000
#define  IPG_LEDCTL_LED3_IVRT		0x40000000
#define  IPG_LEDCTL_LED3_BLINK		0x80000000
#define IPG_EXTCNF_CTRL		0x0f00
#define  IPG_EXTCNF_CTRL_PCIE_WRITE_ENABLE	0x00000001
#define  IPG_EXTCNF_CTRL_PHY_WRITE_ENABLE	0x00000002
#define  IPG_EXTCNF_CTRL_D_UD_ENABLE		0x00000004
#define  IPG_EXTCNF_CTRL_D_UD_LATENCY		0x00000008
#define  IPG_EXTCNF_CTRL_D_UD_OWNER		0x00000010
#define  IPG_EXTCNF_CTRL_MDIO_SW_OWNERSHIP	0x00000020
#define  IPG_EXTCNF_CTRL_MDIO_HW_OWNERSHIP	0x00000040
#define  IPG_EXTCNF_CTRL_EXT_CNF_POINTER	0x0fff0000
#define  IPG_EXTCNF_CTRL_LCD_WRITE_ENABLE	0x00000001
#define  IPG_EXTCNF_CTRL_SWFLAG			0x00000020
#define IPG_EXTCNF_SIZE		0x0f08
#define  IPG_EXTCNF_SIZE_EXT_PHY_LENGTH		0x000000ff
#define  IPG_EXTCNF_SIZE_EXT_DOCK_LENGTH	0x0000ff00
#define  IPG_EXTCNF_SIZE_EXT_PCIE_LENGTH	0x00ff0000
#define IPG_PHY_CTRL		0x0f10
#define  IPG_PHY_CTRL_SPD_EN			0x00000001
#define  IPG_PHY_CTRL_D0A_LPLU			0x00000002
#define  IPG_PHY_CTRL_NOND0A_LPLU		0x00000004
#define  IPG_PHY_CTRL_NOND0A_GBE_DISABLE	0x00000008
#define  IPG_PHY_CTRL_GBE_DISABLE		0x00000040
#define  IPG_PHY_CTRL_B2B_EN			0x00000080
#define IPG_PBA			0x1000
#define  IPG_PBA_8K			0x0008
#define  IPG_PBA_12K			0X000c
#define  IPG_PBA_16K			0x0010
#define  IPG_PBA_22K			0x0016
#define  IPG_PBA_24K			0x0018
#define  IPG_PBA_30K			0x001e
#define  IPG_PBA_32K			0x0020
#define  IPG_PBA_34K			0x0022
#define  IPG_PBA_38K			0x0026
#define  IPG_PBA_40K			0x0028
#define  IPG_PBA_48K			0x0030
#define IPG_PBS			0x1008
#define IPG_EEMNGCTL		0x1010
#define  IPG_EEMNGCTL_CFG_DONE		0x00040000
#define  IPG_EEMNGCTL_CFG_DONE_PORT_1	0x00080000
#define IPG_FCRTL		0x2160
#define  IPG_FCRTL_RTL			0x0000fff8
#define  IPG_FCRTL_XONE			0x80000000
#define IPG_FCRTH		0x2168
#define  IPG_FCRTH_RTH			0x0000fff8
#define  IPG_FCRTH_XFCE			0x80000000
#define IPG_RDFH		0x2410
#define IPG_RDFT		0x2418
#define IPG_RDFHS		0x2420
#define IPG_RDFTS		0x2428
#define IPG_RDFPC		0x2430
#define IPG_RDBAL		0x2800
#define IPG_RDBAH		0x2804
#define IPG_RDLEN		0x2808
#define IPG_RDH			0x2810
#define IPG_RDT			0x2818
#define IPG_RDTR		0x2820
#define  IPG_RDTR_DELAY			0x0000ffff
#define  IPG_RDTR_FPD			0x80000000
#define IPG_RXDCTL		0x2828
#define  IPG_RXDCTL_PTHRESH		0x0000003f
#define  IPG_RXDCTL_HTHRESH		0x0000ff00
#define  IPG_RXDCTL_WTHRESH		0x003f0000
#define  IPG_RXDCTL_GRAN		0x01000000
#define IPG_RADV		0x282c
#define IPG_RSRPD		0x2c00
#define IPG_TXDMAC		0x3000
#define  IPG_TXDMAC_DPP			0x00000001
#define IPG_KABGTXD		0x3004
#define  IPG_KABGTXD_BGSQLBIAS		0x00050000
#define IPG_TDFH		0x3410
#define IPG_TDFT		0x3418
#define IPG_TDFHS		0x3420
#define IPG_TDFTS		0x3428
#define IPG_TDFPC		0x3430
#define IPG_TDBAL		0x3800
#define IPG_TDBAH		0x3804
#define IPG_TDLEN		0x3808
#define IPG_TDH			0x3810
#define IPG_TDT			0x3818
#define IPG_TIDV		0x3820
#define IPG_TXDCTL		0x3828
#define  IPG_TXDCTL_PTHRESH		0x0000003f
#define  IPG_TXDCTL_HTHRESH		0x00003f00
#define  IPG_TXDCTL_WTHRESH		0x003f0000
#define  IPG_TXDCTL_COUNT_DESC		0x00400000
#define  IPG_TXDCTL_GRAN		0x01000000
#define  IPG_TXDCTL_LWTHRESH		0xfe000000
#define IPG_TADV		0x382c
#define IPG_TSPMT		0x3830
#define  IPG_TSPMT_TSMT			0x0000ffff
#define  IPG_TSPMT_TSPBP		0xffff0000
#define IPG_TARC0		0x3840
#define IPG_TDBAL1		0x3900
#define IPG_TDBAH1		0x3904
#define IPG_TDLEN1		0x3908
#define IPG_TDH1		0x3910
#define IPG_TDT1		0x3918
#define IPG_TXDCTL1		0x3928
#define IPG_TARC1		0x3940
#define IPG_STAT_CRCERRS	0x4000
#define IPG_STAT_ALGNERRC	0x4004
#define IPG_STAT_SYMERRS	0x4008
#define IPG_STAT_RXERRC		0x400c
#define IPG_STAT_MPC		0x4010
#define IPG_STAT_SCC		0x4014
#define IPG_STAT_ECOL		0x4018
#define IPG_STAT_MCC		0x401c
#define IPG_STAT_LATECOL	0x4020
#define IPG_STAT_COLC		0x4028
#define IPG_STAT_DC		0x4030
#define IPG_STAT_TNCRS		0x4034
#define IPG_STAT_SEC		0x4038
#define IPG_STAT_CEXTERR	0x403c
#define IPG_STAT_RLEC		0x4040
#define IPG_STAT_XONRXC		0x4048
#define IPG_STAT_XONTXC		0x404c
#define IPG_STAT_XOFFRXC	0x4050
#define IPG_STAT_XOFFTXC	0x4054
#define IPG_STAT_FCRUC		0x4058
#define IPG_STAT_PRC64		0x405c
#define IPG_STAT_PRC127		0x4060
#define IPG_STAT_PRC255		0x4064
#define IPG_STAT_PRC511		0x4068
#define IPG_STAT_PRC1023	0x406c
#define IPG_STAT_PRC1522	0x4070
#define IPG_STAT_GPRC		0x4074
#define IPG_STAT_BPRC		0x4078
#define IPG_STAT_MPRC		0x407c
#define IPG_STAT_GPTC		0x4080
#define IPG_STAT_GORCL		0x4088
#define IPG_STAT_GORCH		0x408c
#define IPG_STAT_GOTCL		0x4090
#define IPG_STAT_GOTCH		0x4094
#define IPG_STAT_RNBC		0x40a0
#define IPG_STAT_RUC		0x40a4
#define IPG_STAT_RFC		0x40a8
#define IPG_STAT_ROC		0x40ac
#define IPG_STAT_RJC		0x40b0
#define IPG_STAT_MGTPRC		0x40b4
#define IPG_STAT_MGTPDC		0x40b8
#define IPG_STAT_MGTPTC		0x40bc
#define IPG_STAT_TORL		0x40c0
#define IPG_STAT_TORH		0x40c4
#define IPG_STAT_TOTL		0x40c8
#define IPG_STAT_TOTH		0x40cc
#define IPG_STAT_TPR		0x40d0
#define IPG_STAT_TPT		0x40d4
#define IPG_STAT_PTC64		0x40d8
#define IPG_STAT_PTC127		0x40dc
#define IPG_STAT_PTC255		0x40e0
#define IPG_STAT_PTC511		0x40e4
#define IPG_STAT_PTC1023	0x40e8
#define IPG_STAT_PTC1522	0x40ec
#define IPG_STAT_MPTC		0x40f0
#define IPG_STAT_BPTC		0x40f4
#define IPG_STAT_TSCTC		0x40f8
#define IPG_STAT_TSCTFC		0x40fc
#define IPG_STAT_IAC		0x4100
#define IPG_STAT_ICRXPTC	0x4104
#define IPG_STAT_ICRXATC	0x4108
#define IPG_STAT_ICTXPTC	0x410c
#define IPG_STAT_ICTXATC	0x4110
#define IPG_STAT_ICTXQEC	0x4118
#define IPG_STAT_ICTXQMTC	0x411c
#define IPG_STAT_ICRXDMTC	0x4120
#define IPG_STAT_ICRXOC		0x4124
#define IPG_RXCSUM		0x5000
#define  IPG_RXCSUM_PCSS		0x000000ff
#define  IPG_RXCSUM_IPOFLD		0x00000100
#define  IPG_RXCSUM_TUOFLD		0x00000200
#define  IPG_RXCSUM_IPV6OFL		0x00000400
#define IPG_MTA			0x5200
#define IPG_MTA_BITS		4096
#define IPG_MTA_BITS_ICH8	1024
#define IPG_RAL			0x5400
#define  IPG_RAL_RAL			0xffffffff
#define IPG_RAH			0x5404
#define  IPG_RAH_RAH			0x0000ffff
#define  IPG_RAH_AS			0x00030000
#define  IPG_RAH_AV			0x80000000
#define IPG_RA_ENTRIES		15
#define IPG_RA_ENTRIES_ICH8	6
#define IPG_VFTA		0x5600
#define IPG_WUC			0x5800
#define IPG_WUFC		0x5808
#define IPG_WUS			0x5810
#define IPG_MANC		0x5820
#define IPG_IPAV		0x5838
#define IPG_IP4AT		0x5840
#define IPG_MANC2H		0x5860
#define  IPG_MANC_SMBUS_EN		0x00000001
#define  IPG_MANC_ASF_EN		0x00000002
#define  IPG_MANC_R_ON_FORCE		0x00000004
#define  IPG_MANC_RMCP_EN		0x00000100
#define  IPG_MANC_0298_EN		0x00000200
#define  IPG_MANC_IPV4_EN		0x00000400
#define  IPG_MANC_IPV6_EN		0x00000800
#define  IPG_MANC_SNAP_EN		0x00001000
#define  IPG_MANC_ARP_EN		0x00002000
#define  IPG_MANC_NEIGHBOR_EN		0x00004000
#define  IPG_MANC_ARP_RES_EN		0x00008000
#define  IPG_MANC_RCV_TCO_EN		0x00020000
#define  IPG_MANC_REPORT_STATUS		0x00040000
#define  IPG_MANC_RCV_ALL		0x00080000
#define  IPG_MANC_BLK_PHY_RST_ON_IDE	0x00040000
#define  IPG_MANC_EN_MAC_ADDR_FILTER	0x00100000
#define  IPG_MANC_EN_MNG2HOST		0x00200000
#define  IPG_MANC_EN_IP_ADDR_FILTER	0x00400000
#define  IPG_MANC_EN_XSUM_FILTER	0x00800000
#define  IPG_MANC_BR_EN			0x01000000
#define  IPG_MANC_SMB_REQ		0x01000000
#define  IPG_MANC_SMB_GNT		0x02000000
#define  IPG_MANC_SMB_CLK_IN		0x04000000
#define  IPG_MANC_SMB_DATA_IN		0x08000000
#define  IPG_MANC_SMB_DATA_OUT		0x10000000
#define  IPG_MANC_SMB_CLK_OUT		0x20000000
#define IPG_IP6AT		0x5880
#define IPG_WUPL		0x5900
#define IPG_WUPM		0x5a00
#define IPG_GCR			0x5b00
#define  IPG_GCR_RXD_NO_SNOOP		0x00000001
#define  IPG_GCR_RXDSCW_NO_SNOOP	0x00000002
#define  IPG_GCR_RXDSCR_NO_SNOOP	0x00000004
#define  IPG_GCR_TXD_NO_SNOOP		0x00000008
#define  IPG_GCR_TXDSCW_NO_SNOOP	0x00000010
#define  IPG_GCR_TXDSCR_NO_SNOOP	0x00000020
#define  IPG_GCR_L1_ACT_WITHOUT_L0S_RX	0x08000000
#define IPG_GSCL_1		0x5b10
#define IPG_GSCL_2		0x5b14
#define IPG_GSCL_3		0x5b18
#define IPG_GSCL_4		0x5b1c
#define IPG_FACTPS		0x5b30
#define IPG_SWSM		0x5b50
#define  IPG_SWSM_SMBI			0x00000001
#define  IPG_SWSM_SWESMBI		0x00000002
#define  IPG_SWSM_WMNG			0x00000004
#define  IPG_SWSM_DRV_LOAD		0x00000008
#define IPG_FWSM		0x5b54
#define  IPG_FWSM_MODE_MASK		0x0000000e
#define   IPG_FWSM_MODE_IAMT		0x00000006
#define   IPG_FWSM_MODE_IAMT_ICH	0x00000004
#define  IPG_FWSM_RSPCIPHY		0x00000040
#define  IPG_FWSM_FW_VALID		0x00080000
#define  IPG_FWSM_DISSW			0x10000000
#define  IPG_FWSM_SKUSEL_MASK		0x60000000
#define   IPG_FWSM_SKUSEL_EMB		0x00000000
#define   IPG_FWSM_SKUSEL_CONS		0x20000000
#define   IPG_FWSM_SKUSEL_PERF_100	0x40000000
#define   IPG_FWSM_SKUSEL_PERF_GBE	0x60000000
#define IPG_SW_FW_SYNC		0x5b5c
#define  IPG_SW_FW_SYNC_EEP_SM		0x0001
#define  IPG_SW_FW_SYNC_PHY0_SM		0x0002
#define  IPG_SW_FW_SYNC_PHY1_SM		0x0004
#define  IPG_SW_FW_SYNC_MAC_CSR_SM	0x0008
#define IPG_FFLT		0x5f00
#define IPG_FFMT		0x9000
#define IPG_FFVT		0x9800

#define PCIX_COMMAND_REGISTER	0xe6
#define PCIX_COMMAND_MMRBC_MASK		0x000c
#define PCIX_STATUS_REGISTER_LO	0xe8
#define PCIX_STATUS_REGISTER_HI	0xea
#define PCIX_STATUS_HI_MMRBC_MASK	0x0060

#define IPG_PHY_PCTRL		0x00
#define IPG_PHY_PSTATUS		0x01
#define IPG_PHY_PID		0x02
#define IPG_PHY_EPID		0x03
#define IPG_PHY_ANA		0x04
#define IPG_PHY_LPA		0x05
#define IPG_PHY_ANE		0x06
#define IPG_PHY_NPT		0x07
#define IPG_PHY_LPN		0x08
#define IPG_PHY_GCON		0x09
#define IPG_PHY_GSTATUS		0x0a
#define IPG_PHY_EPSTATUS	0x0f
#define IPG_PHY_PSCON		0x10
#define IPG_PHY_PSSTAT		0x11
#define IPG_PHY_PINTE		0x12
#define IPG_PHY_PINTS		0x13
#define IPG_PHY_EPSCON1		0x14
#define IPG_PHY_PREC		0x15
#define IPG_PHY_PGSTAT		0x17
#define IPG_PHY_PLED		0x18
#define IPG_PHY_EPSCON2		0x1a
#define IPG_PHY_EPSSTAT		0x1b
#define IPG_PHY_R30PS		0x1d
#define IPG_PHY_R30AW		0x1e
#define IPG_PHY_PPAGE		0x1f

#define ICH8_FLASH_REGSPACE	0xa0

#define ICH8_FLASH_GFPREG	0x00
#define ICH8_FLASH_HSFSTS	0x04
#define  ICH8_FLASH_HSFSTS_FLCDONE	0x0001
#define  ICH8_FLASH_HSFSTS_FLCERR	0x0002
#define  ICH8_FLASH_HSFSTS_DAEL		0x0004
#define  ICH8_FLASH_HSFSTS_BERASESZ	0x0018
#define  ICH8_FLASH_HSFSTS_FLCINPROG	0x0020
#define  ICH8_FLASH_HSFSTS_FLDESVALID	0x4000
#define  ICH8_FLASH_HSFSTS_FLOCKDN	0x8000
#define ICH8_FLASH_HSFCTL	0x06
#define  ICH8_FLASH_HSFCTL_FLCGO	0x0001
#define  ICH8_FLASH_HSFCTL_FLCYCLE	0x0006
#define   ICH8_FLASH_HSFCTL_FLCYCLE_READ	0x0000
#define   ICH8_FLASH_HSFCTL_FLCYCLE_WRITE	0x0004
#define   ICH8_FLASH_HSFCTL_FLCYCLE_ERASE	0x0006
#define  ICH8_FLASH_HSFCTL_FLDBCOUNT	0x0300
#define ICH8_FLASH_FADDR	0x08
#define ICH8_FLASH_FDATA0	0x10
#define ICH8_FLASH_FRACC	0x50
#define ICH8_FLASH_FREG0	0x54
#define ICH8_FLASH_FREG1	0x58
#define ICH8_FLASH_FREG2	0x5c
#define ICH8_FLASH_FREG3	0x60
#define ICH8_FLASH_FPR0		0x74
#define ICH8_FLASH_FPR1		0x78
#define ICH8_FLASH_SSFSTS	0x90
#define ICH8_FLASH_SSFCTL	0x92
#define ICH8_FLASH_PREOP	0x94
#define ICH8_FLASH_OPTYPE	0x96
#define ICH8_FLASH_OPMENU	0x98
#define ICH8_FLASH_LINEAR_ADDR_MASK	0x00ffffff

#define ICH8_FLASH_WORDS	0x0800
#define ICH8_FLASH_SECTOR_SIZE	0x1000
#define ICH8_GFPREG_BASE_MASK	0x1fff

#define EEPROM_WRITE_OPCODE_MICROWIRE	0x05
#define EEPROM_READ_OPCODE_MICROWIRE	0x06
#define EEPROM_ERASE_OPCODE_MICROWIRE	0x07
#define EEPROM_EWDS_OPCODE_MICROWIRE	0x10
#define EEPROM_EWEN_OPCODE_MICROWIRE	0x13

#define EEPROM_WRSR_OPCODE_SPI		0x01
#define EEPROM_WRITE_OPCODE_SPI		0x02
#define EEPROM_READ_OPCODE_SPI		0x03
#define EEPROM_WRDI_OPCODE_SPI		0x04
#define EEPROM_RDSR_OPCODE_SPI		0x05
#define EEPROM_WREN_OPCODE_SPI		0x06
#define EEPROM_A8_OPCODE_SPI		0x08
#define EEPROM_ERASE4K_OPCODE_SPI	0x20
#define EEPROM_ERASE64K_OPCODE_SPI	0xd8
#define EEPROM_ERASE256_OPCODE_SPI	0xdb

#define EEPROM_STATUS_RDY_SPI		0x01
#define EEPROM_STATUS_WEN_SPI		0x02
#define EEPROM_STATUS_BP0_SPI		0x04
#define EEPROM_STATUS_BP1_SPI		0x08
#define EEPROM_STATUS_WPEN_SPI		0x80

#define EEPROM_WORD_SIZE_SHIFT		6
#define EEPROM_SIZE_SHIFT		10
#define EEPROM_SIZE_MASK		0x1c00

#define EEPROM_COMPAT			0x0003
#define EEPROM_ID_LED_SETTINGS		0x0004
#define EEPROM_VERSION			0x0005
#define EEPROM_SERDES_AMPLITUDE		0x0006
#define  EEPROM_SERDES_AMPLITUDE_MASK		0x000f
#define EEPROM_PHY_CLASS_WORD		0x0007
#define  EEPROM_PHY_CLASS_A			0x8000
#define EEPROM_INIT_CONTROL1_REG	0x000a
#define EEPROM_INIT_CONTROL2_REG	0x000f
#define  EEPROM_INIT_CONTROL2_REG_LPLU		0x0001
#define  EEPROM_INIT_CONTROL2_REG_SWPDIO_EXT	0x00f0
#define  EEPROM_INIT_CONTROL2_REG_ANE		0x0800
#define  EEPROM_INIT_CONTROL2_REG_PAUSE_MASK	0x3000
#define  EEPROM_INIT_CONTROL2_REG_PAUSE		0x1000
#define  EEPROM_INIT_CONTROL2_REG_ASM_DIR	0x2000
#define EEPROM_SWDEF_PINS_CTRL_PORT_1	0x0010
#define EEPROM_INIT_CONTROL3_PORT_B	0x0014
#define EEPROM_INIT_3GIO_3		0x001a
#define EEPROM_SWDEF_PINS_CTRL_PORT_0	0x0020
#define EEPROM_INIT_CONTROL3_PORT_A	0x0024
#define EEPROM_CFG			0x0012
#define EEPROM_FLASH_VERSION		0x0032
#define EEPROM_CHECKSUM_REG		0x003f

#define EEPROM_RESERVED_WORD		0xffff

#define PHY_CTRL			0x00
#define  PHY_CTRL_SPEED_SELECT_MSB		0x0040
#define  PHY_CTRL_COLL_TEST_ENABLE		0x0080
#define  PHY_CTRL_FULL_DUPLEX			0x0100
#define  PHY_CTRL_RESTART_AUTO_NEG		0x0200
#define  PHY_CTRL_ISOLATE			0x0400
#define  PHY_CTRL_POWER_DOWN			0x0800
#define  PHY_CTRL_AUTO_NEG_EN			0x1000
#define  PHY_CTRL_SPEED_SELECT_LSB		0x2000
#define  PHY_CTRL_LOOPBACK			0x4000
#define  PHY_CTRL_RESET				0x8000
#define PHY_STATUS			0x01
#define  MII_SR_EXTENDED_CAPS			0x0001
#define  MII_SR_JABBER_DETECT			0x0002
#define  MII_SR_LINK_STATUS			0x0004
#define  MII_SR_AUTONEG_CAPS			0x0008
#define  MII_SR_REMOTE_FAULT			0x0010
#define  MII_SR_AUTONEG_COMPLETE		0x0020
#define  MII_SR_PREAMBLE_SUPPRESS		0x0040
#define  MII_SR_EXTENDED_STATUS			0x0100
#define  MII_SR_100T2_HD_CAPS			0x0200
#define  MII_SR_100T2_FD_CAPS			0x0400
#define  MII_SR_10T_HD_CAPS			0x0800
#define  MII_SR_10T_FD_CAPS			0x1000
#define  MII_SR_100X_HD_CAPS			0x2000
#define  MII_SR_100X_FD_CAPS			0x4000
#define  MII_SR_100T4_CAPS			0x8000
#define PHY_ID1				0x02
#define PHY_ID2				0x03
#define PHY_AUTONEG_ADV			0x04
#define  PHY_AUTONEG_ADV_SELECTOR_FIELD		0x0001
#define  PHY_AUTONEG_ADV_10T_HD_CAPS		0x0020
#define  PHY_AUTONEG_ADV_10T_FD_CAPS		0x0040
#define  PHY_AUTONEG_ADV_100TX_HD_CAPS		0x0080
#define  PHY_AUTONEG_ADV_100TX_FD_CAPS		0x0100
#define  PHY_AUTONEG_ADV_100T4_CAPS		0x0200
#define  PHY_AUTONEG_ADV_PAUSE			0x0400
#define  PHY_AUTONEG_ADV_ASM_DIR		0x0800
#define  PHY_AUTONEG_ADV_REMOTE_FAULT		0x2000
#define  PHY_AUTONEG_ADV_NEXT_PAGE		0x8000
#define PHY_LP_ABILITY			0x05
#define  PHY_LP_ABILITY_10T_HD_CAPS		0x0020
#define  PHY_LP_ABILITY_10T_FD_CAPS		0x0040
#define  PHY_LP_ABILITY_100TX_HD_CAPS		0x0080
#define  PHY_LP_ABILITY_100TX_FD_CAPS		0x0100
#define  PHY_LP_ABILITY_100T4_CAPS		0x0200
#define  PHY_LP_ABILITY_PAUSE			0x0400
#define  PHY_LP_ABILITY_ASM_DIR			0x0800
#define  PHY_LP_ABILITY_ACKNOWLEDGE		0x4000
#define  PHY_LP_ABILITY_NEXT_PAGE		0x8000
#define PHY_AUTONEG_EXP			0x06
#define PHY_NEXT_PAGE_TX		0x07
#define PHY_LP_NEXT_PAGE		0x08
#define PHY_1000T_CTRL			0x09
#define  PHY_1000T_CTRL_ASYM_PAUSE		0x0080
#define  PHY_1000T_CTRL_HD_CAPS			0x0100
#define  PHY_1000T_CTRL_FD_CAPS			0x0200
#define  PHY_1000T_CTRL_REPEATER_DTE		0x0400
#define  PHY_1000T_CTRL_MS_VALUE		0x0800
#define  PHY_1000T_CTRL_MS_ENABLE		0x1000
#define  PHY_1000T_CTRL_TEST_MODE_NORMAL	0x0000
#define  PHY_1000T_CTRL_TEST_MODE_1		0x2000
#define  PHY_1000T_CTRL_TEST_MODE_2		0x4000
#define  PHY_1000T_CTRL_TEST_MODE_3		0x6000
#define  PHY_1000T_CTRL_TEST_MODE_4		0x8000

#define PHY_1000T_STATUS		0x0a
#define PHY_EXT_STATUS			0x0f

#define MAX_PHY_REG_ADDRESS		0x1f
#define MAX_PHY_MULTI_PAGE_REG		0x0f

#define IGP01E1000_PHY_PORT_CONFIG	0x10
#define IGP01E1000_PHY_PORT_STATUS	0x11
#define IGP01E1000_PHY_PORT_CTRL	0x12
#define  IGP01E1000_PHY_PORT_CTRL_TP_LOOPBACK		0x0010
#define  IGP01E1000_PHY_PORT_CTRL_CORRECT_NC_SCMBLR	0x0200
#define  IGP01E1000_PHY_PORT_CTRL_TEN_CRS_SELECT	0x0400
#define  IGP01E1000_PHY_PORT_CTRL_FLIP_CHIP		0x0800
#define  IGP01E1000_PHY_PORT_CTRL_AUTO_MDIX		0x1000
#define  IGP01E1000_PHY_PORT_CTRL_FORCE_MDI_MDIX	0x2000
#define IGP01E1000_PHY_LINK_HEALTH	0x13
#define IGP01E1000_GMII_FIFO		0x14
#define  IGP01E1000_GMII_FIFO_FLEX_SPD		0x10
#define  IGP01E1000_GMII_FIFO_SPD		0x20

#define IGP01E1000_PHY_CHANNEL_QUALITY	0x15
#define IGP02E1000_PHY_POWER_MGMT	0x19
#define  IGP02E1000_PHY_POWER_MGMT_SPD		0x0001
#define  IGP02E1000_PHY_POWER_MGMT_D0_LPLU	0x0002
#define  IGP02E1000_PHY_POWER_MGMT_D3_LPLU	0x0004
#define IGP01E1000_PHY_PAGE_SELECT	0x1f

#define GG82563_MIN_ALT_REG		0x1e
#define GG82563_REG(page, reg)		(((page) << 5) | ((reg) & MAX_PHY_REG_ADDRESS))
#define GG82563_PHY_SPEC_CTRL		GG82563_REG(0, 16)
#define  GG82563_PHY_SPEC_CTRL_DISABLE_JABBER			0x0001
#define  GG82563_PHY_SPEC_CTRL_POLARITY_REVERSAL_DISABLE	0x0002
#define  GG82563_PHY_SPEC_CTRL_POWER_DOWN			0x0004
#define  GG82563_PHY_SPEC_CTRL_COPPER_TRANSMITER_DISABLE	0x0008
#define  GG82563_PHY_SPEC_CTRL_CROSSOVER_MODE_MASK		0x0060
#define  GG82563_PHY_SPEC_CTRL_CROSSOVER_MODE_MDI		0x0000
#define  GG82563_PHY_SPEC_CTRL_CROSSOVER_MODE_MDIX		0x0020
#define  GG82563_PHY_SPEC_CTRL_CROSSOVER_MODE_AUTO		0x0060
#define  GG82563_PHY_SPEC_CTRL_ENALBE_EXTENDED_DISTANCE		0x0080
#define  GG82563_PHY_SPEC_CTRL_ENERGY_DETECT_MASK		0x0300
#define  GG82563_PHY_SPEC_CTRL_ENERGY_DETECT_OFF		0x0000
#define  GG82563_PHY_SPEC_CTRL_ENERGY_DETECT_RX			0x0200
#define  GG82563_PHY_SPEC_CTRL_ENERGY_DETECT_RX_TM		0x0300
#define  GG82563_PHY_SPEC_CTRL_DOWNSHIFT_ENABLE			0x0800
#define GG82563_PHY_SPEC_STATUS		GG82563_REG(0, 17)
#define GG82563_PHY_INT_ENABLE		GG82563_REG(0, 18)
#define GG82563_PHY_SPEC_STATUS_2	GG82563_REG(0, 19)
#define GG82563_PHY_RX_ERR_CNTR		GG82563_REG(0, 21)
#define GG82563_PHY_PAGE_SELECT		GG82563_REG(0, 22)
#define GG82563_PHY_SPEC_CTRL_2		GG82563_REG(0, 26)
#define GG82563_PHY_PAGE_SELECT_ALT	GG82563_REG(0, 29)
#define GG82563_PHY_TEST_CLK_CTRL	GG82563_REG(0, 30)
#define GG82563_PHY_MAC_SPEC_CTRL	GG82563_REG(2, 21)
#define  GG82563_PHY_MAC_SPEC_CTRL_TX_CLK_MASK			0x0007
#define  GG82563_PHY_MAC_SPEC_CTRL_TX_CLK_10MBPS_2_5MHZ		0x0004
#define  GG82563_PHY_MAC_SPEC_CTRL_TX_CLK_100MBPS_25MHZ		0x0005
#define  GG82563_PHY_MAC_SPEC_CTRL_TX_CLK_1000MBPS_2_5MHZ	0x0006
#define  GG82563_PHY_MAC_SPEC_CTRL_TX_CLK_1000MBPS_25MHZ	0x0007
#define  GG82563_PHY_MAC_SPEC_CTRL_ASSERT_CRS_ON_TX		0x0010
#define GG82563_PHY_MAC_SPEC_CTRL_2	GG82563_REG(2, 26)
#define  GG82563_PHY_SPEC_CTRL_2_10BT_POLARITY_FORCE		0x0002
#define  GG82563_PHY_SPEC_CTRL_2_1000MB_TEST_SELECT_MASK	0x000c
#define  GG82563_PHY_SPEC_CTRL_2_1000MB_TEST_SELECT_NORMAL	0x0000
#define  GG82563_PHY_SPEC_CTRL_2_1000MB_TEST_SELECT_112NS	0x0008
#define  GG82563_PHY_SPEC_CTRL_2_1000MB_TEST_SELECT_16NS	0x000c
#define  GG82563_PHY_SPEC_CTRL_2_REVERSE_AUTO_NEG		0x2000
#define  GG82563_PHY_SPEC_CTRL_2_1000BT_DISABLE			0x4000
#define  GG82563_PHY_SPEC_CTRL_2_TRANSMITER_TYPE_MASK		0x8000
#define  GG82563_PHY_SPEC_CTRL_2_TRANSMITTER_TYPE_CLASS_B	0x0000
#define  GG82563_PHY_SPEC_CTRL_2_TRANSMITTER_TYPE_CLASS_A	0x8000
#define GG82563_PHY_DSP_DISTANCE	GG82563_REG(5, 26)
#define GG82563_PHY_KMRN_MODE_CTRL	GG82563_REG(193, 16)
#define  GG82563_PHY_KMRN_MODE_CTRL_PHY_LEDS_EN			0x0020
#define  GG82563_PHY_KMRN_MODE_CTRL_FORCE_LINK_UP		0x0040
#define  GG82563_PHY_KMRN_MODE_CTRL_MDIO_BUS_SPEED_SELECT_MASK	0x0400
#define  GG82563_PHY_KMRN_MODE_CTRL_MDIO_BUS_SPEED_SELECT	0x0400
#define  GG82563_PHY_KMRN_MODE_CTRL_PASS_FALSE_CARRIER		0x0800
#define GG82563_PHY_PORT_RESET		GG82563_REG(193, 17)
#define GG82563_PHY_REVISION_ID		GG82563_REG(193, 18)
#define GG82563_PHY_DEVICE_ID		GG82563_REG(193, 19)
#define GG82563_PHY_PWR_MGMT_CTRL	GG82563_REG(193, 20)
#define  GG82563_PHY_PWR_MGMT_CTRL_ENABLE_ELECTRICAL_IDLE	0x0001
#define  GG82563_PHY_PWR_MGMT_CTRL_DISABLE_PORT			0x0002
#define  GG82563_PHY_PWR_MGMT_CTRL_REVERSE_AUTO_NEG		0x0008
#define  GG82563_PHY_PWR_MGMT_CTRL_DISABLE_1000_NON_D0		0x0010
#define  GG82563_PHY_PWR_MGMT_CTRL_DISABLE_1000			0x0020
#define  GG82563_PHY_PWR_MGMT_CTRL_REVERSE_AUTO_NEG_D0A		0x0040
#define  GG82563_PHY_PWR_MGMT_CTRL_FORCE_POWER_STATE		0x0080
#define  GG82563_PHY_PWR_MGMT_CTRL_PROGRAMMED_POWER_STATE_MASK	0x0300
#define  GG82563_PHY_PWR_MGMT_CTRL_PROGRAMMED_POWER_STATE_DR	0x0000
#define  GG82563_PHY_PWR_MGMT_CTRL_PROGRAMMED_POWER_STATE_D0U	0x0100
#define  GG82563_PHY_PWR_MGMT_CTRL_PROGRAMMED_POWER_STATE_D0A	0x0200
#define  GG82563_PHY_PWR_MGMT_CTRL_PROGRAMMED_POWER_STATE_D3	0x0300
#define GG82563_PHY_RATE_ADAPT_CTRL	GG82563_REG(193, 25)
#define GG82563_PHY_KMRN_FIFO_CTRL_STAT GG82563_REG(194, 16)
#define GG82563_PHY_KMRN_CTRL		GG82563_REG(194, 17)
#define GG82563_PHY_INBAND_CTRL		GG82563_REG(194, 18)
#define GG82563_PHY_KMRN_DIAGNOSTIC	GG82563_REG(194, 19)
#define GG82563_PHY_ACK_TIMEOUTS	GG82563_REG(194, 20)
#define GG82563_PHY_ADV_ABILITY		GG82563_REG(194, 21)
#define GG82563_PHY_LINK_PARTNER_ADV_ABILITY	GG82563_REG(194, 23)
#define GG82563_PHY_ADV_NEXT_PAGE	GG82563_REG(194, 24)
#define GG82563_PHY_LINK_PARTNER_ADV_NEXT_PAGE	GG82563_REG(194, 25)
#define GG82563_PHY_KMRN_MISC		GG82563_REG(194, 26)

#define M88E1000_PHY_SPEC_CTRL		0x10
#define  M88E1000_PHY_SPEC_CTRL_JABBER_DISABLE		0x0001
#define  M88E1000_PHY_SPEC_CTRL_POLARITY_REVERSAL	0x0002
#define  M88E1000_PHY_SPEC_CTRL_SQE_TEST		0x0004
#define  M88E1000_PHY_SPEC_CTRL_CLK125_DISABLE		0x0010
#define  M88E1000_PHY_SPEC_CTRL_MDI_MANUAL_MODE		0x0000
#define  M88E1000_PHY_SPEC_CTRL_MDIX_MANUAL_MODE	0x0020
#define  M88E1000_PHY_SPEC_CTRL_AUTO_X_1000T		0x0040
#define  M88E1000_PHY_SPEC_CTRL_AUTO_X_MODE		0x0060
#define  M88E1000_PHY_SPEC_CTRL_10BT_EXT_DIST_ENABLE	0x0080
#define  M88E1000_PHY_SPEC_CTRL_MII_5BIT_ENABLE		0x0100
#define  M88E1000_PHY_SPEC_CTRL_SCRAMBLER_DISABLE	0x0200
#define  M88E1000_PHY_SPEC_CTRL_FORCE_LINK_GOOD		0x0400
#define  M88E1000_PHY_SPEC_CTRL_ASSERT_CRS_ON_TX	0x0800
#define M88E1000_PHY_SPEC_STATUS	0x11
#define  M88E1000_PHY_SPEC_STATUS_JABBER		0x0001
#define  M88E1000_PHY_SPEC_STATUS_REV_POLARITY		0x0002
#define  M88E1000_PHY_SPEC_STATUS_DOWNSHIFT		0x0020
#define  M88E1000_PHY_SPEC_STATUS_MDIX			0x0040
#define  M88E1000_PHY_SPEC_STATUS_CABLE_LENGTH		0x0380
#define  M88E1000_PHY_SPEC_STATUS_LINK			0x0400
#define  M88E1000_PHY_SPEC_STATUS_SPD_DPLX_RESOLVED	0x0800
#define  M88E1000_PHY_SPEC_STATUS_PAGE_RCVD		0x1000
#define  M88E1000_PHY_SPEC_STATUS_DPLX			0x2000
#define  M88E1000_PHY_SPEC_STATUS_SPEED			0xc000
#define  M88E1000_PHY_SPEC_STATUS_10MBS			0x0000
#define  M88E1000_PHY_SPEC_STATUS_100MBS		0x4000
#define  M88E1000_PHY_SPEC_STATUS_1000MBS		0x8000
#define M88E1000_INT_ENABLE		0x12
#define M88E1000_INT_STATUS		0x13
#define M88E1000_EXT_PHY_SPEC_CTRL	0x14
#define  M88E1000_EXT_PHY_SPEC_CTRL_TX_CLK_MASK			0x0070
#define  M88E1000_EXT_PHY_SPEC_CTRL_TX_CLK_0				0x0000
#define  M88E1000_EXT_PHY_SPEC_CTRL_TX_CLK_2_5				0x0060
#define  M88E1000_EXT_PHY_SPEC_CTRL_TX_CLK_25				0x0070
#define  M88E1000_EXT_PHY_SPEC_CTRL_SLAVE_DOWNSHIFT_MASK	0x0300
#define  M88E1000_EXT_PHY_SPEC_CTRL_SLAVE_DOWNSHIFT_DIS			0x0000
#define  M88E1000_EXT_PHY_SPEC_CTRL_SLAVE_DOWNSHIFT_1X			0x0100
#define  M88E1000_EXT_PHY_SPEC_CTRL_SLAVE_DOWNSHIFT_2X			0x0200
#define  M88E1000_EXT_PHY_SPEC_CTRL_SLAVE_DOWNSHIFT_3X			0x0300
#define  M88E1000_EXT_PHY_SPEC_CTRL_MASTER_DOWNSHIFT_MASK	0x0c00
#define  M88E1000_EXT_PHY_SPEC_CTRL_MASTER_DOWNSHIFT_1X			0x0000
#define  M88E1000_EXT_PHY_SPEC_CTRL_MASTER_DOWNSHIFT_2X			0x0400
#define  M88E1000_EXT_PHY_SPEC_CTRL_MASTER_DOWNSHIFT_3X			0x0800
#define  M88E1000_EXT_PHY_SPEC_CTRL_MASTER_DOWNSHIFT_4X			0x0c00
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_MASK	0x0e00
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_1X		0x0000
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_2X		0x0200
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_3X		0x0400
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_4X		0x0600
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_5X		0x0800
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_6X		0x0a00
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_7X		0x0c00
#define  M88EC018_EXT_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_8X		0x0e00
#define  M88E1000_EXT_PHY_SPEC_CTRL_FIBER_LOOPBACK		0x4000
#define  M88E1000_EXT_PHY_SPEC_CTRL_DOWN_NO_IDLE		0x8000
#define M88E1000_RX_ERR_CNTR		0x15
#define M88E1000_PHY_EXT_CTRL		0x1a
#define M88E1000_PHY_PAGE_SELECT	0x1d
#define M88E1000_PHY_GEN_CONTROL	0x1e

#define IFE_PHY_EXTENDED_STATUS_CONTROL	0x10
#define IFE_PHY_SPECIAL_CONTROL		0x11
#define IFE_PHY_RCV_FALSE_CARRIER	0x13
#define IFE_PHY_RCV_DISCONNECT		0x14
#define IFE_PHY_RCV_ERROT_FRAME		0x15
#define IFE_PHY_RCV_SYMBOL_ERR		0x16
#define IFE_PHY_PREM_EOF_ERR		0x17
#define IFE_PHY_RCV_EOF_ERR		0x18
#define IFE_PHY_TX_JABBER_DETECT	0x19
#define IFE_PHY_EQUALIZER		0x1a
#define IFE_PHY_SPECIAL_CONTROL_LED	0x1b
#define IFE_PHY_MDIX_CONTROL		0x1c
#define  IFE_PHY_MDIX_CONTROL_AUTO_MDIX_COMPLETE	0x0010
#define  IFE_PHY_MDIX_CONTROL_MDIX_STATUS		0x0020
#define  IFE_PHY_MDIX_CONTROL_FORCE_MDIX		0x0040
#define  IFE_PHY_MDIX_CONTROL_AUTO_MDIX			0x0080

#define M88E1000_E_PHY_ID		0x01410c50
#define M88E1000_I_PHY_ID		0x01410c30
#define M88E1011_I_PHY_ID		0x01410c20
#define IGP01E1000_I_PHY_ID		0x02a80380
#define M88E1000_12_PHY_ID		M88E1000_E_PHY_ID
#define M88E1000_14_PHY_ID		M88E1000_E_PHY_ID
#define M88E1011_I_REV_2		0x02
#define M88E1011_I_REV_4		0x04
#define M88E1111_I_PHY_ID		0x01410cc0
#define L1LXT971A_PHY_ID		0x001378e0
#define GG82563_E_PHY_ID		0x01410ca0
#define IGP03E1000_E_PHY_ID		0x02a80390
#define IFE_E_PHY_ID			0x02a80330
#define IFE_PLUS_E_PHY_ID		0x02a80320
#define IFE_C_E_PHY_ID			0x02a80310

#define KUMCTRLSTA_OFFSET_FIFO_CTRL	0x00
#define  KUMCTRLSTA_FIFO_CTRL_RX_BYPASS		0x00000008
#define  KUMCTRLSTA_FIFO_CTRL_TX_BYPASS		0x00000800
#define KUMCTRLSTA_OFFSET_CTRL		0x01
#define KUMCTRLSTA_OFFSET_INB_CTRL	0x02
#define  KUMCTRLSTA_INB_CTRL_DIS_PADDING			0x00000010
#define  KUMCTRLSTA_INB_CTRL_LINK_STATUS_TX_TIMEOUT_DEFAULT	0x00000500
#define KUMCTRLSTA_OFFSET_DIAG		0x03
#define KUMCTRLSTA_OFFSET_TIMEOUTS	0x04
#define KUMCTRLSTA_OFFSET_INB_PARAM	0x09
#define KUMCTRLSTA_OFFSET_HD_CTRL	0x10
#define KUMCTRLSTA_OFFSET_M2P_SERDES	0x1e
#define KUMCTRLSTA_OFFSET_M2P_MODES	0x1f


typedef struct {
	__u64 addr;
	__u16 len;
	__u16 csum;
	__u8 status;
	__u8 errors;
	__u16 special;
} IPG_RX_DESC;

#define IPG_RX_DESC_STATUS_DD		0x01
#define IPG_RX_DESC_STATUS_EOP		0x02
#define IPG_RX_DESC_STATUS_IXSM		0x04
#define IPG_RX_DESC_STATUS_VP		0x08
#define IPG_RX_DESC_STATUS_TCPCS	0x20
#define IPG_RX_DESC_STATUS_IPCS		0x40
#define IPG_RX_DESC_STATUS_PIF		0x80

#define IPG_RX_DESC_ERRORS_CE		0x01
#define IPG_RX_DESC_ERRORS_SE		0x02
#define IPG_RX_DESC_ERRORS_SEQ		0x04
#define IPG_RX_DESC_ERRORS_CXE		0x10
#define IPG_RX_DESC_ERRORS_TCPE		0x20
#define IPG_RX_DESC_ERRORS_IPE		0x40
#define IPG_RX_DESC_ERRORS_RXE		0x80

#define IPG_RX_DESC_SPECIAL_VLAN	0x0fff
#define IPG_RX_DESC_SPECIAL_CFI		0x1000
#define IPG_RX_DESC_SPECIAL_PRI		0xe000

typedef union {
	struct {
		__u64 addr;
		__u16 len;
		__u8 cso;
		__u8 cmd;
		__u8 status;
		__u8 css;
		__u16 special;
	} legacy;
} IPG_TX_DESC;

#define IPG_TX_DESC_LEGACY_CMD_EOP	0x01
#define IPG_TX_DESC_LEGACY_CMD_IFCS	0x02
#define IPG_TX_DESC_LEGACY_CMD_IC	0x04
#define IPG_TX_DESC_LEGACY_CMD_RS	0x08
#define IPG_TX_DESC_LEGACY_CMD_RPS	0x10
#define IPG_TX_DESC_LEGACY_CMD_DEXT	0x20
#define IPG_TX_DESC_LEGACY_CMD_VLE	0x40
#define IPG_TX_DESC_LEGACY_CMD_IDE	0x80

#define IPG_TX_DESC_LEGACY_STATUS_DD	0x01
#define IPG_TX_DESC_LEGACY_STATUS_EC	0x02
#define IPG_TX_DESC_LEGACY_STATUS_LC	0x04
#define IPG_TX_DESC_LEGACY_STATUS_TU	0x08

#define IPG_TX_DESC_LEGACY_SPECIAL_VLAN	0x0fff
#define IPG_TX_DESC_LEGACY_SPECIAL_CFI	0x1000
#define IPG_TX_DESC_LEGACY_SPECIAL_PRI	0xe000

#endif
