#ifndef __NIC_MIIREG_H
#define __NIC_MIIREG_H

/*
   From linux/include/linux/mii.h
   Copyright (C) 1996, 1999, 2001 David S. Miller (davem@redhat.com)
*/

#define MII_BMCR		0x00
#define MII_BMSR		0x01
#define MII_PHYSID1		0x02
#define MII_PHYSID2		0x03
#define MII_ADVERTISE		0x04
#define MII_LPA			0x05
#define MII_EXPANSION		0x06
#define MII_DCOUNTER		0x12
#define MII_FCSCOUNTER		0x13
#define MII_NWAYTEST		0x14
#define MII_RERRCOUNTER		0x15
#define MII_SREVISION		0x16
#define MII_LBRERROR		0x18
#define MII_PHYADDR		0x19
#define MII_RESV2		0x1a
#define MII_TPISTATUS		0x1b
#define MII_NCONFIG		0x1c

#define BMCR_SPEED1000		0x0040
#define BMCR_CTST		0x0080
#define BMCR_FULLDPLX		0x0100
#define BMCR_ANRESTART		0x0200
#define BMCR_ISOLATE		0x0400
#define BMCR_PDOWN		0x0800
#define BMCR_ANENABLE		0x1000
#define BMCR_SPEED100		0x2000
#define BMCR_LOOPBACK		0x4000
#define BMCR_RESET		0x8000

#define BMSR_ERCAP		0x0001
#define BMSR_JCD		0x0002
#define BMSR_LSTATUS		0x0004
#define BMSR_ANEGCAPABLE	0x0008
#define BMSR_RFAULT		0x0010
#define BMSR_ANEGCOMPLETE	0x0020
#define BMSR_10HALF		0x0800
#define BMSR_10FULL		0x1000
#define BMSR_100HALF		0x2000
#define BMSR_100FULL		0x4000
#define BMSR_100BASE4		0x8000

#define ADVERTISE_SLCT		0x001f
#define ADVERTISE_CSMA		0x0001
#define ADVERTISE_10HALF	0x0020
#define ADVERTISE_10FULL	0x0040
#define ADVERTISE_100HALF	0x0080
#define ADVERTISE_100FULL	0x0100
#define ADVERTISE_100BASE4	0x0200
#define ADVERTISE_RFAULT	0x2000
#define ADVERTISE_LPACK		0x4000
#define ADVERTISE_NPAGE		0x8000

#define LPA_SLCT		0x001f
#define LPA_10HALF		0x0020
#define LPA_10FULL		0x0040
#define LPA_100HALF		0x0080
#define LPA_100FULL		0x0100
#define LPA_100BASE4		0x0200
#define LPA_RFAULT		0x2000
#define LPA_LPACK		0x4000
#define LPA_NPAGE		0x8000

#define EXPANSION_NWAY		0x0001
#define EXPANSION_LCWP		0x0002
#define EXPANSION_ENABLENPAGE	0x0004
#define EXPANSION_NPCAPABLE	0x0008
#define EXPANSION_MFAULTS	0x0010

#endif
