#ifndef __NIC_NEREG_H
#define __NIC_NEREG_H

#include <SYS/TYPES.H>
#include <SPAD/TIMER.H>

struct header_8390 {
	__u8 status;
	__u8 next;
	__u16 count;
};

#define TX_TIMEOUT		(JIFFIES_PER_SECOND / 2)
#define WR_TIMEOUT		(JIFFIES_PER_SECOND / 50)
#define RST_TIMEOUT		(JIFFIES_PER_SECOND / 50)
#define MEDIA_CHECK_TIME	(JIFFIES_PER_SECOND * 5)

#define MAX_SERVICE	12

#define NE_REGSPACE	16

#define NE_CMD		0
#define  NE_CMD_STP	 1
#define  NE_CMD_STA	 2
#define  NE_CMD_TXP	 4
#define  NE_CMD_RD0	 8
#define  NE_CMD_RD1	 16
#define  NE_CMD_RD2	 32
#define  NE_CMD_PS0	 64
#define  NE_CMD_PS1	 128

#define NE0_CLDAL0	1
#define NE0_PSTART	1
#define NE0_CLDA1	2
#define NE0_PSTOP	2
#define NE0_BNRY	3
#define NE0_TSR		4
#define  NE_TSR_PTX	 1
#define  NE_TSR_COL	 4
#define  NE_TSR_ABT	 8
#define  NE_TSR_CRS	 16
#define  NE_TSR_FU	 32
#define  NE_TSR_CDH	 64
#define  NE_TSR_OWC	 128
#define NE0_TPSR	4
#define NE0_NCR		5
#define NE0_TBCR0	5
#define NE0_FIFO	6
#define NE0_TBCR1	6
#define NE0_ISR		7
#define  NE_ISR_PRX	 1
#define  NE_ISR_PTX	 2
#define  NE_ISR_RXE	 4
#define  NE_ISR_TXE	 8
#define  NE_ISR_OVW	 16
#define  NE_ISR_CNT	 32
#define  NE_ISR_RDC	 64
#define  NE_ISR_RST	 128
#define NE0_CRDA0	8
#define NE0_RSAR0	8
#define NE0_CRDA1	9
#define NE0_RSAR1	9
#define NE0_RBCR0	10
#define NE0_RBCR1	11
#define NE0_RSR		12
#define  NE_RSR_PRX	 1
#define  NE_RSR_CRC	 2
#define  NE_RSR_FAE	 4
#define  NE_RSR_FO	 8
#define  NE_RSR_MPA	 16
#define  NE_RSR_PHY	 32
#define  NE_RSR_DIS	 64
#define  NE_RSR_DFR	 128
#define NE0_RCR		12
#define  NE_RCR_SEP	 1
#define  NE_RCR_AR	 2
#define  NE_RCR_AB	 4
#define  NE_RCR_AM	 8
#define  NE_RCR_PRO	 16
#define  NE_RCR_MON	 32
#define NE0_CNTR0	13
#define NE0_TCR		13
#define  NE_TCR_CRC	 1
#define  NE_TCR_LB0	 2
#define  NE_TCR_LB1	 4
#define  NE_TCR_ATD	 8
#define  NE_TCR_OFST	 16
#define NE0_CNTR1	14
#define NE0_DCR		14
#define  NE_DCR_WTS	 1
#define  NE_DCR_BOS	 2
#define NE0_CNTR2	15
#define NE0_IMR		15
#define  NE_IMR_PRXE	 1
#define  NE_IMR_PTXE	 2
#define  NE_IMR_RXEE	 4
#define  NE_IMR_TXEE	 8
#define  NE_IMR_OVWE	 16
#define  NE_IMR_CNTE	 32
#define  NE_IMR_RDCE	 64

#define NE1_PAR0	1
#define NE1_PAR1	2
#define NE1_PAR2	3
#define NE1_PAR3	4
#define NE1_PAR4	5
#define NE1_PAR5	6
#define NE1_CURR	7
#define NE1_MAR0	8
#define NE1_MAR1	9
#define NE1_MAR2	10
#define NE1_MAR3	11
#define NE1_MAR4	12
#define NE1_MAR5	13
#define NE1_MAR6	14
#define NE1_MAR7	15

#define NE2_PSTART	1
#define NE2_CLDA0	1
#define NE2_PSTOP	2
#define NE2_CLDA1	2
#define NE2_RNEXT	3
#define NE2_TPSR	4
#define NE2_LNEXT	5
#define NE2_AC1		6
#define NE2_AC0		7
#define NE2_RCR		12
#define NE2_TCR		13
#define NE2_DCR		14
#define NE2_IMR		15

#define NE3_RTL_9346CR	1
#define  NE3_RTL_9346CR_EEDO	1
#define  NE3_RTL_9346CR_EEDI	2
#define  NE3_RTL_9346CR_EESK	4
#define  NE3_RTL_9346CR_EECS	8
#define  NE3_RTL_9346CR_EEM0	64
#define  NE3_RTL_9346CR_EEM1	128
#define NE3_RTL_CONFIG0	3
#define  NE3_RTL_CONFIG0_BNC	4
#define NE3_RTL_CONFIG2	5
#define  NE3_RTL_CONFIG2_BS0	1
#define  NE3_RTL_CONFIG2_BS1	2
#define  NE3_RTL_CONFIG2_PF	16
#define  NE3_RTL_CONFIG2_FCE	32
#define  NE3_RTL_CONFIG2_PL0	64
#define  NE3_RTL_CONFIG2_PL1	128
#define NE3_RTL_CONFIG3	6
#define  NE3_RTL_CONFIG3_PWRDN	2
#define  NE3_RTL_CONFIG3_SLEEP	4
#define  NE3_RTL_CONFIG3_LEDS0	16
#define  NE3_RTL_CONFIG3_LEDS1	32
#define  NE3_RTL_CONFIG3_FUDUP	64
#define NE3_RTL_HLTCLK	9
#define NE3_RTL_ID0	14
#define NE3_RTL_ID1	15

#define NE_DATAPORT	16
#define NE_RESET	31

#define NE1SM_START_PG	0x20
#define NE1SM_STOP_PG	0x40
#define NESM_START_PG	0x40
#define NESM_STOP_PG	0x80

#define TX_2X_PAGES 12
#define TX_1X_PAGES 6

#define EI_PINGPONG

#ifdef EI_PINGPONG
#define TX_PAGES TX_2X_PAGES
#else
#define TX_PAGES TX_1X_PAGES
#endif

#endif
