#ifndef __NIC_SK_H
#define __NIC_SK_H

#include <ARCH/SETUP.H>
#include <SYS/TYPES.H>
#include <SPAD/PKT.H>
#include <SPAD/ETHERNET.H>
#include <SPAD/TIMER.H>
#include <ARCH/IRQ.H>
#include <ARCH/IO.H>
#include <SPAD/PCI.H>

#include "SKREG.H"

/* based on sk98lin driver (C) Copyright 1998-2002 SysKonnect.
			   (C) Copyright 2002-2004 Marvell. */

#define USE_MMIO
#define N_DESCRIPTORS			256	/* must not be changed, I don't know why */
#define N_STATUS_DESCRIPTORS		(16 * N_DESCRIPTORS)
#define MAX_420_RECV_DESC		21
#define INTR_DESCRIPTORS		32
#define MAC_ARBITER_TIMEOUT_AT_52	72
#define PKT_ARBITER_TIMEOUT_AT_52	0xffff
#define RI_ARBITER_TIMEOUT_AT_52	36
#define TX_ARBITER_TIMER		2500
#define TX_ARBITER_LIMIT		20
#define UPPER_PAUSE_THRESH		8192
#define LOWER_PAUSE_THRESH		16384
#define LOWER_LOWER_PAUSE_THRESH	10240
#define BLINK_SOURCE_TIME		500000
#define LED_TIME			50000
#define GMAC_FIFO_FLUSH_THRESH		10
#define SK_XM_RX_HI_WM			0x05aa
#define SK_XM_THR_JUMBO			0x03fc
#define SK_XM_THR_SL			0x01fb
#define SK_XM_THR_MULL			0x01fb
#define PHY_TIMEOUT			(JIFFIES_PER_SECOND / 10)
#define BMU_RX_WATERMARK		0x600
#define BMU_TX_WATERMARK		0x600
#define BMU_PCI33_RX_WATERMARK		0x300
#define BMU_PCI33_TX_WATERMARK		0x300
#define BMU_PEX_RX_WATERMARK		0x80
#define BMU_PEX_TX_WATERMARK		0x600
#define SKGE_TX_REAP_TIMER		(JIFFIES_PER_SECOND / 10)	/* must be low. TCP retransmits sooner than this are not possible */
#define SKGE_TX_TIMEOUT_CYCLES		20
#define SKY2_TX_TIMEOUT			(JIFFIES_PER_SECOND)
#define SK_TCP_SUM_START_1		DEFAULT_CHECKSUM_POS
#define SK_TCP_SUM_START_2		0
#define SK_ENABLE_TX_CHECKSUM
#define SK_ENABLE_RX_CHECKSUM
#define IPS_MAX				10000000
#define IPS_DEFAULT_1G			20000
#define IPS_DEFAULT_100M		2000
#define SKGE_MAX_SEND			(N_DESCRIPTORS - 1 - MAX_PACKET_FRAGMENTS(ETHERNET_JUMBO_MTU))
#define SKY2_MAX_SEND			(N_DESCRIPTORS - 1 - 1 - MAX_PACKET_FRAGMENTS(ETHERNET_JUMBO_MTU) * 2)
#define DEFAULT_SEND			16
#define TIMER_INTERVAL			30
#define SK_HIGH_INTERRUPT

#define DEFAULT_QUEUES			2
#define DEFAULT_MTU			ETHERNET_MTU
#define DUPLEX_HALF			1
#define DUPLEX_FULL			2
#define DUPLEX_AUTO			5
#define DUPLEX_AUTO_BIT			4
#define DEFAULT_DUPLEX			DUPLEX_HALF
#define SPEED_10			1
#define SPEED_100			2
#define SPEED_1000			3
#define SPEED_AUTO			7
#define SPEED_AUTO_BIT			4
#define DEFAULT_SPEED			SPEED_100

#define SK_ALIGN			4096

#define Y2_REV(rev)			((rev) >= SK_CHIP_REVISION_YUKON_XL && (rev) <= SK_CHIP_REVISION_YUKON_FE)

#define HAVE_SYNC_QUEUE(chip_id)	((chip_id) != SK_CHIP_REVISION_YUKON_EC && (chip_id) != SK_CHIP_REVISION_YUKON_FE)

typedef struct sk0 SK0;
typedef struct sk SK;
typedef struct mac MAC;
typedef struct xmit_pkt_info XMIT_PKT_INFO;
typedef struct tx_queue TX_QUEUE;

#ifndef USE_MMIO
#define sk0_ioentry	io_t io
#else
#define sk0_ioentry	__u8 *mem
#endif

struct sk0 {
	sk0_ioentry;
};

#ifdef SK_HIGH_INTERRUPT
#define skisr	__u32 isr;
#else
#define skisr
#endif

#ifndef USE_MMIO
#define range_entry	IO_RANGE range;
#else
#define range_entry
#endif

#define SK_ENTRIES							\
	sk0_ioentry;							\
	AST irq_ast;							\
	IRQ_CONTROL irq_ctrl;						\
	skisr								\
	__u32 imr;							\
	/*RANDOM_CTX rnd_ctx;*/						\
	unsigned first_stat;						\
	__u16 stat_sum_1;						\
	__u16 stat_sum_2;						\
	unsigned char chiptype;						\
	unsigned char chipsubtype;					\
	__u8 media;							\
	char n_macs;							\
	__u8 phytype;							\
	__u8 host_clock;						\
	char copper;							\
	char errorlevel;						\
	unsigned phyaddr;						\
	unsigned allocated_size;					\
	unsigned ramsize;						\
	unsigned ramoffs;						\
	int ips;							\
	int ips_100;							\
	pci_id_t id;							\
	__u32 hwimr;							\
	__u64 stat_dma64addr;						\
	vspace_dma64unlock_t *stat_dma64unlock;				\
	void *lnte;							\
	void *dlrq;							\
	char dev_name[__MAX_STR_LEN];					\
	PACKET *tmp_recv_packets[N_DESCRIPTORS];			\
	range_entry							\

#define CHIPTYPE_GENESIS		0
#define CHIPTYPE_YUKON			1
#define CHIPSUBTYPE_YUKON_LITE			1
#define CHIPSUBTYPE_YUKON_LITE_A1		2
#define CHIPSUBTYPE_YUKON_LITE_A3		3
#define CHIPTYPE_YUKON_2		2
#define CHIPSUBTYPE_YUKON_XL			4
#define CHIPSUBTYPE_YUKON_EC			5
#define CHIPSUBTYPE_YUKON_EC_A1			6
#define CHIPSUBTYPE_YUKON_EC_A2			7
#define CHIPSUBTYPE_YUKON_FE			8

#define Y2_BUG_42(sk)		((sk)->chipsubtype == CHIPSUBTYPE_YUKON_EC_A1)
#define Y2_BUG_43_418(sk)	((sk)->chipsubtype == CHIPSUBTYPE_YUKON_EC_A1)
#define Y2_BUG_46(sk)		((sk)->chipsubtype == CHIPSUBTYPE_YUKON_EC_A1)
#define Y2_BUG_420(sk)		((sk)->chipsubtype == CHIPSUBTYPE_YUKON_EC_A1)
#define Y2_BUG_423(sk)		((sk)->chipsubtype == CHIPSUBTYPE_YUKON_EC_A1)
#define Y2_BUG_424(sk)		((sk)->chipsubtype >= CHIPSUBTYPE_YUKON_EC_A1 && (sk)->chipsubtype <= CHIPSUBTYPE_YUKON_EC_A2)
#define Y2_BUG_425(sk)		((sk)->chipsubtype >= CHIPSUBTYPE_YUKON_EC_A1 && (sk)->chipsubtype <= CHIPSUBTYPE_YUKON_EC_A2)
#define Y2_BUG_427(sk)		((sk)->chipsubtype >= CHIPSUBTYPE_YUKON_XL)
#define Y2_BUG_428(sk)		((sk)->chipsubtype >= CHIPSUBTYPE_YUKON_EC_A1 && (sk)->chipsubtype <= CHIPSUBTYPE_YUKON_EC_A2)
#define Y2_BUG_4109(sk)		(1)
#define Y2_BUG_4115(sk)		((sk)->chipsubtype == CHIPSUBTYPE_YUKON_XL)

#if __DEBUG >= 2
#define mac_maps	int rcv_maps;
#define txq_maps	int snd_maps;
#else
#define mac_maps
#define txq_maps
#endif

#define MCAST_ALL	64
#define MCAST_PROMISC	65
#define N_MCAST		66

#define MAC_ENTRIES_WO_DESCS						\
	sk0_ioentry;							\
	int mac_2;		/* 0 for mac 1, -1 for mac 2 */		\
	SK *sk;								\
	unsigned first_recv;						\
	unsigned n_recv;						\
	unsigned max_n_recv;						\
	__u32 recv_hi_cache;						\
	int outstanding;						\
	int packet_input;						\
	PKTQUEUE *queue;						\
	unsigned mtu;							\
	unsigned char chiptype;						\
	unsigned char chipsubtype;					\
	char queues;							\
	__u8 duplex;							\
	__u8 speed;							\
	char force_address;						\
	__u16 address[3];						\
	unsigned phyid1;						\
	__u64 rcv_dma64addr;						\
	vspace_dma64unlock_t *rcv_dma64unlock;				\
	LINK_STATE link_state;						\
	WQ link_state_wait;						\
	WQ mcast_table[N_MCAST];					\
	int mcast_state;						\
	mac_maps							\

struct sk_for_align {
	SK_ENTRIES
	__u8 align[1];
};

struct mac_wo_descs_for_align {
	MAC_ENTRIES_WO_DESCS
	__u8 align1[1];
};

#define TX_QUEUE_WO_DESCS						\
	sk0_ioentry;							\
	unsigned cs_reg;						\
	unsigned first_sent;						\
	unsigned n_sent;						\
	unsigned max_sent;						\
	__u32 send_hi_cache;						\
	__s32 checksum_cache;						\
	TIMER timer;							\
	short timeout_cycles;						\
	unsigned char chiptype;						\
	unsigned char chipsubtype;					\
	int queue_2;		/* 0 for sync, -1 for async */		\
	MAC *mac;							\
	__u64 snd_dma64addr;						\
	vspace_dma64unlock_t *snd_dma64unlock;				\
	txq_maps

struct tx_queue_wo_descs_for_align {
	TX_QUEUE_WO_DESCS
	__u8 align1[1];
};

struct xmit_pkt_info {
	PACKET *p;
	vspace_dma64unlock_t *unlock;
};

#define TX_QUEUE_WO_TAIL						\
	TX_QUEUE_WO_DESCS						\
	__u8 align1[SK_ALIGN - (__offsetof(struct tx_queue_wo_descs_for_align, align1) & (SK_ALIGN - 1))];						\
	union {								\
		XMIT_DESC xmit[N_DESCRIPTORS];				\
		Y2_DESC y2_xmit[N_DESCRIPTORS];				\
	} u;								\
	XMIT_PKT_INFO xmit_info[N_DESCRIPTORS];				\
	__u64 xmit_addr[N_DESCRIPTORS];

struct tx_queue_wo_tail_for_align {
	TX_QUEUE_WO_TAIL
	__u8 align2[1];
};

struct tx_queue {
	TX_QUEUE_WO_TAIL
	__u8 align2[SK_ALIGN - (__offsetof(struct tx_queue_wo_tail_for_align, align2) & (SK_ALIGN - 1))];
};

#define MAC_ENTRIES_WO_TXQ						\
	MAC_ENTRIES_WO_DESCS						\
	__u8 align1[(-__offsetof(struct mac_wo_descs_for_align, align1)) & (SK_ALIGN - 1)];\
	union {								\
		RECV_DESC recv[N_DESCRIPTORS];				\
		Y2_DESC y2_recv[N_DESCRIPTORS];				\
	} u;								\
	PACKET *recv_packets[N_DESCRIPTORS];

struct mac_wo_txq_for_align {
	MAC_ENTRIES_WO_TXQ
};

struct mac {
	MAC_ENTRIES_WO_TXQ
	__u8 align2[(-sizeof(struct mac_wo_txq_for_align)) & (SK_ALIGN - 1)];
	TX_QUEUE xmit_queue[2];
};

struct sk {
	SK_ENTRIES
	__u8 align[SK_ALIGN - (__offsetof(struct sk_for_align, align) & (SK_ALIGN - 1))];
	Y2_DESC y2_status[N_STATUS_DESCRIPTORS];
	MAC macs[2];
};

#define PORT_ID(mac)		('A' ^ ((mac)->mac_2 & ('A' ^ 'B')))
#define QUEUE_ID(q)		(__unlikely(!(q)->queue_2) ? "SYNC" : "ASYNC")

/* general IO */
#ifndef USE_MMIO
#define SK_READ_8(sk, reg)	(__is_constant(reg) && (reg) < 0x80 ? io_inb((sk)->io + (reg)) : (io_outb((sk)->io + SK_RAP, (reg) >> 7), io_inb((sk)->io + 0x80 + ((reg) & 0x7f))))
#define SK_READ_16(sk, reg)	(__is_constant(reg) && (reg) < 0x80 ? io_inw((sk)->io + (reg)) : (io_outb((sk)->io + SK_RAP, (reg) >> 7), io_inw((sk)->io + 0x80 + ((reg) & 0x7f))))
#define SK_READ_32(sk, reg)	(__is_constant(reg) && (reg) < 0x80 ? io_inl((sk)->io + (reg)) : (io_outb((sk)->io + SK_RAP, (reg) >> 7), io_inl((sk)->io + 0x80 + ((reg) & 0x7f))))
#define SK_WRITE_8(sk, reg, v)	(__is_constant(reg) && (reg) < 0x80 ? io_outb((sk)->io + (reg), (v)) : (io_outb((sk)->io + SK_RAP, (reg) >> 7), io_outb((sk)->io + 0x80 + ((reg) & 0x7f), (v))))
#define SK_WRITE_16(sk, reg, v)	(__is_constant(reg) && (reg) < 0x80 ? io_outw((sk)->io + (reg), (v)) : (io_outb((sk)->io + SK_RAP, (reg) >> 7), io_outw((sk)->io + 0x80 + ((reg) & 0x7f), (v))))
#define SK_WRITE_32(sk, reg, v)	(__is_constant(reg) && (reg) < 0x80 ? io_outl((sk)->io + (reg), (v)) : (io_outb((sk)->io + SK_RAP, (reg) >> 7), io_outl((sk)->io + 0x80 + ((reg) & 0x7f), (v))))
#else
#define SK_READ_8(sk, i)	mmio_inb((sk)->mem + (i))
#define SK_READ_16(sk, i)	__16LE2CPU(mmio_inw((sk)->mem + (i)))
#define SK_READ_32(sk, i)	__32LE2CPU(mmio_inl((sk)->mem + (i)))
#define SK_WRITE_8(sk, i, v)	mmio_outb((sk)->mem + (i), (v))
#define SK_WRITE_16(sk, i, v)	mmio_outw((sk)->mem + (i), __16CPU2LE(v))
#define SK_WRITE_32(sk, i, v)	mmio_outl((sk)->mem + (i), __32CPU2LE(v))
#endif

/* XMAC IO */
#define XM_READ_16(ma, reg)	SK_READ_16((ma), SK_XMACII + (ADD_MAC2_SK_XMACII & (ma)->mac_2) + ((reg) << 1))
#define XM_WRITE_16(ma, reg, v)	SK_WRITE_16((ma), SK_XMACII + (ADD_MAC2_SK_XMACII & (ma)->mac_2) + ((reg) << 1), (v))
#define XM_READ_32(ma, reg)	(XM_READ_16((ma), (reg)) | (XM_READ_16((ma), (reg) + 1) << 16))
#define XM_WRITE_32(ma, reg, v)	(XM_WRITE_16((ma), (reg), (v)), XM_WRITE_16((ma), (reg) + 1, (v) >> 16))

/* GMAC IO */
#define GM_READ_16(ma, reg)	SK_READ_16((ma), SK_GMAC + (ADD_MAC2_SK_GMAC_GPHY & (ma)->mac_2) + (reg))
#define GM_WRITE_16(ma, reg, v)	SK_WRITE_16((ma), SK_GMAC + (ADD_MAC2_SK_GMAC_GPHY & (ma)->mac_2) + (reg), (v))
#define GM_READ_32(ma, reg)	(GM_READ_16((ma), (reg)) | (GM_READ_16((ma), (reg) + 4) << 16))
#define GM_WRITE_32(ma, reg, v)	(GM_WRITE_16((ma), (reg), (v)), GM_WRITE_16((ma), (reg) + 4, (v) >> 16))

__u16 XM_PHY_READ(MAC *mac, __u8 reg);
void XM_PHY_WRITE(MAC *mac, __u8 reg, __u16 val);
__u16 GM_PHY_READ(MAC *mac, __u8 reg);
void GM_PHY_WRITE(MAC *mac, __u8 reg, __u16 val);

#define GMAC_BAD_STATUS(stat, len)	(((stat) & (GMR_FS_LEN | GMR_FS_RX_OK | GMR_FS_CRC_ERR | GMR_FS_LONG_ERR | GMR_FS_MII_ERR | GMR_FS_BAD_FC | GMR_FS_GOOD_FC | GMR_FS_JABBER)) != (GMR_FS_RX_OK | ((len) << GMR_FS_LEN_SHIFT)))
#define XMAC_BAD_STATUS(stat, len)	(((stat) & (XMR_FS_LEN | XMR_FS_ERR | XMR_FS_2L_VLAN)) != ((len) << XMR_FS_LEN_SHIFT))

void *SK_LOOKUP(HANDLE *h, char *str, int open_flags);
extern IO_STUB SK_IOCTL;
void SK_BASIC_RESET(SK *sk);
void SK_CONTINUE_RESET(SK *sk);
void SK_MAC_IRQ(MAC *mac);
void SK_GPHY_IRQ(MAC *mac);
void SK_TIMER_FN(SK *sk);
void SK_TX_TIMEOUT(TX_QUEUE *q);
void SK_BAD_STATUS(MAC *mac, __u32 stat, unsigned len);

__const__ HANDLE_OPERATIONS SKGE_OPERATIONS;
extern AST_STUB SKGE_IRQ;
extern IRQ_STUB SKGE_IRQ_RT;
void SKGE_TIMER_FN(TIMER *t);
void SKGE_START_XMIT(MAC *mac);
void SKGE_TEAR_DOWN_SENT_PACKETS(MAC *mac);
void SKGE_TEAR_DOWN_RECV_PACKETS(MAC *mac, int free);
void SKGE_MAP_RCV_PACKET(MAC *mac, PACKET *p, unsigned idx);

__const__ HANDLE_OPERATIONS SKY2_OPERATIONS;
extern AST_STUB SKY2_IRQ;
extern IRQ_STUB SKY2_IRQ_RT;
void SKY2_TIMER_FN(TIMER *t);
void SKY2_START_XMIT(MAC *mac);
void SKY2_TEAR_DOWN_SENT_PACKETS(MAC *mac);
void SKY2_TEAR_DOWN_RECV_PACKETS(MAC *mac, int free);
void SKY2_ADD_RCV_PACKET(MAC *mac, PACKET *p);
void SKY2_KICK_RECEIVE(MAC *mac);

#define SK_RCVQ_FULL(mac)	((mac)->n_recv >= (mac)->max_n_recv)

#endif
