#include <SPAD/SYSLOG.H>

#include "SK.H"

extern IO_STUB SKGE_PACKET;
static void SKGE_UNMAP_TX_DESC_NOINLINE(TX_QUEUE *q, unsigned idx);
static void SKGE_TX_QUEUE_ERROR(TX_QUEUE *q);
static int SKGE_SPECIAL_IRQ(SK *sk, __u32 isr);
static void SKGE_BAD_RBCTRL(MAC *mac, __u32 rbctrl);

__const__ HANDLE_OPERATIONS SKGE_OPERATIONS = {
	SPL_X(SPL_SK),
	KERNEL$NO_VSPACE_GET,
	KERNEL$NO_VSPACE_PUT,
	KERNEL$NO_VSPACE_MAP,
	KERNEL$NO_VSPACE_DMALOCK,
	KERNEL$NO_VSPACE_DMA64LOCK,
	KERNEL$NO_VSPACE_PHYSLOCK,
	KERNEL$NO_VSPACE_GET_PAGEIN_RQ,
	KERNEL$NO_VSPACE_GET_PAGE,
	KERNEL$NO_VSPACE_SWAP_OP,
	NULL,			/* clone */
	SK_LOOKUP,		/* lookup */
	NULL,			/* create */
	NULL,			/* delete */
	NULL,			/* rename */
	NULL,			/* lookup_io */
	NULL,			/* instantiate */
	NULL,			/* leave */
	NULL,			/* detach */
	NULL,			/* open */
	NULL,			/* close */
	KERNEL$NO_OPERATION,	/* read */
	KERNEL$NO_OPERATION,	/* write */
	KERNEL$NO_OPERATION,	/* aread */
	KERNEL$NO_OPERATION,	/* awrite */
	SK_IOCTL,		/* ioctl */
	KERNEL$NO_OPERATION,	/* bio */
	SKGE_PACKET,		/* pktio */
};

__finline__ void SKGE_MAP_RCV_PACKET(MAC *mac, PACKET *p, unsigned idx)
{
	VDMA64 vdma;
	VDESC desc;
#if __DEBUG >= 2
	mac->rcv_maps++;
	if (__unlikely(mac->rcv_maps > N_DESCRIPTORS))
		KERNEL$SUICIDE("SKGE_MAP_RCV_PACKET: MAPS LEAKED");
	if (__unlikely(p->length < mac->mtu))
		KERNEL$SUICIDE("SKGE_ADD_RCV_PACKET: RECEIVE PACKET TOO SHORT (%d)", p->length);
#endif
	p->addrlen = ETHERNET_ADDRLEN;
	desc.ptr = (unsigned long)p->data + LL_HEADER - sizeof(struct eth_header);
	desc.len = mac->mtu + sizeof(struct eth_header);
	desc.vspace = &KERNEL$VIRTUAL;
	RAISE_SPL(SPL_VSPACE);
	KERNEL$VIRTUAL.op->vspace_dma64lock(&desc, PF_WRITE, &vdma, (vspace_dma64unlock_t **)&p->sender_data);
	LOWER_SPL(SPL_SK);
#ifdef __LITTLE_ENDIAN
	mac->u.recv[idx].rbadr = vdma.ptr;
#else
	mac->u.recv[idx].rbadr_lo = ((__u32 *)&vdma.ptr)[1];
	mac->u.recv[idx].rbadr_hi = ((__u32 *)&vdma.ptr)[0];
#endif
	__write_barrier();
	mac->u.recv[idx].rbctrl = RBCTRL_OWN + RBCTRL_STF + RBCTRL_EN_IRQ_EOF + RBCTRL_OPCODE_CHECKSUM + sizeof(struct eth_header) + mac->mtu;
}

static __finline__ void SKGE_UNMAP_RCV_PACKET(MAC *mac, PACKET *p, unsigned idx)
{
#if __DEBUG >= 2
	mac->rcv_maps--;
	if (__unlikely(mac->rcv_maps < 0))
		KERNEL$SUICIDE("SKGE_UNMAP_RCV_PACKET: MAP COUNT UNDERFLOW");
#endif
	RAISE_SPL(SPL_VSPACE);
	((vspace_dma64unlock_t *)p->sender_data)(
#ifdef __LITTLE_ENDIAN
		mac->u.recv[idx].rbadr
#else
		__make64(mac->u.recv[idx].rbadr_lo, mac->u.recv[idx].rbadr_hi)
#endif
	);
	LOWER_SPL(SPL_SK);
}

static __finline__ void SKGE_UNMAP_TX_DESC(TX_QUEUE *q, unsigned idx)
{
#if __DEBUG >= 2
	q->snd_maps--;
	if (__unlikely(q->snd_maps < 0))
		KERNEL$SUICIDE("SKGE_UNMAP_TX_DESC: MAP COUNT UNDERFLOW");
#endif
	RAISE_SPL(SPL_VSPACE);
	q->xmit_info[idx].unlock(
#ifdef __LITTLE_ENDIAN
		q->u.xmit[idx].tbadr
#else
		__make64(q->u.xmit[idx].tbadr_lo, q->u.xmit[idx].tbadr_hi)
#endif
	);
	LOWER_SPL(SPL_SK);
}

#define SKGE_CAN_SEND(q)	((q)->n_sent <= (q)->max_sent)

static void SKGE_SEND(TX_QUEUE *q, PACKET *p)
{
	VDESC desc;
	VDMA64 vdma;
	unsigned pos;
	__u32 tbctrl;
#ifndef SK_ENABLE_TX_CHECKSUM
	CHECKSUM_PACKET(p, {
		p->status = r_;
		CALL_PKT(p);
		return;
	});
#endif
	pos = (q->first_sent + q->n_sent) & (N_DESCRIPTORS - 1);
	desc.ptr = (unsigned long)p->data + LL_HEADER - sizeof(struct eth_header);
	desc.len = p->data_length + sizeof(struct eth_header);
	desc.vspace = &KERNEL$VIRTUAL;
	RAISE_SPL(SPL_VSPACE);
	KERNEL$VIRTUAL.op->vspace_dma64lock(&desc, PF_READ, &vdma, &q->xmit_info[pos].unlock);
	LOWER_SPL(SPL_SK);
#ifdef __LITTLE_ENDIAN
	q->u.xmit[pos].tbadr = vdma.ptr;
#else
	q->u.xmit[pos].tbadr_lo = ((__u32 *)&vdma.ptr)[1];
	q->u.xmit[pos].tbadr_hi = ((__u32 *)&vdma.ptr)[0];
#endif
#if __DEBUG >= 2
	q->snd_maps++;
	if (__unlikely(q->snd_maps > N_DESCRIPTORS))
		KERNEL$SUICIDE("SKGE_SEND: MAPS LEAKED");
#endif
	if (__unlikely(p->v.len != 0)) {
		unsigned ppos;
		q->xmit_info[pos].p = NULL;
		ppos = (pos + 1) & (N_DESCRIPTORS - 1);
		next_part:
		RAISE_SPL(SPL_VSPACE);
		p->v.vspace->op->vspace_dma64lock(&p->v, PF_READ, &vdma, &q->xmit_info[ppos].unlock);
		LOWER_SPL(SPL_SK);
		if (__unlikely(!vdma.len)) {
			p->flags |= PKT_PAGING_ERROR;
			p->status = -EVSPACEFAULT;
			unm_drop:
			while (pos != ppos) {
				SKGE_UNMAP_TX_DESC_NOINLINE(q, pos);
				pos = (pos + 1) & (N_DESCRIPTORS - 1);
			}
			CALL_PKT(p);
			return;
		}
#ifdef __LITTLE_ENDIAN
		q->u.xmit[ppos].tbadr = vdma.ptr;
#else
		q->u.xmit[ppos].tbadr_lo = ((__u32 *)&vdma.ptr)[1];
		q->u.xmit[ppos].tbadr_hi = ((__u32 *)&vdma.ptr)[0];
#endif
#if __DEBUG >= 2
		q->snd_maps++;
		if (__unlikely(q->snd_maps > N_DESCRIPTORS))
			KERNEL$SUICIDE("SKGE_SEND: MAPS LEAKED");
#endif
		if (__unlikely(vdma.len != p->v.len)) {
			q->u.xmit[ppos].tbctrl = TBCTRL_OWN + TBCTRL_OPCODE_DEFAULT + vdma.len;
			q->xmit_info[ppos].p = NULL;
			ppos = (ppos + 1) & (N_DESCRIPTORS - 1);
			if (__unlikely(ppos == q->first_sent)) {
				p->status = -EMSGSIZE;
				goto unm_drop;
			}
			p->v.ptr += vdma.len;
			p->v.len -= vdma.len;
			goto next_part;
		}
		q->u.xmit[ppos].tbctrl = TBCTRL_OWN + TBCTRL_EOF + TBCTRL_OPCODE_DEFAULT + vdma.len + (__unlikely((pos ^ (ppos + 1)) & ~(INTR_DESCRIPTORS - 1)) ? TBCTRL_EN_IRQ_EOF : 0);
		q->n_sent += (ppos + 1 - pos) & (N_DESCRIPTORS - 1);
		q->xmit_info[ppos].p = p;
		tbctrl = TBCTRL_OWN + TBCTRL_STF + TBCTRL_OPCODE_DEFAULT + sizeof(struct eth_header) + p->data_length;
		goto do_checks;
	} else {
		q->n_sent++;
		q->xmit_info[pos].p = p;
		tbctrl = TBCTRL_OWN + TBCTRL_STF + TBCTRL_EOF + TBCTRL_OPCODE_DEFAULT + vdma.len + (__unlikely(!((pos + 1) & (INTR_DESCRIPTORS - 1))) ? TBCTRL_EN_IRQ_EOF : 0);
		do_checks:
		if (__likely(p->flags & PKT_OUTPUT_CHECKSUM)) {
			tbctrl += TBCTRL_OPCODE_CHECKSUM - TBCTRL_OPCODE_DEFAULT;
			q->u.xmit[pos].reserved1 = 0;
			q->u.xmit[pos].tcp_sum_init_val = 0;
			q->u.xmit[pos].tcp_sum_start = CHECKSUM_FROM(p) + sizeof(struct eth_header);
			q->u.xmit[pos].tcp_sum_write = CHECKSUM_POS(p) + sizeof(struct eth_header);
		}
		__write_barrier();
		q->u.xmit[pos].tbctrl = tbctrl;
	}
	__barrier();
	SK_WRITE_8(q, q->cs_reg, SK_TX_CS_START_TX);
	KERNEL$DEL_TIMER(&q->timer);
	q->timeout_cycles = SKGE_TX_TIMEOUT_CYCLES;
	KERNEL$SET_TIMER(SKGE_TX_REAP_TIMER, &q->timer);
}

static __finline__ void SKGE_INSERT_PACKET(MAC *mac, PACKET *p)
{
	unsigned idx = (mac->first_recv + mac->n_recv) & (N_DESCRIPTORS - 1);
	mac->n_recv++;
	mac->recv_packets[idx] = p;
	SKGE_MAP_RCV_PACKET(mac, p, idx);
}

static __finline__ void SKGE_START_RECV(MAC *mac)
{
	__barrier();
	SK_WRITE_8(mac, SK_RX_CS + (mac->mac_2 & ADD_MAC2_SK_RX), SK_RX_CS_START_RX);
}

static void SKGE_INSERT_PACKET_AND_RECV(MAC *mac, PACKET *p)
{
	SKGE_INSERT_PACKET(mac, p);
	SKGE_START_RECV(mac);
}

DECL_AST(SKGE_PACKET_RETURNED, SPL_SK, PACKET)
{
	MAC *mac;
	PKT_AST_ENTER(RQ);
	mac = RQ->sender_data;
	mac->outstanding--;
	if (__likely(SK_RCVQ_FULL(mac))) {	/* this is needed for proper shutdown (i.e. don't touch registers after the card was reset). At other places in SKGE.C, we know that max_n_recv == N_DESCRIPTORS. In SKY2.C max_n_recv varies according to nic bugs */
		FREE_PACKET(RQ, NULL, SPL_SK);
	} else {
		RQ->flags &= PKT_REUSE_FLAGS;
		SKGE_INSERT_PACKET_AND_RECV(mac, RQ);
	}
	RETURN;
}

static void SKGE_RECEIVE(MAC *mac)
{
	while (mac->n_recv) {
		PACKET *p;
		unsigned str = mac->first_recv;
		__u32 rbctrl;
		__u32 stat;
		rbctrl = mac->u.recv[str].rbctrl;
		if (__unlikely(rbctrl & RBCTRL_OWN)) break;
		__read_barrier();
		mac->n_recv--;
		mac->first_recv = (str + 1) & (N_DESCRIPTORS - 1);
		stat = mac->u.recv[str].rfsw;
		p = mac->recv_packets[str];
		SKGE_UNMAP_RCV_PACKET(mac, p, str);
		PKT_PREFETCH_1(p);
		mac->recv_packets[str] = NULL;
#ifdef SK_ENABLE_RX_CHECKSUM
		p->flags |= PKT_INPUT_CHECKSUM;
		p->checksum.u = MKCHECKSUM(SK_TCP_SUM_START_1, mac->u.recv[str].tcp_sum_1);
#endif
		p->fn = SKGE_PACKET_RETURNED;
		p->sender_data = mac;
		p->h = mac->packet_input;
		p->id = (IDTYPE_PCI | (mac->sk->id & IDTYPE_MASK)) ^ mac->mac_2;
		mac->outstanding++;
		if (__unlikely((rbctrl & (RBCTRL_STF | RBCTRL_EOF | RBCTRL_STATUS_VALID | RBCTRL_TIME_STAMP_VALID)) != (RBCTRL_STF | RBCTRL_EOF | RBCTRL_STATUS_VALID | RBCTRL_TIME_STAMP_VALID))) {
			SKGE_BAD_RBCTRL(mac, rbctrl);
			goto drop;
		}
		rbctrl &= 0xffff;
		if (__unlikely(mac->chiptype == CHIPTYPE_GENESIS) ? __unlikely(XMAC_BAD_STATUS(stat, rbctrl)) : __unlikely(GMAC_BAD_STATUS(stat, rbctrl))) {
			SK_BAD_STATUS(mac, stat, rbctrl);
			goto drop;
		}
		p->data_length = rbctrl - sizeof(struct eth_header);
		if (__unlikely(p->data_length > mac->mtu)) {
			drop:
			p->status = -EIO;
			CALL_PKT(p);
			continue;
		}
		PKT_PREFETCH_2(p);
		CALL_IORQ(p, KERNEL$PKTIO);
	}
	if (__likely(mac->n_recv != N_DESCRIPTORS)) {
		do {
			PACKET *p;
			ALLOC_PACKET(p, mac->mtu, NULL, SPL_SK, break;);
			SKGE_INSERT_PACKET(mac, p);
		} while (mac->n_recv != N_DESCRIPTORS);
		SKGE_START_RECV(mac);
	}
}

static int SKGE_CLEANUP_TX_NONEMPTY(TX_QUEUE *q)
{
	MAC *mac;
	/*if (__unlikely(!q->n_sent)) return 1;*/
	if (__unlikely(q->u.xmit[q->first_sent].tbctrl & TBCTRL_OWN)) return 0;
	do {
		PACKET *p;
		unsigned stp = q->first_sent;
		unsigned tbctrl;
		tbctrl = q->u.xmit[stp].tbctrl;
		if (__unlikely(tbctrl & TBCTRL_OWN)) break;
		if (__likely(tbctrl & TBCTRL_EOF)) {
			if (__unlikely(!(p = q->xmit_info[stp].p))) {
				SKGE_TX_QUEUE_ERROR(q);
				return 1;
			}
			CALL_PKT(p);
		}
		SKGE_UNMAP_TX_DESC(q, stp);
		q->n_sent--;
		q->first_sent = (stp + 1) & (N_DESCRIPTORS - 1);
	} while (q->n_sent);
	KERNEL$DEL_TIMER(&q->timer);
	q->timeout_cycles = SKGE_TX_TIMEOUT_CYCLES;
	KERNEL$SET_TIMER(SKGE_TX_REAP_TIMER, &q->timer);
	mac = q->mac;
	if (__likely(mac->queues - q->queue_2 == 2)) while (__likely(SKGE_CAN_SEND(q))) {
		PACKET *p = NETQUE$DEQUEUE(mac->queue);
		if (__unlikely(!p)) break;
		if (__unlikely(!q->n_sent)) {
			if (__likely(q->max_sent < SKGE_MAX_SEND)) q->max_sent++;
		}
		SKGE_SEND(q, p);
	}
	return 1;
}

#define SKGE_CLEANUP_TX(qq)	(!(qq)->n_sent || SKGE_CLEANUP_TX_NONEMPTY(qq))

#ifdef SK_HIGH_INTERRUPT

DECL_RT_IRQ_HANDLER(SKGE_IRQ_RT)
{
	SK *sk = DATA;
	__u32 isr = SK_READ_32(sk, SK_SISR) & sk->imr;
	if (__unlikely(sk->isr)) {
		IRQ_RETURN;
	}
	if (__unlikely(!isr)) {
#if defined(__i386__) && defined(__GCC__)
		__barrier();	/* not needed but makes machinecode more
				   simple (i.e. no gcse for sk->imr) */
#endif
		SK_WRITE_32(sk, SK_IMR, sk->imr);
		IRQ_RETURN;
	}
	sk->isr = isr;
	IRQ_POST_AST(&sk->irq_ast);
}

#endif

DECL_AST(SKGE_IRQ, SPL_SK, AST)
{
	SK *sk = GET_STRUCT(RQ, SK, irq_ast);
	__u32 isr;
	SK_WRITE_8(sk, SK_TX_CS + ADD_ASYNC_SK_TX, SK_TX_CS_CLR_IRQ_EOF | SK_TX_CS_CLR_IRQ_ERR);
	/* cleanup must be before receive to allow fast retransmits */
	SKGE_CLEANUP_TX(&sk->macs[0].xmit_queue[1]);
	if (__likely(sk->macs[0].queues == 2)) {
		SK_WRITE_8(sk, SK_TX_CS, SK_TX_CS_CLR_IRQ_EOF | SK_TX_CS_CLR_IRQ_ERR);
		SKGE_CLEANUP_TX(&sk->macs[0].xmit_queue[0]);
	}
	if (__unlikely(sk->n_macs == 2)) {
		SK_WRITE_8(sk, SK_TX_CS + ADD_ASYNC_SK_TX + ADD_MAC2_SK_TX, SK_TX_CS_CLR_IRQ_EOF | SK_TX_CS_CLR_IRQ_ERR);
		SKGE_CLEANUP_TX(&sk->macs[1].xmit_queue[1]);
		if (__likely(sk->macs[1].queues == 2)) {
			SK_WRITE_8(sk, SK_TX_CS + ADD_MAC2_SK_TX, SK_TX_CS_CLR_IRQ_EOF | SK_TX_CS_CLR_IRQ_ERR);
			SKGE_CLEANUP_TX(&sk->macs[1].xmit_queue[0]);
		}
	}
#ifndef SK_HIGH_INTERRUPT
	isr = SK_READ_32(sk, SK_ISR) & sk->imr;
#else
	isr = sk->isr;
#endif
#define SPECIAL_IRQ	(SK_IRQ_HW_ERROR | SK_IRQ_PKT_TOUT_RX1 | SK_IRQ_PKT_TOUT_RX2 | SK_IRQ_PKT_TOUT_TX1 | SK_IRQ_PKT_TOUT_TX2 | SK_IRQ_I2C_READY | SK_IRQ_SW | SK_IRQ_EXTERNAL_REG | SK_IRQ_TIMER | SK_IRQ_MAC_1 | SK_IRQ_LINK_SYNC_MAC_1 | SK_IRQ_MAC_2 | SK_IRQ_LINK_SYNC_MAC_2 | SK_IRQ_CHCK_RX1 | SK_IRQ_CHCK_AS_TX1 | SK_IRQ_CHCK_S_TX1 | SK_IRQ_CHCK_RX2 | SK_IRQ_CHCK_AS_TX2 | SK_IRQ_CHCK_S_TX2)
	if (__unlikely(isr & SPECIAL_IRQ)) {
		if (SKGE_SPECIAL_IRQ(sk, isr)) goto ret;
	}
	if (__likely(isr & SK_IRQ_EOF_RX1)) {
		SK_WRITE_8(sk, SK_RX_CS, SK_RX_CS_CLR_IRQ_PAR | SK_RX_CS_CLR_IRQ_EOF | SK_RX_CS_CLR_IRQ_ERR);
		SKGE_RECEIVE(&sk->macs[0]);
	}
	if (__unlikely(isr & SK_IRQ_EOF_RX2)) {
		SK_WRITE_8(sk, SK_RX_CS + ADD_MAC2_SK_RX, SK_RX_CS_CLR_IRQ_PAR | SK_RX_CS_CLR_IRQ_EOF | SK_RX_CS_CLR_IRQ_ERR);
		SKGE_RECEIVE(&sk->macs[1]);
	}
	/*KERNEL$ADD_RANDOMNESS(&sk->rnd_ctx, NULL, 0);*/
#ifndef SK_HIGH_INTERRUPT
	ret:
	sk->irq_ctrl.eoi();
#else
	sk->isr = 0;
	__barrier();
	SK_WRITE_32(sk, SK_IMR, sk->imr);
	ret:
#endif
	RETURN;
}

DECL_IOCALL(SKGE_PACKET, SPL_SK, PACKET)
{
	HANDLE *h = RQ->handle;
	MAC *mac;
	__CHECK_PKT(RQ, "SKGE_PACKET");
	if (__unlikely(h->op != &SKGE_OPERATIONS)) RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_PKTIO);
	SWITCH_PROC_ACCOUNT_KERNEL_OPTIMIZE(h->name_addrspace, SPL_X(SPL_SK));
	mac = h->fnode;
	if (__unlikely(RQ->data_length + RQ->v.len > mac->mtu)) {
		RQ->status = -EMSGSIZE;
		RETURN_PKT(RQ);
	}
	RQ->status = 0;
	if (mac->queues == 1) {
		if (__likely(SKGE_CAN_SEND(&mac->xmit_queue[1]))) SKGE_SEND(&mac->xmit_queue[1], RQ);
		else NETQUE$ENQUEUE_PACKET(mac->queue, RQ);
	} else if (0) {		/* !!! TODO: classify packet */
		if (__likely(SKGE_CAN_SEND(&mac->xmit_queue[1]))) SKGE_SEND(&mac->xmit_queue[1], RQ);
		else class_slow: if (SKGE_CAN_SEND(&mac->xmit_queue[0])) SKGE_SEND(&mac->xmit_queue[0], RQ);
		else NETQUE$ENQUEUE_PACKET(mac->queue, RQ);
	} else goto class_slow;
	RETURN;
}

void SKGE_TIMER_FN(TIMER *t)
{
	TX_QUEUE *q = GET_STRUCT(t, TX_QUEUE, timer);
	LOWER_SPL(SPL_SK);
	VOID_LIST_ENTRY(&q->timer.list);
	if (__unlikely(!SKGE_CLEANUP_TX(q))) {
		if (__unlikely(!--q->timeout_cycles)) {
			SK_TX_TIMEOUT(q);
		} else {
			KERNEL$DEL_TIMER(&q->timer);
			KERNEL$SET_TIMER(SKGE_TX_REAP_TIMER, &q->timer);
		}
	}
}

void SKGE_START_XMIT(MAC *mac)
{
	TX_QUEUE *q = &mac->xmit_queue[2 - mac->queues];
	while (__likely(SKGE_CAN_SEND(q))) {
		PACKET *p = NETQUE$DEQUEUE(mac->queue);
		if (__unlikely(!p)) break;
		SKGE_SEND(q, p);
	}
}

static void SKGE_UNMAP_TX_DESC_NOINLINE(TX_QUEUE *q, unsigned idx)
{
	SKGE_UNMAP_TX_DESC(q, idx);
}

void SKGE_TEAR_DOWN_SENT_PACKETS(MAC *mac)
{
	unsigned i;
	unsigned j;
	for (i = 0; i < 2; i++) {
		for (j = 0; j < mac->xmit_queue[i].n_sent; j++) {
			unsigned idx = (mac->xmit_queue[i].first_sent + j) & (N_DESCRIPTORS - 1);
			SKGE_UNMAP_TX_DESC_NOINLINE(&mac->xmit_queue[i], idx);
			if (__likely(mac->xmit_queue[i].xmit_info[idx].p != NULL)) {
				mac->xmit_queue[i].xmit_info[idx].p->status = -EAGAIN;
				CALL_PKT(mac->xmit_queue[i].xmit_info[idx].p);
			}
		}
		mac->xmit_queue[i].first_sent = 0;
		mac->xmit_queue[i].n_sent = 0;
	}
}

void SKGE_TEAR_DOWN_RECV_PACKETS(MAC *mac, int free)
{
	int j;
	for (j = 0; j < mac->n_recv; j++) {
		SKGE_UNMAP_RCV_PACKET(mac, mac->recv_packets[(mac->first_recv + j) & (N_DESCRIPTORS - 1)], (mac->first_recv + j) & (N_DESCRIPTORS - 1));
		if (free) FREE_PACKET(mac->recv_packets[(mac->first_recv + j) & (N_DESCRIPTORS - 1)], NULL, SPL_SK);
	}
}

static void SKGE_TX_QUEUE_ERROR(TX_QUEUE *q)
{
	MAC *mac = q->mac;
	SK *sk = mac->sk;
	KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "PORT %c: %s TRANSMIT QUEUE ERROR: NO PACKET ON EOF ENTRY", PORT_ID(mac), QUEUE_ID(q));
	SK_BASIC_RESET(sk);
	SK_CONTINUE_RESET(sk);
}

static int SKGE_SPECIAL_IRQ(SK *sk, __u32 isr)
{
	if (isr & SK_IRQ_HW_ERROR) {
		int r = 0;
		__u32 hwisr = SK_READ_32(sk, SK_IHESR);
		if (hwisr & SK_HWIRQ_TS_TIMER_OVERFLOW) {
			SK_WRITE_8(sk, SK_GMAC_TS_CTRL, SK_GMAC_TS_CTRL_CLEAR_IRQ);
			r = 1;
		}
		if (hwisr & SK_HWIRQ_NO_STATUS_MAC_1) {
			SK_WRITE_16(sk, SK_RMF_MAC_CTRL, SK_RMF_MAC_CTRL_CLR_IRQ_NO_ST);
			r = 1;
		}
		if (hwisr & SK_HWIRQ_NO_STATUS_MAC_2) {
			SK_WRITE_16(sk, SK_RMF_MAC_CTRL + ADD_MAC2_SK_RMF, SK_RMF_MAC_CTRL_CLR_IRQ_NO_ST);
			r = 1;
		}
		if (hwisr & SK_HWIRQ_NO_TIMESTAMP_MAC_1) {
			SK_WRITE_16(sk, SK_RMF_MAC_CTRL, SK_RMF_MAC_CTRL_CLR_IRQ_NO_TS);
			r = 1;
		}
		if (hwisr & SK_HWIRQ_NO_TIMESTAMP_MAC_2) {
			SK_WRITE_16(sk, SK_RMF_MAC_CTRL + ADD_MAC2_SK_RMF, SK_RMF_MAC_CTRL_CLR_IRQ_NO_TS);
			r = 1;
		}
		if (hwisr & SK_HWIRQ_SENSOR) {
			if (sk->chiptype != CHIPTYPE_YUKON) {
				KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "SENSOR IRQ"), r = 2;
			} else {
				SK_WRITE_32(sk, SK_IMR, SK_READ_32(sk, SK_IMR) & ~SK_IRQ_HW_ERROR);
				sk->imr &= ~SK_IRQ_HW_ERROR;
				r = 1;
			}
		}
		if (hwisr & SK_HWIRQ_MASTER_ERROR) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PCI MASTER ERROR"), r = 2;
		if (hwisr & SK_HWIRQ_STATUS) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PCI STATUS ERROR"), r = 2;
		if (hwisr & SK_HWIRQ_PAR_RD_RAM) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PARITY ERROR READING FROM RAM"), r = 2;
		if (hwisr & SK_HWIRQ_PAR_WR_RAM) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PARITY ERROR WRITING TO RAM"), r = 2;
		if (hwisr & SK_HWIRQ_PAR_MAC_1) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PARITY ERROR ON MAC A"), r = 2;
		if (hwisr & SK_HWIRQ_PAR_MAC_2) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PARITY ERROR ON MAC B"), r = 2;
		if (hwisr & SK_HWIRQ_PAR_RX_1) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PARITY ERROR ON RECEIVE QUEUE A"), r = 2;
		if (hwisr & SK_HWIRQ_PAR_RX_2) KERNEL$SYSLOG(__SYSLOG_HW_ERROR, sk->dev_name, "PARITY ERROR ON RECEIVE QUEUE B"), r = 2;
		if (__likely(r == 1)) goto brk;
		if (__unlikely(!r)) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "UNKNOWN HARDWARE ERROR %08X", hwisr);
		SK_BASIC_RESET(sk);
		SK_CONTINUE_RESET(sk);
		return 1;
	}
	brk:
	if (isr & SK_IRQ_CHCK_AS_TX2) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INVALID DESCRIPTOR FOR ASYNC TX QUEUE ON PORT B");
	if (isr & SK_IRQ_CHCK_AS_TX1) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INVALID DESCRIPTOR FOR ASYNC TX QUEUE ON PORT A");
	if (isr & SK_IRQ_CHCK_S_TX2) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INVALID DESCRIPTOR FOR SYNC TX QUEUE ON PORT B");
	if (isr & SK_IRQ_CHCK_S_TX1) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INVALID DESCRIPTOR FOR SYNC TX QUEUE ON PORT A");
	if (isr & SK_IRQ_CHCK_RX2) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INVALID DESCRIPTOR FOR RX QUEUE ON PORT B");
	if (isr & SK_IRQ_CHCK_RX1) KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INVALID DESCRIPTOR FOR RX QUEUE ON PORT A");
	if (isr & (SK_IRQ_CHCK_AS_TX2 | SK_IRQ_CHCK_AS_TX1 | SK_IRQ_CHCK_S_TX2 | SK_IRQ_CHCK_S_TX1 | SK_IRQ_CHCK_RX2 | SK_IRQ_CHCK_RX1)) {
		SK_BASIC_RESET(sk);
		SK_CONTINUE_RESET(sk);
		return 1;
	}
	if (isr & SK_IRQ_PKT_TOUT_RX1) {
		if (sk->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_WARNING, sk->dev_name, "RECEIVE PACKET TIMEOUT ON PORT A");
		SK_WRITE_16(sk, SK_PA_CTRL, SK_PA_CTRL_CLR_IRQ_TOUT_RX1);
	}
	if (isr & SK_IRQ_PKT_TOUT_RX2) {
		if (sk->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_WARNING, sk->dev_name, "RECEIVE PACKET TIMEOUT ON PORT B");
		SK_WRITE_16(sk, SK_PA_CTRL, SK_PA_CTRL_CLR_IRQ_TOUT_RX2);
	}
	if (isr & SK_IRQ_PKT_TOUT_TX1) {
		if (sk->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_WARNING, sk->dev_name, "TRANSMIT PACKET TIMEOUT ON PORT A");
		SK_WRITE_16(sk, SK_PA_CTRL, SK_PA_CTRL_CLR_IRQ_TOUT_TX1);
		if (sk->chiptype == CHIPTYPE_GENESIS) {
			SK_BASIC_RESET(sk);
			SK_CONTINUE_RESET(sk);
			return 1;
		}
	}
	if (isr & SK_IRQ_PKT_TOUT_TX2) {
		if (sk->errorlevel >= 2)
			KERNEL$SYSLOG(__SYSLOG_HW_WARNING, sk->dev_name, "TRANSMIT PACKET TIMEOUT ON PORT B");
		SK_WRITE_16(sk, SK_PA_CTRL, SK_PA_CTRL_CLR_IRQ_TOUT_TX2);
		if (sk->chiptype == CHIPTYPE_GENESIS) {
			SK_BASIC_RESET(sk);
			SK_CONTINUE_RESET(sk);
			return 1;
		}
	}
	if (isr & SK_IRQ_I2C_READY) {
		SK_WRITE_32(sk, SK_I2C_HW_IRQ, SK_I2C_HW_IRQ_CLEAR);
	}
	if (isr & SK_IRQ_SW) {
		SK_WRITE_8(sk, SK_CS, SK_CS_CLEAR_IRQ_SW);
	}
	if (isr & SK_IRQ_EXTERNAL_REG) {
		int i;
		for (i = 0; i < sk->n_macs; i++) {
			if (sk->chiptype == CHIPTYPE_GENESIS) {
				if (sk->phytype == SK_EPROM_1_PHY_BCOM) {
					XM_PHY_READ(&sk->macs[i], PHY_BCOM_INT_STAT);
				}
			} else {
				SK_GPHY_IRQ(&sk->macs[i]);
			}
		}
	}
	if (isr & SK_IRQ_TIMER) {
		/*SK_WRITE_8(sk, SK_TIMER_CONTROL, SK_TIMER_CONTROL_STOP);*/
		SK_WRITE_8(sk, SK_TIMER_CONTROL, SK_TIMER_CONTROL_CLEAR_IRQ);
		SK_TIMER_FN(sk);
	}
	if (isr & SK_IRQ_MAC_1) {
		SK_MAC_IRQ(&sk->macs[0]);
	}
	if (isr & SK_IRQ_LINK_SYNC_MAC_1) {
		SK_WRITE_8(sk, SK_LS_CNT_CTRL, SK_LS_CNT_CTRL_CLEAR_IRQ);
	}
	if (isr & SK_IRQ_MAC_2) {
		if (sk->n_macs == 2) SK_MAC_IRQ(&sk->macs[1]);
		else {
			KERNEL$SYSLOG(__SYSLOG_HW_BUG, sk->dev_name, "INTERRUPT FROM NON-PRESENT MAC 2");
			SK_WRITE_32(sk, SK_IMR, SK_READ_32(sk, SK_IMR) & ~SK_IRQ_MAC_2);
			sk->imr &= ~SK_IRQ_MAC_2;
		}
	}
	if (isr & SK_IRQ_LINK_SYNC_MAC_2) {
		SK_WRITE_8(sk, SK_LS_CNT_CTRL + ADD_MAC2_SK_RMF, SK_LS_CNT_CTRL_CLEAR_IRQ);
	}
	return 0;
}

static void SKGE_BAD_RBCTRL(MAC *mac, __u32 rbctrl)
{
	SK *sk = mac->sk;
	int r = 0;
	if (__unlikely(!(rbctrl & RBCTRL_STATUS_VALID))) {
		if (sk->errorlevel >= 1) KERNEL$SYSLOG(__SYSLOG_NET_ERROR, sk->dev_name, "PORT %c: NO STATUS FROM MAC", PORT_ID(mac));
		r = 1;
	}
	if (__unlikely(!(rbctrl & RBCTRL_TIME_STAMP_VALID))) {
		if (sk->errorlevel >= 1) KERNEL$SYSLOG(__SYSLOG_NET_ERROR, sk->dev_name, "PORT %c: NO TIMESTAMP FROM MAC", PORT_ID(mac));
		r = 1;
	}
	if (r) return;
	if ((rbctrl & (RBCTRL_STF | RBCTRL_EOF)) != (RBCTRL_STF | RBCTRL_EOF)) {
		if (sk->errorlevel >= 1) KERNEL$SYSLOG(__SYSLOG_NET_ERROR, sk->dev_name, "PORT %c: TOO LONG FRAME RECEIVED", PORT_ID(mac));
	}
}
