#ifndef __NIC_SKREG_H
#define __NIC_SKREG_H

#include <SYS/TYPES.H>
#include <ENDIAN.H>

/* based on sk98lin driver (C) Copyright 1998-2002 SysKonnect.
			   (C) Copyright 2002-2004 Marvell. */

#define PCI_SK_OUR_1		0x40
#define  PCI_SK_OUR_1_VIO		(1 << 25)
#define  PCI_SK_OUR_1_EN_BOOT		(1 << 24)
#define  PCI_SK_OUR_1_EN_IO_MAPPING	(1 << 23)
#define  PCI_SK_OUR_1_EN_EPROM		(1 << 22)
#define  PCI_SK_OUR_1_PAGESIZE_1	(1 << 21)
#define  PCI_SK_OUR_1_PAGESIZE_0	(1 << 20)
#define  PCI_SK_OUR_1_PAGE_REG_2	(1 << 18)
#define  PCI_SK_OUR_1_PAGE_REG_1	(1 << 17)
#define  PCI_SK_OUR_1_PAGE_REG_0	(1 << 16)
#define  PCI_SK_OUR_1_NO_TAR		(1 << 15)
#define  PCI_SK_OUR_1_FORCE_BE		(1 << 14)
#define  PCI_SK_OUR_1_DIS_MRL		(1 << 13)
#define  PCI_SK_OUR_1_DIS_MRM		(1 << 12)
#define  PCI_SK_OUR_1_DIS_MWI		(1 << 11)
#define  PCI_SK_OUR_1_DISCONNECT_AT_CLS	(1 << 10)
#define  PCI_SK_OUR_1_BURST_DISABLE	(1 << 9)
#define  PCI_SK_OUR_1_DIS_PCI_CLOCK	(1 << 8)
#define  PCI_SK_OUR_1_SKEW_PCI_3	(1 << 7)
#define  PCI_SK_OUR_1_SKEW_PCI_2	(1 << 6)
#define  PCI_SK_OUR_1_SKEW_PCI_1	(1 << 5)
#define  PCI_SK_OUR_1_SKEW_PCI_0	(1 << 4)
#define  PCI_SK_OUR_1_SKEW_HOST_3	(1 << 3)
#define  PCI_SK_OUR_1_SKEW_HOST_2	(1 << 2)
#define  PCI_SK_OUR_1_SKEW_HOST_1	(1 << 1)
#define  PCI_SK_OUR_1_SKEW_HOST_0	(1 << 0)
#define  PCI_Y2_OUR_1_CLS_OPT		(1 << 3)
#define PCI_SK_OUR_2		0x44
#define  PCI_SK_OUR_2_VPD_WRITE_THR	(1 << 24)
#define  PCI_SK_OUR_2_VPD_DEVSEL	(1 << 17)
#define  PCI_SK_OUR_2_VPD_ROM_SIZE	(1 << 14)
#define  PCI_SK_OUR_2_PATCH_DIR_3	(1 << 11)
#define  PCI_SK_OUR_2_PATCH_DIR_2	(1 << 10)
#define  PCI_SK_OUR_2_PATCH_DIR_1	(1 << 9)
#define  PCI_SK_OUR_2_PATCH_DIR_0	(1 << 8)
#define  PCI_SK_OUR_2_EXT_PATCHES_3	(1 << 7)
#define  PCI_SK_OUR_2_EXT_PATCHES_2	(1 << 6)
#define  PCI_SK_OUR_2_EXT_PATCHES_1	(1 << 5)
#define  PCI_SK_OUR_2_EXT_PATCHES_0	(1 << 4)
#define  PCI_SK_OUR_2_EN_DUMMY_READ	(1 << 3)
#define  PCI_SK_OUR_2_REV_BYTE_DESC	(1 << 2)
#define  PCI_SK_OUR_2_USEDATA64		(1 << 0)
#define PCI_SK_OUR_STATUS	0x7c
#define  PCI_SK_OUR_STATUS_PCI64	(1 << 31)
#define  PCI_SK_OUR_STATUS_PCIX		(1 << 30)
#define  PCI_SK_OUR_STATUS_MODE_MASK	(3 << 28)
#define  PCI_SK_OUR_STATUS_PCI66	(1 << 27)
#define  PCI_SK_OUR_STATUS_PCI_X	(1 << 26)
#define  PCI_SK_OUR_STATUS_DLLE_MASK	(3 << 24)
#define  PCI_SK_OUR_STATUS_DLLR_MASK	(0xf << 20)
#define  PCI_SK_OUR_STATUS_DLLC_MASK	(0xf << 16)
#define PCI_SK_PEX_UNC_ERR_STAT	0x104
#define PCI_SK_PEX_UNC_ERR_MASK	0x104

#define SK_REGSPACE		0x4000
#define SK_IO_REGSPACE		0x0100

#define SK_RAP			0x0000
#define SK_CS			0x0004
#define  SK_CS_CLK_RUN_HOT		(1 << 13)
#define  SK_CS_CLK_RUN_RST		(1 << 12)
#define  SK_CS_CLK_RUN_ENA		(1 << 11)
#define  SK_CS_VAUX_AVAIL		(1 << 10)
#define  SK_CS_BUS_CLOCK		(1 << 9)
#define  SK_CS_SLOT_SIZE		(1 << 8)
#define  SK_CS_SET_IRQ_SW		(1 << 7)
#define  SK_CS_CLEAR_IRQ_SW		(1 << 6)
#define  SK_CS_STOP_MASTER_DONE		(1 << 5)
#define  SK_CS_STOP_MASTER		(1 << 4)
#define  SK_CS_MASTER_RESET_CLEAR	(1 << 3)
#define  SK_CS_MASTER_RESET_SET		(1 << 2)
#define  SK_CS_SW_RESET_CLEAR		(1 << 1)
#define  SK_CS_SW_RESET_SET		(1 << 0)
#define  SK_Y2_CS_VMAIN_AVAIL		(1 << 17)
#define  SK_Y2_CS_VAUX_AVAIL		(1 << 16)
#define  SK_Y2_CS_ASF_ENABLE		(1 << 13)
#define  SK_Y2_CS_ASF_DISABLE		(1 << 12)
#define  SK_Y2_CS_CLK_RUN_ENA		(1 << 11)
#define  SK_Y2_CS_CLK_RUN_DIS		(1 << 10)
#define  SK_Y2_CS_LED_STAT_ON		(1 << 9)
#define  SK_Y2_CS_LED_STAT_OFF		(1 << 8)
#define SK_LED			0x0006
#define  SK_LED_ON			(1 << 1)
#define  SK_LED_OFF			(1 << 0)
#define SK_POWER		0x0007
#define  SK_POWER_VAUX_ENA		(1 << 7)
#define  SK_POWER_VAUX_DIS		(1 << 6)
#define  SK_POWER_VCC_ENA		(1 << 5)
#define  SK_POWER_VCC_DIS		(1 << 4)
#define  SK_POWER_VAUX_ON		(1 << 3)
#define  SK_POWER_VAUX_OFF		(1 << 2)
#define  SK_POWER_VCC_ON		(1 << 1)
#define  SK_POWER_VCC_OFF		(1 << 0)
#define SK_ISR			0x0008
#define SK_IMR			0x000c
#define  SK_IRQ_HW_ERROR		(1 << 31)
#define  SK_IRQ_PKT_TOUT_RX1		(1 << 29)
#define  SK_IRQ_PKT_TOUT_RX2		(1 << 28)
#define  SK_IRQ_PKT_TOUT_TX1		(1 << 27)
#define  SK_IRQ_PKT_TOUT_TX2		(1 << 26)
#define  SK_IRQ_I2C_READY		(1 << 25)
#define  SK_IRQ_SW			(1 << 24)
#define  SK_IRQ_EXTERNAL_REG		(1 << 23)
#define  SK_IRQ_TIMER			(1 << 22)
#define  SK_IRQ_MAC_1			(1 << 21)
#define  SK_IRQ_LINK_SYNC_MAC_1		(1 << 20)
#define  SK_IRQ_MAC_2			(1 << 19)
#define  SK_IRQ_LINK_SYNC_MAC_2		(1 << 18)
#define  SK_IRQ_EOB_RX1			(1 << 17)
#define  SK_IRQ_EOF_RX1			(1 << 16)
#define  SK_IRQ_CHCK_RX1		(1 << 15)
#define  SK_IRQ_EOB_RX2			(1 << 14)
#define  SK_IRQ_EOF_RX2			(1 << 13)
#define  SK_IRQ_CHCK_RX2		(1 << 12)
#define  SK_IRQ_EOB_S_TX1		(1 << 11)
#define  SK_IRQ_EOF_S_TX1		(1 << 10)
#define  SK_IRQ_CHCK_S_TX1		(1 << 9)
#define  SK_IRQ_EOB_AS_TX1		(1 << 8)
#define  SK_IRQ_EOF_AS_TX1		(1 << 7)
#define  SK_IRQ_CHCK_AS_TX1		(1 << 6)
#define  SK_IRQ_EOB_S_TX2		(1 << 5)
#define  SK_IRQ_EOF_S_TX2		(1 << 4)
#define  SK_IRQ_CHCK_S_TX2		(1 << 3)
#define  SK_IRQ_EOB_AS_TX2		(1 << 2)
#define  SK_IRQ_EOF_AS_TX2		(1 << 1)
#define  SK_IRQ_CHCK_AS_TX2		(1 << 0)
#define  SK_Y2_IRQ_HW_ERROR		(1 << 31)
#define  SK_Y2_IRQ_STAT_BMU		(1 << 30)
#define  SK_Y2_IRQ_ASF			(1 << 29)
#define  SK_Y2_IRQ_POLL_CHECK		(1 << 27)
#define  SK_Y2_IRQ_I2C_READY		(1 << 26)
#define  SK_Y2_IRQ_SW			(1 << 25)
#define  SK_Y2_IRQ_TIMER		(1 << 24)
#define  SK_Y2_IRQ_PHY2			(1 << 12)
#define  SK_Y2_IRQ_MAC2			(1 << 11)
#define  SK_Y2_IRQ_RX2			(1 << 10)
#define  SK_Y2_IRQ_TXS2			(1 << 9)
#define  SK_Y2_IRQ_TXA2			(1 << 8)
#define  SK_Y2_IRQ_PHY1			(1 << 4)
#define  SK_Y2_IRQ_MAC1			(1 << 3)
#define  SK_Y2_IRQ_RX1			(1 << 2)
#define  SK_Y2_IRQ_TXS1			(1 << 1)
#define  SK_Y2_IRQ_TXA1			(1 << 0)
#define SK_IHESR		0x0010
#define SK_IHEMR		0x0014
#define  SK_HWIRQ_TS_TIMER_OVERFLOW	(1 << 13)
#define  SK_HWIRQ_SENSOR		(1 << 12)
#define  SK_HWIRQ_MASTER_ERROR		(1 << 11)
#define  SK_HWIRQ_STATUS		(1 << 10)
#define  SK_HWIRQ_NO_STATUS_MAC_1	(1 << 9)
#define  SK_HWIRQ_NO_STATUS_MAC_2	(1 << 8)
#define  SK_HWIRQ_NO_TIMESTAMP_MAC_1	(1 << 7)
#define  SK_HWIRQ_NO_TIMESTAMP_MAC_2	(1 << 6)
#define  SK_HWIRQ_PAR_RD_RAM		(1 << 5)
#define  SK_HWIRQ_PAR_WR_RAM		(1 << 4)
#define  SK_HWIRQ_PAR_MAC_1		(1 << 3)
#define  SK_HWIRQ_PAR_MAC_2		(1 << 2)
#define  SK_HWIRQ_PAR_RX_1		(1 << 1)
#define  SK_HWIRQ_PAR_RX_2		(1 << 0)
#define  SK_Y2_HWIRQ_TS_TIMER_OVERFLOW	(1 << 29)
#define  SK_Y2_HWIRQ_SENSOR		(1 << 28)
#define  SK_Y2_HWIRQ_MASTER_ERROR	(1 << 27)
#define  SK_Y2_HWIRQ_STATUS_EXCEPTION	(1 << 26)
#define  SK_Y2_HWIRQ_PCI_EXPRESS	(1 << 25)
#define  SK_Y2_HWIRQ_PCI_EXPRESS_ERROR	(1 << 24)
#define  SK_Y2_HWIRQ_PAR_RD_RAM_2	(1 << 13)
#define  SK_Y2_HWIRQ_PAR_WR_RAM_2	(1 << 12)
#define  SK_Y2_HWIRQ_PAR_MAC_2		(1 << 11)
#define  SK_Y2_HWIRQ_PAR_RX_2		(1 << 10)
#define  SK_Y2_HWIRQ_TCP_S2		(1 << 9)
#define  SK_Y2_HWIRQ_TCP_A2		(1 << 8)
#define  SK_Y2_HWIRQ_PAR_RD_RAM_1	(1 << 5)
#define  SK_Y2_HWIRQ_PAR_WR_RAM_1	(1 << 4)
#define  SK_Y2_HWIRQ_PAR_MAC_1		(1 << 3)
#define  SK_Y2_HWIRQ_PAR_RX_1		(1 << 2)
#define  SK_Y2_HWIRQ_TCP_S1		(1 << 1)
#define  SK_Y2_HWIRQ_TCP_A1		(1 << 0)
#define SK_SISR			0x0018
#define SK_Y2_SISR2		0x001c
#define SK_Y2_SISR3		0x0020
#define SK_Y2_EISR		0x0024
#define SK_Y2_LISR		0x0028
#define SK_Y2_ICR		0x002c
#define  SK_Y2_ICR_ENABLE		2

#define SK_XMACII_IMR		0x0020
#define SK_XMACII_ISR		0x0028
#define SK_XMACII_PHY_ADDR	0x0030
#define  SK_XMACII_PHY_ADDR_XMAC	(0 << 8)
#define  SK_XMACII_PHY_ADDR_BCOM	(1 << 8)
#define  SK_XMACII_PHY_ADDR_LONE	(2 << 8)
#define  SK_XMACII_PHY_ADDR_NAT		(0 << 8)
#define SK_XMACII_PHY_DATA	0x0034
#define  ADD_MAC2_SK_XMACII_I_P		0x0020

#define SK_BMU_CS_RECEIVE	0x0060
#define  ADD_MAC2_SK_BMU_CS_RECEIVE	0x0004
#define SK_BMU_CS_SYNC_XMIT	0x0068
#define SK_BMU_CS_ASYNC_XMIT	0x006c
#define  ADD_MAC2_SK_BMU_CS_XMIT	0x0008

/* EPROM */
#define SK_MAC_ADDR_1		0x0100
#define SK_MAC_ADDR_2		0x0108
#define SK_MAC_ADDR_3		0x0110
#define  ADD_MAC2_SK_MAC_ADDR		0x0008
#define SK_CONNECTOR		0x0118
#define  SK_PMD_CONNECTOR_UNDEFINED	0x00
#define  SK_PMD_CONNECTOR_DUPLEX_SC	0x43
#define  SK_PMD_CONNECTOR_SHIELDED_DSUB	0x44
#define  SK_PMD_CONNECTOR_SHIELDED_ANSI	0x46
#define  SK_PMD_CONNECTOR_UTP		0x4a
#define SK_PMD_TYPE		0x0119
#define  SK_PMD_TYPE_UNDEFINED		0x00
#define  SK_PMD_TYPE_1000BASE_CX	0x43
#define  SK_PMD_TYPE_1000BASE_LX	0x4c
#define  SK_PMD_TYPE_1000BASE_SX	0x53
#define  SK_PMD_TYPE_1000BASE_T		0x54
#define SK_CONFIGURATION	0x011a
#define  SK_CONFIGURATION_YU_LITE_A1	(3 << 4)
#define  SK_CONFIGURATION_YU_LITE_A3	(7 << 4)
#define  SK_CONFIGURATION_YU_EC_A1	(0 << 4)
#define  SK_CONFIGURATION_YU_EC_A2	(1 << 4)
#define  SK_CONFIGURATION_REV_MASK	(15 << 4)
#define  SK_CONFIGURATION_DIS_DL_CLOCKS	(1 << 1)
#define  SK_CONFIGURATION_SINGLE_MAC	(1 << 0)
#define SK_CHIP_REVISION	0x011b
#define  SK_CHIP_REVISION_GENESIS	0x0a
#define  SK_CHIP_REVISION_YUKON		0xb0
#define  SK_CHIP_REVISION_YUKON_LITE	0xb1
#define  SK_CHIP_REVISION_YUKON_LP	0xb2
#define  SK_CHIP_REVISION_YUKON_XL	0xb3
#define  SK_CHIP_REVISION_YUKON_EC	0xb6
#define  SK_CHIP_REVISION_YUKON_FE	0xb7
#define SK_EPROM_0		0x011c
#define  SK_EPROM_0_MEMORY_512_0	0x01
#define  SK_EPROM_0_MEMORY_1024_0	0x02
#define  SK_EPROM_0_MEMORY_1024_512	0x03
#define  SK_EPROM_0_MEMORY_2048_0	0x04
#define SK_EPROM_1		0x011d
#define  SK_EPROM_1_PHY_XMAC		0x00
#define  SK_EPROM_1_PHY_BCOM		0x01
#define  SK_EPROM_1_PHY_LONE		0x02
#define  SK_EPROM_1_PHY_NAT		0x03
#define  SK_EPROM_1_PHY_MARV_COPPER	0x04
#define  SK_EPROM_1_PHY_MARV_FIBER	0x05
#define SK_EPROM_2		0x011e
#define  SK_EPROM_2_DUAL_MAC		0x03
#define SK_EPROM_3		0x011f
#define  SK_EPROM_3_SELF_TEST_RESULT	0x0f
#define SK_EPROM_ADDR_COUNTER	0x0120
#define SK_Y2_CLK_CTRL		0x0120
#define  SK_Y2_CLK_CTRL_DIV		(1 << 21)
#define  SK_Y2_CLK_CTRL_SEL		(1 << 16)
#define  SK_Y2_CLK_CTRL_ENABLE		(1 << 1)
#define  SK_Y2_CLK_CTRL_DISABLE		(1 << 0)
#define SK_EPROM_DATA		0x0124
#define SK_LOADER_CONTROL	0x0128
#define SK_LOADER_TEST		0x0129
#define  SK_LOADER_TEST_ON		(1 << 3)
#define  SK_LOADER_TEST_OFF		(1 << 2)
#define  SK_LOADER_TEST_STEP		(1 << 1)
#define  SK_LOADER_TEST_START		(1 << 0)

/* Timer */
#define SK_TIMER_INIT_VAL	0x0130
#define SK_TIMER		0x0134
#define SK_TIMER_CONTROL	0x0138
#define  SK_TIMER_CONTROL_START		(1 << 2)
#define  SK_TIMER_CONTROL_STOP		(1 << 1)
#define  SK_TIMER_CONTROL_CLEAR_IRQ	(1 << 0)
#define SK_TIMER_TEST		0x0139
#define  SK_TIMER_TEST_ON		(1 << 2)
#define  SK_TIMER_TEST_OFF		(1 << 1)
#define  SK_TIMER_TEST_STEP		(1 << 0)

/* IRQ moderation */
#define SK_IRQM_TIMER_INIT_VAL	0x0140
#define SK_IRQM_TIMER		0x0144
#define SK_IRQM_TIMER_CONTROL	0x0148
#define  SK_IRQM_TIMER_CONTROL_START	(1 << 2)
#define  SK_IRQM_TIMER_CONTROL_STOP	(1 << 1)
#define SK_IRQM_TIMER_TEST	0x0149
#define  SK_IRQM_TIMER_TEST_ON		(1 << 2)
#define  SK_IRQM_TIMER_TEST_OFF		(1 << 1)
#define  SK_IRQM_TIMER_TEST_STOP	(1 << 0)
#define SK_IMMR			0x014c
#define SK_IHEMMR		0x0150

/* PCI test */
#define SK_TEST_CTRL_1		0x0158
#define  SK_TEST_CTRL_1_DATAPERR_MREAD	(1 << 7)
#define  SK_TEST_CTRL_1_DATAPERR_MWRITE	(1 << 6)
#define  SK_TEST_CTRL_1_DATAPERR_TREAD	(1 << 5)
#define  SK_TEST_CTRL_1_DATAPERR_TWRITE	(1 << 4)
#define  SK_TEST_CTRL_1_ADDRPERR_M	(1 << 3)
#define  SK_TEST_CTRL_1_ADDRPERR_T	(1 << 2)
#define  SK_TEST_CTRL_1_EN_CONFIG_ON	(1 << 1)
#define  SK_TEST_CTRL_1_EN_CONFIG_OFF	(1 << 0)
#define SK_TEST_CTRL_2		0x0159
#define  SK_TEST_CTRL_2_DATAPERR_MRD64	(1 << 3)
#define  SK_TEST_CTRL_2_DATAPERR_MWR64	(1 << 2)
#define  SK_TEST_CTRL_2_ADDRPERR_M64	(1 << 1)
#define  SK_TEST_CTRL_2_ADDRPERR_M64_2	(1 << 0)
#define SK_GENERAL_PURPOSE	0x015c
#define SK_GENERAL_PURPOSE_DIR	0x015e

/* I2C */
#define SK_I2C_HW_CONTROL	0x0160
#define  SK_I2C_HW_CONTROL_FLAG		(1 << 31)
#define  SK_I2C_HW_CONTROL_ADDRESS	(1 << 16)
#define  SK_I2C_HW_CONTROL_DEVSEL	(1 << 9)
#define  SK_I2C_HW_CONTROL_BURST	(1 << 4)
#define  SK_I2C_HW_CONTROL_SIZE_256	0x0
#define  SK_I2C_HW_CONTROL_SIZE_512	0x2
#define  SK_I2C_HW_CONTROL_SIZE_1024	0x4
#define  SK_I2C_HW_CONTROL_SIZE_2048	0x6
#define  SK_I2C_HW_CONTROL_SIZE_4096	0x8
#define  SK_I2C_HW_CONTROL_SIZE_8192	0xa
#define  SK_I2C_HW_CONTROL_SIZE_16384	0xc
#define  SK_I2C_HW_CONTROL_SIZE_32768	0xe
#define  SK_I2C_HW_CONTROL_STOP		(1 << 0)
#define SK_I2C_HW_DATA		0x0164
#define SK_I2C_HW_IRQ		0x0168
#define  SK_I2C_HW_IRQ_CLEAR		(1 << 0)
#define SK_I2C_SW		0x016c
#define  SK_I2C_SW_DATA_DIR		(1 << 2)
#define  SK_I2C_SW_DATA			(1 << 1)
#define  SK_I2C_SW_CLOCK		(1 << 0)

/* Blink source counter */
#define SK_BLINK_CNTR_INIT_VAL	0x0170
#define SK_BLINK_CNTR		0x0174
#define SK_BLINK_CNTR_CONTROL	0x0178
#define  SK_BLINK_CNTR_CONTROL_START	(1 << 1)
#define  SK_BLINK_CNTR_CONTROL_STOP	(1 << 0)
#define SK_BLINK_CNTR_STATUS	0x0179
#define  SK_BLINK_CNTR_STATUS_SOURCE	(1 << 0)
#define SK_BLINK_CNTR_TEST	0x017a
#define  SK_BLINK_CNTR_TEST_ON		(1 << 2)
#define  SK_BLINK_CNTR_TEST_OFF		(1 << 1)
#define  SK_BLINK_CNTR_TEST_STEP	(1 << 0)

/* RAM random access */
#define SK_RAM_ADDRESS		0x0180
#define SK_RAM_DATA_LO		0x0184
#define SK_RAM_DATA_HI		0x0188

/* RAM interface */
#define SK_RI_TIMEOUT_WRITE_RX	0x0190
#define SK_RI_TIMEOUT_WRITE_TXA	0x0191
#define SK_RI_TIMEOUT_WRITE_TXS	0x0192
#define SK_RI_TIMEOUT_READ_RX	0x0193
#define SK_RI_TIMEOUT_READ_TXA	0x0194
#define SK_RI_TIMEOUT_READ_TXS	0x0195
#define  ADD_MAC2_SK_RI_TIMEOUT		0x0006

#define SK_RI_TIMEOUT_TIMER	0x019c
#define SK_RI_CTRL		0x01a0
#define  SK_RI_CTRL_CLEAR_IRQ_PAR_RD	(1 << 9)
#define  SK_RI_CTRL_CLEAR_IRQ_PAR_WR	(1 << 8)
#define  SK_RI_CTRL_RESET_CLEAR		(1 << 1)
#define  SK_RI_CTRL_RESET_SET		(1 << 0)
#define SK_RI_TIMER_TEST	0x01a2
#define  SK_RI_TIMER_TEST_ON		(1 << 2)
#define  SK_RI_TIMER_TEST_OFF		(1 << 1)
#define  SK_RI_TIMER_TEST_STEP		(1 << 0)
#define  ADD_RB2_SK_RI_CTRL	0x0040

/* MAC arbiter */
#define SK_MA_TIMEOUT_INIT_RX	0x01b0
#define SK_MA_TIMEOUT_INIT_TX	0x01b2
#define SK_MA_TIMEOUT_TIMER_RX	0x01b4
#define SK_MA_TIMEOUT_TIMER_TX	0x01b6
#define  ADD_MAC2_SK_MA_TIMEOUT_TIMER	0x0001
#define SK_MA_CTRL		0x01b8
#define  SK_MA_CTRL_FAST_OE_ON		(1 << 3)
#define  SK_MA_CTRL_FAST_OE_OFF		(1 << 2)
#define  SK_MA_CTRL_RESET_CLEAR		(1 << 1)
#define  SK_MA_CTRL_RESET_SET		(1 << 0)
#define SK_MA_TIMER_TEST	0x01ba
#define  SK_MA_TIMER_TEST_TOUT_TX2	(1 << 15)
#define  SK_MA_TIMER_TEST_TOUT_TX2_ON	(1 << 14)
#define  SK_MA_TIMER_TEST_TOUT_TX2_OFF	(1 << 13)
#define  SK_MA_TIMER_TEST_TOUT_TX2_STEP	(1 << 12)
#define  SK_MA_TIMER_TEST_TOUT_TX1	(1 << 11)
#define  SK_MA_TIMER_TEST_TOUT_TX1_ON	(1 << 10)
#define  SK_MA_TIMER_TEST_TOUT_TX1_OFF	(1 << 9)
#define  SK_MA_TIMER_TEST_TOUT_TX1_STEP	(1 << 8)
#define  SK_MA_TIMER_TEST_TOUT_RX2	(1 << 7)
#define  SK_MA_TIMER_TEST_TOUT_RX2_ON	(1 << 6)
#define  SK_MA_TIMER_TEST_TOUT_RX2_OFF	(1 << 5)
#define  SK_MA_TIMER_TEST_TOUT_RX2_STEP	(1 << 4)
#define  SK_MA_TIMER_TEST_TOUT_RX1	(1 << 3)
#define  SK_MA_TIMER_TEST_TOUT_RX1_ON	(1 << 2)
#define  SK_MA_TIMER_TEST_TOUT_RX1_OFF	(1 << 1)
#define  SK_MA_TIMER_TEST_TOUT_RX1_STEP	(1 << 0)

#define SK_MA_RECOVERY_INIT_RX	0x01c0
#define SK_MA_RECOVERY_INIT_TX	0x01c2
#define SK_MA_RECOVERY_TIMER_RX	0x01c4
#define SK_MA_RECOVERY_TIMER_TX	0x01c6
#define  ADD_MAC2_SK_MA_RECOVERY_TIMER	0x0001
#define SK_MA_RECOVERY_CTRL	0x01c8
#define  SK_MA_RECOVERY_CTRL_EN_TX2_ON	(1 << 7)
#define  SK_MA_RECOVERY_CTRL_EN_TX2_OFF	(1 << 6)
#define  SK_MA_RECOVERY_CTRL_EN_TX1_ON	(1 << 5)
#define  SK_MA_RECOVERY_CTRL_EN_TX1_OFF	(1 << 4)
#define  SK_MA_RECOVERY_CTRL_EN_RX2_ON	(1 << 3)
#define  SK_MA_RECOVERY_CTRL_EN_RX2_OFF	(1 << 2)
#define  SK_MA_RECOVERY_CTRL_EN_RX1_ON	(1 << 1)
#define  SK_MA_RECOVERY_CTRL_EN_RX1_OFF	(1 << 0)
#define SK_MA_RECOVERY_TEST	0x01ca
#define  SK_MA_RECOVERY_TEST_TX2	(1 << 15)
#define  SK_MA_RECOVERY_TEST_TX2_ON	(1 << 14)
#define  SK_MA_RECOVERY_TEST_TX2_OFF	(1 << 13)
#define  SK_MA_RECOVERY_TEST_TX2_STEP	(1 << 12)
#define  SK_MA_RECOVERY_TEST_TX1	(1 << 11)
#define  SK_MA_RECOVERY_TEST_TX1_ON	(1 << 10)
#define  SK_MA_RECOVERY_TEST_TX1_OFF	(1 << 9)
#define  SK_MA_RECOVERY_TEST_TX1_STEP	(1 << 8)
#define  SK_MA_RECOVERY_TEST_RX2	(1 << 7)
#define  SK_MA_RECOVERY_TEST_RX2_ON	(1 << 6)
#define  SK_MA_RECOVERY_TEST_RX2_OFF	(1 << 5)
#define  SK_MA_RECOVERY_TEST_RX2_STEP	(1 << 4)
#define  SK_MA_RECOVERY_TEST_RX1	(1 << 3)
#define  SK_MA_RECOVERY_TEST_RX1_ON	(1 << 2)
#define  SK_MA_RECOVERY_TEST_RX1_OFF	(1 << 1)
#define  SK_MA_RECOVERY_TEST__RX1_STEP	(1 << 0)

/* Packet arbiter */
#define SK_PA_TIMEOUT_INIT_RX	0x01d0	/* 16 bits */
#define SK_PA_TIMEOUT_INIT_TX	0x01d8	/* 16 bits */
#define SK_PA_TIMEOUT_RX	0x01e0	/* 16 bits */
#define SK_PA_TIMEOUT_TX	0x01e8	/* 16 bits */
#define  ADD_MAC2_SK_PA_TIMEOUT		0x0004
#define SK_PA_CTRL		0x01f0
#define  SK_PA_CTRL_CLR_IRQ_TOUT_TX2	(1 << 13)
#define  SK_PA_CTRL_CLR_IRQ_TOUT_TX1	(1 << 12)
#define  SK_PA_CTRL_CLR_IRQ_TOUT_RX2	(1 << 11)
#define  SK_PA_CTRL_CLR_IRQ_TOUT_RX1	(1 << 10)
#define  SK_PA_CTRL_EN_TIMEOUT_TX2_ON	(1 << 9)
#define  SK_PA_CTRL_EN_TIMEOUT_TX2_OFF	(1 << 8)
#define  SK_PA_CTRL_EN_TIMEOUT_TX1_ON	(1 << 7)
#define  SK_PA_CTRL_EN_TIMEOUT_TX1_OFF	(1 << 6)
#define  SK_PA_CTRL_EN_TIMEOUT_RX2_ON	(1 << 5)
#define  SK_PA_CTRL_EN_TIMEOUT_RX2_OFF	(1 << 4)
#define  SK_PA_CTRL_EN_TIMEOUT_RX1_ON	(1 << 3)
#define  SK_PA_CTRL_EN_TIMEOUT_RX1_OFF	(1 << 2)
#define  SK_PA_RESET_CLEAR		(1 << 1)
#define  SK_PA_RESET_SET		(1 << 0)
#define SK_PA_TIMER_TEST	0x01f2
#define  SK_PA_TIMER_TEST_TX2_TEST_ON	(1 << 14)
#define  SK_PA_TIMER_TEST_TX2_TEST_OFF	(1 << 13)
#define  SK_PA_TIMER_TEST_TX2_STEP	(1 << 12)
#define  SK_PA_TIMER_TEST_TX1_TEST_ON	(1 << 10)
#define  SK_PA_TIMER_TEST_TX1_TEST_OFF	(1 << 9)
#define  SK_PA_TIMER_TEST_TX1_STEP	(1 << 8)
#define  SK_PA_TIMER_TEST_RX2_TEST_ON	(1 << 6)
#define  SK_PA_TIMER_TEST_RX2_TEST_OFF	(1 << 5)
#define  SK_PA_TIMER_TEST_RX2_STEP	(1 << 4)
#define  SK_PA_TIMER_TEST_RX1_TEST_ON	(1 << 2)
#define  SK_PA_TIMER_TEST_RX1_TEST_OFF	(1 << 1)
#define  SK_PA_TIMER_TEST_RX1_STEP	(1 << 0)

/* Transmit arbiter */
#define SK_TA_INT_TIMER_INIT	0x0200	/* 24 bits */
#define SK_TA_INT_TIMER		0x0204	/* 24 bits */
#define SK_TA_LIMIT_CNT_INIT	0x0208	/* 24 bits */
#define SK_TA_LIMIT_CNT		0x020c	/* 24 bits */
#define SK_TA_CTRL		0x0210
#define  SK_TA_CTRL_FORCE_SYNC_ON	(1 << 7)
#define  SK_TA_CTRL_FORCE_SYNC_OFF	(1 << 6)
#define  SK_TA_CTRL_EN_ALLOC		(1 << 5)
#define  SK_TA_CTRL_DIS_ALLOC		(1 << 4)
#define  SK_TA_CTRL_RATE_CONTROL_START	(1 << 3)
#define  SK_TA_CTRL_RATE_CONTROL_STOP	(1 << 2)
#define  SK_TA_CTRL_OPERATIONAL_ON	(1 << 1)
#define  SK_TA_CTRL_OPERATIONAL_OFF	(1 << 0)
#define SK_TA_TEST		0x0211
#define  SK_TA_TEST_INT_TIMER_TEST_ON	(1 << 5)
#define  SK_TA_TEST_INT_TIMER_TEST_OFF	(1 << 4)
#define  SK_TA_TEST_INT_TIMER_STEP	(1 << 3)
#define  SK_TA_TEST_LIMIT_CNT_TEST_ON	(1 << 2)
#define  SK_TA_TEST_LIMIT_CNT_TEST_OFF	(1 << 1)
#define  SK_TA_TEST_LIMIT_CNT_STEP	(1 << 0)
#define SK_TA_STATUS		0x0212
#define  SK_TA_STATUS_PRIORITY_SYNC	(1 << 0)
#define  ADD_MAC2_TRANSMIT_ARBITER	0x0080

#define SK_EXTERNAL		0x0300
#define SK_CONFIGURATION_FILE	0x0380

/* Receive queue */
#define SK_RX_BUFFER_BYTE_CNT	0x0400
#define SK_RX_BUFFER_CTRL	0x0402
#define SK_RX_NEXT_DESC_LO	0x0404
#define SK_RX_BUFFER_LO		0x0408
#define SK_RX_BUFFER_HI		0x040c
#define SK_RX_FRAME_STATUS	0x0410
#define SK_RX_TIME_STAMP	0x0414
#define SK_RX_CHECKSUM_1	0x0418
#define SK_RX_CHECKSUM_2	0x041a
#define SK_RX_START_CHECKSUM_1	0x041c
#define SK_RX_START_CHECKSUM_2	0x041e

#define SK_RX_CUR_DESC_LO	0x0420
#define SK_RX_CUR_DESC_HI	0x0424
#define SK_Y2_RX_DONE		0x0424
#define SK_RX_CUR_ADDR_CNT_LO	0x0428
#define SK_RX_CUR_ADDR_CNT_HI	0x042c
#define SK_RX_CUR_BYTE_CNT	0x0430
#define SK_RX_CS		0x0434
#define  SK_RX_CS_SUPEVISOR_IDLE	(1 << 24)
#define  SK_RX_CS_RESET_DESC_CLEAR	(1 << 21)
#define  SK_RX_CS_RESET_DESC_SET	(1 << 20)
#define  SK_RX_CS_RESET_FIFO_CLEAR	(1 << 19)
#define  SK_RX_CS_RESET_FIFO_SET	(1 << 18)
#define  SK_RX_CS_RUN_PFI_SM		(1 << 17)
#define  SK_RX_CS_RESET_PFI_SM		(1 << 16)
#define  SK_RX_CS_RUN_SUPERVISOR_SM	(1 << 15)
#define  SK_RX_CS_RESET_SUPERVISOR_SM	(1 << 14)
#define  SK_RX_CS_RUN_DESC_READ_SM	(1 << 13)
#define  SK_RX_CS_RESET_DESC_READ_SM	(1 << 12)
#define  SK_RX_CS_RUN_DESC_WRITE_SM	(1 << 11)
#define  SK_RX_CS_RESET_DESC_WRITE_SM	(1 << 10)
#define  SK_RX_CS_RUN_TRANSFER_SM	(1 << 9)
#define  SK_RX_CS_RESET_TRANSFER_SM	(1 << 8)
#define  SK_RX_CS_EN_POLLING_ON		(1 << 7)
#define  SK_RX_CS_EN_POLLING_OFF	(1 << 6)
#define  SK_RX_CS_STOP_RX		(1 << 5)
#define  SK_RX_CS_START_RX		(1 << 4)
#define  SK_RX_CS_CLR_IRQ_PAR		(1 << 3)
#define  SK_RX_CS_CLR_IRQ_EOB		(1 << 2)
#define  SK_RX_CS_CLR_IRQ_EOF		(1 << 1)
#define  SK_RX_CS_CLR_IRQ_ERR		(1 << 0)
#define  SK_Y2_RX_CS_IDLE		(1 << 31)
#define  SK_Y2_RX_CS_TCP_PKT		(1 << 30)
#define  SK_Y2_RX_CS_IP_PKT		(1 << 29)
#define  SK_Y2_RX_CS_RSS_HASH_ENA	(1 << 15)
#define  SK_Y2_RX_CS_RSS_HASH_DIS	(1 << 14)
#define  SK_Y2_RX_CS_CHKSUM_ENA		(1 << 13)
#define  SK_Y2_RX_CS_CHKSUM_DIS		(1 << 12)
#define  SK_Y2_RX_CS_CLR_IRQ_PAR	(1 << 11)
#define  SK_Y2_RX_CS_CLR_IRQ_CHK	(1 << 10)
#define  SK_Y2_RX_CS_STOP_RX		(1 << 9)
#define  SK_Y2_RX_CS_START_RX		(1 << 8)
#define  SK_Y2_RX_CS_FIFO_OP_ON		(1 << 7)
#define  SK_Y2_RX_CS_FIFO_OP_OFF	(1 << 6)
#define  SK_Y2_RX_CS_FIFO_ENA		(1 << 5)
#define  SK_Y2_RX_CS_FIFO_RESET		(1 << 4)
#define  SK_Y2_RX_CS_OP_ON		(1 << 3)
#define  SK_Y2_RX_CS_OP_OFF		(1 << 2)
#define  SK_Y2_RX_CS_CLEAR_RESET	(1 << 1)
#define  SK_Y2_RX_CS_SET_RESET		(1 << 0)
#define SK_RX_FLAG		0x0438
#define  SK_RX_FLAG_ALMOST_FULL		(1 << 27)
#define  SK_RX_FLAG_EOF_IN_FIFO		(1 << 26)
#define  SK_RX_FLAG_WATERMARK_REACHED	(1 << 25)
#define  SK_RX_FLAG_FIFO_LEVEL		(1 << 16)	/* 8 bits */
#define  SK_RX_FLAG_WATERMARK		(1 << 0)	/* 8 bits */
#define SK_RX_TEST_1		0x043c
#define SK_RX_TEST_2		0x0440
#define SK_Y2_RX_WATERMARK	0x0440
#define SK_Y2_RX_ALIGNMENT	0x0442
#define SK_RX_TEST_3		0x0444
#define SK_Y2_RX_RSP		0x0444
#define SK_Y2_RX_RSL		0x0446
#define SK_Y2_RX_RP		0x0448
#define SK_Y2_RX_RL		0x044a
#define SK_Y2_RX_WP		0x044c
#define SK_Y2_RX_WSP		0x044d
#define SK_Y2_RX_WL		0x044e
#define SK_Y2_RX_WSL		0x044f
#define SK_Y2_RX_PREF_CTRL	0x0450
#define  SK_Y2_RX_PREF_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_Y2_RX_PREF_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_Y2_RX_PREF_CTRL_RESET_CLEAR		(1 << 1)
#define  SK_Y2_RX_PREF_CTRL_RESET_SET		(1 << 0)
#define SK_Y2_RX_PREF_LAST_IDX	0x0454
#define SK_Y2_RX_PREF_ADDR_LO	0x0458
#define SK_Y2_RX_PREF_ADDR_HI	0x045c
#define SK_Y2_RX_GET_IDX	0x0460
#define SK_Y2_RX_PUT_IDX	0x0464
#define SK_Y2_RX_FIFO_WP	0x0470
#define SK_Y2_RX_FIFO_RP	0x0474
#define SK_Y2_RX_FIFO_WM	0x0478
#define SK_Y2_RX_FIFO_LEVEL	0x047c
#define  ADD_MAC2_SK_RX			0x0080

/* Sync transmit queue */
#define SK_TX_BUFFER_BYTE_CNT	0x0600
#define SK_TX_BUFFER_CTRL	0x0602
#define SK_TX_NEXT_DESC_LO	0x0604
#define SK_TX_BUFFER_LO		0x0608
#define SK_TX_BUFFER_HI		0x060c
#define SK_TX_FRAME_STATUS	0x0610
#define SK_TX_CHECKSUM_ST_VAL	0x0614
#define SK_TX_CHECKSUM_WR_POS	0x0618
#define SK_TX_CHECKSUM_ST_POS	0x061a

#define SK_TX_CUR_DESC_LO	0x0620
#define SK_TX_CUR_DESC_HI	0x0624
#define SK_Y2_TX_DONE		0x0624
#define SK_TX_CUR_ADDR_CNT_LO	0x0628
#define SK_TX_CUR_ADDR_CNT_HI	0x062c
#define SK_TX_CUR_BYTE_CNT	0x0630
#define SK_TX_CS		0x0634
#define  SK_TX_CS_SUPEVISOR_IDLE	(1 << 24)
#define  SK_TX_CS_RESET_DESC_CLEAR	(1 << 21)
#define  SK_TX_CS_RESET_DESC_SET	(1 << 20)
#define  SK_TX_CS_RESET_FIFO_CLEAR	(1 << 19)
#define  SK_TX_CS_RESET_FIFO_SET	(1 << 18)
#define  SK_TX_CS_RUN_PFI_SM		(1 << 17)
#define  SK_TX_CS_RESET_PFI_SM		(1 << 16)
#define  SK_TX_CS_RUN_SUPERVISOR_SM	(1 << 15)
#define  SK_TX_CS_RESET_SUPERVISOR_SM	(1 << 14)
#define  SK_TX_CS_RUN_DESC_READ_SM	(1 << 13)
#define  SK_TX_CS_RESET_DESC_READ_SM	(1 << 12)
#define  SK_TX_CS_RUN_DESC_WRITE_SM	(1 << 11)
#define  SK_TX_CS_RESET_DESC_WRITE_SM	(1 << 10)
#define  SK_TX_CS_RUN_TRANSFER_SM	(1 << 9)
#define  SK_TX_CS_RESET_TRANSFER_SM	(1 << 8)
#define  SK_TX_CS_EN_POLLING_ON		(1 << 7)
#define  SK_TX_CS_EN_POLLING_OFF	(1 << 6)
#define  SK_TX_CS_STOP_TX		(1 << 5)
#define  SK_TX_CS_START_TX		(1 << 4)
#define  SK_TX_CS_CLR_IRQ_EOB		(1 << 2)
#define  SK_TX_CS_CLR_IRQ_EOF		(1 << 1)
#define  SK_TX_CS_CLR_IRQ_ERR		(1 << 0)
#define  SK_Y2_TX_CS_IDLE		(1 << 31)
#define  SK_Y2_TX_CS_IPIDINCR_ON	(1 << 13)
#define  SK_Y2_TX_CS_IPIDINCR_OFF	(1 << 12)
#define  SK_Y2_TX_CS_CLR_IRQ_TCP	(1 << 11)
#define  SK_Y2_TX_CS_CLR_IRQ_CHK	(1 << 10)
#define  SK_Y2_TX_CS_STOP_TX		(1 << 9)
#define  SK_Y2_TX_CS_START_TX		(1 << 8)
#define  SK_Y2_TX_CS_FIFO_OP_ON		(1 << 7)
#define  SK_Y2_TX_CS_FIFO_OP_OFF	(1 << 6)
#define  SK_Y2_TX_CS_FIFO_ENA		(1 << 5)
#define  SK_Y2_TX_CS_FIFO_RESET		(1 << 4)
#define  SK_Y2_TX_CS_OP_ON		(1 << 3)
#define  SK_Y2_TX_CS_OP_OFF		(1 << 2)
#define  SK_Y2_TX_CS_CLEAR_RESET	(1 << 1)
#define  SK_Y2_TX_CS_SET_RESET		(1 << 0)
#define SK_TX_FLAG		0x0638
#define  SK_TX_FLAG_ALMOST_FULL		(1 << 27)
#define  SK_TX_FLAG_EOF_IN_FIFO		(1 << 26)
#define  SK_TX_FLAG_WATERMARK_REACHED	(1 << 25)
#define  SK_TX_FLAG_FIFO_LEVEL		(1 << 16)	/* 8 bits */
#define  SK_TX_FLAG_WATERMARK		(1 << 0)	/* 8 bits */
#define SK_TX_TEST_1		0x063c
#define SK_TX_TEST_2		0x0640
#define SK_Y2_TX_WATERMARK	0x0640
#define SK_Y2_TX_ALIGNMENT	0x0642
#define SK_TX_TEST_3		0x0644
#define SK_Y2_TX_RSP		0x0644
#define SK_Y2_TX_RSL		0x0646
#define SK_Y2_TX_RP		0x0648
#define SK_Y2_TX_RL		0x064a
#define SK_Y2_TX_WP		0x064c
#define SK_Y2_TX_WSP		0x064d
#define SK_Y2_TX_WL		0x064e
#define SK_Y2_TX_WSL		0x064f
#define SK_Y2_TX_PREF_CTRL	0x0650
#define  SK_Y2_TX_PREF_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_Y2_TX_PREF_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_Y2_TX_PREF_CTRL_RESET_CLEAR		(1 << 1)
#define  SK_Y2_TX_PREF_CTRL_RESET_SET		(1 << 0)
#define SK_Y2_TX_PREF_LAST_IDX	0x0654
#define SK_Y2_TX_PREF_ADDR_LO	0x0658
#define SK_Y2_TX_PREF_ADDR_HI	0x065c
#define SK_Y2_TX_GET_IDX	0x0660
#define SK_Y2_TX_PUT_IDX	0x0664
#define SK_Y2_TX_FIFO_WP	0x0670
#define SK_Y2_TX_FIFO_RP	0x0674
#define SK_Y2_TX_FIFO_WM	0x0678
#define SK_Y2_TX_FIFO_LEVEL	0x067c
#define  ADD_ASYNC_SK_TX		0x0080
#define  ADD_MAC2_SK_TX			0x0100

/* Receive RAMbuffer */
#define SK_RRB_START_ADDR	0x0800	/* 19 bits, low 10 bits zero */
#define SK_RRB_END_ADDR		0x0804	/* 19 bits, low 10 bits zero */
#define SK_RRB_WRITE_PTR	0x0808	/* 19 bits */
#define SK_RRB_READ_PTR		0x080c	/* 19 bits */
#define SK_RRB_UPPER_THRESH_PP	0x0810	/* 19 bits */
#define SK_RRB_LOWER_THRESH_PP	0x0814	/* 19 bits */
#define SK_RRB_UPPER_THRESH_PRI	0x0818	/* 19 bits */
#define SK_RRB_LOWER_THRESH_PRI	0x081c	/* 19 bits */
#define SK_RRB_PACKET_CNT	0x0820	/* 19 bits */
#define SK_RRB_LEVEL		0x0824	/* 19 bits */
#define SK_RRB_CTRL		0x0828
#define  SK_RRB_CTRL_TEST_CNT_DOWN	(1 << 19)
#define  SK_RRB_CTRL_TEST_CNT_ON	(1 << 18)
#define  SK_RRB_CTRL_TEST_CNT_OFF	(1 << 17)
#define  SK_RRB_CTRL_TEST_CNT_UP	(1 << 16)
#define  SK_RRB_CTRL_TEST_WP_ON		(1 << 14)
#define  SK_RRB_CTRL_TEST_WP_OFF	(1 << 13)
#define  SK_RRB_CTRL_TEST_WP_STEP	(1 << 12)
#define  SK_RRB_CTRL_TEST_RP_ON		(1 << 10)
#define  SK_RRB_CTRL_TEST_RP_OFF	(1 << 9)
#define  SK_RRB_CTRL_TEST_RP_STEP	(1 << 8)
#define  SK_RRB_CTRL_ST_FWD_ON		(1 << 5)
#define  SK_RRB_CTRL_ST_FWD_OFF		(1 << 4)
#define  SK_RRB_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_RRB_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_RRB_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_RRB_CTRL_RESET_SET		(1 << 0)
#define  ADD_MAC2_SK_RRB		0x0080

/* Sync transmit RAMbuffer */
#define SK_TRB_START_ADDR	0x0a00	/* 19 bits, low 10 bits zero */
#define SK_TRB_END_ADDR		0x0a04	/* 19 bits, low 10 bits zero */
#define SK_TRB_WRITE_PTR	0x0a08	/* 19 bits */
#define SK_TRB_READ_PTR		0x0a0c	/* 19 bits */
#define SK_TRB_PACKET_CNT	0x0a20	/* 19 bits */
#define SK_TRB_LEVEL		0x0a24	/* 19 bits */
#define SK_TRB_CTRL		0x0a28
#define  SK_TRB_CTRL_TEST_CNT_DOWN	(1 << 19)
#define  SK_TRB_CTRL_TEST_CNT_ON	(1 << 18)
#define  SK_TRB_CTRL_TEST_CNT_OFF	(1 << 17)
#define  SK_TRB_CTRL_TEST_CNT_UP	(1 << 16)
#define  SK_TRB_CTRL_TEST_WP_ON		(1 << 14)
#define  SK_TRB_CTRL_TEST_WP_OFF	(1 << 13)
#define  SK_TRB_CTRL_TEST_WP_STEP	(1 << 12)
#define  SK_TRB_CTRL_TEST_RP_ON		(1 << 10)
#define  SK_TRB_CTRL_TEST_RP_OFF	(1 << 9)
#define  SK_TRB_CTRL_TEST_RP_STEP	(1 << 8)
#define  SK_TRB_CTRL_ST_FWD_ON		(1 << 5)
#define  SK_TRB_CTRL_ST_FWD_OFF		(1 << 4)
#define  SK_TRB_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_TRB_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_TRB_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_TRB_CTRL_RESET_SET		(1 << 0)
#define  ADD_ASYNC_SK_TRB		0x0080
#define  ADD_MAC2_SK_TRB		0x0100

/* Receive MAC FIFO */
#define SK_RMF_END_ADDR		0x0c00
#define SK_RMF_WRITE_PTR	0x0c04
#define SK_RMF_READ_PTR		0x0c0c
#define SK_RMF_PACKET_CNT	0x0c10
#define SK_RMF_LEVEL		0x0c14
#define SK_RMF_MAC_CTRL		0x0c18
#define  SK_RMF_MAC_CTRL_RX_TS_TIMEOUT	(1 << 24)	/* 8 bits */
#define  SK_RMF_MAC_CTRL_RX_ST_TIMEOUT	(1 << 16)	/* 8 bits */
#define  SK_RMF_MAC_CTRL_RXRDY_PTCH_ON	(1 << 13)
#define  SK_RMF_MAC_CTRL_RXRDY_PTCH_OFF	(1 << 12)
#define  SK_RMF_MAC_CTRL_RXVAL_PTCH_ON	(1 << 11)
#define  SK_RMF_MAC_CTRL_RXVAL_PTCH_OFF	(1 << 10)
#define  SK_RMF_MAC_CTRL_EN_AFULL_ON	(1 << 9)
#define  SK_RMF_MAC_CTRL_EN_AFULL_OFF	(1 << 8)
#define  SK_RMF_MAC_CTRL_EN_PAUSE_ON	(1 << 7)
#define  SK_RMF_MAC_CTRL_EN_PAUSE_OFF	(1 << 6)
#define  SK_RMF_MAC_CTRL_EN_FLUSHRX_ON	(1 << 5)
#define  SK_RMF_MAC_CTRL_EN_FLUSHRX_OFF	(1 << 4)
#define  SK_RMF_MAC_CTRL_TIME_STAMP_ON	(1 << 3)
#define  SK_RMF_MAC_CTRL_TIME_STAMP_OFF	(1 << 2)
#define  SK_RMF_MAC_CTRL_CLR_IRQ_NO_TS	(1 << 1)
#define  SK_RMF_MAC_CTRL_CLR_IRQ_NO_ST	(1 << 0)
#define SK_RMF_CTRL		0x0c1c
#define  SK_RMF_CTRL_TEST_CNT_DOWN	(1 << 19)
#define  SK_RMF_CTRL_TEST_CNT_ON	(1 << 18)
#define  SK_RMF_CTRL_TEST_CNT_OFF	(1 << 17)
#define  SK_RMF_CTRL_TEST_CNT_UP	(1 << 16)
#define  SK_RMF_CTRL_TEST_WP_ON		(1 << 14)
#define  SK_RMF_CTRL_TEST_WP_OFF	(1 << 13)
#define  SK_RMF_CTRL_TEST_WP_STEP	(1 << 12)
#define  SK_RMF_CTRL_TEST_RP_ON		(1 << 10)
#define  SK_RMF_CTRL_TEST_RP_OFF	(1 << 9)
#define  SK_RMF_CTRL_TEST_RP_STEP	(1 << 8)
#define  SK_RMF_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_RMF_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_RMF_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_RMF_CTRL_RESET_SET		(1 << 0)
#define SK_RX_LED_CNT_INIT_VAL	0x0c20
#define SK_RX_LED_CNT		0x0c24
#define SK_RX_LED_CNT_CTRL	0x0c28
#define  SK_RX_LED_CNT_CTRL_START	(1 << 2)
#define  SK_RX_LED_CNT_CTRL_STOP	(1 << 1)
#define  SK_RX_LED_CNT_CTRL_SWITCH_ON	(1 << 0)
#define SK_RX_LED_CND_TEST	0x0c29
#define  SK_RX_LED_CND_TEST_ON		(1 << 2)
#define  SK_RX_LED_CND_TEST_OFF		(1 << 1)
#define  SK_RX_LED_CND_TEST_STEP	(1 << 0)
#define SK_LS_CNT_INIT_VAL	0x0c30
#define SK_LS_CNT		0x0c34
#define SK_LS_CNT_CTRL		0x0c38
#define  SK_LS_CNT_CTRL_START		(1 << 2)
#define  SK_LS_CNT_CTRL_STOP		(1 << 1)
#define  SK_LS_CNT_CTRL_CLEAR_IRQ	(1 << 0)
#define SK_LS_CNT_TEST		0x0c39
#define  SK_LS_CNT_TEST_ON		(1 << 2)
#define  SK_LS_CNT_TEST_OFF		(1 << 1)
#define  SK_LS_CNT_TEST_STEP		(1 << 0)
#define SK_LS_LINK_LED		0x0c3c
#define  SK_LS_LINK_LED_BLINKING_ON	(1 << 5)
#define  SK_LS_LINK_LED_BLINKING_OFF	(1 << 4)
#define  SK_LS_LINK_LED_LINK_SYNC_ON	(1 << 3)
#define  SK_LS_LINK_LED_LINK_SYNC_OFF	(1 << 2)
#define  SK_LS_LINK_LED_ON		(1 << 1)
#define  SK_LS_LINK_LED_OFF		(1 << 0)
#define  ADD_MAC2_SK_RMF		0x0080

/* GMAC receive FIFO */
#define SK_RX_GMF_END_ADDR	0x0c40
#define SK_RX_GMF_AF_THRESH	0x0c44
#define SK_RX_GMF_CTRL		0x0c48
#define  SK_RX_GMF_CTRL_TEST_WP_ON	(1 << 14)
#define  SK_RX_GMF_CTRL_TEST_WP_OFF	(1 << 13)
#define  SK_RX_GMF_CTRL_TEST_WP_STEP	(1 << 12)
#define  SK_RX_GMF_CTRL_TEST_RP_ON	(1 << 10)
#define  SK_RX_GMF_CTRL_TEST_RP_OFF	(1 << 9)
#define  SK_RX_GMF_CTRL_TEST_RP_STEP	(1 << 8)
#define  SK_RX_GMF_CTRL_FIFO_FLUSH_ON	(1 << 7)
#define  SK_RX_GMF_CTRL_FIFO_FLUSH_OFF	(1 << 6)
#define  SK_RX_GMF_CTRL_CLR_RX_OVERRUN	(1 << 5)
#define  SK_RX_GMF_CTRL_CLR_RX_COMPLETE	(1 << 4)
#define  SK_RX_GMF_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_RX_GMF_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_RX_GMF_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_RX_GMF_CTRL_RESET_SET	(1 << 0)
#define SK_RX_GMF_FLUSH_MASK	0x0c4c
#define SK_RX_GMF_FLUSH_THRESH	0x0c50
#define SK_RX_GMF_WRITE_PTR	0x0c60
#define SK_RX_GMF_WRITE_LEVEL	0x0c68
#define SK_RX_GMF_READ_PTR	0x0c70
#define SK_RX_GMF_READ_LEVEL	0x0c78
#define  ADD_MAC2_SK_RX_GMF		0x0080

/* Transmit MAC FIFO */
#define SK_TMF_END_ADDR		0x0d00
#define SK_TMF_WRITE_PTR	0x0d04
#define SK_TMF_WRITE_SHADOW_PTR	0x0d08
#define SK_TMF_READ_PTR		0x0d0c
#define SK_TMF_PACKET_CNT	0x0d10
#define SK_TMF_LEVEL		0x0d14
#define SK_TMF_MAC_CTRL		0x0d18
#define  SK_TMF_MAC_CTRL_WAIT_FLUSH	(1 << 16)	/* 5 bits */
#define  SK_TMF_MAC_CTRL_CLEAR_IRQ_PAR	(1 << 15)
#define  SK_TMF_MAC_CTRL_EN_RECOV_ON	(1 << 13)
#define  SK_TMF_MAC_CTRL_EN_RECOV_OFF	(1 << 12)
#define  SK_TMF_MAC_CTRL_TXRDY_PTCH_ON	(1 << 11)
#define  SK_TMF_MAC_CTRL_TXRDY_PTCH_OFF	(1 << 10)
#define  SK_TMF_MAC_CTRL_USE_AFULL_ON	(1 << 9)
#define  SK_TMF_MAC_CTRL_USE_AFULL_OFF	(1 << 8)
#define  SK_TMF_MAC_CTRL_EN_WAIT4EM_ON	(1 << 7)
#define  SK_TMF_MAC_CTRL_EN_WAIT4EM_OFF	(1 << 6)
#define  SK_TMF_MAC_CTRL_EN_FLUSHTX_ON	(1 << 5)
#define  SK_TMF_MAC_CTRL_EN_FLUSHTX_OFF	(1 << 4)
#define  SK_TMF_MAC_CTRL_LOOPBACK_ON	(1 << 3)
#define  SK_TMF_MAC_CTRL_LOOPBACK_OFF	(1 << 2)
#define  SK_TMF_MAC_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_TMF_MAC_CTRL_RESET_SET	(1 << 0)
#define SK_TMF_CTRL		0x0d1c
#define  SK_TMF_CTRL_TEST_WSP_ON	(1 << 22)
#define  SK_TMF_CTRL_TEST_WSP_OFF	(1 << 21)
#define  SK_TMF_CTRL_TEST_WSP_STEP	(1 << 20)
#define  SK_TMF_CTRL_TEST_CNT_DOWN	(1 << 19)
#define  SK_TMF_CTRL_TEST_CNT_ON	(1 << 18)
#define  SK_TMF_CTRL_TEST_CNT_OFF	(1 << 17)
#define  SK_TMF_CTRL_TEST_CNT_UP	(1 << 16)
#define  SK_TMF_CTRL_TEST_WP_ON		(1 << 14)
#define  SK_TMF_CTRL_TEST_WP_OFF	(1 << 13)
#define  SK_TMF_CTRL_TEST_WP_STEP	(1 << 12)
#define  SK_TMF_CTRL_TEST_RP_ON		(1 << 10)
#define  SK_TMF_CTRL_TEST_RP_OFF	(1 << 9)
#define  SK_TMF_CTRL_TEST_RP_STEP	(1 << 8)
#define  SK_TMF_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_TMF_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_TMF_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_TMF_CTRL_RESET_SET		(1 << 0)
#define SK_TX_LED_CNT_INIT_VAL	0x0d20
#define SK_TX_LED_CNT		0x0d24
#define SK_TX_LED_CNT_CTRL	0x0d28
#define  SK_TX_LED_CNT_CTRL_START	(1 << 2)
#define  SK_TX_LED_CNT_CTRL_STOP	(1 << 1)
#define  SK_TX_LED_CNT_CTRL_SWITCH_ON	(1 << 0)
#define SK_TX_LED_CNT_TEST	0x0d29
#define  SK_TX_LED_CNT_TEST_ON		(1 << 2)
#define  SK_TX_LED_CNT_TEST_OFF		(1 << 1)
#define  SK_TX_LED_CNT_TEST_STEP	(1 << 0)
#define  ADD_MAC2_SK_TMF		0x0080

/* GMAC transmit FIFO */
#define SK_TX_GMF_END_ADDR	0x0d40
#define SK_TX_GMF_AE_THRESH	0x0d44
#define SK_TX_GMF_CTRL		0x0d48
#define  SK_TX_GMF_CTRL_TEST_WSP_ON	(1 << 18)
#define  SK_TX_GMF_CTRL_TEST_WSP_OFF	(1 << 17)
#define  SK_TX_GMF_CTRL_TEST_WSP_STEP	(1 << 16)
#define  SK_TX_GMF_CTRL_TEST_WP_ON	(1 << 14)
#define  SK_TX_GMF_CTRL_TEST_WP_OFF	(1 << 13)
#define  SK_TX_GMF_CTRL_TEST_WP_STEP	(1 << 12)
#define  SK_TX_GMF_CTRL_TEST_RP_ON	(1 << 10)
#define  SK_TX_GMF_CTRL_TEST_RP_OFF	(1 << 9)
#define  SK_TX_GMF_CTRL_TEST_RP_STEP	(1 << 8)
#define  SK_TX_GMF_CTRL_CLR_TX_UNDERRUN	(1 << 6)
#define  SK_TX_GMF_CTRL_CLR_TX_COMPLETE	(1 << 5)
#define  SK_TX_GMF_CTRL_CLR_TX_PERR	(1 << 4)
#define  SK_TX_GMF_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_TX_GMF_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_TX_GMF_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_TX_GMF_CTRL_RESET_SET	(1 << 0)
#define SK_TX_GMF_WRITE_PTR	0x0d60
#define SK_TX_GMF_WRITE_SHADOW	0x0d64
#define SK_TX_GMF_WRITE_LEVEL	0x0d68
#define SK_TX_GMF_READ_PTR	0x0d70
#define SK_TX_GMF_RESTART_PTR	0x0d74
#define SK_TX_GMF_READ_LEVEL	0x0d78
#define  ADD_MAC2_SK_TX_GMF		0x0080

/* Descriptor poll timer */
#define SK_DP_TIMER_INIT_VAL	0x0e00	/* 24 bits */
#define SK_DP_TIMER		0x0e04	/* 24 bits */
#define SK_DP_TIMER_CTRL	0x0e08
#define  SK_DP_TIMER_CTRL_START		(1 << 1)
#define  SK_DP_TIMER_CTRL_STOP		(1 << 0)
#define SK_DP_TIMER_TEST	0x0e0a
#define  SK_DP_TIMER_TEST_ON		(1 << 2)
#define  SK_DP_TIMER_TEST_OFF		(1 << 1)
#define  SK_DP_TIMER_TEST_STEP		(1 << 0)
#define SK_GMAC_TS_VALUE	0x0e14
#define SK_GMAC_TS_CTRL		0x0e18
#define  SK_GMAC_TS_CTRL_START		(1 << 2)
#define  SK_GMAC_TS_CTRL_STOP		(1 << 1)
#define  SK_GMAC_TS_CTRL_CLEAR_IRQ	(1 << 0)
#define SK_GMAC_TS_TEST		0x0e1a
#define SK_POLL_CTRL		0x0e20
#define SK_POLL_LAST_IDX	0x0e24
#define SK_POLL_LIST_ADDR_LO	0x0e28
#define SK_POLL_LIST_ADDR_HI	0x0e2c
#define SK_ASF_SMB_CONFIG	0x0e40
#define SK_ASF_SMB_CSD_REG	0x0e44
#define SK_ASF_IRQ_V_BASE	0x0e60
#define SK_ASF_STAT_CMD		0x0e68
#define  SK_ASF_STAT_CMD_OS_PRES	(1 << 4)
#define  SK_ASF_STAT_CMD_RESET		(1 << 3)
#define  SK_ASF_STAT_CMD_RUNNING	(1 << 2)
#define  SK_ASF_STAT_CMD_CLR_HSTI	(1 << 1)
#define  SK_ASF_STAT_CMD_IRQ		(1 << 0)
#define SK_ASF_HOST_COM		0x0e6c
#define  SK_ASF_HOST_COM_CLR_ASFI	(1 << 1)
#define  SK_ASF_HOST_COM_HOST_IRQ	(1 << 0)
#define SK_ASF_DATA_REG_1	0x0e70
#define SK_ASF_DATA_REG_2	0x0e74
#define SK_ASF_DATA_REG_3	0x0e78
#define SK_ASF_DATA_REG_4	0x0e7c

/* Status BMU (Y2) */
#define SK_STAT_CTRL		0x0e80
#define  SK_STAT_CTRL_CLR_IRQ		(1 << 4)
#define  SK_STAT_CTRL_OPERATIONAL_ON	(1 << 3)
#define  SK_STAT_CTRL_OPERATIONAL_OFF	(1 << 2)
#define  SK_STAT_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_STAT_CTRL_RESET_SET		(1 << 0)
#define SK_STAT_LAST_IDX	0x0e84
#define SK_STAT_LIST_ADDR_LO	0x0e88
#define SK_STAT_LIST_ADDR_HI	0x0e8c
#define SK_STAT_TXA1_RIDX	0x0e90
#define SK_STAT_TXS1_RIDX	0x0e92
#define SK_STAT_TXA2_RIDX	0x0e94
#define SK_STAT_TXS2_RIDX	0x0e96
#define SK_STAT_TX_IDX_TH	0x0e98
#define SK_STAT_PUT_IDX		0x0e9c
#define SK_STAT_FIFO_WP		0x0ea0
#define SK_STAT_FIFO_RP		0x0ea4
#define SK_STAT_FIFO_RSP	0x0ea5
#define SK_STAT_FIFO_LEVEL	0x0ea8
#define SK_STAT_FIFO_SHLVL	0x0eaa
#define SK_STAT_FIFO_WM		0x0eac
#define SK_STAT_FIFO_ISR_WM	0x0ead
#define SK_STAT_LEV_TIMER_INI	0x0eb0
#define SK_STAT_LEV_TIMER_CNT	0x0eb4
#define SK_STAT_LEV_TIMER_CTRL	0x0eb8
#define  SK_STAT_LEV_TIMER_CTRL_START	(1 << 2)
#define  SK_STAT_LEV_TIMER_CTRL_STOP	(1 << 1)
#define  SK_STAT_LEV_TIMER_CTRL_CLR_IRQ	(1 << 0)
#define SK_STAT_LEV_TIMER_TEST	0x0eb9
#define SK_STAT_TX_TIMER_INI	0x0ec0
#define SK_STAT_TX_TIMER_CNT	0x0ec4
#define SK_STAT_TX_TIMER_CTRL	0x0ec8
#define  SK_STAT_TX_TIMER_CTRL_START	(1 << 2)
#define  SK_STAT_TX_TIMER_CTRL_STOP	(1 << 1)
#define  SK_STAT_TX_TIMER_CTRL_CLR_IRQ	(1 << 0)
#define SK_STAT_TX_TIMER_TEST	0x0ec9
#define SK_STAT_ISR_TIMER_INI	0x0ed0
#define SK_STAT_ISR_TIMER_CNT	0x0ed4
#define SK_STAT_ISR_TIMER_CTRL	0x0ed8
#define  SK_STAT_ISR_TIMER_CTRL_START	(1 << 2)
#define  SK_STAT_ISR_TIMER_CTRL_STOP	(1 << 1)
#define  SK_STAT_ISR_TIMER_CTRL_CLR_IRQ	(1 << 0)
#define SK_STAT_ISR_TIMER_TEST	0x0ed9

/* GMAC / GPHY */
#define SK_GMAC_CTRL		0x0f00
#define  SK_GMAC_CTRL_H_BURST_ON	(1 << 7)
#define  SK_GMAC_CTRL_H_BURST_OFF	(1 << 6)
#define  SK_GMAC_CTRL_F_LOOPB_ON	(1 << 5)
#define  SK_GMAC_CTRL_F_LOOPB_OFF	(1 << 4)
#define  SK_GMAC_CTRL_PAUSE_ON		(1 << 3)
#define  SK_GMAC_CTRL_PAUSE_OFF		(1 << 2)
#define  SK_GMAC_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_GMAC_CTRL_RESET_SET		(1 << 0)
#define SK_GPHY_CTRL		0x0f04
#define  SK_GPHY_CTRL_SEL_BDT		(1 << 28)
#define  SK_GPHY_CTRL_INT_POL_HI	(1 << 27)
#define  SK_GPHY_CTRL_75_OHM		(1 << 26)
#define  SK_GPHY_CTRL_DIS_FC		(1 << 25)
#define  SK_GPHY_CTRL_DIS_SLEEP		(1 << 24)
#define  SK_GPHY_CTRL_HWCFG_M_3		(1 << 23)
#define  SK_GPHY_CTRL_HWCFG_M_2		(1 << 22)
#define  SK_GPHY_CTRL_HWCFG_M_1		(1 << 21)
#define  SK_GPHY_CTRL_HWCFG_M_0		(1 << 20)
#define  SK_GPHY_CTRL_ANEG_0		(1 << 19)
#define  SK_GPHY_CTRL_ENA_XC		(1 << 18)
#define  SK_GPHY_CTRL_DIS_125		(1 << 17)
#define  SK_GPHY_CTRL_ANEG_3		(1 << 16)
#define  SK_GPHY_CTRL_ANEG_2		(1 << 15)
#define  SK_GPHY_CTRL_ANEG_1		(1 << 14)
#define  SK_GPHY_CTRL_ENA_PAUSE		(1 << 13)
#define  SK_GPHY_CTRL_PHYADDR_4		(1 << 12)
#define  SK_GPHY_CTRL_PHYADDR_3		(1 << 11)
#define  SK_GPHY_CTRL_PHYADDR_2		(1 << 10)
#define  SK_GPHY_CTRL_PHYADDR_1		(1 << 9)
#define  SK_GPHY_CTRL_PHYADDR_0		(1 << 8)
#define  SK_GPHY_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_GPHY_CTRL_RESET_SET		(1 << 0)
#define   SK_GPHY_CTRL_ANEG_ADV_ALL_M		(SK_GPHY_CTRL_ANEG_3 |\
						 SK_GPHY_CTRL_ANEG_2 |\
						 SK_GPHY_CTRL_ANEG_1 |\
						 SK_GPHY_CTRL_ANEG_0)
#define   SK_GPHY_CTRL_HWCFG_GMII_COP		(SK_GPHY_CTRL_HWCFG_M_3 |\
						 SK_GPHY_CTRL_HWCFG_M_2 |\
						 SK_GPHY_CTRL_HWCFG_M_1 |\
						 SK_GPHY_CTRL_HWCFG_M_0)
#define   SK_GPHY_CTRL_HWCFG_GMII_FIB		(SK_GPHY_CTRL_HWCFG_M_2 |\
						 SK_GPHY_CTRL_HWCFG_M_1 |\
						 SK_GPHY_CTRL_HWCFG_M_0)
#define SK_GMAC_IRQ_SRC		0x0f08
#define  SK_GMAC_IRQ_SRC_TX_CNT_OVER	(1 << 5)
#define  SK_GMAC_IRQ_SRC_RX_CNT_OVER	(1 << 4)
#define  SK_GMAC_IRQ_SRC_TX_FIFO_UNDER	(1 << 3)
#define  SK_GMAC_IRQ_SRC_TX_COMPLETE	(1 << 2)
#define  SK_GMAC_IRQ_SRC_RX_FIFO_OVER	(1 << 1)
#define  SK_GMAC_IRQ_SRC_RX_COMPLETE	(1 << 0)
#define SK_GMAC_IRQ_MASK	0x0f0c
#define SK_GMAC_LINK_CTRL	0x0f10
#define  SK_GMAC_LINK_CTRL_RESET_CLEAR	(1 << 1)
#define  SK_GMAC_LINK_CTRL_RESET_SET	(1 << 0)
#define  ADD_MAC2_SK_GMAC_GPHY		0x0080

#define SK_Y2_CONFIGURATION_FILE 0x1c00

/* XMACII registers */
#define SK_XMACII		0x2000
#define  ADD_MAC2_SK_XMACII		0x1000

/* GMAC registers */
#define SK_GMAC			0x2800
#define  ADD_MAC2_SK_GMAC		0x1000

/* Descriptors */

typedef struct {
	__u32 rbctrl;
	__u32 nrdadr;
#ifdef __LITTLE_ENDIAN
	__u64 rbadr;
#else
	__u32 rbadr_lo;
	__u32 rbadr_hi;
#endif
	__u32 rfsw;
	__u32 time_stamp;
#ifdef __LITTLE_ENDIAN
	__u16 tcp_sum_1;
	__u16 tcp_sum_2;
	__u16 tcp_sum_start_1;
	__u16 tcp_sum_start_2;
#else
	__u16 tcp_sum_2;
	__u16 tcp_sum_1;
	__u16 tcp_sum_start_2;
	__u16 tcp_sum_start_1;
#endif
} RECV_DESC;

#define RBCTRL_OWN		(1 << 31)
#define RBCTRL_STF		(1 << 30)
#define RBCTRL_EOF		(1 << 29)
#define RBCTRL_EN_IRQ_EOB	(1 << 28)
#define RBCTRL_EN_IRQ_EOF	(1 << 27)
#define RBCTRL_DEV_0		(1 << 26)
#define RBCTRL_STATUS_VALID	(1 << 25)
#define RBCTRL_TIME_STAMP_VALID	(1 << 24)
#define RBCTRL_OPCODE_DEFAULT	(0x55 << 16)
#define RBCTRL_OPCODE_CHECKSUM	(0x56 << 16)

typedef struct {
	__u32 tbctrl;
	__u32 ntdadr;
#ifdef __LITTLE_ENDIAN
	__u64 tbadr;
#else
	__u32 tbadr_lo;
	__u32 tbadr_hi;
#endif
	__u32 tfsw;
#ifdef __LITTLE_ENDIAN
	__u16 tcp_sum_init_val;
	__u16 reserved1;
	__u16 tcp_sum_write;
	__u16 tcp_sum_start;
#else
	__u16 reserved1;
	__u16 tcp_sum_init_val;
	__u16 tcp_sum_start;
	__u16 tcp_sum_write;
#endif
	__u32 reserved2;
} XMIT_DESC;

#define TBCTRL_OWN		(1 << 31)
#define TBCTRL_STF		(1 << 30)
#define TBCTRL_EOF		(1 << 29)
#define TBCTRL_EN_IRQ_EOB	(1 << 28)
#define TBCTRL_EN_IRQ_EOF	(1 << 27)
#define TBCTRL_ST_FWD_ON	(1 << 26)
#define TBCTRL_DIS_CRC		(1 << 25)
#define TBCTRL_SW_0		(1 << 24)
#define TBCTRL_OPCODE_DEFAULT	(0x55 << 16)
#define TBCTRL_OPCODE_CHECKSUM	(0x56 << 16)

/* Yukon 2 descriptors */

#define Y2_OP_TCPWRITE		0x11
#define Y2_OP_TCPSTART		0x12
#define Y2_OP_TCPINIT		0x14
#define Y2_OP_TCPLCK		0x18
#define Y2_OP_ADDR64		0x21
#define Y2_OP_VLAN		0x22
#define Y2_OP_LRGLEN		0x24

#define Y2_OP_BUFFER		0x40
#define Y2_OP_PACKET		0x41
#define Y2_OP_LARGESEND		0x43

#define Y2_OP_RXSTAT		0x60
#define Y2_OP_RXTIMESTAMP	0x61
#define Y2_OP_RXVLAN		0x62
#define Y2_OP_RXTIMESTAMP_VLAN	0x63
#define Y2_OP_RXCHKS		0x64
#define Y2_OP_RSS_HASH		0x65
#define Y2_OP_RXCHKSVLAN	0x66
#define Y2_OP_TXINDEXLE		0x68

#define Y2_OP_PUTIDX		0x70
#define Y2_OP_OWNER		0x80

#define Y2_CTRL_EOP		(1 << 7)
#define Y2_CTRL_FRC_STAT	(1 << 6)
#define Y2_CTRL_INS_VLAN	(1 << 5)
#define Y2_CTRL_LOCK_SUM	(1 << 4)
#define Y2_CTRL_INIT_SUM	(1 << 3)
#define Y2_CTRL_WR_SUM		(1 << 2)
#define Y2_CTRL_CALSUM		(1 << 1)
#define Y2_CTRL_UDPTCP		(1 << 0)

typedef struct {
#ifdef __LITTLE_ENDIAN
	__u16 tcp_sum_write;
	__u16 tcp_sum_offset;
	__u16 tcp_sum_init_val;
	__u8 lock;
	__u8 opcode;
#else
	__u16 tcp_sum_offset;
	__u16 tcp_sum_write;
	__u8 opcode;
	__u8 lock;
	__u16 tcp_sum_init_val;
#endif
} Y2_TXCHECKSUM;

typedef struct {
	__u32 hiaddr;
#ifdef __LITTLE_ENDIAN
	__u16 reserved1;
	__u8 reserved2;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 reserved2;
	__u16 reserved1;
#endif
} Y2_TXHIADDR;

typedef struct {
	__u32 loaddr;
#ifdef __LITTLE_ENDIAN
	__u16 len;
	__u8 ctrl;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 ctrl;
	__u16 len;
#endif
} Y2_TXPACKET;

typedef struct {
#ifdef __LITTLE_ENDIAN
	__u16 tcp_sum_start_1;
	__u16 tcp_sum_start_2;
	__u16 reserved1;
	__u8 lock;
	__u8 opcode;
#else
	__u16 tcp_sum_start_2;
	__u16 tcp_sum_start_1;
	__u8 opcode;
	__u8 lock;
	__u16 reserved1;
#endif
} Y2_RXCHECKSUM;

typedef struct {
	__u32 hiaddr;
#ifdef __LITTLE_ENDIAN
	__u16 reserved1;
	__u8 reserved2;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 reserved2;
	__u16 reserved1;
#endif
} Y2_RXHIADDR;

typedef struct {
	__u32 loaddr;
#ifdef __LITTLE_ENDIAN
	__u16 len;
	__u8 ctrl;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 ctrl;
	__u16 len;
#endif
} Y2_RXPACKET;

typedef struct {
#ifdef __LITTLE_ENDIAN
	__u16 tcp_sum_1;
	__u16 tcp_sum_2;
	__u16 vlan_id;
	__u8 reserved1;
	__u8 opcode;
#else
	__u16 tcp_sum_2;
	__u16 tcp_sum_1;
	__u8 opcode;
	__u8 reserved1;
	__u16 vlan_id;
#endif
} Y2_STCHECKSUM;

typedef struct {
	__u32 rxstat;
#ifdef __LITTLE_ENDIAN
	__u16 len;
	__u8 port;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 port;
	__u16 len;
#endif
} Y2_STPACKET;

typedef struct {
	__u32 time_stamp;
#ifdef __LITTLE_ENDIAN
	__u16 vlan_id;
	__u8 reserved1;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 reserved1;
	__u16 vlan_id;
#endif
} Y2_STTIMESTAMP;

typedef struct {
	__u32 lostat;
#ifdef __LITTLE_ENDIAN
	__u16 histat;
	__u8 reserved1;
	__u8 opcode;
#else
	__u8 opcode;
	__u8 reserved1;
	__u16 histat;
#endif
} Y2_STTXINDEX;

typedef union {
	Y2_TXCHECKSUM txch;
	Y2_TXHIADDR txhi;
	Y2_TXPACKET txpa;
	Y2_RXCHECKSUM rxch;
	Y2_RXHIADDR rxhi;
	Y2_RXPACKET rxpa;
	Y2_STCHECKSUM stch;
	Y2_STPACKET stpa;
	Y2_STTIMESTAMP stti;
	Y2_STTXINDEX sttx;
} Y2_DESC;

/* Common defines */

#define GENESIS_HOST_CLOCK		53
#define YUKON_HOST_CLOCK		78
#define YUKON_2_FE_PEX_HOST_CLOCK	100
#define YUKON_2_PEX_HOST_CLOCK		125
#define YUKON_2_PCIX_HOST_CLOCK		156

#define GENESIS_FIFO_SIZE	3840

#include "SKXMAC.H"
#include "SKGMAC.H"
#include "SKPHY.H"

#endif
