#ifndef __NIC_SKXMAC_H
#define __NIC_SKXMAC_H

/* XMAC-II */

#define XM_MMU_CMD		0x0000
#define  XM_MMU_PHY_RDY			(1 << 12)
#define  XM_MMU_PHY_BUSY		(1 << 11)
#define  XM_MMU_IGN_PF			(1 << 10)
#define  XM_MMU_MAC_LB			(1 << 9)
#define  XM_MMU_FRC_COL			(1 << 7)
#define  XM_MMU_SIM_COL			(1 << 6)
#define  XM_MMU_NO_PRE			(1 << 5)
#define  XM_MMU_GMII_FD			(1 << 4)
#define  XM_MMU_RAT_CTRL		(1 << 3)
#define  XM_MMU_GMII_LOOP		(1 << 2)
#define  XM_MMU_ENA_RX			(1 << 1)
#define  XM_MMU_ENA_TX			(1 << 0)
#define XM_POFF			0x0008
#define XM_BURST		0x000c
#define XM_1L_VLAN_TAG		0x0010
#define XM_2L_VLAN_TAG		0x0014
#define XM_TX_CMD		0x0020
#define  XM_TX_BK2BK			(1 << 6)
#define  XM_TX_ENC_BYP			(1 << 5)
#define  XM_TX_SAM_LINE			(1 << 4)
#define  XM_TX_NO_GIG_MD		(1 << 3)
#define  XM_TX_NO_PRE			(1 << 2)
#define  XM_TX_NO_CRC			(1 << 1)
#define  XM_TX_AUTO_PAD			(1 << 0)
#define XM_TX_RT_LIM		0x0024
#define  XM_RT_LIM_MSK			0x1f
#define XM_TX_STIME		0x0028
#define  XM_STIME_MSK			0x7f
#define XM_TX_IPG		0x002c
#define  XM_IPG_MSK			0xff
#define XM_RX_CMD		0x0030
#define  XM_RX_LENERR_OK		(1 << 8)
#define  XM_RX_BIG_PK_OK		(1 << 7)
#define  XM_RX_IPG_CAP			(1 << 6)
#define  XM_RX_TP_MD			(1 << 5)
#define  XM_RX_STRIP_FCS		(1 << 4)
#define  XM_RX_SELF_RX			(1 << 3)
#define  XM_RX_SAM_LINE			(1 << 2)
#define  XM_RX_STRIP_PAD		(1 << 1)
#define  XM_RX_DIS_CEXT			(1 << 0)
#define XM_PHY_ADDR		0x0034
#define  XM_PHY_ADDR_SZ			0x1f
#define XM_PHY_DATA		0x0038
#define XM_GP_PORT		0x0040
#define  XM_GP_ANIP			(1 << 6)
#define  XM_GP_FRC_INT			(1 << 5)
#define  XM_GP_RES_MAC			(1 << 3)
#define  XM_GP_RES_STAT			(1 << 2)
#define  XM_GP_INP_ASS			(1 << 0)
#define XM_IMSK			0x0044
#define XM_ISRC			0x0048
#define  XM_IS_LNK_AE			(1 << 14)
#define  XM_IS_TX_ABORT			(1 << 13)
#define  XM_IS_FRC_INT			(1 << 12)
#define  XM_IS_INP_ASS			(1 << 11)
#define  XM_IS_LIPA_RC			(1 << 10)
#define  XM_IS_RX_PAGE			(1 << 9)
#define  XM_IS_TX_PAGE			(1 << 8)
#define  XM_IS_AND			(1 << 7)
#define  XM_IS_TSC_OV			(1 << 6)
#define  XM_IS_RXC_OV			(1 << 5)
#define  XM_IS_TXC_OV			(1 << 4)
#define  XM_IS_RXF_OV			(1 << 3)
#define  XM_IS_TXF_UR			(1 << 2)
#define  XM_IS_TX_COMP			(1 << 1)
#define  XM_IS_RX_COMP			(1 << 0)
#define XM_HW_CFG		0x004c
#define  XM_HW_GEN_EOP			(1 << 3)
#define  XM_HW_COM4SIG			(1 << 2)
#define  XM_HW_GMII_MD			(1 << 0)
#define XM_TX_LO_WM		0x0060
#define XM_TX_HI_WM		0x0062
#define  XM_TX_WM_MSK			0x01ff
#define XM_TX_THR		0x0064
#define XM_HT_THR		0x0066
#define  XM_THR_MSK			0x03ff
#define XM_PAUSE_DA		0x0068
#define XM_CTL_PARA		0x0070
#define XM_MAC_OPCODE		0x0074
#define XM_MAC_PTIME		0x0076
#define XM_TX_STAT		0x0078
#define  XM_ST_VALID			(1 << 31)
#define  XM_ST_BYTE_CNT			(0x3fff << 17)
#define  XM_ST_RETRY_CNT		(0x1f << 12)
#define  XM_ST_EX_COL			(1 << 11)
#define  XM_ST_EX_DEF			(1 << 10)
#define  XM_ST_BURST			(1 << 9)
#define  XM_ST_DEFER			(1 << 8)
#define  XM_ST_BC			(1 << 7)
#define  XM_ST_MC			(1 << 6)
#define  XM_ST_UC			(1 << 5)
#define  XM_ST_TX_UR			(1 << 4)
#define  XM_ST_CS_ERR			(1 << 3)
#define  XM_ST_LAT_COL			(1 << 2)
#define  XM_ST_MUL_COL			(1 << 1)
#define  XM_ST_SGN_COL			(1 << 0)
#define XM_EXM_START		0x0080
#define XM_SRC_CHK		0x0100
#define XM_SA			0x0108
#define XM_HSM			0x0110
#define XM_RX_LO_WM		0x0118
#define XM_RX_HI_WM		0x011a
#define  XM_RX_WM_MSK			0x03ff
#define XM_RX_THR		0x011c
#define XM_DEV_ID		0x0120
#define  XM_DEV_OUI			(0xffffff << 8)
#define  XM_DEV_REV			(0x07 << 5)
#define XM_MODE			0x0124
#define  XM_MD_ENA_REJ			(1 << 26)
#define  XM_MD_SPOE_E			(1 << 25)
#define  XM_MD_TX_REP			(1 << 24)
#define  XM_MD_SPOFF_I			(1 << 23)
#define  XM_MD_LE_STW			(1 << 22)
#define  XM_MD_TX_CONT			(1 << 21)
#define  XM_MD_TX_PAUSE			(1 << 20)
#define  XM_MD_ATS			(1 << 19)
#define  XM_MD_SPOL_I			(1 << 18)
#define  XM_MD_SPOH_I			(1 << 17)
#define  XM_MD_CAP			(1 << 16)
#define  XM_MD_ENA_HASH			(1 << 15)
#define  XM_MD_CSA			(1 << 14)
#define  XM_MD_CAA			(1 << 13)
#define  XM_MD_RX_MCTRL			(1 << 12)
#define  XM_MD_RX_RUNT			(1 << 11)
#define  XM_MD_RX_IRLE			(1 << 10)
#define  XM_MD_RX_LONG			(1 << 9)
#define  XM_MD_RX_CRCE			(1 << 8)
#define  XM_MD_RX_ERR			(1 << 7)
#define  XM_MD_DIS_UC			(1 << 6)
#define  XM_MD_DIS_MC			(1 << 5)
#define  XM_MD_DIS_BC			(1 << 4)
#define  XM_MD_ENA_PROM			(1 << 3)
#define  XM_MD_ENA_BE			(1 << 2)
#define  XM_MD_FTF			(1 << 1)
#define  XM_MD_FRF			(1 << 0)
#define XM_LSA			0x0128
#define XM_TS_READ		0x0130
#define XM_TS_LOAD		0x0134
#define XM_STAT_CMD		0x0200
#define  XM_SC_SNP_RXC			(1 << 5)
#define  XM_SC_SNP_TXC			(1 << 4)
#define  XM_SC_CP_RXC			(1 << 3)
#define  XM_SC_CP_TXC			(1 << 2)
#define  XM_SC_CLR_RXC			(1 << 1)
#define  XM_SC_CLR_TXC			(1 << 0)
#define XM_RX_CNT_EV		0x0204
#define XM_TX_CNT_EV		0x0208
#define XM_RX_EV_MSK		0x020c
#define  XMR_MAX_SZ_OV			(1U << 31)
#define  XMR_1023B_OV			(1 << 30)
#define  XMR_511B_OV			(1 << 29)
#define  XMR_255B_OV			(1 << 28)
#define  XMR_127B_OV			(1 << 27)
#define  XMR_64B_OV			(1 << 26)
#define  XMR_UTIL_OV			(1 << 25)
#define  XMR_UTIL_UR			(1 << 24)
#define  XMR_CEX_ERR_OV			(1 << 23)
#define  XMR_FCS_ERR_OV			(1 << 21)
#define  XMR_LNG_ERR_OV			(1 << 20)
#define  XMR_RUNT_OV			(1 << 19)
#define  XMR_SHT_ERR_OV			(1 << 18)
#define  XMR_SYM_ERR_OV			(1 << 17)
#define  XMR_CAR_ERR_OV			(1 << 15)
#define  XMR_JAB_PKT_OV			(1 << 14)
#define  XMR_FIFO_OV			(1 << 13)
#define  XMR_FRA_ERR_OV			(1 << 12)
#define  XMR_FMISS_OV			(1 << 11)
#define  XMR_BURST			(1 << 10)
#define  XMR_INV_MOC			(1 << 9)
#define  XMR_INV_MP			(1 << 8)
#define  XMR_MCTRL_OV			(1 << 7)
#define  XMR_MPAUSE_OV			(1 << 6)
#define  XMR_UC_OK_OV			(1 << 5)
#define  XMR_MC_OK_OV			(1 << 4)
#define  XMR_BC_OK_OV			(1 << 3)
#define  XMR_OK_LO_OV			(1 << 2)
#define  XMR_OK_HI_OV			(1 << 1)
#define  XMR_OK_OV			(1 << 0)
#define XM_TX_EV_MSK		0x0210
#define  XMT_MAX_SZ_OV			(1 << 25)
#define  XMT_1023B_OV			(1 << 24)
#define  XMT_511B_OV			(1 << 23)
#define  XMT_255B_OV			(1 << 22)
#define  XMT_127B_OV			(1 << 21)
#define  XMT_64B_OV			(1 << 20)
#define  XMT_UTIL_OV			(1 << 19)
#define  XMT_UTIL_UR			(1 << 18)
#define  XMT_CS_ERR_OV			(1 << 17)
#define  XMT_FIFO_UR_OV			(1 << 16)
#define  XMT_EX_DEF_OV			(1 << 15)
#define  XMT_DEF				(1 << 14)
#define  XMT_LAT_COL_OV			(1 << 13)
#define  XMT_ABO_COL_OV			(1 << 12)
#define  XMT_MUL_COL_OV			(1 << 11)
#define  XMT_SNG_COL			(1 << 10)
#define  XMT_MCTRL_OV			(1 << 9)
#define  XMT_MPAUSE			(1 << 8)
#define  XMT_BURST			(1 << 7)
#define  XMT_LONG			(1 << 6)
#define  XMT_UC_OK_OV			(1 << 5)
#define  XMT_MC_OK_OV			(1 << 4)
#define  XMT_BC_OK_OV			(1 << 3)
#define  XMT_OK_LO_OV			(1 << 2)
#define  XMT_OK_HI_OV			(1 << 1)
#define  XMT_OK_OV			(1 << 0)
#define XM_TXF_OK		0x0280
#define XM_TXO_OK_HI		0x0284
#define XM_TXO_OK_LO		0x0288
#define XM_TXF_BC_OK		0x028c
#define XM_TXF_MC_OK		0x0290
#define XM_TXF_UC_OK		0x0294
#define XM_TXF_LONG		0x0298
#define XM_TXE_BURST		0x029c
#define XM_TXF_MPAUSE		0x02a0
#define XM_TXF_MCTRL		0x02a4
#define XM_TXF_SNG_COL		0x02a8
#define XM_TXF_MUL_COL		0x02ac
#define XM_TXF_ABO_COL		0x02b0
#define XM_TXF_LAT_COL		0x02b4
#define XM_TXF_DEF		0x02b8
#define XM_TXF_EX_DEF		0x02bc
#define XM_TXE_FIFO_UR		0x02c0
#define XM_TXE_CS_ERR		0x02c4
#define XM_TXP_UTIL		0x02c8
#define XM_TXF_64B		0x02d0
#define XM_TXF_127B		0x02d4
#define XM_TXF_255B		0x02d8
#define XM_TXF_511B		0x02dc
#define XM_TXF_1023B		0x02e0
#define XM_TXF_MAX_SZ		0x02e4
#define XM_RXF_OK		0x0300
#define XM_RXO_OK_HI		0x0304
#define XM_RXO_OK_LO		0x0308
#define XM_RXF_BC_OK		0x030c
#define XM_RXF_MC_OK		0x0310
#define XM_RXF_UC_OK		0x0314
#define XM_RXF_MPAUSE		0x0318
#define XM_RXF_MCTRL		0x031c
#define XM_RXF_INV_MP		0x0320
#define XM_RXF_INV_MOC		0x0324
#define XM_RXE_BURST		0x0328
#define XM_RXE_FMISS		0x032c
#define XM_RXF_FRA_ERR		0x0330
#define XM_RXE_FIFO_OV		0x0334
#define XM_RXF_JAB_PKT		0x0338
#define XM_RXE_CAR_ERR		0x033c
#define XM_RXF_LEN_ERR		0x0340
#define XM_RXE_SYM_ERR		0x0344
#define XM_RXE_SHT_ERR		0x0348
#define XM_RXE_RUNT		0x034c
#define XM_RXF_LNG_ERR		0x0350
#define XM_RXF_FCS_ERR		0x0354
#define XM_RXF_CEX_ERR		0x035c
#define XM_RXP_UTIL		0x0360
#define XM_RXF_64B		0x0368
#define XM_RXF_127B		0x036c
#define XM_RXF_255B		0x0370
#define XM_RXF_511B		0x0374
#define XM_RXF_1023B		0x0378
#define XM_RXF_MAX_SZ		0x037c

#define XMR_FS_LEN		(0x3fff << 18)
#define  XMR_FS_LEN_SHIFT		18
#define XMR_FS_2L_VLAN		(1 << 17)
#define XMR_FS_1L_VLAN		(1 << 16)
#define XMR_FS_BC		(1 << 15)
#define XMR_FS_MC		(1 << 14)
#define XMR_FS_UC		(1 << 13)
#define XMR_FS_BURST		(1 << 11)
#define XMR_FS_CEX_ERR		(1 << 10)
#define XMR_FS_802_3		(1 << 9)
#define XMR_FS_COL_ERR		(1 << 8)
#define XMR_FS_CAR_ERR		(1 << 7)
#define XMR_FS_LEN_ERR		(1 << 6)
#define XMR_FS_FRA_ERR		(1 << 5)
#define XMR_FS_RUNT		(1 << 4)
#define XMR_FS_LNG_ERR		(1 << 3)
#define XMR_FS_FCS_ERR		(1 << 2)
#define XMR_FS_ERR		(1 << 1)
#define XMR_FS_MCTRL		(1 << 0)

#endif
