#include <ARCH/IPCHECKS.H>
#include <SPAD/SYSLOG.H>

#include "TCPIP.H"

__u16 IP_MAX_DEFRAG = 0xffff;

void IP_FRAGMENT(PACKET *p, unsigned mtu, long *outstanding)
{
	__u8 header_2[0xf * 4];
#define ip2 ((struct ip *)header_2)
	unsigned ihl, cptr, opt, dopt, o, l;
	unsigned new_data, new_total_size;
	unsigned ns;

	/*__debug_printf("f: %u -> %u\n", p->data_length, mtu);*/
	if (__unlikely(p->data_length < mtu))
		KERNEL$SUICIDE("IP_FRAGMENT: FRAGMENTING PACKET SMALLER THAN MTU (%u < %u)", p->data_length, mtu);

	retry_defrag:
	DEFRAG_PACKET(p, if (!NET$OOM()) goto retry_defrag; goto drop);
	if (__unlikely(ip(p)->ip_off & htons(IP_DF))) {
		ICMP_SEND(p, ICMP_TYPECODE(ICMP_UNREACH, ICMP_UNREACH_NEEDFRAG), htonl(mtu));
		goto drop;
	}
	CHECKSUM_PACKET(p, goto drop);
	ihl = IP_HLEN(ip(p)->ip_vhl);
	opt = sizeof(struct ip);
	dopt = sizeof(struct ip);
	memcpy(header_2, ip(p), sizeof(struct ip));
	while (__unlikely(opt < ihl) && (o = p->data[LL_HEADER + opt]) != IPOPT_EOL) {
		if (o == IPOPT_NOP) {
			opt++;
			continue;
		}
		if (__unlikely(opt + 1 >= ihl)) {
			invalid:
			INVALID_IP_OPTIONS(p);
			goto drop;
		}
		l = p->data[LL_HEADER + opt + 1];
		if (__unlikely(l < 2) || __unlikely(opt + l > ihl)) goto invalid;
		if (IPOPT_COPIED(o)) {
			memcpy(header_2 + dopt, p->data + LL_HEADER + opt, l);
			dopt += l;
		}
		opt += l;
	}
	while (__unlikely(dopt & 3)) header_2[dopt++] = IPOPT_EOL;
	ip2->ip_vhl = IP_VVHL(dopt);
	cptr = ihl;
	new_data = (mtu - ihl) & ~7;
	new_total_size = ihl + new_data;
	while (__unlikely(cptr < p->data_length)) {
		PACKET *new;
		retry_alloc:
		ALLOC_PACKET(new, new_total_size, &NET$PKTPOOL, SPL_NET, if (!NET$OOM()) goto retry_alloc; goto drop);
		new->fn = NET$FREE_PACKET;
		(*(long *)(new->sender_data = outstanding))++;
		new->flags = PKT_IPHDR_CHECKSUM_OK;
		new->data_length = new_total_size;
		new->addrlen = p->addrlen;
		memcpy(PKT_DSTADDR(new, p->addrlen), PKT_DSTADDR(p, p->addrlen), 2 + (p->addrlen << 1));
		if (cptr == ihl) memcpy(ip(new), ip(p), ihl), ns = ihl;
		else memcpy(ip(new), ip2, dopt), ns = dopt;
		if (cptr + new_data < p->data_length) ip(new)->ip_off |= htons(IP_MF);
		memcpy((__u8 *)ip(new) + ns, (__u8 *)ip(p) + cptr, new_data);
		ip(new)->ip_len = htons(ns + new_data);
		ip(new)->ip_sum = 0;
		ip(new)->ip_sum = IP_CHECKSUM_FOLD_INVERT(NET$IP_CHECKSUM(0, (__u8 *)ip(new), IP_HLEN(ip(new)->ip_vhl)));
		new->h = p->h;
		new->id = IDTYPE_LO;
		iplog(new);
		CALL_IORQ(new, KERNEL$PKTIO);
		ip2->ip_off = htons(ntohs(ip2->ip_off) + (new_data >> 3));
		cptr += new_data;
		if (p->data_length - cptr + dopt < mtu) new_data = p->data_length - cptr;
		else new_data = (mtu - dopt) & ~7;
		new_total_size = dopt + new_data;
	}
	drop:
	p->status = 0;
	CALL_PKT(p);
#undef ip2
}

#define DEFRAG_HASH_SIZE	256

static LIST_HEAD FRAGS[DEFRAG_HASH_SIZE];
static DECL_LIST(ALL_FRAGS);
static unsigned FRAGBUF_SIZE = 0;

static __finline__ unsigned FRAG_HASH(PACKET *p)
{
	unsigned x = ip(p)->ip_src.s_addr + ip(p)->ip_dst.s_addr;
	x += x >> 16;
	x += ip(p)->ip_id;
	x += x >> 8;
	x &= DEFRAG_HASH_SIZE - 1;
	return x;
}

static void DEL_FRAG_PACKET(PACKET *p)
{
	DEL_FROM_LIST(&p->list);
	DEL_FROM_LIST(PKT_Q_ENTRY(p));
	FRAGBUF_SIZE -= sizeof(PACKET) + p->length;
	p->status = 0;
	CALL_PKT(p);
}

static __finline__ void CHECK_OVER(u_jiffies_lo_t j)
{
	PACKET *p;
	while (!LIST_EMPTY(&ALL_FRAGS) && (__unlikely(j - (p = PKT_Q_RQ(ALL_FRAGS.prev))->sent_time >= IPFRAG_MAX_AGE) || __unlikely(FRAGBUF_SIZE >= IPFRAG_MAX_SIZE))) {
		DEL_FRAG_PACKET(p);
	}
}

static void INVALID_FRAGMENT(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID FRAGMENT, IP LENGTH %X, SRC %s, DST %s, PROTOCOL %02X, FRAG %04X", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), ip(p)->ip_p, ntohs(ip(p)->ip_off));
}

static void LENGTH_EXCEEDED(PACKET *p, unsigned len)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "PACKET LENGTH %X EXCEEDED MAX PACKET LENGTH %X, SRC %s, DST %s, PROTOCOL %02X", len, NET$MAX_PACKET_LENGTH, PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), ip(p)->ip_p);
}

static void OVERLAPING_FRAGMENT(PACKET *p1, PACKET *p2)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "FRAGMENTS OVERLAP, SRC %s, DST %s, PROTOCOL %02X, LENGTH1 %X, FRAG1 %04X, LENGTH2 %X, FRAG2 %04X", PRINT_IP(a1, ip(p1)->ip_src.s_addr), PRINT_IP(a2, ip(p2)->ip_dst.s_addr), ip(p1)->ip_p, p1->data_length, ntohs(ip(p1)->ip_off), p2->data_length, ntohs(ip(p2)->ip_off));
}

static void DIFFERENT_INTERFACE(PACKET *p1, PACKET *p2)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "FRAGMENTS CAME FROM DIFFERENT INTERFACES, SRC %s, DST %s, PROTOCOL %02X", PRINT_IP(a1, ip(p1)->ip_src.s_addr), PRINT_IP(a2, ip(p2)->ip_dst.s_addr), ip(p1)->ip_p);
}

static __finline__ PACKET *DEFRAG_CHAIN(PACKET *p)
{
	unsigned f;
	PACKET *pp, *ppp, *np = NULL;
	unsigned doff = 0;
	pp = p;
	a:
	if ((((f = ntohs(ip(pp)->ip_off)) & IP_OFFMASK) << 3) != doff) {
		return NULL;
	}
	doff += pp->data_length - sizeof(struct ip);
	if (f & IP_MF) {
		if (pp->list.next >= (LIST_ENTRY *)(void *)&FRAGS[0] && pp->list.next < (LIST_ENTRY *)(void *)&FRAGS[DEFRAG_HASH_SIZE]) {
			return NULL;
		}
		pp = LIST_STRUCT(pp->list.next, PACKET, list);
		if (__unlikely(ip(pp)->ip_src.s_addr != ip(p)->ip_src.s_addr) ||
		    __unlikely(ip(pp)->ip_dst.s_addr != ip(p)->ip_dst.s_addr) ||
		    __unlikely(ip(pp)->ip_id != ip(p)->ip_id) ||
		    __unlikely(ip(pp)->ip_p != ip(p)->ip_p)) {
		    	return NULL;
		}
		goto a;
	}
	if (__unlikely(doff > NET$MAX_PACKET_LENGTH - sizeof(struct ip))) {
		LENGTH_EXCEEDED(p, doff + sizeof(struct ip));
		goto dropp;
	}
	ALLOC_PACKET(np, sizeof(struct ip) + doff, &NET$PKTPOOL, SPL_NET, NET$DELAYED_OOM(); goto dropp;);
	np->fn = NET$FREE_PACKET;
	np->sender_data = &KERNEL$LIST_END;
	np->data_length = sizeof(struct ip) + doff;
	np->addrlen = p->addrlen;
	np->id = p->id;
	memcpy(np->data, p->data, LL_HEADER + sizeof(struct ip));
	ip(np)->ip_len = htons(sizeof(struct ip) + doff);
	ip(np)->ip_off = htons(0);
	IP_HEADER_MAKE_CHECKSUM((__u8 *)ip(np));
	np->flags |= PKT_IPHDR_CHECKSUM_OK;
	doff = 0;
	for (ppp = p; ppp != pp; ppp = LIST_STRUCT(ppp->list.next, PACKET, list)) {
		memcpy((char *)(ip(np) + 1) + doff, ip(ppp) + 1, ppp->data_length - sizeof(struct ip));
		doff += ppp->data_length - sizeof(struct ip);
	}
	memcpy((char *)(ip(np) + 1) + doff, ip(ppp) + 1, ppp->data_length - sizeof(struct ip));
	dropp:
	while (p != pp) {
		ppp = LIST_STRUCT(p->list.next, PACKET, list);
		DEL_FRAG_PACKET(p);
		p = ppp;
	}
	DEL_FRAG_PACKET(p);
	return np;
}

void IP_DEFRAGMENT(PACKET *p)
{
	unsigned off, ppoff;
	unsigned h;
	PACKET *pp, *ppp, *np;
	u_jiffies_lo_t j;
	/*__debug_printf("d");*/
	DUP_PACKET(p, &NET$PKTPOOL_LONG_TERM, NET$DELAYED_OOM(); goto drop);

	off = (ntohs(ip(p)->ip_off) & IP_OFFMASK) << 3;
	if (__unlikely(off + p->data_length > IP_MAX_DEFRAG)) {
		INVALID_FRAGMENT(p);
		goto drop;
	}
	h = FRAG_HASH(p);
	ppp = NULL;
	LIST_FOR_EACH(pp, &FRAGS[h], PACKET, list) {
		if (__unlikely(ip(pp)->ip_src.s_addr != ip(p)->ip_src.s_addr)) {
			if (ip(pp)->ip_src.s_addr > ip(p)->ip_src.s_addr) break;
			else continue;
		}
		if (__unlikely(ip(pp)->ip_dst.s_addr != ip(p)->ip_dst.s_addr)) {
			if (ip(pp)->ip_dst.s_addr > ip(p)->ip_dst.s_addr) break;
			else continue;
		}
		if (__unlikely(ip(pp)->ip_p != ip(p)->ip_p)) {
			if (ip(pp)->ip_p > ip(p)->ip_p) break;
			continue;
		}
		if (__unlikely(ip(pp)->ip_id != ip(p)->ip_id)) {
			if (ip(pp)->ip_id > ip(p)->ip_id) break;
			continue;
		}
		if (local_security && __unlikely(pp->id != p->id)) {
			DIFFERENT_INTERFACE(pp, p);
			DEL_FRAG_PACKET(pp);
			goto drop;
		}
		ppoff = (ntohs(ip(pp)->ip_off) & IP_OFFMASK) << 3;
		if (__unlikely(off < ppoff)) {
			if (__unlikely(off + p->data_length - sizeof(struct ip) > ppoff)) {
				over:
				OVERLAPING_FRAGMENT(pp, p);
				DEL_FRAG_PACKET(pp);
				goto drop;
			}
			break;
		} else if (__unlikely(off > ppoff)) {
			if (__unlikely(ppoff + pp->data_length - sizeof(struct ip) > off)) {
				goto over;
			}
			if (!ppp) ppp = pp;
			continue;
		} else {
			goto over;
		}
	}
	j = KERNEL$GET_JIFFIES_LO();
	p->sent_time = j;
	ADD_TO_LIST_BEFORE(&pp->list, &p->list);
	ADD_TO_LIST(&ALL_FRAGS, PKT_Q_ENTRY(p));
	FRAGBUF_SIZE += sizeof(PACKET) + p->length;
	if (!ppp) ppp = p;
	np = DEFRAG_CHAIN(ppp);
	CHECK_OVER(j);
	if (np) {
		IP_INPUT(np);
		return;
	}
	return;
	drop:
	p->status = 0;
	CALL_PKT(p);
}

void IP_FRAG_INIT(void)
{
	int i;
	for (i = 0; i < DEFRAG_HASH_SIZE; i++) INIT_LIST(&FRAGS[i]);
}

void IP_FRAG_DONE(void)
{
	int i;
	int spl = KERNEL$SPL;
	RAISE_SPL(SPL_NET);
	for (i = 0; i < DEFRAG_HASH_SIZE; i++) while (!LIST_EMPTY(&FRAGS[i])) {
		PACKET *p = LIST_STRUCT(FRAGS[i].next, PACKET, list);
		DEL_FRAG_PACKET(p);
	}
	LOWER_SPLX(spl);
}
