#include <SPAD/PKT.H>
#include <STRING.H>
#include "MCAST.H"

#include "TCPIP.H"

void ICMP_SEND(PACKET *op, __u32 typecode, __u32 extra)
{
	PACKET *p;
	unsigned hlen;
	in_addr_t src;
	if (__unlikely(ip(op)->ip_p == IPPROTO_ICMP)) {
		if (__unlikely(op->data_length < sizeof(struct ip) + ICMP_LEN)) return;
		if (__likely(icmp(op)->icmp_type != ICMP_ECHO)) return;
	}
	TEST_BROADCAST_PACKET(op, return;);
	if (__unlikely(ip(op)->ip_off & htons(IP_OFFMASK))) return;
	if (__unlikely((__u32)(ntohl(ip(op)->ip_src.s_addr) + 1) < 2)) return;
	if (__unlikely((__u32)(ntohl(ip(op)->ip_dst.s_addr) + 1) < 2)) return;
	if (__unlikely(TCPIP_MULTICAST_OR_EXPERIMENTAL_ADDRESS(ip(op)->ip_src.s_addr))) return;
	if (__unlikely(TCPIP_MULTICAST_OR_EXPERIMENTAL_ADDRESS(ip(op)->ip_dst.s_addr))) return;
	if (__unlikely(IP_IS_BROADCAST(ip(op)->ip_src.s_addr) == 1)) return;
	if (__unlikely(IP_IS_BROADCAST(ip(op)->ip_dst.s_addr) == 1)) return;
	src = IP_FIND_LOCAL_ADDRESS(ip(op)->ip_dst.s_addr);
	if (__unlikely(src == htonl(INADDR_ANY))) {
		src = IP_FIND_LOCAL_ADDRESS(ip(op)->ip_src.s_addr);
		if (__unlikely(src == htonl(INADDR_ANY))) return;
	}
	hlen = IP_HLEN(ip(op)->ip_vhl);
	ALLOC_PACKET(p, sizeof(struct ip) + ICMP_LEN + hlen + 8, &NET$PKTPOOL, SPL_NET, NET$DELAYED_OOM(); return);
	p->fn = NET$FREE_PACKET;
	p->data_length = sizeof(struct ip) + ICMP_LEN + hlen + 8;
	ip(p)->ip_vhl = IP_VHL;
	ip(p)->ip_tos = IPTOS_PREC_PRIORITY | IPTOS_RELIABILITY;
	*(__u32 *)&ip(p)->ip_ttl = IP_TTL_P_SUM(IPPROTO_ICMP);
	ip(p)->ip_src.s_addr = src;
	ip(p)->ip_dst.s_addr = ip(op)->ip_src.s_addr;
	*(__u32 *)&icmp(p)->icmp_type = typecode;
	p->checksum.u = MKCHECKSUM(sizeof(struct ip), sizeof(struct ip) + 2);
	p->flags |= PKT_OUTPUT_CHECKSUM | PKT_TCPUDP_CHECKSUM_OK;
	icmp(p)->icmp_void = extra;
	if (__likely(op->data_length >= hlen + 8)) {
		memcpy(icmp(p)->icmp_data, ip(op), hlen + 8);
	} else {
		memcpy(icmp(p)->icmp_data, ip(op), hlen);
		memset((__u8 *)icmp(p)->icmp_data + hlen, 0, 8);
	}
	IP_SEND_PACKET(p);
}

static void ICMP_ECHO_REPLY(PACKET *p)
{
	in_addr_t a;
	retry_clone:
	CLONE_PACKET_FOR_RESEND(p, if (!NET$OOM()) goto retry_clone; goto drop);
	p->flags &= PKT_REUSE_FLAGS;
#ifdef RESET_PING_SIZE
	/* after I had to travel through the city because of unresponsive
	   machine four times, I implemented this l33t debugging feature ... */
	if (__unlikely(ntohs(ip(p)->ip_len) - 20 - 8 == RESET_PING_SIZE))
#ifdef RESET_PING_IP
		if (__likely(ntohl(ip(p)->ip_src.s_addr) == RESET_PING_IP))
#endif
			__asm__ volatile ("1: movb $0xfe, %al; outb %al, $0x64; hlt; jmp 1b");
#endif
	a = ip(p)->ip_src.s_addr;
	ip(p)->ip_src.s_addr = ip(p)->ip_dst.s_addr;
	ip(p)->ip_dst.s_addr = a;
	*(__u32 *)&ip(p)->ip_ttl = IP_TTL_P_SUM(IPPROTO_ICMP);
	*(__u32 *)&icmp(p)->icmp_type = ICMP_TYPECODE(ICMP_ECHOREPLY, 0);
	p->checksum.u = MKCHECKSUM(sizeof(struct ip), sizeof(struct ip) + 2);
	p->flags |= PKT_OUTPUT_CHECKSUM | PKT_TCPUDP_CHECKSUM_OK;
	IP_SEND_PACKET(p);
	return;
	drop:
	p->status = 0;
	CALL_PKT(p);
}

static __finline__ void SET_SOCKET_ERROR(TCPIP_SOCKET *s, unsigned type, unsigned code, __u32 param)
{
	int mss;
	if (__likely(type == ICMP_UNREACH)) {
		switch (code) {
			case ICMP_UNREACH_NET:
			case ICMP_UNREACH_SRCFAIL:
			case ICMP_UNREACH_NET_UNKNOWN:
			case ICMP_UNREACH_ISOLATED:
				s->conn_error = -ENETUNREACH;
				goto set_err;
			case ICMP_UNREACH_HOST:
			case ICMP_UNREACH_HOST_UNKNOWN:
				s->conn_error = -EHOSTUNREACH;
				goto set_err;
			case ICMP_UNREACH_PROTOCOL:
				s->conn_error = -EPROTONOSUPPORT;
				goto set_err;
			case ICMP_UNREACH_PORT:
				s->conn_error = -ECONNREFUSED;
				goto set_err;
			case ICMP_UNREACH_NET_PROHIB:
			case ICMP_UNREACH_HOST_PROHIB:
			case ICMP_UNREACH_FILTER_PROHIB:
				s->conn_error = -EACCES;
				goto set_err;
			case ICMP_UNREACH_TOSNET:
			case ICMP_UNREACH_TOSHOST:
			case ICMP_UNREACH_HOST_PRECEDENCE:
			case ICMP_UNREACH_PRECEDENCE_CUTOFF:
				s->ip_tos = 0;
				return;
			case ICMP_UNREACH_NEEDFRAG:
				if (s->packet == UDP_PACKET) {
					s->conn_error = -EMSGSIZE;
					goto set_err;
				}
				mss = ((ntohl(param) & 0xffff) - sizeof(struct ip) - sizeof(struct tcphdr)) & ~3;
				if (__likely(mss >= IP_MIN_MTU - sizeof(struct ip) - sizeof(struct tcphdr))) {
					if (__likely(mss < s->mss)) s->mss = mss;
				} else {
					if (__likely(s->mss > IP_MIN_MTU - sizeof(struct ip) - sizeof(struct tcphdr))) {
						s->mss = ((s->mss + (IP_MIN_MTU - sizeof(struct ip) - sizeof(struct tcphdr))) >> 1) & ~3;
					}
				}
				return;
		}
	} else if (__unlikely(type == ICMP_TIMXCEED)) {
		switch (code) {
			case ICMP_TIMXCEED_INTRANS:
				s->conn_error = -ENETUNREACH;
				goto set_err;
			case ICMP_TIMXCEED_REASS:
				return;
		}
	} else if (__unlikely(type == ICMP_PARAMPROB)) {
		s->conn_error = -EPROTO;
		goto set_err;
	}
	return;

	set_err:
	if (s->packet == UDP_PACKET && s->remote_addr != htonl(INADDR_ANY)) {
		s->sock_error = s->conn_error;
		WQ_WAKE_ALL(&s->read_wait);
		WQ_WAKE_ALL(&s->write_wait);
	}
}

void ICMP_PACKET(PACKET *p)
{
	unsigned hlen;
	TCPIP_SOCKET *s;
	switch (icmp(p)->icmp_type) {
		case ICMP_ECHO:
			ICMP_ECHO_REPLY(p);
			return;
		case ICMP_UNREACH:
		case ICMP_SOURCEQUENCH:
		case ICMP_TIMXCEED:
		case ICMP_PARAMPROB:
			if (__unlikely(p->data_length < sizeof(struct ip) + ICMP_LEN + sizeof(struct ip))) break;
#define ip2 ((struct ip *)icmp(p)->icmp_data)
			hlen = IP_HLEN(ip2->ip_vhl);
#define tcp2 ((struct tcphdr *)(icmp(p)->icmp_data + hlen))
#define udp2 ((struct udphdr *)(icmp(p)->icmp_data + hlen))
			if (__likely(ip2->ip_p == IPPROTO_TCP)) {
				if (__unlikely(p->data_length < sizeof(struct ip) + ICMP_LEN + hlen + 4)) break;
				s = LOOKUP_SOCKET(ip2->ip_src.s_addr, tcp2->th_sport, ip2->ip_dst.s_addr, tcp2->th_dport, LS_TCP);
			} else if (__likely(ip2->ip_p == IPPROTO_UDP)) {
				if (__unlikely(p->data_length < sizeof(struct ip) + ICMP_LEN + hlen + 4)) break;
				s = LOOKUP_SOCKET(ip2->ip_src.s_addr, udp2->uh_sport, ip2->ip_dst.s_addr, udp2->uh_dport, LS_UDP);
			} else break;
			if (__unlikely(!s)) break;
			SET_SOCKET_ERROR(s, icmp(p)->icmp_type, icmp(p)->icmp_code, icmp(p)->icmp_void);
#undef ip2
#undef tcp2
#undef udp2
			break;
	}
	p->status = 0;
	CALL_PKT(p);
}

