#include <SPAD/SYSLOG.H>
#include <ARCH/IPCHECKS.H>
#include "IP.H"

#include "TCPIP.H"

static void INVALID_IP_PACKET(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 1)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID IP PACKET: PHYSICAL LENGTH %X, VERSION/HEADER %02X, TOS %02X, IP LENGTH %04X, ID %04X, FRAGMENT %04X, TTL %02X, PROTOCOL %02X, CHECKSUM %04X, SRC %s, DST %s", p->data_length, ip(p)->ip_vhl, ip(p)->ip_tos, ntohs(ip(p)->ip_len), ntohs(ip(p)->ip_id), ntohs(ip(p)->ip_off), ip(p)->ip_ttl, ip(p)->ip_p, ntohs(ip(p)->ip_sum), PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr));
}

static void INVALID_IP_CHECKSUM(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	static char a3[__MAX_STR_LEN];
	unsigned hlen = IP_HLEN(ip(p)->ip_vhl);
	if (errorlevel >= 1)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID IP CHECKSUM: VERSION/HEADER %02X, TOS %02X, IP LENGTH %04X, ID %04X, FRAGMENT %04X, TTL %02X, PROTOCOL %02X, CHECKSUM %04X, SRC %s, DST %s, OPTIONS %s", ip(p)->ip_vhl, ip(p)->ip_tos, ntohs(ip(p)->ip_len), ntohs(ip(p)->ip_id), ntohs(ip(p)->ip_off), ip(p)->ip_ttl, ip(p)->ip_p, ntohs(ip(p)->ip_sum), PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), PRINT_OPTIONS(a3, (__u8 *)(ip(p) + 1), hlen - sizeof(struct ip)));
}

void INVALID_IP_OPTIONS(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	static char a3[__MAX_STR_LEN];
	unsigned hlen = IP_HLEN(ip(p)->ip_vhl);
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID IP OPTIONS: VERSION/HEADER %02X, TOS %02X, IP LENGTH %04X, ID %04X, FRAGMENT %04X, TTL %02X, PROTOCOL %02X, CHECKSUM %04X, SRC %s, DST %s, OPTIONS %s", ip(p)->ip_vhl, ip(p)->ip_tos, ntohs(ip(p)->ip_len), ntohs(ip(p)->ip_id), ntohs(ip(p)->ip_off), ip(p)->ip_ttl, ip(p)->ip_p, ntohs(ip(p)->ip_sum), PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), PRINT_OPTIONS(a3, (__u8 *)(ip(p) + 1), hlen - sizeof(struct ip)));
}

void INVALID_TCP_PACKET(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID TCP PACKET: IP LENGTH %X, SRC %s:%u, DST %s:%u, HLEN %02X, FLAGS %02X", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), ntohs(tcp(p)->th_sport), PRINT_IP(a2, ip(p)->ip_dst.s_addr), ntohs(tcp(p)->th_dport), tcp(p)->th_off4, tcp(p)->th_flags);
}

static void INVALID_TCP_CHECKSUM(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID TCP CHECKSUM: IP LENGTH %X, SRC %s:%u, DST %s:%u, HLEN %02X, FLAGS %02X", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), ntohs(tcp(p)->th_sport), PRINT_IP(a2, ip(p)->ip_dst.s_addr), ntohs(tcp(p)->th_dport), tcp(p)->th_off4, tcp(p)->th_flags);
}

static void INVALID_UDP_PACKET(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID UDP PACKET: IP LENGTH %X, SRC %s:%u, DST %s:%u, UDP LENGTH %04X", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), ntohs(udp(p)->uh_sport), PRINT_IP(a2, ip(p)->ip_dst.s_addr), ntohs(udp(p)->uh_dport), ntohs(udp(p)->uh_ulen));
}

void INVALID_UDP_CHECKSUM(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID UDP CHECKSUM: IP LENGTH %X, SRC %s:%u, DST %s:%u", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), ntohs(udp(p)->uh_sport), PRINT_IP(a2, ip(p)->ip_dst.s_addr), ntohs(udp(p)->uh_dport));
}

static void INVALID_ICMP_CHECKSUM(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID ICMP CHECKSUM: IP LENGTH %X, SRC %s, DST %s, TYPE %02X, CODE %02X", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), icmp(p)->icmp_type, icmp(p)->icmp_code);
}

static void INVALID_IGMP_DESTINATION(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	static char a3[16];
	if (errorlevel >= 2)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "IGMP DESTINATION ADDRESS IS NOT MULTICAST: IP LENGTH %X, SRC %s, DST %s, TYPE %02X, CODE %02X, GROUP %s", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), igmp(p)->igmp_type, igmp(p)->igmp_code, PRINT_IP(a3, igmp(p)->igmp_group.s_addr));
}

static void INVALID_IGMP_CHECKSUM(PACKET *p)
{
	static char a1[16];
	static char a2[16];
	static char a3[16];
	if (errorlevel >= 1)
		KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "INVALID IGMP CHECKSUM: IP LENGTH %X, SRC %s, DST %s, TYPE %02X, CODE %02X, GROUP %s", p->data_length, PRINT_IP(a1, ip(p)->ip_src.s_addr), PRINT_IP(a2, ip(p)->ip_dst.s_addr), igmp(p)->igmp_type, igmp(p)->igmp_code, PRINT_IP(a3, igmp(p)->igmp_group.s_addr));
}

void IP_INPUT(PACKET *p)
{
	unsigned hlen, tlen;
	unsigned protocol;
	TCPIP_SOCKET *s;
	static u_jiffies_lo_t arp_revalidate_time = 0;
	iplog(p);
	if (__unlikely(p->data_length < sizeof(struct ip))) {
		if (errorlevel >= 1)
			KERNEL$SYSLOG(__SYSLOG_NET_ERROR, net_name, "TOO SHORT IP PACKET, LENGTH %X", p->data_length);
		goto drop;
	}
	hlen = ip(p)->ip_vhl - IP_VHL;
	if (__unlikely(hlen > IP_VHL_MAX - IP_VHL)) {
		invl:
		INVALID_IP_PACKET(p);
		goto drop;
	}
	hlen = (hlen << 2) + sizeof(struct ip);
	if (__unlikely(hlen > p->data_length)) goto invl;
	if (__unlikely((tlen = ntohs(ip(p)->ip_len)) < hlen + 8)) goto invl;
	if (__unlikely(tlen != p->data_length)) {
/* some network cards pad packets with non-zero bytes */
		if (__likely(tlen == 40) && __likely(p->data_length == 46)) {
			__u32 p1 = *(__u32 *)&p->data[LL_HEADER + 40];
			__u32 p2 = *(__u16 *)&p->data[LL_HEADER + 44];
/* SK-Yukon pads with 0xaa .... 0xaaaaaaaaaaaa luckily compensates checksum */
			if (__unlikely(p1 | p2) && __unlikely((p1 ^ 0xaaaaaaaa) | (p2 ^ 0xaaaa))) p->flags &= ~PKT_INPUT_CHECKSUM;
			p->data_length = 40;
		} else {
			p->data_length = tlen;
			p->flags &= ~PKT_INPUT_CHECKSUM;
			/* I think this is not so common to waste space because
			   of it ...
			unsigned i;
			if (__unlikely(tlen > p->data_length)) goto invl;
			for (i = tlen; i < p->data_length; i++)
				if (__unlikely(p->data[LL_HEADER + i])) {
					p->flags &= ~PKT_INPUT_CHECKSUM;
					break;
				}
			p->data_length = tlen;
			*/
		}
	}
	if (!(p->flags & PKT_IPHDR_CHECKSUM_OK)) {
		if (__likely(ip(p)->ip_vhl == IP_VHL)) {
			if (__unlikely(IP_HEADER_CHECK_5((__u8 *)ip(p)) != 0xffff)) {
				INVALID_IP_CHECKSUM(p);
				goto drop;
			}
		} else {
			hlen = IP_HLEN(ip(p)->ip_vhl);
			if (__unlikely(IP_CHECKSUM_FOLD_INVERT(NET$IP_CHECKSUM(0, (__u8 *)ip(p), hlen)) != 0)) {
				INVALID_IP_CHECKSUM(p);
				goto drop;
			}
		}
	}
	if (__unlikely(!TCPIP_BINDABLE_ADDRESS(ip(p)->ip_dst.s_addr))) {
		struct udphdr *udp;
		udp = (struct udphdr *)((__u8 *)ip(p) + IP_HLEN(ip(p)->ip_vhl));
		if ((__unlikely(udp->uh_dport == htons(BOOTP_CLIENT_PORT)) || __unlikely(udp->uh_dport == htons(BOOTP_SERVER_PORT))) && __likely(ip(p)->ip_p == IPPROTO_UDP) && __likely(!((*(__u32 *)&ip(p)->ip_id & htonl(IP_MF | IP_OFFMASK))))) {
			DHCP_INPUT(p);
			return;
		}
		if (TCPIP_MULTICAST_OR_EXPERIMENTAL_ADDRESS(ip(p)->ip_dst.s_addr)) {
			if (__likely(TCPIP_MULTICAST_ADDRESS(ip(p)->ip_dst.s_addr))) {
				goto accept_addr;
			}
			goto drop;
		}
		if (__unlikely(!IFF_GATE)) goto drop;
		TEST_BROADCAST_PACKET(p, goto drop;);
		if (__unlikely((__u32)(ntohl(ip(p)->ip_dst.s_addr) + 1) < 2)) goto drop;
		if (__unlikely((__u32)(ntohl(ip(p)->ip_src.s_addr) + 1) < 2)) goto drop;
		if (__unlikely(local_security)) if (__unlikely(ARP_CHECK_SECURITY(p))) return;
		if (__unlikely(KERNEL$GET_JIFFIES_LO() - arp_revalidate_time > ARP_REVALIDATE_TIME)) {
			arp_revalidate_time = KERNEL$GET_JIFFIES_LO();
			ARP_UPDATE(p);
		}
		retry_clone:
		CLONE_PACKET_FOR_RESEND(p, {
			if (!NET$OOM()) goto retry_clone;
			p->status = -ENOMEM;
			CALL_PKT(p);
			return;
		});
		IP_ROUTE_PACKET(p);
		return;
	}
	accept_addr:
	REMOVE_IP_OPTIONS;
	if (__unlikely(local_security)) {
		if (__unlikely(udp(p)->uh_dport == htons(BOOTP_CLIENT_PORT)) &&
		    __likely(ip(p)->ip_p == IPPROTO_UDP) &&
		    __likely(!((*(__u32 *)&ip(p)->ip_id & htonl(IP_MF | IP_OFFMASK))))) {
		    	DHCP_INPUT(p);
			return;
		}
		if (__unlikely(ARP_CHECK_SECURITY(p))) return;
	}
	if (__unlikely(KERNEL$GET_JIFFIES_LO() - arp_revalidate_time > ARP_REVALIDATE_TIME)) {
		arp_revalidate_time = KERNEL$GET_JIFFIES_LO();
		ARP_UPDATE(p);
	}
	if (__unlikely((*(__u32 *)&ip(p)->ip_id & htonl(IP_MF | IP_OFFMASK)))) {
		IP_DEFRAGMENT(p);
		return;
	}
	protocol = ip(p)->ip_p;
	if (__likely(protocol == IPPROTO_TCP)) {
		if (__unlikely(p->data_length < sizeof(struct ip) + sizeof(struct tcphdr)))
			goto invl;
		hlen = TCP_HLEN(tcp(p)->th_off4);
		if (__unlikely(hlen < sizeof(struct tcphdr)) || __unlikely(sizeof(struct ip) + hlen > p->data_length) || __unlikely(hlen > 60) || __unlikely(TCPIP_MULTICAST_OR_EXPERIMENTAL_ADDRESS(ip(p)->ip_dst.s_addr))) {
			INVALID_TCP_PACKET(p);
			goto drop;
		}
		if (__unlikely(!(p->flags & PKT_TCPUDP_CHECKSUM_OK))) {
			CHECK_CHECKSUM(TCPUDP_MAGIC_CHECKSUM_UNFOLDED(IPPROTO_TCP, p->data_length - sizeof(struct ip)), 2 * sizeof(in_addr_t), invl_tcp, comp_tcp, INVALID_TCP_CHECKSUM);
		}
		if (__unlikely(!(s = LOOKUP_SOCKET(ip(p)->ip_dst.s_addr, tcp(p)->th_dport, ip(p)->ip_src.s_addr, tcp(p)->th_sport, LS_TCP)))) {
			if (__unlikely(!(s = LOOKUP_LISTEN(ip(p)->ip_dst.s_addr, tcp(p)->th_dport, LL_TCP)))) {
				tcp_rst:
				TCP_NULL_PACKET(NULL, p);
				return;
			}
		}
		if (__unlikely(!(s->flags & SOCK_NETACL_ACCEPT_IN))) {
			int r;
			if (__unlikely(s->packet == TCP_NULL_PACKET) || __unlikely(s->packet == TCP_NULL_PACKET_1)) goto tcp_rst;
			if (__likely(s->flags & SOCK_NETACL_TCP_ACCEPT)) {
				r = NETACL_SEARCH(s->node, ip(p)->ip_src.s_addr, ntohs(s->local_port) | NETACL_PORT_IN);
				if (__unlikely(r < 0)) {
					if (s->packet == TCP_LISTEN) goto tcp_rst;
					goto icmp_filter_prohib;
				}
			} else {
				r = NETACL_SEARCH(s->node, s->remote_addr, ntohs(s->remote_port));
				if (__unlikely(r < 0)) {
					icmp_filter_prohib:
					ICMP_SEND(p, ICMP_TYPECODE(ICMP_UNREACH, ICMP_UNREACH_FILTER_PROHIB), 0);
					goto drop;
				}
			}
			s->flags |= __likely((((unsigned long)s->packet - (unsigned long)TCP_LISTEN) | (r & NETACL_ALLADDR)) != 0) ? SOCK_NETACL_ACCEPT_IN : 0;
		}
		s->packet(s, p);
		return;
	} else if (__likely(protocol == IPPROTO_UDP)) {
		/*
		if (__unlikely(p->data_length < sizeof(struct ip) + sizeof(struct udphdr)))
			goto invl;
		*/
		if (__unlikely(ntohs(udp(p)->uh_ulen) + sizeof(struct ip) != p->data_length)) {
			INVALID_UDP_PACKET(p);
			goto drop;
		}
		CHECK_UDP_CHECKSUM;
		if (__unlikely(udp(p)->uh_dport == htons(BOOTP_CLIENT_PORT))) {
			DHCP_INPUT(p);
			return;
		}
		if (__unlikely(!(s = LOOKUP_SOCKET(ip(p)->ip_dst.s_addr, udp(p)->uh_dport, ip(p)->ip_src.s_addr, udp(p)->uh_sport, LS_UDP)))) {
			/* this also accepts multicast packets
			   TODO: allow one multicast packet to more sockets */
			if (__unlikely(!(s = LOOKUP_LISTEN(ip(p)->ip_dst.s_addr, udp(p)->uh_dport, LL_UDP)))) {
				udp_null:
				UDP_NULL_PACKET(p);
				return;
			};
		};
		if (__unlikely(!(s->flags & SOCK_NETACL_ACCEPT_IN))) {
			int r = NETACL_SEARCH(s->node, ip(p)->ip_src.s_addr, ntohs(udp(p)->uh_dport) | NETACL_PORT_UDP | NETACL_PORT_IN);
			if (__unlikely(r < 0)) {
			/* it would be better to send ICMP_UNREACH_FILTER_PROHIB
			   here, but we actually want to hide the information
			   that the port is open */
				goto udp_null;
			}
			s->flags |= __likely(s->remote_addr | (r & NETACL_ALLADDR)) ? SOCK_NETACL_ACCEPT_IN : 0;
		}
		UDP_PACKET(s, p);
		return;
	} else if (__likely(protocol == IPPROTO_ICMP)) {
		if (__unlikely(p->data_length < sizeof(struct ip) + ICMP_LEN))
			goto invl;
		if (__unlikely(TCPIP_MULTICAST_OR_EXPERIMENTAL_ADDRESS(ip(p)->ip_dst.s_addr)))
			goto drop;
		if (__unlikely(!(p->flags & PKT_TCPUDP_CHECKSUM_OK))) {
			CHECK_CHECKSUM(0, 0, invl_icmp, comp_icmp, INVALID_ICMP_CHECKSUM);
		}
		ICMP_PACKET(p);
		return;
	} else if (__likely(protocol == IPPROTO_IGMP)) {
		if (__unlikely(!TCPIP_MULTICAST_ADDRESS(ip(p)->ip_dst.s_addr))) {
			INVALID_IGMP_DESTINATION(p);
			goto drop;
		}
		if (__unlikely(!(p->flags & PKT_TCPUDP_CHECKSUM_OK))) {
			CHECK_CHECKSUM(0, 0, invl_igmp, comp_igmp, INVALID_IGMP_CHECKSUM);
		}
		IGMP_PACKET(p);
		return;
	} else {
		ICMP_SEND(p, ICMP_TYPECODE(ICMP_UNREACH, ICMP_UNREACH_PROTOCOL), 0);
	}
	drop:
	p->status = 0;
	CALL_PKT(p);
}
