#ifdef sio
#define WFN KERNEL$WAKE_READ
DECL_IOCALL(TCP_READ, SPL_NET, SIORQ)
#else
#define WFN KERNEL$WAKE_AREAD
DECL_IOCALL(TCP_RECVMSG, SPL_NET, AIORQ)
#endif
{
	long ss;
	VBUF vbuf;
	PACKET *p;
	TCPIP_SOCKET *s;
	HANDLE *h = RQ->handle;
	unsigned pos;
	u_jiffies_lo_t j;
#ifndef sio
	unsigned flags;
#endif
	if (__unlikely(h->op != &TCP_OPS)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_NET));
	s = h->fnode;
	if (__unlikely(s->sock_error)) {
		RQ->status = s->sock_error;
		RETURN_AST(RQ);
	}
#ifndef sio
	{
		vspace_unmap_t *unmap;
		VDESC v;
		struct _msghdr *p;
		v.ptr = RQ->pos;
		v.len = sizeof(struct _msghdr);
		v.vspace = RQ->v.vspace;
		RAISE_SPL(SPL_VSPACE);
		p = v.vspace->op->vspace_map(&v, PF_RW, &unmap);
		LOWER_SPL(SPL_NET);
		if (__unlikely(!p)) DO_PAGEIN(RQ, &v, PF_RW);
		if (__unlikely(__IS_ERR(p))) {
			RQ->status = __PTR_ERR(p);
			RETURN_AST(RQ);
		}
		flags = p->msg_flags;
		if (__likely(((struct sockaddr_in *)&p->msg_addr)->sin_len >= sizeof(struct sockaddr_in))) {
			((struct sockaddr_in *)&p->msg_addr)->sin_family = PF_INET;
			((struct sockaddr_in *)&p->msg_addr)->sin_len = sizeof(struct sockaddr_in);
			((struct sockaddr_in *)&p->msg_addr)->sin_port = s->remote_port;
			((struct sockaddr_in *)&p->msg_addr)->sin_addr.s_addr = s->remote_addr;
		} else {
			((struct sockaddr_in *)&p->msg_addr)->sin_len = 0;
		}
		RAISE_SPL(SPL_VSPACE);
		unmap(p);
		LOWER_SPL(SPL_NET);
	}
#endif
	if (__unlikely(!RQ->v.len)) goto ret;
	if (__unlikely(s->packet != TCP_ESTABLISHED)) {
		if (__likely(s->packet == TCP_NULL_PACKET) || __likely(s->packet == TCP_SYN_SENT)) goto wait;
		RQ->status = -ENOTCONN;
		RETURN_AST(RQ);
	}
	if (__unlikely(s->sock_rcvlowat > 1) && __likely(!(s->flags & SOCK_SHUTDOWN_READ))) {
		unsigned wat = RQ->v.len > s->sock_rcvlowat ? s->sock_rcvlowat : RQ->v.len;
		if (wat > (tcp_seq)(s->ack - s->read_seq)) goto wait;
	}
#ifndef sio
	if (__unlikely(flags & MSG_PEEK)) {
		unsigned read_seq = s->read_seq;
		LIST_FOR_EACH(p, &s->in_queue, PACKET, list) {
			a_t:
			pos = (tcp_seq)(read_seq - ntohl(tcp(p)->th_seq));
			if (__unlikely(pos >= p->data_length - sizeof(struct ip) - sizeof(struct tcphdr)))
				continue;
			vbuf.ptr = (char *)(tcp(p) + 1) + pos;
			vbuf.len = p->data_length - sizeof(struct ip) - sizeof(struct tcphdr) - pos;
			vbuf.spl = SPL_X(SPL_NET);
			RAISE_SPL(SPL_VSPACE);
			ss = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
			if (__unlikely(!ss)) DO_PAGEIN(RQ, &RQ->v, PF_WRITE);
			RQ->progress += ss;
			read_seq = (tcp_seq)(read_seq + ss);
			if (!RQ->v.len) goto ret;
			if (ss != vbuf.len) goto a_t;
		}
		goto gotall;
	}
#endif
	retry:
	if (__unlikely(LIST_EMPTY(&s->in_queue))) {
		wait:
#ifndef sio
		if (__unlikely(flags & MSG_WAITALL)) goto w;
		gotall:
#endif
		if (RQ->progress) goto ret;
		if (__unlikely(s->flags & SOCK_SHUTDOWN_READ)) {
			goto ret;
		}
		if (h->flags & SOCKET_NONBLOCK
#ifndef sio
			|| __unlikely(flags & MSG_DONTWAIT)
#endif
		) {
			RQ->status = -EWOULDBLOCK;
			RETURN_AST(RQ);
		}
#ifndef sio
		w:
#endif
		WQ_WAIT_F(&s->read_wait, RQ);
		RETURN;
	}
	p = LIST_STRUCT(s->in_queue.next, PACKET, list);
	pos = (tcp_seq)(s->read_seq - ntohl(tcp(p)->th_seq));
	if (__unlikely(pos >= p->data_length - sizeof(struct ip) - sizeof(struct tcphdr)))
		goto free_packet;
	vbuf.ptr = (char *)(tcp(p) + 1) + pos;
	vbuf.len = p->data_length - sizeof(struct ip) - sizeof(struct tcphdr) - pos;
	vbuf.spl = SPL_X(SPL_NET);
	RAISE_SPL(SPL_VSPACE);
	ss = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
	if (__unlikely(!ss)) DO_PAGEIN(RQ, &RQ->v, PF_WRITE);
	RQ->progress += ss;
	s->read_seq = (tcp_seq)(s->read_seq + ss);
	s->read_rate += ss;
	j = KERNEL$GET_JIFFIES_LO();
	if (__unlikely(j - s->read_rate_time > TCP_READ_BUFFER_TIME)) {
		s->read_rate >>= 1;
		s->read_rate_time = s->read_rate_time + ((j - s->read_rate_time) >> 1);
	}
	if (ss == vbuf.len) {
		int rwindow = TCP_READ_BUFFER(s);
		rwindow -= (tcp_seq)(s->ack - s->read_seq);
		if (rwindow > s->offered_window && __likely(!(s->flags & SOCK_SHUTDOWN_READ))) {
			int mask = __likely(s->flags & SOCK_WINSCALE) ? ~((1 << TCP_WINDOW_SCALE) - 1) : ~0;
			int z = 0;
			if (__unlikely((s->offered_window & mask) < s->mss)) {
				z = 2;
				if (!(s->offered_window & mask)) z = 1;
			}
			s->offered_window = rwindow;
			if (__unlikely(z)) {
				if ((z == 1 && (rwindow & mask)) || (rwindow & mask) >= s->mss) TCP_SEND_ACK(s);
			}
		}
		free_packet:
		NET$QFREE((SOCKET *)s, sizeof(PACKET) + p->length);
		DEL_FROM_LIST(&p->list);
		FREE_PACKET(p, NULL, SPL_NET);
	}
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_NET));
	TEST_LOCKUP_LOOP(RQ, RETURN);
	if (RQ->v.len) goto retry;
	ret:
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);
}

#undef WFN

#ifdef sio
#define WFN KERNEL$WAKE_WRITE
DECL_IOCALL(TCP_WRITE, SPL_NET, SIORQ)
#else
#define WFN KERNEL$WAKE_AWRITE
DECL_IOCALL(TCP_SENDMSG, SPL_NET, AIORQ)
#endif
{
	int r;
	long ss;
	VBUF vbuf;
	PACKET *p;
	TCPIP_SOCKET *s;
	HANDLE *h = RQ->handle;
	WQ *wq;
#ifndef sio
	unsigned flags;
#endif
	if (__unlikely(h->op != &TCP_OPS)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_NET));
	s = h->fnode;
	if (__unlikely(s->sock_error)) {
		RQ->status = s->sock_error;
		RETURN_AST(RQ);
	}
	if (__unlikely(s->flags & SOCK_SHUTDOWN_WRITE)) {
		RQ->status = -ESHUTDOWN;
		RETURN_AST(RQ);
	}
#ifndef sio
	{
		vspace_unmap_t *unmap;
		VDESC v;
		struct _msghdr *p;
		v.ptr = RQ->pos;
		v.len = sizeof(struct _msghdr);
		v.vspace = RQ->v.vspace;
		RAISE_SPL(SPL_VSPACE);
		p = v.vspace->op->vspace_map(&v, PF_READ, &unmap);
		LOWER_SPL(SPL_NET);
		if (__unlikely(!p)) DO_PAGEIN(RQ, &v, PF_READ);
		if (__unlikely(__IS_ERR(p))) {
			RQ->status = __PTR_ERR(p);
			RETURN_AST(RQ);
		}
		flags = p->msg_flags;
		if (__unlikely(((struct sockaddr_in *)&p->msg_addr)->sin_len >= sizeof(struct sockaddr_in))) {
			if (__unlikely(((struct sockaddr_in *)&p->msg_addr)->sin_family != PF_INET) ||
			    __unlikely(((struct sockaddr_in *)&p->msg_addr)->sin_port != s->remote_port) ||
			    __unlikely(((struct sockaddr_in *)&p->msg_addr)->sin_addr.s_addr != s->remote_addr)) {
				RAISE_SPL(SPL_VSPACE);
				unmap(p);
				LOWER_SPL(SPL_NET);
				RQ->status = -EINVAL;
				RETURN_AST(RQ);
			}
		}
		RAISE_SPL(SPL_VSPACE);
		unmap(p);
		LOWER_SPL(SPL_NET);
	}
#endif
	if (__unlikely(s->packet != TCP_ESTABLISHED)) {
		if (__likely(s->packet == TCP_SYN_SENT)) goto wait;
		RQ->status = -ENOTCONN;
		RETURN_AST(RQ);
	}
	if (__unlikely(!RQ->v.len)) goto ret;
	if (__unlikely(s->sock_sndlowat > 1)) {
		unsigned wat = RQ->v.len > s->sock_rcvlowat ? s->sock_rcvlowat : RQ->v.len;
		if (__unlikely(s->sent_queue_length + s->out_queue_length + wat > TCP_WRITE_BUFFER(s))) {
			wait:
#ifndef sio
			if (__unlikely(flags & MSG_WAITALL)) goto w;
#endif
			if (RQ->progress) goto ret;
			if (h->flags & SOCKET_NONBLOCK
#ifndef sio
				|| __unlikely(flags & MSG_DONTWAIT)
#endif
			) {
				RQ->status = -EWOULDBLOCK;
				RETURN_AST(RQ);
			}
#ifndef sio
			w:
#endif
			WQ_WAIT_F(&s->write_wait, RQ);
			RETURN;
		}
	}
	retry:
	if ((p = s->prepared_packet)) {
		int lo;
		unsigned vlen;
		fill_pkt:
		vbuf.ptr = p->data + LL_HEADER + p->data_length;
		vlen = s->mss + sizeof(struct ip) + sizeof(struct tcphdr);
		if (__unlikely(vlen > p->length)) vlen = p->length;
		vbuf.len = vlen - p->data_length;
		vbuf.spl = SPL_X(SPL_NET);
		RAISE_SPL(SPL_VSPACE);
		ss = RQ->v.vspace->op->vspace_get(&RQ->v, &vbuf);
		if (__unlikely(!ss)) {
			if (__unlikely(p->data_length == sizeof(struct ip) + sizeof(struct tcphdr))) {
				NET$QFREE((SOCKET *)s, sizeof(PACKET) + p->length);
				FREE_PACKET(p, NULL, SPL_NET);
				s->prepared_packet = NULL;
			}
			DO_PAGEIN(RQ, &RQ->v, PF_READ);
		}
		s->out_queue_length += ss;
		p->data_length += ss;
		RQ->progress += ss;
		lo = LIST_EMPTY(&s->out_queue);
		if (ss == vbuf.len) {
			ADD_TO_LIST_END(&s->out_queue, &p->list);
			s->prepared_packet = NULL;
		}
		if (lo) TCP_SEND_MORE(s);
	} else {
		if (__unlikely(TCP_CANT_WRITE(s))) {
			goto wait;
		}
		if (__unlikely((wq = KERNEL$MAY_ALLOC(h->name_addrspace, sizeof(PACKET) + sizeof(struct ip) + sizeof(struct tcphdr) + s->mss)) != NULL)) {
			wait_wq:
			WQ_WAIT_F(wq, RQ);
			RETURN;
		}
		ALLOC_PACKET(p, sizeof(struct ip) + sizeof(struct tcphdr) + s->mss, NULL, SPL_NET, {
			wq = NET$OOM();
			if (__unlikely(!wq)) call_again: RETURN_IORQ_LSTAT(RQ, WFN);
			if (__unlikely(__IS_ERR(wq))) {
				RQ->status = __PTR_ERR(wq);
				RETURN_AST(RQ);
			}
			goto wait_wq;
		});
		if (__unlikely(r = NET$QALLOC((SOCKET *)s, sizeof(PACKET) + p->length))) {
			FREE_PACKET(p, NULL, SPL_NET);
			if (r == 1) goto call_again;
			RQ->status = r;
			RETURN_AST(RQ);
		}
		s->prepared_packet = p;
		p->data_length = sizeof(struct ip) + sizeof(struct tcphdr);
		goto fill_pkt;
	}
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_NET));
	TEST_LOCKUP_LOOP(RQ, RETURN);
	if (RQ->v.len) goto retry;
	ret:
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);
}

#undef WFN

