#ifdef sio
#define WFN KERNEL$WAKE_READ
DECL_IOCALL(UDP_READ, SPL_NET, SIORQ)
#else
#define WFN KERNEL$WAKE_AREAD
DECL_IOCALL(UDP_RECVMSG, SPL_NET, AIORQ)
#endif
{
	long ss;
	VBUF vbuf;
	PACKET *pk;
	TCPIP_SOCKET *s;
	HANDLE *h = RQ->handle;
#ifndef sio
	unsigned flags;
#endif
	if (__unlikely(h->op != &UDP_OPS)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_NET));
	s = h->fnode;
	if (__unlikely(LIST_EMPTY(&s->in_queue))) pk = NULL;
	else pk = LIST_STRUCT(s->in_queue.next, PACKET, list);
#ifndef sio
	{
		vspace_unmap_t *unmap;
		VDESC v;
		struct _msghdr *p;
		v.ptr = RQ->pos;
		v.len = sizeof(struct _msghdr);
		v.vspace = RQ->v.vspace;
		RAISE_SPL(SPL_VSPACE);
		p = v.vspace->op->vspace_map(&v, PF_RW, &unmap);
		LOWER_SPL(SPL_NET);
		if (__unlikely(!p)) DO_PAGEIN(RQ, &v, PF_RW);
		if (__unlikely(__IS_ERR(p))) {
			RQ->status = __PTR_ERR(p);
			RETURN_AST(RQ);
		}
		flags = p->msg_flags;
		if (__likely(pk != NULL) && __unlikely(RQ->v.len < pk->data_length - sizeof(struct ip) - sizeof(struct udphdr))) p->msg_flags |= MSG_TRUNC;
		if (__likely(((struct sockaddr_in *)&p->msg_addr)->sin_len >= sizeof(struct sockaddr_in))) {
			if (__likely(pk != NULL)) {
				((struct sockaddr_in *)&p->msg_addr)->sin_family = PF_INET;
				((struct sockaddr_in *)&p->msg_addr)->sin_len = sizeof(struct sockaddr_in);
				((struct sockaddr_in *)&p->msg_addr)->sin_port = udp(pk)->uh_sport;
				((struct sockaddr_in *)&p->msg_addr)->sin_addr.s_addr = ip(pk)->ip_src.s_addr;
			}
		} else {
			((struct sockaddr_in *)&p->msg_addr)->sin_len = 0;
		}
		RAISE_SPL(SPL_VSPACE);
		unmap(p);
		LOWER_SPL(SPL_NET);
	}
#endif
	if (__unlikely(s->sock_error)) {
		RQ->status = s->sock_error;
		s->sock_error = 0;
		RETURN_AST(RQ);
	}
	if (__unlikely(!RQ->v.len)) goto ret;
	if (__unlikely(!pk)) {
		if (RQ->progress) goto ret;
		if (h->flags & SOCKET_NONBLOCK
#ifndef sio
			|| __unlikely(flags & MSG_DONTWAIT)
#endif
		) {
			RQ->status = -EWOULDBLOCK;
			RETURN_AST(RQ);
		}
		WQ_WAIT_F(&s->read_wait, RQ);
		RETURN;
	}
	vbuf.ptr = udp(pk) + 1;
	vbuf.len = pk->data_length - sizeof(struct ip) - sizeof(struct udphdr);
	vbuf.spl = SPL_X(SPL_NET);
	a:
	RAISE_SPL(SPL_VSPACE);
	ss = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
	if (__unlikely(!ss)) {
		unsigned u = (char *)vbuf.ptr - (char *)(udp(pk) + 1);
		RQ->v.ptr -= u;
		RQ->v.len += u;
		RQ->progress -= ss;
		DO_PAGEIN(RQ, &RQ->v, PF_RW);
	}
	RQ->progress += ss;
	if (__unlikely(ss != vbuf.len)) {
		vbuf.ptr = (char *)vbuf.ptr + ss;
		vbuf.len -= ss;
		if (__likely(RQ->v.len != 0)) goto a;
	}
#ifndef sio
	if (__likely(!(flags & MSG_PEEK)))
#endif
	{
		s->out_queue_length -= sizeof(PACKET) + pk->length;
		NET$QFREE((SOCKET *)s, sizeof(PACKET) + pk->length);
		DEL_FROM_LIST(&pk->list);
		FREE_PACKET(pk, &NET$PKTPOOL, SPL_NET);
	}
	ret:
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);
}

#undef WFN

#ifdef sio
#define WFN KERNEL$WAKE_WRITE
DECL_IOCALL(UDP_WRITE, SPL_NET, SIORQ)
#else
#define WFN KERNEL$WAKE_AWRITE
DECL_IOCALL(UDP_SENDMSG, SPL_NET, AIORQ)
#endif
{
	long ss;
	VBUF vbuf;
	PACKET *p;
	TCPIP_SOCKET *s;
	HANDLE *h = RQ->handle;
	WQ *wq;
	int r;
#ifndef sio
	in_addr_t dstaddr;
	unsigned dstport;
#endif
	if (__unlikely(h->op != &UDP_OPS)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_NET));
	s = h->fnode;
#ifndef sio
	{
		vspace_unmap_t *unmap;
		VDESC v;
		struct _msghdr *p;
		v.ptr = RQ->pos;
		v.len = sizeof(struct _msghdr);
		v.vspace = RQ->v.vspace;
		RAISE_SPL(SPL_VSPACE);
		p = v.vspace->op->vspace_map(&v, PF_READ, &unmap);
		LOWER_SPL(SPL_NET);
		if (__unlikely(!p)) DO_PAGEIN(RQ, &v, PF_READ);
		if (__unlikely(__IS_ERR(p))) {
			RQ->status = __PTR_ERR(p);
			RETURN_AST(RQ);
		}
		/*flags = p->msg_flags;*/
		if (__likely(((struct sockaddr_in *)&p->msg_addr)->sin_len >= sizeof(struct sockaddr_in))) {
			dstaddr = ((struct sockaddr_in *)&p->msg_addr)->sin_addr.s_addr;
			dstport = ((struct sockaddr_in *)&p->msg_addr)->sin_port;
			if (__unlikely(((struct sockaddr_in *)&p->msg_addr)->sin_family != PF_INET) ||
			    (s->remote_addr != htonl(INADDR_ANY) && (__unlikely(dstport != s->remote_port) ||
			     __unlikely(dstaddr != s->remote_addr))) ||
			     __unlikely(INAPPROPRIATE_UDP_ADDRESS(dstaddr))) {
				RQ->status = -EINVAL;
				iun:
				RAISE_SPL(SPL_VSPACE);
				unmap(p);
				LOWER_SPL(SPL_NET);
				RETURN_AST(RQ);
			}
		} else {
			dstaddr = s->remote_addr;
			dstport = s->remote_port;
			if (__unlikely(dstaddr == htonl(INADDR_ANY))) {
				RQ->status = -ENOTCONN;
				goto iun;
			}
		}
		RAISE_SPL(SPL_VSPACE);
		unmap(p);
		LOWER_SPL(SPL_NET);
	}
#else
	if (__unlikely(s->remote_addr == htonl(INADDR_ANY))) {
		RQ->status = -ENOTCONN;
		RETURN_AST(RQ);
	}
#endif
	if (__unlikely(s->sock_error)) {
		RQ->status = s->sock_error;
		s->sock_error = 0;
		RETURN_AST(RQ);
	}
	if (__unlikely(!RQ->v.len)) {
		goto retp;
	}
	if (__unlikely(RQ->v.len > NET$MAX_PACKET_LENGTH - sizeof(struct ip) - sizeof(struct udphdr))) {
		RQ->status = -EMSGSIZE;
		RETURN_AST(RQ);
	}
	if (__unlikely((wq = KERNEL$MAY_ALLOC(h->name_addrspace, sizeof(PACKET) + sizeof(struct ip) + sizeof(struct udphdr) + RQ->v.len)) != NULL)) {
		wait_wq:
		WQ_WAIT_F(wq, RQ);
		RETURN;
	}
	ALLOC_PACKET(p, sizeof(struct ip) + sizeof(struct udphdr) + RQ->v.len, &NET$PKTPOOL, SPL_NET, {
		wq = NET$OOM();
		if (__unlikely(!wq)) RETURN_IORQ_LSTAT(RQ, WFN);
		if (__unlikely(__IS_ERR(wq))) {
			RQ->status = __PTR_ERR(wq);
			RETURN_AST(RQ);
		}
		goto wait_wq;
		RETURN;
	});
	p->fn = NET$FREE_PACKET;
	p->data_length = sizeof(struct ip) + sizeof(struct udphdr) + RQ->v.len;
	ip(p)->ip_vhl = IP_VHL;
	ip(p)->ip_tos = s->ip_tos;
	*(__u32 *)&ip(p)->ip_ttl = IP_TTL_P_SUM(IPPROTO_UDP);
	if (__unlikely(s->local_port == htons(IPPORT_ANY))) {
		int r;
		if (__unlikely(r = CONNECT_BIND(s, 1))) {
			RQ->status = r;
			goto free_return_ast;
		}
	}
	if (s->local_addr == htonl(INADDR_ANY)) {
		in_addr_t la = IP_FIND_LOCAL_ADDRESS(
#ifdef sio
			s->remote_addr
#else
			dstaddr
#endif
);
		if (__unlikely(la == htonl(INADDR_ANY))) {
			netdown:
			RQ->status = -ENETDOWN;
			free_return_ast:
			FREE_PACKET(p, &NET$PKTPOOL, SPL_NET);
			RETURN_AST(RQ);
		}
		ip(p)->ip_src.s_addr = la;
	} else if (__unlikely(TCPIP_MULTICAST_ADDRESS(s->local_addr))) {
		if (__unlikely(s->multicast_src == htonl(INADDR_ANY))) {
			s->multicast_src = IP_DEFAULT_MULTICAST_IF();
			if (__unlikely(s->multicast_src == htonl(INADDR_ANY))) {
				goto netdown;
			}
		}
		ip(p)->ip_src.s_addr = s->multicast_src;
	} else {
		ip(p)->ip_src.s_addr = s->local_addr;
	}
#ifdef sio
	ip(p)->ip_dst.s_addr = s->remote_addr;
	if (__unlikely(TCPIP_MULTICAST_ADDRESS(s->remote_addr))) {
		ip(p)->ip_ttl = s->mcast_ttl;
	}
	*(__u32 *)&udp(p)->uh_sport = UDP_SET_PORTS(s->local_port, s->remote_port);
#else
	ip(p)->ip_dst.s_addr = dstaddr;
	*(__u32 *)&udp(p)->uh_sport = UDP_SET_PORTS(s->local_port, dstport);
#endif
	if (__unlikely(!(s->flags & SOCK_NETACL_ACCEPT_OUT))) {
		if (__unlikely((r = NETACL_SEARCH(s->node, ip(p)->ip_dst.s_addr, (ntohl(*(__u32 *)&udp(p)->uh_sport) & 0xffff) | NETACL_PORT_UDP)) < 0)) {
			RQ->status = -EACCES;
			goto free_return_ast;
		}
#ifdef sio
		s->flags |= SOCK_NETACL_ACCEPT_OUT;
#else
		s->flags |= ((unsigned)r & NETACL_ALL) * (SOCK_NETACL_ACCEPT_OUT / NETACL_ALL);
#endif
	}
	*(__u32 *)&udp(p)->uh_ulen = UDP_LENGTH_SUM(RQ->v.len + sizeof(struct udphdr), TCPUDP_MAGIC_CHECKSUM(IPPROTO_UDP, RQ->v.len + sizeof(struct udphdr)));
	p->checksum.u = MKCHECKSUM(sizeof(struct ip) - 2 * sizeof(in_addr_t), sizeof(struct ip) + 6);
	p->flags |= PKT_OUTPUT_CHECKSUM | PKT_OUTPUT_CHECKSUM_UDP | PKT_TCPUDP_CHECKSUM_OK;
	vbuf.ptr = udp(p) + 1;
	vbuf.len = RQ->v.len;
	vbuf.spl = SPL_X(SPL_NET);
	a:
	RAISE_SPL(SPL_VSPACE);
	ss = RQ->v.vspace->op->vspace_get(&RQ->v, &vbuf);
	if (__unlikely(!ss)) {
		unsigned u = (char *)vbuf.ptr - (char *)(udp(p) + 1);
		RQ->v.ptr -= u;
		RQ->v.len += u;
		FREE_PACKET(p, &NET$PKTPOOL, SPL_NET);
		DO_PAGEIN(RQ, &RQ->v, PF_READ);
	}
	if (__unlikely(ss != vbuf.len)) {
		vbuf.ptr = (char *)vbuf.ptr + ss;
		vbuf.len -= ss;
		goto a;
	}
	RQ->progress += p->data_length - sizeof(struct ip) - sizeof(struct udphdr);
	if (__unlikely(r = IP_SEND_PACKET(p))) {
		RQ->status = r;
		RETURN_AST(RQ);
	}
	retp:
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);
}

#undef WFN

